/*
	For best results in visual layout while viewing this file, set
	tab stops to every 4 columns.
*/

/*
	dcp.h
*/

/* DCP a uucp clone. Copyright Richard H. Lamb 1985,1986,1987 */

#include <stdio.h>

#include "lib.h"
#include "ulib.h"
#include "host.h"	/* Host specific definitions */

#define SYSTEMS "systems"
#define LOGFILE "LOGFILE"
#define SYSLOG	"SYSLOG"

#define MSGTIME	20
#define MAXPACK	256

#define ERROR	10
#define EMPTY	11

#define	SLAVE	0
#define	MASTER	1

#define FAILED	(-1)
#define OK		0

/* systems (L.sys) file fields definitions */

#define	FLD_REMOTE	0
#define	FLD_CCTIME	1
#define	FLD_DEVICE	2
#define	FLD_TYPE	3
#define	FLD_SPEED	4
#define	FLD_PROTO	5
#define	FLD_EXPECT	6
#define FLD_SEND	7

typedef int	(*procref)();

typedef struct {
	char type;
	procref a, b, c, d;
} Proto;

/* the various protocols available. Add here for others */
extern procref getpkt, sendpkt, openpk, closepk;

extern int ggetpkt(), gsendpkt(), gopenpk(), gclosepk();

extern int pktsize;		/* packet size for this protocol*/
extern FILE *syslog;		/* syslog file pointer			*/
extern char workfile[80];	/* name of current workfile		*/
extern FILE *fwork;             /* current work file pointer    */
extern int fp;                  /* current disk file handle             */
extern FILE *fsys;
extern int remote;              /* -1 means we're remote                */
extern int msgtime;             /* timeout setting (length)             */
extern char *Rmtname;		/* system we WANT to talk to	*/
extern char rmtname[20];	/* system we end up talking to	*/
extern char s_systems[64];	/* full-name of systems file	*/

extern int debuglevel;

extern unsigned int checksum();
extern char *curdir;

extern void printmsg();

extern char getsystem(), callup(), startup(), sysend();

extern char scandir(), schkdir();
extern char *xscandir();
extern char sinit(), sfile(), sdata(), seof(), sbreak();
extern char rinit(), rfile(), rdata();
extern char endp();
