;PPMPX3c.ASM 3.3(for DPMI)
;	MACHINE LANGUAGE SUBROUTINES
;	FOR PPMPQS
;	1991-97 by YUJI KIDA
;
.386P

code	segment	use16
	assume	cs:code,ds:code

	INCLUDE	UBP.MAC
	include	ppmpx.h

	org	100h
start:
	jmp	start0

	include	dpmi4ub.h
	include	dpmi4ub.lib


start0:
	MOV_AX	AR0		;ARRAY[0] is the command
	MOV	BX,OFFSET CMD_TBL
	SHL	AX,1
	ADD	BX,AX
	JMP	CS:[BX]

CMD_TBL:
	dw	initialize,getprime,storedecomdata,closefiles

	even
P_OFF		dd	?
primeadrnow	dd	?

C_OFF		dw	?
C_SEG		dw	?

primehandle	dw	?
decomhandle	dw	?

FBsize		dd	?
primes		dd	?

rowstotal	dd	?
rowslimit	dd	?
rowsnow		dd	?

primenow	dd	?
offnow		dw	?	;offnow is 16bit, means
				;the number of factors
				;must be < 65536

;
; close all files and free DPMI memory
;
;command#=3

closefiles:
	mov	ax,cs
	mov	ds,ax

	mov	ah,3eh
	mov	bx,[decomhandle]
	int	21h

	mov	ah,3eh
	mov	bx,[primehandle]
	int	21h

	call	freemainDATAmemory
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf

;
; get and set primes
;
;command#=1

getprime:
	call	real2protA

	mov	esi,cs:[P_OFF]
	movzx	eax,word ptr [esi]
	add	esi,2
	shl	eax,1
	add	eax,esi
	mov	ebx,eax
	mov	word ptr [ebx],0
	mov	eax,[esi]
	mov	dword ptr gs:[BUFFER],eax
	mov	edi,gs:[primeadrnow]
	mov	[edi],eax
	add	edi,4
	mov	gs:[primeadrnow],edi

	call	prot2real
	mov	ax,cs
	mov	ds,ax

	mov	dx,offset BUFFER
	mov	cx,4
	mov	bx,[primehandle]
	mov	ah,40h
	int	21h
	jc	short primediskerror

primeret:
	mov	ax,ss
	mov	ds,ax
	retf

primediskerror:
	mov	bx,AR0
	mov	word ptr [bx],8001h
	jmp	primeret

;
; write factored data
;
;command#=2

setdata:
	push	bx
	mov	bx,[offnow]
	mov	eax,[primenow]
	mov	[bx],eax	;set prime#
	add	bx,4
	mov	[offnow],bx
	pop	bx
	ret

storedecomdata:
	push	bp

	mov	ax,cs
	mov	ds,ax
	mov	es,ax

	mov	eax,[rowstotal]
	cmp	eax,[rowslimit]
	jae	div32incomplete		;neglect this data

	inc	eax
	mov	[rowstotal],eax
	mov	[rowsnow],eax

	mov	[primenow],0
	mov	[offnow],offset BUFFER

	lds	si,dword ptr [C_off]	;transfer to 32 bit format
				;and copy to WBUFFER in cs
	mov	di,offset CBUFFER
	xor	eax,eax
	lodsw
	test	ax,8000h	;check sign
	pushf			;*
	and	ax,1fffh	;lenmask
	mov	cx,ax
	inc	ax
	shr	ax,1
	stosd
	rep	movsw
	xor	ax,ax
	stosw

	call	real2protB

	popf			;*
	jz	div32positive
	call	setdata
div32positive:
	mov	edi,fs:[_primeadr]
	add	edi,4		;primeunitbytes	;offset of 2

	std
	mov	ecx,[primes]
div32LP:
	push	ecx
	inc	[primenow]
	mov	ebp,fs:[edi]	;ebp = denominator
div3210:
	mov	si,offset CBUFFER
	mov	ax,[si]
	mov	cx,ax		;dword length
	shl	ax,2
	add	si,ax		;dword highest adr
	xor	edx,edx
	shr	cx,1
	pushf			;*
	jcxz	div3221
	align	4
div3220:
	lodsd
	div	ebp
	lodsd
	div	ebp
	loop	div3220
div3221:
	popf			;*
	jnc	div3222
	lodsd
	div	ebp
div3222:
	or	edx,edx
	jz	short div32100	;divide exactly if it can

	add	edi,4		;primeunitbytes
	pop	ecx
	loop	div32LP

	cld

	cmp	dword ptr [CBUFFER],1
	jne	short div32incomplete
	cmp	dword ptr [CBUFFER+4],1
	je	short div200

div32incomplete:		;neglect this data
	call	prot2real

	pop	bp
	mov	bx,AR0
	mov	word ptr cs:[bx],101	;error mark

	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf


div32100:
	call	setdata

	mov	si,offset CBUFFER
	mov	ax,[si]
	mov	cx,ax		;dword length
	shl	ax,2
	add	si,ax		;highest adr
	xor	edx,edx

	lodsd
	div	ebp
	push	eax		;push highst dword
	jmps	div32120
	align	4
div32110:
	lodsd
	div	ebp
div32120:
	mov	[si+4],eax
	loop	div32110

	pop	eax		;check highest dword
	or	eax,eax
	jnz	div32130
	dec	dword ptr [CBUFFER]	;dec length if highest=0
div32130:
	jmp	div3210


	;write result
div200:
	call	prot2real

	mov	ax,[offnow]
	mov	bx,offset BUFFER0
	sub	ax,bx
	mov	cx,ax		;byte size
	sub	ax,4
	shr	ax,2
	mov	[bx],ax		;number of factors
	mov	word ptr [bx+2],0
	mov	dx,bx
	mov	bx,[decomhandle]
	mov	ah,40h			
	int	21h
	jc	short decomdiskerror

decomret:
	pop	bp
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf


decomdiskerror:
	mov	bx,AR0
	mov	word ptr [bx],8001h	;-1 of UB
	jmp	decomret


;
;* Initialize
;COMMAND#=0

;	V1=P
;	V2=C#
;	AR[1]	TOTAL SIZE \ 32

INITIALIZE:
	mov	ax,cs
	mov	ds,ax
	mov	es,ax

	MOV	BX,V1		;adr of p
	movzx	edx,word ptr [bx]
	movzx	eax,word ptr [bx+2]
	shl	eax,4
	add	eax,edx
	mov	[P_OFF],eax

	MOV	BX,V2		;adr of C#
	mov	ax,[bx]
	mov	[C_OFF],ax
	mov	ax,[bx+2]
	mov	[C_SEG],ax

	xor	eax,eax
	MOV_AX	AR1
	shl	eax,5		;*32
	mov	[FBsize],eax
	dec	eax
	mov	[primes],eax

	mov	[rowstotal],0
	mov	[rowsnow],0

	;create files

	mov	dx,offset primefilename
	mov	ah,3ch			;create handle
	mov	cx,0
	int	21h
	jc	diskerror
	mov	[primehandle],ax

	mov	dx,offset decomfilename
	mov	ah,3ch			;create handle
	mov	cx,0
	int	21h
	jc	diskerror
	mov	[decomhandle],ax

	;DPMI initialize

	mov	eax,[primes]
	shl	eax,2		;4 bytes or each prime
	add	eax,64		;for alignment safety
	mov	[DPMImemorysize],eax
	call	DPMIinit
	jc	DPMIerror

	mov	ebx,dword ptr [DPMIaddresslow]
	add	ebx,0fh
	and	bx,0fff0h
	mov	fs:[_primeadr],ebx
	push	ebx

	call	prot2real

	pop	ebx
	mov	[primeadrnow],ebx
	mov	ebx,[FBsize]
	mov	[rowslimit],ebx

	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf

diskerror:
	mov	bx,AR0
	mov	word ptr cs:[bx],8001h	;-1 of UB

	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf
DPMIerror:
;	call	prot2real
	mov	bx,AR1
	mov	word ptr cs:[bx],8001h	;-1 of UB

	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf



primefilename	db	'PPMPPRMS.PPM',0
decomfilename	db	'PPMPDCMP.PPM',0


	even
CBUFFER		dw	600 dup(0)	;variable C is copied here

	align	4
BUFFER0		dd	?
BUFFER		dd	2048 dup(0)	;max number of factors

CODE	ENDS
END	START
