;DPMI4UB.ASM
; use DPMI in UBASIC machine language programs
; terminate & stay resident program
; use int DPMIUBint=0c7h

.386p

code	segment	use16
	assume	cs:code,ds:code

	org	100h
start:
	jmp	DPMIinit

	include	DPMI4UB.H
oldoff	dw	?
oldseg	dw	?

DPMIoffset	dw	?
DPMIsegment	dw	?
DPMIprivatesize	dw	?
DPMIprivateseg	dw	?
DPMIbuffersize	dw	?
DPMIactive	dw	0


DPMIinit:
	mov	[realSEG],cs
	mov	[realSTACKSEG],ss

	;avoid duplicate execution

	xor	ax,ax
	mov	ds,ax
	mov	si,DPMIUBint*4+2
	mov	ds,[si]

	mov	si,offset DPMIUBmsg
	mov	di,si
	mov	cx,10
	repe	cmpsb
	jne	DPMIin
DPMIduplicate:
	mov	[DPMIactive],0

	mov	ax,cs
	mov	ds,ax
	mov	dx,offset resetmsg
	mov	ah,9
	int	21h
	mov	ax,4c02h
	int	21h

DPMIin:
	mov	ax,cs
	mov	ds,ax

	mov	ax,1687h
	int	2fh		;get DPMI state
	or	ax,ax
	jz	DPMIexists
DPMIerror:
	mov	dx,offset errormsg
	mov	ah,9
	int	21h
	mov	ax,4c01h
	int	21h

DPMIexists:
	mov	[DPMIoffset],di
	mov	[DPMIsegment],es
	mov	[DPMIprivatesize],si

	cmp	cl,3
	jb	DPMIerror

	mov	dx,offset successmsg
	mov	ah,9
	int	21h

	xor	ax,ax
	mov	ds,ax
	mov	bx,DPMIUBint*4
	lds	si,[bx]
	mov	es:[oldoff],bx	;save old DPMIUBint table entry
	mov	es:[oldseg],ds
	mov	ds,ax
	mov	word ptr [bx],offset R2Pservice
	mov	ax,cs
	mov	[bx+2],ax
	mov	ds,ax

	mov	ax,offset DPMIprivatebuffer
	add	ax,_DPMIPbuffersize+_DPMIbuffersize
	shr	ax,4		;para size
	push	ax
	mov	bx,ax
	mov	ah,4ah		;reduce memory
	int	21h

	;terminate and stay resident

	pop	dx
	mov	ah,31h
	int	21h


callDPMIpart1:
	mov	ax,offset DPMIprivatebuffer
	add	ax,0fh
	shr	ax,4
	mov	dx,cs
	add	ax,dx
	mov	[DPMIprivateseg],ax
	mov	es,ax

	sub	ax,dx
	add	ax,[DPMIprivatesize]
	shl	ax,4
	mov	[DPMIPbufferoff],ax	;offset from cs

	mov	ax,0			;access DPMI host from 16bit segment
					;of course other segments can be 32bit
					;teach DPMI hosts the size of stack frame
	call	dword ptr [DPMIoffset]
	jc	DPMIerror

	;now in protected mode

	mov	[sysCODEsel],cs
	mov	[sysDATAsel],ds
	mov	[sysSTACKsel],ss

	mov	ax,0305h
	int	31h
;	mov	[DPMIbuffersize],ax
	mov	[DPMIsaverestoreoff],di
	mov	[DPMIsaverestoreseg],si

	mov	ax,0306h
	int	31h
	mov	[DPMIchangeR2Poff],cx
	mov	[DPMIchangeR2Pseg],bx
	mov	[DPMIchangeP2Roff],edi
	mov	[DPMIchangeP2Rseg],si
	ret

callDPMIpart2:

	;create 4 selectors

	mov	ax,0
	mov	cx,4
	int	31h
	jc	DPMIerror

	mov	[mainDATAsel],ax	;1st selector
	mov	dx,ax
	mov	ax,3		;get step
	int	31h
	add	dx,ax
	mov	[userCODE16sel],dx
	add	dx,ax
	mov	[userCODE32sel],dx
	add	dx,ax
	mov	[userDATA16sel],dx

	; set access rights

	mov	ax,cs
	lar	cx,ax
	xchg	cl,ch
	and	cx,0060h	;get CPL
	push	cx
	or	cx,code32	;4k,32bit,code
	mov	bx,[userCODE32sel]
	mov	ax,9		;set access rights
	int	31h
	pop	cx
	jc	DPMIerror

	push	cx
	or	cx,code16	;1,16bit,code
	mov	bx,[userCODE16sel]
	mov	ax,9		;set access rights
	int	31h
	pop	cx
	jc	DPMIerror

	or	cx,data32	;4k,32bit,data
	mov	bx,[mainDATAsel]
	mov	ax,9		;set access rights
	int	31h
	jc	DPMIerror

	;set base address

	xor	cx,cx
	xor	dx,dx
	mov	bx,[mainDATAsel]
	mov	ax,7		;set base address
	int	31h
	jc	DPMIerror

	;set limit

	xor	cx,cx
	xor	dx,dx
	dec	cx
	dec	dx		;4GB limit
	mov	ax,8		;set limit
	mov	bx,[mainDATAsel]
	int	31h
	jc	DPMIerror

	xor	cx,cx
	xor	dx,dx
	dec	dx		;64KB limit
	mov	ax,8		;set limit
	mov	bx,[userCODE16sel]
	int	31h
	jc	DPMIerror

	xor	cx,cx
	xor	dx,dx
	dec	dx		;64KB limit
	mov	ax,8		;set limit
	mov	bx,[userDATA16sel]
	int	31h
	jc	DPMIerror

	xor	cx,cx
	xor	dx,dx
	dec	dx		;64KB limit
	mov	ax,8		;set limit
	mov	bx,[userCODE32sel]
	int	31h
	jc	DPMIerror
	ret


	;change to protected mode
	;called from each user routine at first

	align	4
R2Pservice:
	cli
	mov	ax,cs
	mov	ds,ax
	mov	es,ax
	mov	[realSTACKSEG],ss
	sti

	pop	ax
	mov	[userOFF],ax
	pop	ax
	mov	[userSEG],ax
	popf

;	cmp	[DPMIactive],0
;	jne	R2Pservicein

	mov	[DPMIactive],1

	call	callDPMIpart1
	call	callDPMIpart2
	call	prot2real

R2Pservicein:
	call	real2prot

	mov	dx,16
	mov	ax,[userSEG]
	mul	dx
	mov	cx,dx
	mov	dx,ax
	push	cx
	push	dx
	mov	bx,[userCODE16sel]
	mov	ax,7		;set base address
	int	31h

	pop	dx
	pop	cx
	mov	bx,[userDATA16sel]
	mov	ax,7		;set base address
	int	31h

	cli
	mov	es,[userDATA16sel]
	sti
	mov	si,offset DPMIUBcommondatatop
	mov	di,si
	mov	cx,offset DPMIUBcommondataover
	sub	cx,si
	shr	cx,1
	rep	movsw

	mov	ax,[userCODE16sel]
	mov	[userSEG],ax
	jmp	dword ptr [userOFF]


	;subroutines

prot2real:
	cli
	mov	es,[sysDATAsel]
	movzx	edi,word ptr [DPMIPbufferoff]
	mov	al,0
	call	dword ptr [DPMIsaverestoreoff]

	mov	ax,[realSEG]
	mov	cx,ax
	mov	si,ax
	mov	dx,[realSTACKSEG]
	mov	bx,sp
	mov	di,offset prot2realin
	jmp	fword ptr [DPMIchangeP2Roff]
prot2realin:
	sti
	ret


real2prot:
	;must ds=cs

	cli
	mov	ax,[sysDATAsel]
	mov	cx,ax			;new ds = new es = ax
	mov	dx,[sysSTACKsel]	;new ss = dx
	mov	si,[sysCODEsel]		;new cs = ss
	xor	ebx,ebx
	mov	edi,ebx
	mov	bx,sp			;new esp
	mov	di,offset real2protin
	jmp	dword ptr [DPMIchangeR2Poff]
real2protin:
	movzx	edi,word ptr [DPMIPbufferoff]
	mov	al,1
	call	dword ptr cs:[DPMIsaverestoreoff]
	sti
	ret
 
DPMIprivatebuffer	db	?

resetmsg		db	'DPMI4UB is set again.',0dh,0ah,'$'
errormsg	db	'ERROR! DPMI is not ready.',0dh,0ah,'$'
successmsg	db	'DPMI for UBASIC ver. 1.0  (1996 Yuji KIDA)',0dh,0ah
		db	'DPMI is successfully initialized.',0dh,0ah,'$'


code	ends
end	start
