@echo off
rem =========================================================================
rem
rem               Man 1.9.xx - copyright (c) 1993 Stuart Herbert
rem           Batch file for supporting viewing of compressed entries
rem
rem =========================================================================
rem
rem     Parameters :
rem
rem     %1     - '-e' for expand only, '-c' for compress after use
rem     %2     - name of archive
rem     %3     - name of file to extract (file is extracted to %temp%\%3)
rem     %4..%9 - command to invoke editor/reader or whatever
rem
rem =========================================================================
rem
rem     Environments :
rem
rem     ARCHIVER      - ARJ             for ARJ 2.41 support
rem                     INFOZIP         for INFOZIP support
rem                     LHA             for LHA support
rem                     MS              for COMPRESS and EXPAND support
rem                     PKZIP           for PKZip 2.04g support
rem
rem     Defaults to INFO-ZIP because I encourage PD/FreeWare software :-)
rem
rem =========================================================================
rem
rem NOTES
rem
rem     Because command.com makes
rem
rem             set manexp=unzip -p %2 > %temp%\%3
rem
rem     attempt redirection, I have had to use conditionals throughout this
rem     .bat file.  This is a nasty situation, and if I can find a better
rem     solution, I will release an update.  If you can find a better
rem     solution, mail me!
rem
rem =========================================================================
rem Parameter validation and initialisation
rem =========================================================================

rem ***
rem Debugging code - normally REM'd out
rem ***

rem echo %1 %2 %3 %4 %5 %6 %7 %8 %9
rem pause

rem ***
rem if TEMP not set, don't know where to place expanded file :-)
rem ***

if %temp%+ == + goto notemp

rem ***
rem create mancom.bat to compress the expanded file and delete it
rem ***

echo @echo off > %temp%\mancom.bat
if %1+==-c+ echo cls >> %temp%\mancom.bat
if %1+==-c+ echo echo Compressing file ... please wait >> %temp%\mancom.bat

if %archiver%+ == +        goto infozip1
if %archiver%+ == ARJ+     goto arj1
if %archiver%+ == INFOZIP+ goto infozip1
if %archiver%+ == LHA+     goto lha1
if %archiver%+ == MS+      goto ms1
if %archiver%+ == PKZIP+   goto pkzip1

:arj1
if %1+==-c+ echo if exist %temp%\%3 arj a -e %2 %temp%\%3 >> %temp%\mancom.bat
goto cont1

:infozip1
if %1+==-c+ echo if exist %temp%\%3 zip -k9Dm %2 %temp%\%3 >> %temp%\mancom.bat
goto cont1

:lha1
if %1+==-c+ echo if exist %temp%\%3 lha a %2 %temp%\%3 >> %temp%\mancom.bat
goto cont1

:ms1
if %1+==-c+ echo if exist %temp%\%3 compress %temp%\%3 %2 >> %temp%\mancom.bat
goto cont1

:pkzip1
if %1+==-c+ echo if exist %temp%\%3 pkzip -aeX %2 %temp%\%3 >> %temp%\mancom.bat
goto cont1

:cont1
echo if exist %temp%\%3 del %temp%\%3 >> %temp%\mancom.bat

rem ***
rem if the file exists, expand it
rem ***

if exist %2 goto expandit
goto call

:expandit
echo Expanding file ... please wait
if %archiver%+ == +        goto infozip2
if %archiver%+ == +        goto arj2
if %archiver%+ == INFOZIP+ goto infozip2
if %archiver%+ == LHA+     goto lha2
if %archiver%+ == MS+      goto ms2
if %archiver%+ == PKZIP+   goto pkzip2

:arj2
arj x -jw%temp%\%3 %2 %3
goto cont2

:infozip2
unzip -p %2 %3 > %temp%\%3
goto cont2

:lha2
lha p %2 %3 > %temp%\%3
goto cont2

:ms2
expand %2 %temp%\%3 > nul
goto cont2

:pkzip+
pkunzip -c %2 %3 > %temp%\%3
goto cont2

:cont2

rem ***
rem call the viewer, editor, WinHelp, or whatever
rem ***

:call
shift
shift
shift
call %1 %2 %3 %4 %5 %6 %7 %8 %9

rem ***
rem if WinHelp called, prompt for keypress before tidying up
rem ***

if %1+==winhelp+ goto winhelp
goto tidy

:winhelp
echo WARNING -- Reading Compressed Windows Help File
echo Please finish reading file before pressing any key
echo.
pause

rem ***
rem tidy up afterwards
rem ***

:tidy
if exist %temp%\mancom.bat call %temp%\mancom.bat > nul
if exist %temp%\mancom.bat del %temp%\mancom.bat > nul
goto exit

rem ***
rem tell them that TEMP is not set
rem ***

:notemp
echo The DOS environment variable TEMP is not set
echo.
echo TEMP must be set to point to a directory you can create files in
echo eg SET TEMP=C:\TEMP
echo.
echo Please set TEMP before trying to use compressed entries
pause

:exit
