


     FIGLET(6)              v2.1 (12 Aug 1994)               FIGLET(6)



     NAME
          figlet - print in large characters made up of ordinary
          screen characters


     SYNOPSIS
          figlet [ -clnprtvxDELNRX ] [ -d fontdirectory ]
               [ -f fontfile ] [ -m smushmode ] [ -w outputwidth ]
               [ -C controlfile ] [ -I infocode ]


     DESCRIPTION
          figlet prints its input using large characters made up of
          ordinary screen characters.  figlet output is generally
          reminiscent of the sort of ``signatures'' many people like
          to put at the end of e-mail and UseNet messages.  It is also
          reminiscent of the output of some banner programs, although
          it is oriented normally, not sideways.

          figlet can print in a variety of fonts, both left-to-right
          and right-to-left, with adjacent characters kerned and
          ``smushed'' together in various ways.  figlet fonts are
          stored in separate files, which can be identified by the
          suffix ``.flf''.  Most figlet font files will be stored in
          figlet's default font directory.

          figlet can also use ``control files'', which tell it to map
          certain input characters to certain other characters,
          similar to the Unix tr command.  Control files can be
          identified by the suffix ``.flc''.  Most figlet control
          files will be stored in figlet's default font directory.


     OTHER FONTS & MAILING LIST
          As of this writing you can get many fonts which are not in
          the basic figlet package by anonymous FTP from
          ftp.nicoh.com:pub/figlet/fonts.  ftp.nicoh.com:pub/figlet
          should also contain the latest version of figlet and other
          utilities related to figlet.  Of special interest are non-
          Roman fonts.  As of this writing, there are Hebrew and
          Cyrillic (Russian) fonts; more are expected.

          We run an e-mail list dedicated to figlet software and font
          announcements, as well as general discussion about figlet.
          If you would like to be on this list, send e-mail to
          listserv@vmd.cso.uiuc.edu with the message body

               subscribe figlet-l YOUR NAME

          where YOUR NAME should be replaced with your name.  For
          those who don't want to be bothered with the discussions,
          the list can be configured so that you only see software



     Page 1                                           (printed 9/9/95)






     FIGLET(6)              v2.1 (12 Aug 1994)               FIGLET(6)



          update notices, or only software and font announcements.


     USAGE
          Just start up figlet (type ``figlet'') and then type
          whatever you want.  Alternatively, pipe a file or the output
          of another command through figlet.  See EXAMPLES for other
          things to do.


     OPTIONS
          figlet reads command line options from left to right, and
          only the last option that affects a parameter has any
          effect.  Every option has an inverse, so that, for example,
          if figlet is customized with a C-shell alias, all the
          options are still available.

          Commonly-used options are -f, -c, -m0, -t, -p and -v.


          -f fontfile
               Select the font.  The .flf suffix may be left off of
               fontfile, in which case figlet automatically appends
               it.  figlet looks for the file first in the default
               font directory and then in the current directory, or,
               if fontfile was given as a full pathname, in the given
               directory.  If the -f option is not specified, figlet
               uses the font that was specified when it was compiled.
               To find out which font this is, use the -I3 option.


          -d fontdirectory
               Change the default font directory.  figlet looks for
               fonts first in the default directory and then in the
               current directory.  If the -d option is not specified,
               figlet uses the directory that was specified when it
               was compiled.  To find out which directory this is, use
               the -I2 option.


          -c
          -l
          -r
          -x   These options handle the justification of figlet
               output.  -c centers the output horizontally.  -l makes
               the output flush-left.  -r makes it flush-right.  -x
               (default) sets the justification according to whether
               left-to-right or right-to-left text is selected.
               Left-to-right text will be flush-left, while right-to-
               left text will be flush-right.  (Left-to-right versus
               right-to-left text is controlled by -L, -R and -X.)




     Page 2                                           (printed 9/9/95)






     FIGLET(6)              v2.1 (12 Aug 1994)               FIGLET(6)



          -t
          -w outputwidth
               These options control the outputwidth, or the screen
               width figlet assumes when formatting its output.
               figlet uses the outputwidth to determine when to break
               lines and how to center the output.  Normally, figlet
               assumes 80 columns so that people with wide terminals
               won't annoy the people they e-mail figlet output to.
               -t sets the outputwidth to the terminal width.  If the
               terminal width cannot be determined, the previous
               outputwidth is retained.  -w sets the outputwidth to
               the given integer.  An outputwidth of 1 is a special
               value that tells figlet to print each non-space
               character, in its entirety, on a separate line, no
               matter how wide it is.


          -p
          -n   These options control how figlet handles newlines.  -p
               puts figlet into ``paragraph mode'', which eliminates
               some unnecessary line breaks when piping a multi-line
               file through figlet.  In paragraph mode, figlet treats
               line breaks within a paragraph as if they were merely
               blanks between words.  (Specifically, -p causes figlet
               to convert any newline which is not preceded by a
               newline and not followed by a space character into a
               blank.)  -n puts figlet back to normal (default), in
               which every newline figlet reads causes it to produce a
               line break.


          -D
          -E   -D switches to the German (Deutsch) character set.
               Turns `[', `\' and `]' into umlauted A, O and U,
               respectively.  `{', `|' and `}' turn into the
               respective lower case versions of these.  `~' turns
               into s-z.  (Of course, all this assumes the font author
               has placed German characters in these positions in the
               font file.  Many font authors do not.)  -E switches
               back to English (default), i.e., the standard ASCII
               character set.


          -C controlfile
          -N   These options deal with figlet controlfiles.  A
               controlfile is a file containing a list of commands
               that figlet executes each time it reads a character.
               These commands can map certain input characters to
               other characters, similar to the Unix tr command or the
               figlet -D option.  figlet maintains a list of
               controlfiles, which is empty when figlet starts up.  -C
               adds the given controlfile to the list.  -N clears the



     Page 3                                           (printed 9/9/95)






     FIGLET(6)              v2.1 (12 Aug 1994)               FIGLET(6)



               controlfile list, cancelling the effect of any previous
               -C.  figlet executes the commands in all controlfiles
               in the list.  See CONTROLFILE FORMAT for details on how
               to write a controlfile.


          -m smushmode
               Specifies how figlet should ``smush'' and kern
               consecutive characters together.  On the command line,
               -m0 can be useful, as it tells figlet to kern
               characters without smushing them together.  Otherwise,
               this option is rarely needed, as a figlet font file
               specifies the best smushmode to use with the font.  -m
               is, therefore, most useful to font designers testing
               the various smushmodes with their font.  smushmode can
               be -2 through 63.

               -2 Get mode from font file (default).
                    Every figlet font file specifies the best
                    smushmode to use with the font.  This will be one
                    of the smushmodes (-1 through 63) described in the
                    following paragraphs.

               -1 No smushing or kerning.
                    Characters are simply concatenated together.

               0 Kern only.
                    Characters are pushed together until they touch.

                    In any non-negative smushmode figlet kerns
                    adjacent font characters, i.e., it pushes adjacent
                    font characters together until their non-blank
                    portions touch.  At that point, it may or may not
                    push the two font characters 1 screen character
                    closer, depending on the smushmode.  Pushing font
                    characters one step closer requires ``smushing''
                    two non-blank screen characters into a single
                    screen character.  figlet has 6 ways of doing
                    this, represented by 1, 2, 4, 8, 16 and 32.  The
                    various non-negative smushmodes (0-63) are
                    obtained by adding up the numbers corresponding to
                    the sort of smushing figlet should do.  In
                    particular smushmode 0 kerns characters without
                    smushing them into each other.

               1 Smush equal characters.
                    Two screen characters are smushed into a single
                    character if they are the same.  The resulting
                    character is the same as both of the original
                    characters.  This mode does not smush the
                    character known as a hardblank, which is a
                    character that prints as a blank, but is not



     Page 4                                           (printed 9/9/95)






     FIGLET(6)              v2.1 (12 Aug 1994)               FIGLET(6)



                    smushed (except in mode 32).  See FONT FILE FORMAT
                    for more information on hardblanks.

               2 Smush underscores.
                    An underscore will be smushed into (and replaced
                    by) any of ``|/\[]{}()<>''.

               4 Hierarchy smushing.
                    Smushes certain characters together according to a
                    hierarchy containing 6 classes: ``|'', ``/\'',
                    ``[]'', ``{}'', ``()'', ``<>''.  A member of any
                    class can be smushed into and replaced by a member
                    of any later class.

               8 Opposite pair smushing, type I.
                    Smushes opposing brackets (``[]''), braces
                    (``{}'') and parentheses (``()'') together,
                    replacing them with a vertical bar (`|').

               16 Opposite pair smushing, type II.
                    Smushes opposing slashes (``/\'') and greater-
                    than/less-than (``><'') together, replacing them
                    with an upper-case `X'.  ``><'' are only smushed
                    together when they are in that order, i.e., ``<>''
                    will not be smushed.

               32 Hardblank smushing.
                    Smushes two hardblanks together, replacing them
                    with a single hardblank.  See FONT FILE FORMAT for
                    more information on hardblanks.


          -v
          -I infocode
               These options print various information about figlet,
               then exit.  If several of these options are given on
               the command line, only the last is executed, and only
               after all other command-line options have been dealt
               with.

               -v prints version and copyright information, as well as
               a ``Usage: ...''  line.  -I prints the information
               corresponding to the given infocode in a consistent,
               reliable (i.e., guaranteed to be the same in future
               releases) format.  -I is primarily intended to be used
               by programs that use figlet.  infocode can be any of
               the following.

               -1 Normal operation (default).
                    This infocode indicates that figlet should operate
                    normally, not giving any informational printout,
                    printing its input in the selected font.



     Page 5                                           (printed 9/9/95)






     FIGLET(6)              v2.1 (12 Aug 1994)               FIGLET(6)



               0 Version and copyright.
                    This is identical to -v.

               1 Version (integer).
                    This will print the version of your copy of figlet
                    as a decimal integer.  The main version number is
                    multiplied by 10000, the sub-version number is
                    multiplied by 100, and the sub-sub-version number
                    is multiplied by 1.  These are added together, and
                    the result is printed out.  For example, figlet
                    2.1 will print ``20100''.  If there is ever a
                    version 2.1.1, it will print ``20101''.
                    Similarly, version 3.7.2 would print ``30702''.
                    These numbers are guaranteed to be ascending, with
                    later versions having higher numbers.  Note that
                    the first major release of figlet, version 2.0,
                    did not have the -I option.

               2 Default font directory.
                    This will print the default font directory.  It is
                    affected by the -d option.

               3 Font.
                    This will print the name of the font figlet would
                    use.  It is affected by the -f option.  This is
                    not a filename; the ``.flf'' suffix is not
                    printed.

               4 Output width.
                    This will print the value figlet would use for
                    outputwidth, the number of columns wide figlet
                    assumes the screen is.  It is affected by the -w
                    and -t options.

               If infocode is any other positive value, figlet will
               simply exit without printing anything.


          -L
          -R
          -X   These options control whether figlet prints left-to-
               right or right-to-left.  -L selects left-to-right
               printing.  -R selects right-to-left printing.  -X
               (default) makes figlet use whichever is specified in
               the font file.


     EXAMPLES
          To use figlet with its default settings, simply type

               example% figlet




     Page 6                                           (printed 9/9/95)






     FIGLET(6)              v2.1 (12 Aug 1994)               FIGLET(6)



          and then type whatever you like.

          To change the font, use the -f option, for example,

               example% figlet -f script


          Use the -c option if you would prefer centered output:

               example% figlet -c


          We have found that the most common use of figlet is making
          up large text to be placed in e-mail messages.  For this
          reason, figlet defaults to 80 column output.  If you are
          using a wider terminal, and would like figlet to use the
          full width of your terminal, use the -t option:

               example% figlet -t


          If you don't want figlet to smush font characters into each
          other, use the -m0 option:

               example% figlet -m0


          If figlet gets its input from a file, it is often a good
          idea to use -p:

               example% figlet -p < myfile


          Of course, the above can be combined:

               example% figlet -ptm0 -f shadow < anotherfile
               example% figlet -cf slant



        Other Things to Try
          On many systems nice effects can be obtained from the lean
          font by piping it through tr.  Some you might want to try
          are the following:

               example% figlet -f lean | tr ' _/' ' ()'
               example% figlet -f lean | tr ' _/' './\\'
               example% figlet -f lean | tr ' _/' ' //'
               example% figlet -f lean | tr ' _/' '/  '

          Similar things can be done with the block font and many of
          the other figlet fonts.



     Page 7                                           (printed 9/9/95)






     FIGLET(6)              v2.1 (12 Aug 1994)               FIGLET(6)



     FONT FILE FORMAT
          If you would like to design a figlet font, it is usually
          best to begin with an already-existing font.  Except for the
          first line of a font file, most of the file format should be
          obvious.  If you design a font, please let us know about it!
          (See AUTHORS for e-mail addresses.)

          A figlet font filename must have the suffix ``.flf''.

          A figlet font file begins with a header.  The header
          consists of one line giving information about the font,
          followed by zero or more comment lines, which figlet
          ignores.  Following the header is the font data.


        The Header
          The first line of a figlet font file is of the following
          form:

               flf2ahardblank height up_ht maxlen smushmode cmt_count rtol

          where hardblank is a character, and the remaining values are
          integers, for example:

               flf2a$ 6 5 20 15 3 0

          The last value, rtol, may be omitted, in which case it is
          assumed to be 0.

               flf2a$ 6 5 20 15 3


          For those desiring a quick explanation, the above line
          indicates that this font has characters which are 6 lines
          tall, 5 of which are above the baseline, no line in the font
          data is more than 20 characters long, the default smushmode
          is 15 (kern and smush in various ways), there are 3 comment
          lines, and this font is to be printed left-to-right.  More
          in-depth explanations follow.

          The first five characters of a font file should be
          ``flf2a''.  ``flf2'' is the magic number of a figlet 2 font
          file.  The next character (`a') is currently ignored.  It
          may mean something in future versions of figlet.  If it
          does, you can be sure your fonts will still work if this
          character is `a'.

          Immediately following this is the hardblank (character).
          Note that there are no blanks between ``flf2a'' and the
          hardblank.  figlet can smush together consecutive characters
          in various ways.  Normally, any character can be smushed
          into a blank.  A hardblank prints as a blank, but cannot be



     Page 8                                           (printed 9/9/95)






     FIGLET(6)              v2.1 (12 Aug 1994)               FIGLET(6)



          smushed into any character except a blank, and, if smushmode
          32 is enabled, another hardblank.  (For example, the `r' in
          script.flf contains a hardblank, `$' in that font.  To see
          why this is necessary, create a copy of script.flf with this
          hardblank replaced by a blank.  In this new font, the ``tr''
          combination looks awful.)

          By convention, the hardblank is a `$', but it can be any
          character besides blank, newline and null.  If you want the
          entire printing ASCII set available to use, make the
          hardblank a <delete> character.

          Then comes the height (integer).  This is the number of
          screen lines high that each character in the font is.

          up_ht (integer) is the number of lines from the baseline of
          a character to the top of the character, i.e., it is the
          height of a character, ignoring any descenders.  This number
          is currently ignored by figlet, but future versions may use
          it.

          maxlen (integer) is the maximum length of a line in the font
          file (excluding the first line and the comments lines, which
          can be as long as you want).  You may want to make this a
          little too large as a safety measure.

          smushmode (integer) determines how much figlet smushes the
          font.  Possible smushmodes are -1 through 63.  Typically,
          you'll want to use 0 (kern font characters without smushing
          them together), -1 (no kerning or smushing) or 15 (smush
          various pairs of characters together into single
          characters).  To try out different smushmodes with your
          font, use the -m command-line option.  See OPTIONS for a
          more detailed explanation of these smushmodes.  (Note that a
          smushmode of -2 can be given on the command line, but not in
          a font file.)

          Between the first line and the actual characters of the font
          are the comment lines.  Cmt_count specifies how many lines
          there are.  These lines are optional, may be as long as you
          want, and are ignored by figlet.

          rtol (integer) tells which direction the font is to be
          printed.  0 means left-to-right, and 1 means right-to-left.
          Left-to-right text is printed flush-left by default, while
          right-to-left text is printed flush-right by default.  rtol
          may be omitted, in which case 0 (left-to-right) is assumed.
          Earlier versions of figlet (i.e., version 2.0) ignore rtol.

          Thus, a complete figlet font file header will look something
          like the following:




     Page 9                                           (printed 9/9/95)






     FIGLET(6)              v2.1 (12 Aug 1994)               FIGLET(6)



               flf2a$ 6 5 20 15 3
               Example by Glenn Chappell <ggc@uiuc.edu> 8/94
               Permission is hereby given to modify this font, as long as the
               modifier's name is placed on a comment line.


        The Font Data
          The font data begins on the next line after the comments and
          continues to the end of the file.  The characters from ` '
          to `~' are given in standard ASCII order, followed by the
          extra German characters: umlauted `A', `O', `U', `a', `o'
          and `u' and s-z.  Following these are the optional code-
          tagged characters.  Each character uses height lines, where
          height was given on the first line of the font file.  Each
          code-tagged character is preceeded by an extra line with the
          character's code (a number) on it.  The characters in the
          file are given exactly as they should be printed out, with
          two exceptions: (1) hardblanks should be the hardblank
          character, not a blank, and (2) every line has an endmark
          character.

          In most figlet fonts, the endmark is either `@' or '#'.
          figlet eliminates the last block of consecutive equal
          characters from each line (other than the header lines) when
          the file is read in.  By convention, the last line of a font
          character has 2 endmarks, while all the rest have one.  This
          makes it easy to see where characters begin and end.  No
          line should have more than 2 endmarks.

          The code-tagged characters are optional, and are ignored by
          earier versions of figlet (i.e., version 2.0).  The code-
          tagged characters begin just after the German characters.
          There can be as many or as few of these as you like.  The
          first line of a code-tagged character has a single number on
          it, the character's code, which is the number by which
          figlet will refer to it.  This number can be in decimal,
          octal or hexadecimal, using the standard scanf conventions
          for such numbers.  On the next line the character itself
          begins, in the same format as the un-tagged characters.

          If two or more font characters have the same tag, the last
          one in the font is the one used.  For this purpose, the
          normal ASCII characters are considered to have tags equal to
          their ASCII value, while the German characters are given
          tags -255 through -249.

          There is no required encoding for the code-tagged
          characters.  figlet simply prints the character with the
          given code when it is told to.  However, in most of the
          fonts, we have used ISO Latin-1 for characters 160-255,
          following a suggestion of Zhahai Stewart.  Stewart has
          suggested using Unicode for other characters.



     Page 10                                          (printed 9/9/95)






     FIGLET(6)              v2.1 (12 Aug 1994)               FIGLET(6)



          The zero tag is treated specially.  It is figlet's ``missing
          character''.  Whenever figlet is told to print a character
          which doesn't exist in the current font, it will print
          character zero.  If character zero doesn't exist, nothing
          will be printed.


        Notes
          It is very important that every character in a font has the
          same height, and, once the endmarks are removed, that all
          the lines constituting a single font character have the same
          length.  Be careful also that no lines in the font file have
          trailing blanks, as figlet will take these to be the
          endmarks.  Many problems like these can be found easily
          using chkfont, part of the standard figlet package, and also
          available, as of this writing, by anonymous FTP from
          ftp.nicoh.com:pub/figlet/util.

          If you don't want to define all the characters, make the
          undefined characters empty, i.e., each line of the character
          should consist only of one or two endmarks.

          The blank character should usually be made entirely of
          hardblanks.  (Most slanted fonts are an exception to this.)

          If you design a font, it is helpful if you put your name and
          an e-mail address on a comment line.  If you will allow
          others to modify your font, you may want to say so on a
          comment line.

          If a font contains a non-Roman alphabet stored in locations
          normally taken by ASCII, we have found it helpful to include
          a ``translation'' table as one of the characters of the
          font.  Typically, the ``~'' character contains a list of all
          the special characters in the font, along with the ASCII
          characters they correspond to.  It is a good idea to keep
          this table no more than 79 columns wide.  (Thanks to
          Gedaliah Friedenberg for this idea.)

          Again, if you design a font, please let us know!


     CONTROLFILE FORMAT
          (Note: This section isn't terribly well-written.  I really
          don't have time right now to do much with it.  If you want
          to write a controlfile, just look at the existing files and
          ignore the f command, and you'll probably do pretty well.
          Anyone needing extra help can write us at <figlet@uiuc.edu>.
          Also, anyone willing to revise this section or the FONT FILE
          FORMAT section is welcome to do so.  Please let us know
          about your efforts if you give it a try.  -GGC-)




     Page 11                                          (printed 9/9/95)






     FIGLET(6)              v2.1 (12 Aug 1994)               FIGLET(6)



          Controlfiles are files containing lists of commands that
          figlet executes each time it reads a character.  A
          controlfile is specified to figlet using the -C command line
          option (see OPTIONS).  In the file itself the first line
          identifies the file as a figlet controlfile, and the
          remaining lines are the commands, one per line.  Currently,
          the only recognized commands tell figlet to translate one
          character to another (similar to the Unix tr command).  In
          future versions of figlet, more commands may be added.  As
          with font files, when writing a controlfile, it is usually
          best to begin with an existing file.

          The filename of a figlet controlfile must have the suffix
          ``.flc''.

          The first five characters of a controlfile should be
          ``flc2a''.  ``flc2'' is the magic number of a figlet
          controlfile.  The next character (`a') is currently ignored.
          It may mean something in future versions of figlet.  If it
          does, you can be sure your files will still work if this
          character is `a'.

          Each of the following lines of the file consists of a one-
          character command followed by whatever parameters the
          command requires, excepting blank lines, which are ignored.
          There are currently three recognized commands: #, t and f.


          # comment
               Any line beginning with # is ignored.


          t translate
               This is similar to the Unix tr command.  It directs
               figlet to ``translate'' one character to another.
               ``t'' is followed by one or more blanks, then by a
               character (or range of characters, e.g., ``A-Z'') then
               one or more blanks, then another character (or range).

               For example,

                    t # $

               will convert `#' to `$', while

                    t A-Z a-z

               will convert upper-case ASCII to lower-case ASCII.  A
               range should always be followed by another range of the
               same size.

               A number of backslash (`\') options are available for



     Page 12                                          (printed 9/9/95)






     FIGLET(6)              v2.1 (12 Aug 1994)               FIGLET(6)



               specifying characters.  Any of the standard ``C''
               language backslash-character conventions are legal,
               e.g., ``\n'' for newline, etc.  Also, backslash-blank
               can be used to specify a blank character.  Backslash
               followed by a number in any of the standard scanf
               formats (decimal, octal or hexadecimal) specifies the
               character with the given code.  For example,

                    t \n-\  \65-W

               will convert all characters from newline to blank into
               the corresponding characters from `A' to `W' (`A' has
               code 65).

               If a number of consecutive t commands are given, then
               for each character input, only the first applicable
               command, if any, will be executed.  As a result,

                    t A B
                    t B A

               will swap the characters `A' and `B'.  If figlet reads
               an `A' the first command will change `A' to `B', in
               which case the second will not be executed.  In the
               following list,

                    t A B
                    t A C

               the second command is never executed.  In short, a
               sequence of t commands ``does what it ought to''.


          f freeze
               More complex files, in which a single character is
               acted upon by several t commands, can be set up using
               the f command.  f ``freezes'' the current character,
               executing the remaining commands in the controlfile as
               if they were in a separate file.  The f command has no
               parameters, and anything following it on the same line
               is ignored.  (Note: If you, along with so many others,
               cannot figure out what the f command does, or why
               anyone would use it, feel free to ignore it.)  After
               figlet executes a t command, it skips to the end of the
               file or to the next f command.  If any t commands
               follow, the first applicable one will be executed.  The
               result is that f acts as a ``freeze'', executing the
               remaining commands as if they were in a separate file.



     FILES



     Page 13                                          (printed 9/9/95)






     FIGLET(6)              v2.1 (12 Aug 1994)               FIGLET(6)



          file.flf            figlet font file
          file.flc            figlet control file


     DIAGNOSTICS
          figlet's diagnostics are intended to be self-explanatory.
          Possible messages are

               Usage: ...
               Out of memory
               Unable to open font file
               Not a figlet 2 font file
               Unable to open control file
               Not a figlet 2 control file
               "-t" is disabled, since ioctl is not fully implemented.

          This last message is printed when the -t option is given,
          but the operating system in use does not include the system
          call figlet uses to determine the terminal width.

          figlet also prints an explanatory message if the -F option
          is given on the command line.  The earlier version of
          figlet, version 2.0, listed the available fonts when the -F
          option was given.  This option has been removed from figlet
          2.1.  It has been replaced by the figlist script, which is
          part of the standard figlet package.


     ORIGIN
          ``figlet'' stands for ``Frank, Ian and Glenn's LETters''.
          Inspired by Frank's .sig, Glenn wrote (most of) it, and Ian
          helped.

          Most of the standard figlet fonts were inspired by
          signatures on various UseNet articles.  Since typically
          hundreds of people use the same style of letters in their
          signatures, it was often not deemed necessary to give credit
          to any one font designer.


     BUGS
          Very little error checking is done on font and control
          files.  While figlet tries to be forgiving of errors, and
          should (hopefully) never actually crash, using an
          improperly-formatted file with figlet will produce
          unpredictable output.

          figlet does not handle formatting characters in a very
          intelligent way.  A tab character is converted to a blank,
          and vertical-tab, form-feed and carriage-return are each
          converted to a newline.  On many systems, tabs can be
          handled better by piping files through expand before piping



     Page 14                                          (printed 9/9/95)






     FIGLET(6)              v2.1 (12 Aug 1994)               FIGLET(6)



          through figlet.

          figlet output is quite ugly if it is displayed in a
          proportionally-spaced font.  I suppose this is to be
          expected.


     AUTHORS
          Glenn Chappell <ggc@uiuc.edu> did most of the work. You can
          e-mail him but he is not an e-mail fanatic; people who e-
          mail Glenn will probably get answers, but if you e-mail his
          best friend:

          Ian Chai <chai@uiuc.edu>, who is an e-mail fanatic, you'll
          get answers, endless conversation about the mysteries of
          life, invitations to join some 473 mailing lists and a free
          toaster.  (Well, ok, maybe not the free toaster.)

          Frank inspired this whole project with his .sig, but don't
          e-mail him; he's decidedly an un-e-mail-fanatic.



































     Page 15                                          (printed 9/9/95)
