             Borland Turbo Vision (Pascal) Bug List
                        Version 2.0


Last Updated: 3/1/94

Maintained by: Brad Williams
               bwilliams@marvin.ag.uidaho.edu


*** This list is PASCAL TurboVision (TV) specific.  For a C++  
specific buglist, see the file \turbo-vision\faq\tvbugs.cpp
maintained by Marc Stern (stern@mble.philips.be) on the
anonymous ftp site vtucs.cc.vt.edu.  Most bugs and fixes
presented have been discussed on the listserv TurbVis or the
Usenet group comp.os.msdos.programmer.turbovision.  For 
compiler specific bugs, see the bug lists TP6BUGSx.ZIP and 
BP7BUGSx.ZIP maintained by Duncan Murdoch 
(dmurdoch@mast.QueensU.CA) on garbo.uwasa.fi in the 
\pc\turbopas directory.  Many of the TV bugs and patches
listed are converted from a list formerly maintained by Juergen
Schlegelmilch.  Great appreciation for his prior efforts.

This list contains bug fixes and enhancements to the TV
sources.  These enhancements are obviously subjective and rely
most of the time on personal feelings of the posters about the
look and feel of their applications.

*** This is an unofficial list and is not a substitute for
*** Borland Technical or customer support which can be reached
*** at 800-331-0877 for registered Borland product owners.
*** Borland customer on-line service can be reached at
***
***           customer-support@borland.com
***
*** Online technical support is not available.  Borland's
*** internet address for reporting bugs is
***
***           bugs@borland.com

All submissions determined to be "true" bugs will be forwarded
to Borland.  The maintainer of this list, the authors of bug
fixes, and the vtucs.cc.vt.edu ftp site are not responsible for
the reliability of any information presented in this document. 

*** Always make a backup of the source code file under a new
*** name prior making any changes to the original file.

Send all comments about bugs you have discovered and any
patches to the maintainer of this list or to the TurbVis
listserv for discussion.  Please include a description of the
problem you are having and a small section of source code which
will duplicate the problem when compiled/run.  All suggestions
for improvement of current patches are appreciated.

If you do not have Internet access, bugs and patches can be
submitted through Duncan Murdoch at:

               CompuServe: 71631,122
               Fidonet   : DJ Murdoch at 1:249/99.5

or directly by postal delivery to:

               Dr. Brad Williams
               Research Office
               University of Idaho
               Moscow, Idaho 83844


How to Use This List
--------------------
At the beginning of this list is an index of new
problems/enhancements/questions or changes to old
problems/enhancements/questions in reverse chronological order.
This facilitates quick review for changes from previous
additions.  Following is the list of
problems/enhancements/questions about TV in topical order. 
They are discussed and source code patches referenced where
available. All source code patches in this file are placed at
the end in alphabetic order according to the procedure,
function, or object's name, then by individual object method.
For example,

         AddToBuffer
         TCollection.Init
         TCollection.Load
         TObject.Free
         TProgram.Exec

If extensive files are required, the individual file will be
referenced under the appropriate problem/enhancement/question. 

There are two possible methods for searching this document, by
topic under the PROBLEMS/QUESTIONS section or by procedure,
function, or object method name under the PATCHES section.  All
PROBLEMS/QUESTIONS and PATCHES are cross-referenced.  If you do
not find the topic/patch in one list, check the other.  If you
still cannot find a solution look at the FAQ (TVPAS.FAQ) posted
at this site.  If you still cannot determine a solution to your
problem, post a message to the listserv TurbVis or Usenet group
comp.os.msdos.programmer.turbovision.

---------------------------------------------------------------
       CHRONOLOGICAL INDEX OF CHANGES TO THIS DOCUMENT
---------------------------------------------------------------
4-1-94 - Version 2.1
   Views - 8 deleted - patch not required
1-1-94 - Version 1.0 of this list
   Collections - 1
   Editors - 8, 9
   Help - 4, 5
   Menus - 1
   Views - 4, 5, 6, 7, 8

5-10-93 - First edition of this list
   Drivers - 1
   Editors - 1,2,3,4,5,6,7
   Help - 1,2,3
   Outlines - 1
   Streams - 1
   Views - 1,2,3
   Windows - 1

---------------------------------------------------------------
             PROBLEMS / ENHANCEMENTS / QUESTIONS
---------------------------------------------------------------
Collections
-----------
1. Problem   : Program crashes when expanding a collection if a
               heap error handler is installed to return Nil when
               there is insufficient memory.
   Version   : 1.0, 2.0
   Type      : Bug
   Reference : TCollection.SetLimit

   TCollection.SetLimit does not allow a NIL result after memory
   allocation failures.   It assumes that if GetMem returns, then
   it has succeeded.  It will copy the old items on top of the
   interrupt vector table at 0:0 and the program crashes or hangs.


Drivers
-------
1. Problem   : Calling MoveBuf (unit Drivers) with an Attr
               parameter of 0 would produce a corrupt draw
               buffer.
   Version   : 1.0
   Type      : Bug
   Reference : MoveBuf

   There is a STOSB instruction where a MOVSB should be.


Editors
-------
1. Problem: When TFileEditor is Loaded from a stream it gives
            unusual codes in the edit window and sometimes
            hangs the system.
   Version: 1.0
   Type   : Bug
   Patch  : TFileEditor.InitBuffer

   TFileEditor.NewBuffer allocates 0 bytes, but does not set
   BufSize to 0. If TFileEditor.Load loads a TFileEditor from a
   stream,  BufSize is read from the stream, too, and has its
   old value.  InitBuffer (called by TEditor.Load) ignores it,
   so the content of the editor is loaded into memory, which
   was never allocated -> the program will crash. So you can't
   use TFileEditors, if you store and load the desktop.


2. Problem: When I try to "find" text in an editor window the
            program crashes.
   Version: 1.0
   Type   : Bug
   Patch  : IScan

   In this assembly-routine the programmer forgot that MOV
   does not set the flags. If the search string nearly matches
   the last chars in the text, the routine runs over the end of
   the text -- eventually replacing text! Here is an example:
   Let '123456' be the text, and search for '45z'.
   The routine scans the text '1234' for the '4' and finds it:
         123456
            45z
   Then it compares the rest, finds the difference and skips
   this occurence. CX (number the chars left in the text) is
   now 0, but the routine just MOVs it back from DX, jumping
   then with JNE. Now it is behind the end of text!


3. Problem: All scroll bar events are "stolen" by TMemo when
            used in a TDialog with any other view that has a
            scroll bar.
   Version: 1.0
   Type   : Bug
   Patch  : TEditor.HandleEvent

   This routine consumes all cmScrollBarChanged-events, without
   testing the sender. With TEditor, everything is ok, but with
   TMemo, there is a problem.  TMemo cannot coexist in a
   TDialog with other objects having scrollbars. The test, whe-
   ther a cmScrollBarChanged-event is from one of its own
   scroll bars is done in the local procedure CheckScrollBar,
   but the HandleEvent routine clears the event in any case.


4. Problem : Unpredictable results after insufficient memory
             when overwriting text.
   Version : 1.0
   Type    : Bug
   Patch   : TEditor.InsertBuffer

   Overwriting chars in an TEditor object is done in
   TEditor.HandleEvent by marking the next char as block and
   calling InsertBuffer via InsertText. This routine checks,
   whether there is enough memory and complains
   (edOutOfMemory), but does not reset the block marker. If you
   now press backspace, the block is deleted (i.e. the char
   under the cursor), not the char on the left side of the
   cursor.

   Example:
   Be sure to compile TVDEMOS\TVEDIT.PAS without the Range
   Check option; there seems to be another minor bug
   concerning Integer and Word types. Start TVEDIT.EXE, open a
   new edit window and start typing until the messagebox 'Not
   enough memory for this operation' comes up. Press Enter to   
   close the messagebox, move the cursor in the middle of a
   line and type until the messagebox comes up again. Press     
   Enter to close it again and then press Backspace. Not the
   char on the left side of the cursor will be deleted, but
   the char at cursor position.


5. Problem : ^T sometimes deletes more than the next word.
   Version : 1.0
   Type    : Enhancement
   Patch   : TEditor.NextWord

   ^T deletes _up to the next_ word, to be exact: up to the
   next char out of
   WordChars: set of Char = ['0'..'9', 'A'..'Z', '_', 'a'..'z']
   This will usually be just the next word, but can be more.
   The IDE editor first skips the current word if the cursor is
   in one. Then it skips blanks and tabs up to the next
   non-blank/non-tab.

   The patch has been patched to avoid problems if the current
   char is the last char is the last char in the buffer and not
   a WordChar.


6. Problem : ^QF followed by ^L followed by Space deletes words
             in TVEdit.
   Version : 1.0, 2.0
   Type    : Bug
   Patch   : TEditor.HandleEvent

   If you mark a block manually and type a key, the block will
   be replaced by the key. Because occurences of the search
   string are marked as block, the described effect is seen. If
   you really want to avoid it, you have to change
   TEditor.HandleEvent to clear the blockmarkers before
   inserting a normal char.

7. Problem : The number keys 3-6 can not be entered.
   Version : 1.0
   Type    : Bug
   Patch   : TEditor.ConvertEvent

   There are actually two changes listed under ConvertEvent
   that need to be made.

8. Problem : TEditor and TMemo have been working fine but now 
             when I delete any text in an editor Window my
             program crashes with an arithmetic overflow.
   Version : 1.0, 2.0
   Type    : Bug
   Patch   : Recompile EDITORS.PAS with the $Q- compiler 
             directive.

   Most TV units have errors that result in an arithmetic 
   overflow.

9. Problem : When a TMemo or TEditor is hidden in a dialog,
             its associated scrollbars and indicator can
             not be hidden.
   Version : 1.0, 2.0
   Type    : Bug
   Patch   : TEditor.SetState

   The SetState method always sets the scrollbars' and
   indicator's State fields when it is in the sfActive
   mode, rather than in the sfFocused mode.  This
   patch also applies to the NewEdit in
   NED103.ZIP/NED3.ZIP



Help
----
1. Problem : Garbage added instead of a defined cross-
             reference.
   Version : 1.0
   Type    : Bug
   Patch   : THelpFile.AddCrossReference

  In this routine the programmer allocates memory and then
  forgets to use the pointer to it. He just forgot a line.

2. Problem : Get a run time error if Range Checking is on or a
             randomly chosen help text or garbage displayed
             with Range Checking turned off when a help topic
             context does not.
   exist.
   Version : 1.0
   Type    : Bug
   Patch   : THelpIndex.Position

   If called with a negative argument, it returns random
   values, since it checks only for the upper bound, not for
   the lower one. The help compiler TVHC uses -1 for unknown
   topics, so this doesn't work.

   Example:
   Compile TVDEMOS\TVDEMO.PAS to disk. Then add the line {abc}
   to the first topic in TVDEMOS\DEMOHELP.TXT and compile it
   with TVHC DEMOHELP.TXT.  This will produce DEMOHELP.HLP and
   DEMOHELP.PAS. Start TVDEMO.EXE, press F1 to see the general
   help and then Enter to follow the cross reference 'abc'.
   You will not see the text 'No help available in this
   context.', as intended by HELPFILE.PAS, but get a runtime
   error (if you compiled TVDEMO with Range Check option) or a
   randomly chosen help text if any (without Range checking).

3. Problem : If range checking is not enabled, the system hangs
             or TVHC crashes with a runtime error 204 if a
             large help topic is read into TVHC.
   Version : 1.0
   Type    : Bug
   Patch   : AddToBuffer

   In TV 1.0 AddToBuffer has the incorrect assembler routine.
   (Not tested for CopyToBuffer in version 2.0)

   No range checking is done in this routine. If a paragraph is
   longer than specified in the constant BufferSize
   (default:1024), memory behind the buffer is overwritten,
   resulting in crash.

   Example:
   Create a file TESTHELP.TXT with this content:
    .topic TestContext
    The following paragraph is too long to fit into the
    standard-sized buffer of TVHC.PAS:
      1234567890123456789012345678901234567890
      1234567890123456789012345678901234567890

        .. another 100 lines likes these ..

      1234567890123456789012345678901234567890
      1234567890123456789012345678901234567890
   Now start TVHC on it:   TVHC TESTHELP.TXT
   Your system will hang, if you haven't compiled TVHC with
   Range Check option, otherwise you will get a runtime error
   204.

4. Problem : A empty help topic causes a help file crash.
   Version : 2.0
   Type    : Bug
   Patch   : THelpTopic.Load

   If the help topic is declared in the help script but
   does not contain any text following it the help engine
   crashes when it is displayed.

   .topic First
   .topic Second

   hcFirst exists, but has no text (empty).

   THelpTopic.Load never calls its inherited constructor to
   initialize its data fields.

5. Problem : Sometimes the TVHC help compiler crashes with
             a run time error 204.
   Version : 1.0, 2.0
   Type    : Bug
   Patch   : custom help text

   More than one possibility, but a run time 204 error can
   be caused by brackets for a cross reference being placed
   on two different lines.  The brackets must be on ONE
   line.  Spaces should not be used around the aliases.


Menus
-----
1. Problem : Heap used by TPopMenu's is not recovered when the menu is
             destructed.
   Version : 1.0, 2.0
   Type    : Bug
   Patch   : TMenuPopup.Done

   TMenuPopup inherits its destructor from TMenuView.Done.  Because
   TMenuBar does not want to reconstruct the TMenuItem list it uses
   each time a submenu is opened, a global procedure (DisposeMenu) is
   used for releasing the heap used by the TMenuItem list in a
   TMenuBar.  TMenuPopup never creates a destructor to release the
   heap as is done in TMenuBar.Done.


OutLines
--------

1. Problem : Run out of memory when using the Outline unit.
   Version : 2.0 (corrected in TP/BP maintainence version 7.01)
   Type    : Bug
   Patch   : DisposeNode

   The DisposeNode procedure in the Outlines unit neglects to
   dispose of the Text string allocated by NewNode.  This means
   that disposing of a POutline object leaves all the strings
   sitting in memory.  It also has redundant tests to avoid
   disposing of a nil pointer.

2. Problem : TOutline gives invalid colors when inserted in a
             monochrome window.
   Version : 2.0
   Type    : Bug
   Patch   : App.Colors

   CAppMonochrome and CMonochrome were not updated by Borland to
   the new color schemes and they have some entries (the last ones
   that are mapped to CxxxxWindow) set to zero.  These should be
   set to a valid value.

Streams
-------

1. Problem : TBufStream sometimes writes garbage to the stream.
   Version : 1.0
   Type    : Bug
   Patch   : FlushBuffer

   The local procedure FlushBuffer in the WObjects and Objects
   units has an incorrect JE instruction.

Views
-----

1. Problem - The path returned by TFileDialog is incorrect.
   Version: 1.0, 2.0 (corrected in TP/BP maintainence version
                    7.01)
   Type : Bug
   Patch: TFileDialog.GetFileName.1

   The GetFileName method receives an incorrect result from the
   RelativePath function. RelativePath is actually not a method
   of TFileDialog, but a local function in the GetFileName
   method. The assignment of the RelativePath result is
   incorrect.

2. Problem : System hangs when attempting to open a file using
             TFileDialog with a "*" as the wildcard.
   Version : 1.0
   Type    : Bug
   Patch   : NoWildChars

   This routine is used by TFileDialog-objects to delete
   wildcards in filenames. If called with an empty argument, it
   overwrites the stack. Try it: just give first '*' as mask,
   then a name with no extension in a TFileDialog.

   Example:
   TVDEMOS\TVDEMO.PAS. Create the file TEST (no extension!),
   then start TVDEMO.EXE. Press F3 to invoke the FileOpen
   dialog. Type "*" without the quote marks, press Enter,
   choose TEST from the file list and press Enter again: The
   system hangs.

3. Problem : Poor quality history buttons.
   Version : 1.0, 2.0
   Type    : Bug
   Patch   : None (THistory.Draw)

   THistory.Draw (Unit Dialogs) uses chars ASCII 221 and 22 for
   the history button sides. These chars are _not_ included in
   codepages other than 437 (e.g. codepage 850, recommended by
   IBM for europe). So, the button looks somewhat awful in
   europe.
   Example:
   To use codepage 850 with your display, include the lines
   (with correct paths, of course)
      nlsfunc.exe country.sys
      mode con cp prepare=((850)ega.cpi)
   in your AUTOEXEC.BAT and type CHCP 850 at the DOS prompt
   after startup. DOS will complain, because you haven't
   prepared this codepage for all devices, but this doesn't
   matter. Start TVDEMOS\TVDEMO and press F3 to invoke a
   TFileDialog with a history button on the left side of the
   'Name' input line. Look at the System-menu symbol for
   another example of such incompatibly written software.

4. Problem : When a default button's command is disabled, pressing
             return on a control that is not a button causes the
             cmDefault command to be sent.
   Version : 1.0, 2.0
   Type    : Bug
   Patch   : TButton.HandleEvent

   TButton.HandleEvent does not check the current State of
   the button to see if it is disabled before responding to
   a cmDefault command.


5. Problem : The incremental search in a TSortedListBox is out of
             synch after releasing and regaining the focus.
   Version : 1.0, 2.0
   Type    : Bug
   Patch   : TSortedListBox.HandleEvent

   SearchPos is never reset when the focus is released and regained.
   The cursor is repositioned at column 1 in the listbox and gives a
   flicker when backspace is pressed.


6. Problem : The system hangs or the program crashes when
             TListBox.GetText is called.
   Version : 1.0, 2.0
   Type    : Bug
   Patch   : TListBox.GetText

   TListBox.GetText does not check to see if the pointer returned
   from its associated List is Nil.


7. Problem : When a control is loaded from a resource file,
             the ofSelectable bit in the Options flag is
             always set.
   Version : 1.0, 2.0
   Type    : Bug
   Patch   : TCluster.SetButtonState

   TCluster.Load calls TCluster.SetButtonState which always
   sets the ofSelectable bit.


8. Problem : A system crash occurs when a window containing
             a TStaticText that has no string (Text = NIL)
             is disposed.
   Version : 1.0, 2.0
   Type    : Bug
   Patch   : TStaticText.Done

   TStaticText.Done does not check to see if Text is Nil
   before it attempts to dispose Text.


9. Problem : In a TFileDialog, when a directory list that
             is not the current driver is displayed, typing
             a path name that begins with '\' results in an
             attempt to open a file in the root directory
             by the name entered in the file inputline.
   Version : 1.0, 2.0
   Type    : Bug
   Patch   : TFileDialog.GetFileName.2

   The Directory variable's drive letter is never prepended
   to the file name entered.  When FExpand is called it
   assumes the current drive is used resulting in looking
   for the directory on the wrong drive.


10. Problem : Subviews in a window or dialog that have their
              ofCenterX or ofCenterY bits set do not remain
              centered when its owner is resized.
    Version : 1.0, 2.0
    Type    : Bug
    Patch   : TView.DrawView

    TView.DrawView may not be the best place to put this
    patch, but it worked and another place could not be
    found.  Simply calling TWindow.Redraw after resizing
    the owner does not correct the problem.  There is never
    any check of the ofCenterX or ofCenterY flags after a
    view has been inserted into the dialog.



Windows
-------

1. Problem : A window that has neither the wfGrow nor wfMove
             flags set does not disable the cmResize command
             when it is active.
   Version : 1.0, 2.0
   Type    : Bug
   Patch   : TWindow.SetState

   A pair of parentheses is missing in the TWindow.SetState
   method so that Flags and wfGrow are AND'd the wfGrow added
   to them.  The result is always nonzero and will result in
   always disabling the cmResize.


---------------------------------------------------------------

                         PATCHES
---------------------------------------------------------------
Procedure : AddToBuffer
Version   : 1.0
Type      : Bug
File      : Tvhc.pas
Reference : Help.3
Submitter : Juergen Schlegelmilch
Patch     :

TV 1.0  procedure AddToBuffer(var Line: String; Wrapping:      
                              Boolean);

 assembler;
  asm
          PUSH    DS
          CLD
          PUSH    DS
          POP     ES
          MOV     DI,OFFSET Buffer
          ADD     DI,Ofs
          LDS     SI,Line
          LODSB
          XOR     AH,AH
 { ** patch: the following test is missing in the original ** }
 { ** version. Causes crashes on buffer overflow           ** }
          MOV     BX,BufferSize { BufferSize-Ofs is the space
                                left in Buffer }
          SUB     BX,ES:Ofs
          CMP     BX,AX { AX holds the needed amount of space }
          JAE     @@0           { enough -> ok }
          MOV     AX,BX        { else just fill the Buffer up }
  @@0:
          ADD     ES:Ofs,AX
          XCHG    AX,CX
          JCXZ    @@3          { don't copy 64K if there is     
                                nothing to do }
          REP     MOVSB
          CMP     ES:Ofs,BufferSize
          JE      @@3           { don't append ' '/#13 if there 
                                  is no room }
          XOR     AL,AL
          INC     ES:Ofs
          TEST    Wrapping,1    { Only add a #13, line          
                                terminator, if not }
          JE      @@1           { currently wrapping the text.
                                 Otherwise  }
          MOV     AL,' '-13     { add a ' '. }
  @@1:    ADD     AL,13
  @@2:    STOSB
  @@3:
          POP     DS
  end;

---------------------------------------------------------------

Function : DisposeNode
Version  : 2.0 (corrected in TP/BP maintainence version 7.01)
Type     : Bug
File     : Outline.pas 
Reference: Outline.1
Submitter: ?
Patch    :

   CHANGE FROM:

   procedure DisposeNode(Node: PNode);
   begin
     if Node <> nil then
       with Node^ do
       begin
         if ChildList <> nil then DisposeNode(ChildList);
         if Next <> nil then DisposeNode(Next);
       end;
     Dispose(Node);

   CHANGE TO:

   procedure DisposeNode(Node: PNode);
   begin
     if Node <> nil then
       with Node^ do
         begin
           DisposeNode(ChildList);
           DisposeNode(Next);
           DisposeStr(Text);
           Dispose(Node);
         end;
   end;

---------------------------------------------------------------

Function : FlushBuffer
Version  : 1.0
Type     : Bug
File     : WObjects.pas, Objects.pas
Reference: Streams.1
Submitter: Borland (Amrik Dhillon)
Patch    :

   Two possibilites, source code patch or TPU patch with DEBUG.

   Source Code - In the FlushBuffer procedure, change the first
      "JE @@4" instruction to "JE @@3".

   Using DEBUG <g>,

   In WObjects.TPU

   -e7ca3
       43.35
   -w

   In Objects.TPU

   -e2c75
       45.37

   -w
   

---------------------------------------------------------------

Function : IScan
Version  : 1.0
Type     : Bug
File     : Editors.pas
Reference: Editors.2
Submitter: Juergen Schlegelmilch
Patch    :

(* Comment: The only change needed is the line marked with ***.
   But for better use of TEditor objects outside the USA and
   GB, it's better to use the DOS codepage (MSDOS3.X or higher
   required) for case conversion. *)

  { Improvement JS: UpperCase uses DOS codepage }
  procedure DOSUpCase; assembler;
  { a dummy to get a pointer in the codesegment }
  asm
          DD 0
  end;

  function UpperCase:Char ; assembler ;
  { changes lower case to upper case letters, using DOS         
  codepage. Does not need DS to point to Turbo's global data
 segment.
    input : AL char
    output: AL upper case of it }
  asm
       CMP  AL,'a'           { normal lower case chars.. }
       JB   @@1
       CMP  AL,'z'
       JBE  @@4              { .. get normal treatment. }
       DB   $2E,$FF,$1E      { this is a CALLF [cs:] }
       DW   DOSUpCase        { all others are converted using }
       JMP  @@1              { the DOS codepage }
  @@4:
       SUB AL,20H
  @@1:
  end ;

  function UpCase(c:Char): Char; assembler;
  { should be exported, i.e. included in interface }
  asm
       MOV   AL,c
       CALL UpperCase
  end;

  function IScan(var Block; Size: Word; Str: String): Word;
assembler;
  var
    S: String;
  asm
   PUSH  DS
   MOV   AX,SS        { copy the Str to S, converting it.. }
   MOV   ES,AX        { to upper case }
   LEA   DI,S
   LDS   SI,Str
   XOR   AH,AH
   LODSB              { copy string length }
   STOSB
   MOV   CX,AX
   MOV   BX,AX
   JCXZ  @@9
@@1:    LODSB         { load each char from Str.. }
   CALL  UpperCase    { get upper case of it.. }
   STOSB              { and store it to S }
   LOOP  @@1
   SUB   DI,BX    { goto beginning of S (without length byte) }
   LDS   SI,Block
   MOV   CX,Size
   JCXZ  @@8
   CLD
   SUB   CX,BX        { no need to examine the last chars in..}
   JB    @@8          { Block, the search string won't fit }
   INC   CX
@@4:    MOV   AH,ES:[DI]  { search for the first char of search 
                            string }
@@5:    LODSB
   CALL  UpperCase
   CMP AL,AH     { compare chars from Block with first char.. }
   LOOPNE @@5         { of search string until found }
   JNE   @@8          { no occurence -> goto end }
   DEC   SI           { compare the whole search string }
   MOV   DX,CX      { save number of remaining bytes in Block }
   MOV   CX,BX        { get search string length }
@@6:    REPE  CMPSB   { exact match.. }
   JE    @@10         { up to end of search string -> success }
   MOV   AL,DS:[SI-1] { else: }
   CALL  UpperCase    { compare upper case }
   CMP   AL,ES:[DI-1]
   JE    @@6          { matches -> continue }
   SUB   CX,BX      { else compare failed; restore pointers.. }
   ADD   SI,CX        { in Block.. }
   ADD   DI,CX        { and search string }
   INC   SI
   MOV   CX,DX   { restore number of remaining bytes in Block }
   OR    CX,CX        { *** MOV does not modify the flags! ***}
   JNE   @@4          { zero remaining bytes -> end }
@@8:    XOR   AX,AX   { end without success: return 0 }
   JMP   @@11
@@9:    MOV   AX, 1   { end with empty search string:.. }
   JMP   @@11         { pointer to next char }
@@10:   SUB   SI,BX   { end with success: return pointer to.. }
   MOV   AX,SI        { found occurence }
   SUB   AX,WORD PTR Block
   INC   AX
@@11:   DEC   AX      { set correct range of AX for BOOLEAN }
   POP DS
  end;

{ an init routine, replacing the END. at end of EDITORS.PAS}
  const RetFar:Byte=$CB ;
  var i: Integer;
  begin
    { Improvement JS: UpperCase uses DOS codePage }
    asm
      push  ds
      mov   ds,PrefixSeg
      mov   dx,$D0 { DS:DX = 32 bytes scratch area in the PSP }
      mov   ax,$3800      { get extended country information }
      int   21h
      mov   bx,dx
      mov   ax,[bx+$12]   { Pointer to case conversion          
                          routine.. }
      mov   bx,[bx+$14]   { for chars >80h }
      pop   ds
      jnc   @@ok       { if DOS reports error, set it to RETF }
      mov   ax,Offset RetFar
      mov   bx,ds
@@ok:
      mov   word ptr cs:DOSUpCase,ax
      mov   word ptr cs:DOSUpCase+2,bx
    end ;
  end.

---------------------------------------------------------------
Procedure : MoveBuf
Version   : 1.0
Type      : Bug
File      : Drivers.pas
Reference : Drivers.1
Submitter : Hans Schleichert [100031,775]
Patch :

   Change the STOSB into a MOVSB in the MoveBuf procedure.

   An alternative fix is to patch DRIVERS.TPU:

   Patch the byte $AA at offset decimal 7085 (hex $1BAD) in
   DRIVERS.TPU to $A4 to make the change.

---------------------------------------------------------------

Object   : NoWildChars
Version  : 1.0
Type     : Bug
File     : StdDlg.pas
Reference: Views.2
Submitter: Juergen Schlegelmilch
Patch    :

  function NoWildChars(S: String): String; assembler;
  asm
          PUSH  DS
          LDS   SI,S            { pointer to argument string }
          LES   DI,@Result      { same to result string }
          XOR   AX,AX
          LODSB               { get length of argument string }

          { ** patch: test for empty argument string ** }

          OR    AL,AL           { length=0 ? }
          JE    @@3             { -> result = '' }
          XCHG  AX,CX           { else: }
          INC   DI              { skip result length byte }
  @@1:    LODSB               { get char from argument string }
          CMP   AL,'?'          { '?' or '*' ? }
          JE    @@2             { then skip it.. }
          CMP   AL,'*'
          JE    @@2
          STOSB             { else copy it into result string }
  @@2:    LOOP  @@1
          XCHG  AX,DI   { calculate length of result string.. }
          MOV DI,WORD PTR @Result
          SUB AX,DI            { as Endoffset+1 - Startoffset }
          DEC     AX            { don't count the length byte }
  @@3:
          STOSB                 { set length of result string }
          POP DS
  end;

---------------------------------------------------------------

Object   : TButton.HandleEvent
Version  : 1.0, 2.0
Type     : Bug
File     : Dialogs.pas
Reference: Views.4
Submitter: Brad Williams
Patch    :

   Change the following section of TButton.HandleEvent from:

   CASE Event.What OF
     ...
     evBroadcast : CASE Event.Command OF
                     cmDefault : IF AmDefault
                                    THEN BEGIN
                                           Press;
                                           ClearEvent(Event);   
                                         END;
     .....
   END;

   to:
   
   CASE Event.What OF
     ...
     evBroadcast : CASE Event.Command OF
                     cmDefault : IF AmDefault AND 
                                    (State AND sfDisabled = 0)
                                    THEN BEGIN
                                           Press;
                                           ClearEvent(Event);
                                         END;
     ...
   END;



---------------------------------------------------------------

Object   : TCluster.SetButtonState
Version  : 1.0, 2.0
Type     : Bug
File     : Dialogs.pas
Reference: Views.7
Submitter: Brad Williams
Patch    : Change TCluster.SetButtonState to the following:


procedure TCluster.SetButtonState(AMask: Longint; Enable: Boolean); assembler;
asm
        LES     DI,Self
        MOV     AX,AMask.Word[0]
        MOV     DX,AMask.Word[2]
        TEST    Enable,0FFH
        JNZ     @@1
        NOT     AX
        NOT     DX
        AND     ES:[DI].TCluster.EnableMask.Word[0],AX
        AND     ES:[DI].TCluster.EnableMask.Word[2],DX
        JMP     @@2
@@1:    OR      ES:[DI].TCluster.EnableMask.Word[0],AX
        OR      ES:[DI].TCluster.EnableMask.Word[2],DX
@@2:    MOV     CX,ES:[DI].Strings.TCollection.Count
        CMP     CX,32
        JA      @@5              { change @@6 -> @@5 }
        MOV     BX,ES:[DI].TCluster.Options
        AND     BX,not ofSelectable
        MOV     AX,ES:[DI].TCluster.EnableMask.Word[0]
        MOV     DX,ES:[DI].TCluster.EnableMask.Word[2]
@@3:    SHR     DX,1
        RCR     AX,1
        JC      @@4
        LOOP    @@3
      { JMP @@5 delete this and
        change @@5-> @@4, @@6 -> @@5 }
@@4:    MOV     ES:[DI].TCluster.Options,BX
@@5:
end;


---------------------------------------------------------------

Object   : TCollection.SetLimit
Version  : 1.0, 2.0
Type     : Bug
File     : Objects.pas
Reference: Collections.1
Submitter: Duncan Murdoch
Patch    :

PROCEDURE TCollection.SetLimit(ALimit: Integer);
VAR
  AItems: PItemList;
  begin
    if ALimit < Count then ALimit := Count;
    if ALimit > MaxCollectionSize
       then ALimit := MaxCollectionSize;
    if ALimit <> Limit
       then begin
              if ALimit = 0
                 then AItems := nil
                 else  { Changed by DJM for GetMem failures}
                    GetMem(AItems, ALimit * SizeOf(Pointer));
              if (AItems <> nil) or (ALimit = 0)
                 then begin
                        if (Count <> 0) and (Items <> nil)
                           then Move(Items^,AItems^,
                                     Count * SizeOf(Pointer));
                        if Limit <> 0
                           then FreeMem(Items,
                                     Limit * SizeOf(Pointer));
                        Items := AItems;
                        Limit := ALimit;
                      end;
            end;
  end;

---------------------------------------------------------------

Object   : TEditor.ConvertEvent;
Version  : 1.0
Type     : Bug
File     : Editors.pas
Reference: Editors.7
Submitter: Borland
Patch    :

   There are actually two sets of changes that must be made.  

   In the function ScanKeyMap make the following two changes.

   EXISTING CODE:                CHANGE TO:

   LODSW                         LODSW
   OR      BL,BL                 CMP     BL,DL
   JE      @@2
   CMP     BL,DL

   { deleted code }

   EXISTING CODE:                CHANGE TO:

   JE      @@4                   JE      @@4         
   @@2:    CMP     BH,DH         CMP     BH,DH       
   JE      @@4                   JE      @@4


   In the procedure ConvertEvent add the following declaration
   to the variable section and insert the first statement in
   the procedure block.

   EXISTING:

   var
     Key: Word;

   CHANGE TO:

   var
     ShiftState : Byte absolute $40:$17;  { added variable }
     Key : Word;

   begin
     if (ShiftState and $03 <> 0)         { added statement }
        and (Event.ScanCode >= $47)
            and (Event.ScanCode <= $51)
        then Event.CharCode := #0;
     Key := Event.KeyCode;

---------------------------------------------------------------

Object   : TEditor.HandleEvent;
Version  : 1.0
Type     : Bug
File     : Editors.pas
Reference: Editors.3
Submitter: Juergen Schlegelmilch
Patch    :

  There are two places that need to be patched, the local
  procedure CheckScrollBar should be changed to a function and
  the handling of the evBroadcast cmScrollBarChanged in the
  HandleEvent main loop.

  { function CheckScrollBar:Boolean returns False, if the }
  { sending scrollbar was not the scrollbar in question.  }

  function CheckScrollBar (P : PScrollBar;
                           var D : Integer) : Boolean;
  begin
    if (Event.InfoPtr = P) and (P^.Value <> D)
       then begin
              D := P^.Value;
              Update(ufView);
              CheckScrollBar := True;
            end
       else CheckScrollBar := False;
  end;

    { HandleEvent main loop patch }

  begin

    (* ... several lines skipped ... *)

    evBroadcast :
      case Event.Command of
        cmScrollBarChanged :
            { The EXIT prevents the Event from being cleared. }
          if not(CheckScrollBar(HScrollBar, Delta.X) or
                   CheckScrollBar(VScrollBar, Delta.Y))
             then Exit;
      else Exit;

    (* ... several lines skipped ... *)

    ClearEvent(Event);
  end;

---------------------------------------------------------------

Object   : TEditor.HandleEvent;
Version  : 1.0
Type     : Bug
File     : Editors.pas
Reference: Editors.6
Submitter: Juergen Schlegelmilch
Patch    :

  TEditor.HandleEvent(var Event: TEvent);
  begin

  (* ... several lines skipped ... *)

      evKeyDown:
        case Event.CharCode of
          #9,#32..#255:
            begin
              Lock;
      { patch: reset blockmarkers if not overwriting }
              if Overwrite then
                begin
                  if CurPtr <> LineEnd(CurPtr) then
                     SelEnd := NextChar(CurPtr)
                end
              else
                SelEnd := SelStart;
              InsertText(@Event.CharCode, 1, False);
              TrackCursor(CenterCursor);
              Unlock;
            end;
        else
          Exit;
        end;

  (* ... several lines skipped ... *)

  end;

---------------------------------------------------------------

Object   : TEditor.NextWord;
Version  : 1.0, 2.0
Type     : Enhancement
File     : Editors.pas
Reference: Editors.5
Submitter: Juergen Schlegelmilch, Burkhart Renk
Patch    :

  function TEditor.NextWord(P: Word): Word;
  begin
    if BufChar(P) in WordChars
       then while (P < BufLen) and (BufChar(P) in WordChars) do
             P := NextChar(P)
             { add check for P < BufLen }
       else if P < BufLen then P := NextChar(P);
    while (P < BufLen) and
          ((BufChar(P) = ' ') or (BufChar(P) = #9)) do
          P := NextChar(P);
    NextWord := P;
  end ;

---------------------------------------------------------------

Object   : TEditor.SetState;
Version  : 1.0, 2.0
Type     : Bug
File     : Editors.pas
Reference: Editors.9
Submitter: Brad Williams
Patch    : Change the TEditor.SetState method to the following

procedure TEditor.SetState(AState: Word; Enable: Boolean);
begin
  inherited SetState(AState, Enable);
  { patched Editors.9 }
  case AState of
    sfExposed:
      if Enable then Unlock;
    sfFocused : if (State and sfSelected) = sfSelected then
      begin
        if HScrollBar <> nil then HScrollBar^.SetState(sfVisible, Enable);
        if VScrollBar <> nil then VScrollBar^.SetState(sfVisible, Enable);
        if Indicator <> nil then Indicator^.SetState(sfVisible, Enable);
        UpdateCommands;
      end;
    sfSelected :
      begin
        if HScrollBar <> nil then HScrollBar^.SetState(sfVisible, Enable);
        if VScrollBar <> nil then VScrollBar^.SetState(sfVisible, Enable);
        if Indicator <> nil then Indicator^.SetState(sfVisible, Enable);
        UpdateCommands;
      end;
  end;
  { end patch }
end;

---------------------------------------------------------------

Object   : TFileDialog.GetFileName.1
Version  : 1.0, 2.0 (corrected in TP/BP maintainence version
                   7.01)
Type     : Bug
File     : StdDlg.pas
Reference: Views.1
Submitter: Borland
Patch    :

   Change the local function RelativePath to the following:

   FUNCTION RelativePath (VAR S : PathStr) : Boolean;
   BEGIN
     S := LTrim(RTrim(S));
     RelativePath := NOT ((S <> '') AND
                         ((S[1] = '\') OR (S[2] = ':')));
   END;


---------------------------------------------------------------

Object   : TFileDialog.GetFileName.2
Version  : 1.0, 2.0
Type     : Bug
File     : StdDlg.pas
Reference: Views.9
Submitter: Jack Nomssi
Patch    : Change the beginning code of the main block of
           GetFileName

procedure TFileDialog.GetFileName(var S: PathStr);
begin
  S := FileName^.Data^;
  { patch }
  if RelativePath(S) then S := FExpand(Directory^ + S)
  else if (S <> '') and (S[1]='\') then
          S := FExpand(Copy(Directory^,1,2)+S)
       else S := FExpand(S);
  { patch }
  ...
end;


---------------------------------------------------------------

Object   : TFileEditor.InitBuffer;
Version  : 1.0
Type     : Bug
File     : Editors.pas
Reference: Editors.1
Submitter: Juergen Schlegelmilch
Patch    :

  PROCEDURE TFileEditor.InitBuffer;
  BEGIN
    NewBuffer(Pointer(Buffer));
    BufSize:=0;                  {* new line *}
  END;

---------------------------------------------------------------

Object   : TFileEditor.InsertBuffer;
Version  : 1.0
Type     : Bug
File     : Editors.pas
Reference: Editors.4
Submitter: Juergen Schlegelmilch
Patch    :

  function TEditor.InsertBuffer (var P : PEditBuffer; 
           Offset, Length : Word; 
           AllowUndo, SelectText : Boolean) : Boolean;
  var
    SelLen, DelLen, SelLines, Lines: Word;
    NewSize: Longint;
  begin

  (* ... several lines skipped ... *)

    if NewSize > BufLen + DelCount 
       then if (NewSize > $FFF0) or not SetBufSize(NewSize)     
             then begin
                      EditorDialog(edOutOfMemory, nil);

   { ** patch - reset block markers to avoid abnormal ** }
   { ** behavior of a following BackSpace:            ** }

                      SelEnd := SelStart;
                      InsertBuffer := False;
                      Exit;
                    end;

  (* ... several lines skipped ... *)

    SetBufSize(BufLen + DelCount);
    if (SelLines = 0) and (Lines = 0) 
       then Update(ufLine) 
       else Update(ufView);
  end;

---------------------------------------------------------------

Object   : THelpIndex.Position;
Version  : 1.0
Type     : Bug
File     : HelpFile.pas
Reference: Help.2
Submitter: Juergen Schlegelmilch
Patch    :

  function THelpIndex.Position(I: Integer): Longint;
  begin
    if (-1 < I) and (I < Size) 
       then Position := Index^[I]
       else Position := -1;
  end;

---------------------------------------------------------------

Object   : THelpTopic.AddCrossRef;
Version  : 1.0
Type     : Bug
File     : HelpFile.pas
Reference: Help.1
Submitter: Juergen Schlegelmilch
Patch    :

  procedure THelpTopic.AddCrossRef(Ref: TCrossRef);
  var
    P: PCrossRefs;
  begin
    GetMem(P, (NumRefs+1) * SizeOf(TCrossRef));
    if NumRefs > 0 then
    begin
      Move(CrossRefs^, P^, NumRefs * SizeOf(TCrossRef));
      FreeMem(CrossRefs, NumRefs * SizeOf(TCrossRef));
    end;
    CrossRefs := P;  { ** line added ** }
    CrossRefs^[NumRefs] := Ref;
    Inc(NumRefs);
  end;

---------------------------------------------------------------

Object   : THelpTopic.Load;
Version  : 1.0, 2.0
Type     : Bug
File     : HelpFile.pas
Reference: Help.4
Submitter: Peter Brandstrom
Patch    :

  Add the folling as the first line in THelpFile.Load:

  TObject.Init;    { TV 1.0, TP 6.xx }   or
  inherited Init;  { TV 2.0, TP 7.xx, BP 7.xx }

  BEGIN
    inherited Init;
    ..... { existing code }
  END;

---------------------------------------------------------------

Object   : THistory.Draw;
Version  : 1.0
Type     : Bug
File     : Dialogs.pas
Reference: Views.3
Submitter: Juergen Schlegelmilch
Patch    : None

---------------------------------------------------------------

Object   : TListBox.GetText;
Version  : 1.0, 2.0
Type     : Bug
File     : Dialogs.pas
Reference: Views.6
Submitter: Brad Williams
Patch    : Place a check for a nil pointer being returned from
           List^.At(Item).


function TListBox.GetText(Item: Integer; MaxLen: Integer): String;
var S : PString;
begin
  GetText := '';
  if (List <> nil)
     then begin
            S := PString(List^.At(Item));
            if (S <> nil)
               then GetText := S^;
          end;
end;

---------------------------------------------------------------

Object   : TMenuPopup.Done;
Version  : 1.0, 2.0
Type     : Bug
File     : Menus.pas
Reference: Menus.1
Submitter: Berend deBoer
Patch    : Create a TMenuPopup.Done destructor.


DESTRUCTOR TMenuPopup.Done;
BEGIN
  DisposeMenu(Menu);
  inherited Done;
END;

---------------------------------------------------------------

Object   : TSortedListBox.HandleEvent;
Version  : 1.0, 2.0
Type     : Bug
File     : StdDlg.pas
Reference: Views.5
Submitter: Jack Nomssi
Patch    : 

   Change the 3rd and 4th lines in TSortedListBox.HandleEvent 
   
   from:

   IF OldValue <> Focused
      THEN SearchPos := 0;
     
   to:

   IF (OldValue <> Focused) OR 
      ((Event.What = evBroadcast) AND (Event.InfoPtr = @Self)
       AND (Event.Command = cmReleasedFocus))
      THEN SearchPos := 0;

---------------------------------------------------------------

Object   : TStaticText.Done;
Version  : 1.0, 2.0
Type     : Bug
File     : Dialogs.pas
Reference: Views.7
Submitter: Brad Williams
Patch    : Change TStaticText.Done to the following

destructor TStaticText.Done;
begin
  if Text <> NIL
     then DisposeStr(Text);
  TView.Done;
end;


---------------------------------------------------------------

Object   : TView.Draw
Version  : 1.0, 2.0
Type     : Bug
File     : Views.pas
Reference: Views.10
Submitter: Brad Williams
Patch    : Change add the following code to the start of
           TView.DrawView.

destructor TView.DrawView;
begin
  { patch }
  IF (Options AND ofCenterX = ofCenterX) OR (Options AND ofCenterY <> 0)
     THEN BEGIN
            IF (Options AND ofCenterX) = ofCenterX
               THEN Origin.X := (Owner^.Size.X - Size.X) DIV 2;
            IF (Options AND ofCenterY) = ofCenterY
               THEN Origin.Y := (Owner^.Size.Y - Size.Y) DIV 2;
            MoveTo(Origin.X,Origin.Y);
          END;
  { end patch }
  if Exposed then
  begin
    Draw;
    DrawCursor;
  end;
end;


---------------------------------------------------------------

Object   : TWindows.SetState;
Version  : 1.0, 2.0
Type     : Bug
File     : Views.pas
Reference: Windows.1
Submitter: Hans Schleichert
Patch    : 

   Enclose the wfGrow + wfMove in parentheses.

   For Version 1.0, change the SetState method or override to:

    PROCEDURE TMyWindow.SetState (AState : Word ; Enable :
                                  Boolean) ;
        BEGIN
            TWindow.SetState (AState, Enable) ;
            IF (AState = sfSelected) AND Enable THEN
            IF Flags AND (wfGrow+wfMove) = 0 THEN
                 {      ^^^           ^^^           }
                 { these parenthesis are the patch }
            DisableCommands ([cmResize])
        END;

   For Version 2.0, change the following line in the SetState   
      method from:

   IF Flags AND wfGrow + wfMove <> 0 then
      WindowCommands := WindowCommands + [cmReSize];

   TO:
      
   IF Flags AND (wfGrow + wfMove) <> 0 then
      WindowCommands := WindowCommands + [cmReSize];



---------------------------------------------------------------
End of TVBUGS.PAS
