//             GFX, graphical extension for Turbo Vision.
//                     Written By: Simor Balazs
//                              V 3.10
//
//    This software can be freely distributed provided, that the author
//   message remains intact, and it is not used for professional purposes.
// If you make modifications to the software and you want to redistribute it,
//     please let the user know, that it is not the original version.
//        You may NOT redistribute the source code of the software, it is
//                          not shareware


// This headerfile contains definitions for use with the GFX graphics
//                         interface for TV

#ifndef __GFX_H
#define __GFX_H


#define _GFX_VERSION    0x0310


#undef GfxIncludeTV

#ifndef Uses_TApplication
#    define Uses_TApplication
#    define GfxIncludeTV
#endif

#ifndef Uses_TScreen
#    define Uses_TScreen
#    define GfxIncludeTV
#endif

#ifndef Uses_TView
#    define Uses_TView
#    define GfxIncludeTV
#endif

#ifndef Uses_TEvent
#    define Uses_TEvent
#    define GfxIncludeTV
#endif

#ifndef Uses_TMouse
#    define Uses_TMouse
#    define GfxIncludeTV
#endif

#ifndef Uses_TRect
#    define Uses_TRect
#    define GfxIncludeTV
#endif

#ifndef Uses_TPoint
#    define Uses_TPoint
#    define GfxIncludeTV
#endif

#ifdef GfxIncludeTV
#    include <tvision\tv.h>
#    undef GfxIncludeTV
#endif

#ifndef __GRAPHICS_H
#    include <graphics.h>
#endif

//--------------------------External variables------------------------

extern int _xCharSize, _yCharSize;
extern short _useAltWriteMethod;
extern unsigned short far * _Cache;
extern short _gfxInGraphicMode;
extern char * _gfxBgiPath;

#ifdef __FLAT__
extern unsigned short _gfxDosMemSelector;
#endif

//------------------------Global functions----------------------------

extern int GFXinitialize(int gdriver, int gmode);
extern void GFXclose(void);
extern void GFXclose(ushort mode);
extern void ClearCacheRegion(const TRect& r, Boolean outline);
#ifdef __FLAT__
extern void GFXgetDosMemSelector(void);
extern void GFXfreeDosMemSelector(void);
#endif

#define ScreenModeIsGraphic()   (_gfxInGraphicMode != 0)
#define ScreenModeIsText()      (_gfxInGraphicMode == 0)

//----------------------------Classes---------------------------------



class GRect : public TRect
{
public:
    GRect(void) {}
    GRect(TRect base);
    GRect(TPoint topleft, TPoint bottomright)
        { a.x = topleft.x;
          a.y = topleft.y;
          b.x = bottomright.x;
          b.y = bottomright.y;
        }
    GRect(int ax, int ay, int bx, int by)
        {
        a.x = ax;
        a.y = ay;
        b.x = bx;
        b.y = by;
        }
    int distance(TPoint &p);
};


struct Win
{
    GRect w;
    int XCorr, YCorr; //Correction values for this window
    Win *next;
};


class GView : public TView
{
public:
    GView (const TRect& bounds) : TView (bounds) {winList = 0;} 

    virtual void draw();
    virtual void paint() {TView::draw();}
    int beginPaint(void);
    void endPaint(void);
    GRect getGClipRect() { return GRect( TView::getClipRect() ); }
    GRect getGBounds() { return GRect( TView::getBounds() ); }
    GRect getGExtent() { return GRect( TView::getExtent() ); }
    GRect getGAbsBounds();
    TRect getAbsBounds();
    Boolean isClear();
    void makeArea(char *area);
    void freeWinList(void);
    void makeWinList(char *area, TRect& rect, TPoint& orig);
    void imagedimensions(void far *buf, unsigned *width, unsigned *height);

    void arc(int x, int y, int stangle, int endangle, int radius);
    void bar(int left, int top, int right, int bottom);
    void bar3d(int left, int top, int right, int bottom, int depth,
                int topflag);
    void circle(int x, int y, int radius);
    void cleardevice(void) {}
    void clearviewport(void);
    void drawpoly(int numpoints, int far *polypoints);
    void ellipse(int x, int y, int stangle, int endangle,
                int xradius, int yradius);
    void fillellipse(int x, int y, int xradius, int yradius);
    void fillpoly(int numpoints, int far *polypoints);
    #pragma argsused
    void floodfill(int x, int y, int border) {}
    void getimage(int left, int top, int right, int bottom,
                void far *bitmap);
    #pragma argsused
    void getpixel(int x, int y) {}
    int  getx(void);
    int  gety(void);
    unsigned long imagesize(int left, int top, int right, int bottom);
    void line(int x1, int y1, int x2, int y2);
    void linerel(int dx, int dy);
    void lineto(int x, int y);
    void moverel(int dx, int dy);
    void moveto(int x, int y);
    void outtext(char far *textstring);
    void outtextxy(int x, int y, char far *textstring);
    void pieslice(int x, int y, int stangle, int endangle, int radius);
    void putimage(int left, int top, void far *bitmap, int op);
    void putpixel(int x, int y, int color);
    void rectangle(int left, int top, int right, int bottom);
    void sector(int x, int y, int stangle, int endangle,
            int xradius, int yradius);
    #pragma argsused
    void setactivepage(int page) {}
    #pragma argsused
    void setviewport(int left, int top, int right, int bottom, int clip) {}
    #pragma argsused
    void setvisualpage(int page) {}
private:

    TPoint myCP; //CP (Current Point) in the GView see graphics.h doc

    Win *winList; //actual winlist (valid after a call to beginPaint until
                //calling endPaint)
    TRect crect; //for internal use in beginPaint and endPaint
}; //GView


enum gfx_mouse_shape {
    GM_DEFAULT_ARROW,
    GM_POINTER_NW1,
    GM_POINTER_NW2,
    GM_POINTER_N1,
    GM_POINTER_N2,
    GM_POINTER_E,
    GM_NE_ARROW,
    GM_POINTER_W,
    GM_NW_SE_ARROW,
    GM_NE_SW_ARROW,
    GM_NS_ARROW,
    GM_EW_ARROW,
    GM_MOVE,
    GM_MOVE2,
    GM_HOURGLASS1,
    GM_HOURGLASS2,
    GM_CLOCK1,
    GM_CLOCK2,
};

struct gfx_mouse_shape_descriptor {
    short hotPointX;
    short hotPointY;
    short and_mask[16];
    short xor_mask[16];
};


class GMouseShape {

public:

    GMouseShape(gfx_mouse_shape ms);
    GMouseShape(gfx_mouse_shape_descriptor& ms);
    ~GMouseShape();

    static void setMouseGraphicCursor(gfx_mouse_shape ms);
    static void setMouseGraphicCursor(gfx_mouse_shape_descriptor& ms);

    static void getMouseShapeDescriptor(gfx_mouse_shape ms, gfx_mouse_shape_descriptor& sd);

    static void redraw();
protected:

    static void setMouseGraphicCursor(short hotPointX, short hotPointY, short mem_seg, short mem_off);

    gfx_mouse_shape_descriptor saved_shape_descriptor;

    static gfx_mouse_shape_descriptor current_shape_descriptor;

    static short * real_mem_shape_descriptor_p;// protected pointer to real mode memory
    static unsigned short sel_real_mem;        // selector of real mode memory
    static unsigned short seg_real_mem;        // segment of real mode memory
    static unsigned short ofs_real_mem;        // offset of real mode memory
};




enum videoModes //this list is extended with graphics modes
    {
    smBW80      = 0x0002,
    smCO80      = 0x0003,
    smMono      = 0x0007,
    smFont8x8   = 0x0100,
    smEGALO     = 0x1001,
    smEGAHI     = 0x1002,
    smVGALO     = 0x1003,
    smVGAMED    = 0x1004,
    smVGAHI     = 0x1005,
    smDETECT    = 0x2000
    };

#define smDefault    smDETECT


class GApplication : public TApplication
{
public:
    GApplication(ushort mode = smDefault, char *pathToBGI = 0);
    ~GApplication();

    void setScreenMode(ushort mode); //overriding original
    void suspend(); //overriding original
    void resume(); //overriding original

    void setDefaultCursor(gfx_mouse_shape ms);
    void setDefaultCursor(gfx_mouse_shape_descriptor& ms);
    void setWaitCursor(gfx_mouse_shape ms);
    void setWaitCursor(gfx_mouse_shape_descriptor& ms);
    void setMoveCursor(gfx_mouse_shape ms);
    void setMoveCursor(gfx_mouse_shape_descriptor& ms);
    void setResizeCursor(gfx_mouse_shape ms);
    void setResizeCursor(gfx_mouse_shape_descriptor& ms);

    static gfx_mouse_shape_descriptor defaultCursor;
    static gfx_mouse_shape_descriptor waitCursor;
    static gfx_mouse_shape_descriptor moveCursor;
    static gfx_mouse_shape_descriptor resizeCursor;
private:
    ushort lastMode;
};


#define GM_WAIT     GApplication::waitCursor

#endif
