Program NestTTT5_Demo_1;

uses CRT,FastTTT5,DOS,WinTTT5,KeyTTT5,StrnTTT5,NestTTT5;


var
  Hyphens,
  EndProgram: Boolean;
  Main_Menu,
  Long_menu,
  File_Menu,                       {dummy menu is a short cut to represent}
  Utility_Menu,                    {all the other menus that would be used}
  Dummy_Menu:Nest_Menu;            {in a large system.                    }


{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                      S E T U P    M E N U S                         }
{                                                                     }
{    In the first block of procedures we will set up the menus by     }
{    calling the Initialize_menu proc, and the we will add menus      }
{    topics to each menu by calling the Add_Topic proc.               }
{                                                                     }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

  Procedure SetUp_Menus;
  {NOTE: The initialize_Menu proc must be called prior to trying to add
         any topics to the menu. The procedure is passed four parameters:

               1) The name of the Menu - this must already been VAR declared
                  with a type of Nest_Menu.

               2) The Heading for the menu.

               3) The width of the menu in characters. If a value of zero
                  is used, the program will automatically compute the
                  necessary width.

  }
  begin
      Initialize_Menu(Main_Menu,'Sprint',0,0);  {14}
      Initialize_Menu(File_Menu,'File',22,12);
      Initialize_Menu(Utility_Menu,'Utility',19,13);
      Initialize_Menu(Long_Menu,'Potpourri',19,10);
      Initialize_Menu(Dummy_Menu,'A N Other',0,0);
  end; {of proc SetUp_Menus}

  {NOTE:   The add topic procedure (below) is used to add another topic
           to a menu. Add the topics in the order that you want
           them to appear in the menu. The Add_Topic procedure
           is passed 6 parameters:

           1)  The name of the Menu to which the topic is to
               be added.

           2)  The string for the topic title.

           3)  A boolean to indicate if the topic is active or
               inactive. If the topic is inactive, the topic will
               be displayed in an alternate color, and the cursor
               bar will not land on the topic.

           4)  A character that represents a "Hot Key" that the
               user can press to invoke the topic. Pass a #0 of
               the topic does not have a hot key.

           5)  A unique return code (type integer) that will be
               passed to the user-defined execution procedure
               to indicate which topic has been chosen.

           6)  The address of a menu that will be called if the
               topic is selected. If you do not want to load
               another menu (i.e. its the end of the line), enter
               a NIL address.

    Once a topic has been added, it can be modified with the following
    procedures:
                 Modify_Topic
                 Modify_Topic_Name
                 Modify_Topic_Active
                 Modify_Topic_HotKey
                 Modify_Topic_RetCode
                 Modify_Topic_SubMenu
  }

  Procedure Define_Main_Menu;
  {}
  begin
      Add_Topic(Main_Menu,'File       *  Alt-F',true,#161,101,@File_Menu);
      Add_Topic(Main_Menu,'Edit'              ,true,#0  ,0,@Dummy_Menu);
      Add_Topic(Main_Menu,'-'                 ,true,#0  ,0  ,nil);
      Add_Topic(Main_Menu,'Insert'            ,true,#0,103,@Dummy_Menu);
      Add_Topic(Main_Menu,'Typestyle'         ,true,#0,104,@Dummy_Menu);
      Add_Topic(Main_Menu,'Style'             ,true,#0,105,@Dummy_Menu);
      Add_Topic(Main_Menu,'Layout'            ,true,#0,0,@Dummy_Menu);
      Add_Topic(Main_Menu,'-'                 ,true,#0,0,nil);
      Add_Topic(Main_Menu,'Print'             ,false,#0,107,@Dummy_Menu);
      Add_Topic(Main_Menu,'Window'            ,true,#0,108,@Dummy_Menu);
      Add_Topic(Main_Menu,'Utilities  *  Alt-U'  ,true,#150,109,@Utility_Menu);
      Add_Topic(Main_Menu,'Customize'         ,true,#0,110,@Dummy_Menu);
      Add_Topic(Main_Menu,'-'                 ,true,#0,0,nil);
      Add_Topic(Main_Menu,'Quit'              ,true,#173,999,nil);
  end; {of proc Define_Main_Menu}

  Procedure Define_File_Menu;
  {}
  begin
      Add_Topic(File_Menu,'New'            ,true,#0,201,nil);
      Add_Topic(File_Menu,'Open'           ,true,#0,202,nil);
      Add_Topic(File_Menu,'Close'          ,true,#0,203,nil);
      Add_Topic(File_Menu,'Insert'         ,true,#0,204,nil);
      Add_Topic(File_Menu,'-'              ,true,#0,0,nil);
      Add_Topic(File_Menu,'Save'           ,true,#0,205,nil);
      Add_Topic(File_Menu,'Write As'       ,true,#0,206,nil);
      Add_Topic(File_Menu,'Revert to Saved',true,#0,207,nil);
      Add_Topic(File_Menu,'-'              ,true,#0,0,nil);
      Add_Topic(File_Menu,'Translate'      ,true,#0,208,nil);
      Add_Topic(File_Menu,'File Manager'   ,true,#0,209,nil);
      Add_Topic(File_Menu,'Pick from List' ,true,#0,210,nil);
  end; {of proc Define_File_Menu}

  Procedure Define_Long_Menu;
  {}
  begin
      Add_Topic(Long_Menu,'bottom of File' ,true,#0,71,nil);
      Add_Topic(Long_Menu,'Bottom of screen',true,#0,72,nil);
      Add_Topic(Long_Menu,'case Rotate'    ,true,#0,73,nil);
      Add_Topic(Long_Menu,'case Switch'     ,true,#0,74,nil);
      Add_Topic(Long_Menu,'center Tab'     ,true,#0,75,nil);
      Add_Topic(Long_Menu,'Decimal tab'    ,true,#0,76,nil);
      Add_Topic(Long_Menu,'delete Line'    ,true,#0,77,nil);
      Add_Topic(Long_Menu,'delete Word'    ,true,#0,78,nil);
      Add_Topic(Long_Menu,'delete Sentence',true,#0,79,nil);
      Add_Topic(Long_Menu,'delete Paragraph',true,#0,80,nil);
      Add_Topic(Long_Menu,'delete End of line' ,true,#0,81,nil);
      Add_Topic(Long_Menu,'reformat Document',true,#0,82,nil);
      Add_Topic(Long_Menu,'eXchange cases'    ,true,#0,73,nil);
      Add_Topic(Long_Menu,'lookup Zip'     ,true,#0,74,nil);
      Add_Topic(Long_Menu,'Underline'      ,true,#0,75,nil);
      Add_Topic(Long_Menu,'Italicize'      ,true,#0,76,nil);
      Add_Topic(Long_Menu,'go Home'        ,true,#0,77,nil);
      Add_Topic(Long_Menu,'Cancel undo'    ,true,#0,78,nil);
  end; {of proc Define_Long_Menu}

  Procedure Define_Utility_Menu;
  {}
  begin
      Hyphens := true;
      Add_Topic(Utility_Menu,'Spelling'    ,true,#0,901,nil);
      Add_Topic(Utility_Menu,'Hyphenation  *  On ' ,true,#0,902,nil);
      Add_Topic(Utility_Menu,'Thesaurus'   ,true,#0,903,nil);
      Add_Topic(Utility_Menu,'Glossary'    ,true,#0,904,nil);
      Add_Topic(Utility_Menu,'-'           ,true,#0,0,nil);
      Add_Topic(Utility_Menu,'Arrange-Sort',true,#0,905,nil);
      Add_Topic(Utility_Menu,'Line Drawing',true,#0,906,nil);
      Add_Topic(Utility_Menu,'-'           ,true,#0,0,nil);
      Add_Topic(Utility_Menu,'Potpourri    *',true,#0,907,@Long_Menu);
      Add_Topic(Utility_Menu,'QuickCard'   ,true,#0,908,nil);
      Add_Topic(Utility_Menu,'Macros'      ,true,#0,909,nil);
      Add_Topic(Utility_Menu,'-'           ,true,#0,0,nil);
      Add_Topic(Utility_Menu,'Back Up Demo *',true,#0,910,nil);
  end; {of proc Define_Utility_Menu}

  Procedure Define_Dummy_Menu;
  {}
  begin
      Add_Topic(Dummy_Menu,'Ignite'      ,true,#0,801,nil);
      Add_Topic(Dummy_Menu,'Check Boosters',true,#0,802,nil);
      Add_Topic(Dummy_Menu,'Fire Retros' ,true,#0,803,nil);
      Add_Topic(Dummy_Menu,'Shutdown'    ,true,#0,804,nil);
      Add_Topic(Dummy_Menu,'-'           ,true,#0,0,nil);
      Add_Topic(Dummy_Menu,'Launch'      ,true,#0,805,nil);
      Add_Topic(Dummy_Menu,'Remove Suit',false,#0,806,nil);
      Add_Topic(Dummy_Menu,'-'           ,true,#0,0,nil);
      Add_Topic(Dummy_Menu,'Abort Mission',true,#0,807,nil);
      Add_Topic(Dummy_Menu,'Panic'       ,true,#0,808,nil);
  end; {of proc Define_Dummy_Menu}

  Procedure Paint_Screen;
  {makes the screen look like a word processor}
  begin
      ClearText(1,1,80,25,lightgray,blue);
      WriteAt(1,25,black,lightgray,
      Padleft('Press F10 or / for menu.             Alt-X   to quit',80,' '));
      Plainwrite(1,1,
      '[     T     1         2         3         4         5         6         7     ]');
      Plainwrite(5,3,'Imagine you have written a wordprocessing program and you want');
      PlainWrite(5,4,'to give the program a full and powerful menu system. The NestTTT');
      PlainWrite(5,5,'unit will give you all the power you need and more!');
      PlainWrite(5,7,'For starters, press the F10 key or the slash key, and roam around');
      Plainwrite(5,8,'the menu a little. Features include: capital letter selection, ');
      Plainwrite(5,9,'optional HotKey selection, point and shoot (with full mouse support),');
      Plainwrite(5,10,'non-selectable topics, line separators, auto positioning of menus and');
      PlainWrite(5,11,'sub menus. The list goes on and on...');
      PlainWrite(5,13,'When a menu "system" has been defined, it''s easy to call up any of the');
      PlainWrite(5,14,'nested menus and bypass all the parent menus. For example, press Alt-U');
      Plainwrite(5,15,'while no menu is on display - the Utility menu will automatically pop-up');
      Plainwrite(5,16,'at the top level.');
      PlainWrite(5,18,'All of the topics that are highlighted with an asterisk "*" are designed');
      Plainwrite(5,19,'to illustrate some of the features of the menu. For example, select the');
      Plainwrite(5,20,'Utility option from the main menu, or press Alt-U, and select the Potpourri');
      Plainwrite(5,21,'topic. This is a menu that exceeds the no. of display lines - the menu');
      Plainwrite(5,22,'will automatically scroll the topics. Also, select the Hyphenation topic');
      Plainwrite(5,23,'to see a topic that can switch between two or more displays.');
  end; {of proc Paint_Screen}


{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                                                                     }
{         P R O G R A M    E X E C U T I O N    C O N T R O L         }
{                                                                     }
{    In the next block of procedures, the execution procedure or      }
{    despatcher is defined. This must be declared FAR and must have   }
{    the exact parameters list. This procedure is called every time   }
{    a non-menu topic is selected.                                    }
{                                                                     }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

   Procedure Dummy_Activity(var Finish:byte);
   {Saves writing a lot of real life procedures for the demo}
   begin
       TempMessageBox(20,5,white,red,3,'Just Imagine I did something!');
       Finish := DontClear;   {return to same place in the menu}
   end; {of proc Dummy_Activity}

{$F+}
   Procedure Action(Var Code: integer; var Finish:byte);
   {This is the main procedure the controls the execution of all
    the menu options.}
   begin
       Case Code of
       902: begin
                If Hyphens then
                   Modify_Topic_name(Utility_Menu,2,'Hyphenation  *  Off')
                else
                   Modify_Topic_name(Utility_Menu,2,'Hyphenation  *  On ');
                Hyphens := not Hyphens;
                Finish := RefreshTopic;
            end;
       910: begin
                TempMessageBox(20,5,white,red,3,'We will back up one level');
                Finish := ClearCurrent;
            end;
       999: begin
                sound(1000);delay(2);nosound;
                Endprogram := true;
                Finish := ClearAll;
            end;
       else Dummy_Activity(Finish);
       end;  {case}
   end; {of proc Action}
{$F-}

   Procedure Menu_Loop;
   {}
   var Ch : char;
   begin
       EndProgram := false;
       Repeat
            Ch := Getkey;
            Case Ch of
            #178,                               {Alt-M}
            '/',
            #196 :  Show_Nest(Main_menu);       {F10}
            #161 :  Show_Nest(File_Menu);       {Alt F}
            #150 :  Show_Nest(Utility_menu);    {Alt U}
            #027,
            #173 :  Endprogram := true;         {Alt X}
            end;
      Until   EndProgram;
   end; {of proc Menu_Loop}


begin                                         {The main program}
    ClearText(1,1,80,25,white,black);
    SetUp_menus;
    Define_Main_Menu;
    Define_File_menu;
    Define_Utility_Menu;
    Define_Dummy_Menu;
    Define_Long_Menu;
    Assign_Despatcher(Action);
    With NTTT do             {optionally modify default colors etc.}
    begin
        AllowEsc := false;
        LeftSide := false;
        BoxFCol := black;
        BoxBCol := lightgray;
        CapFCol := white;
        BacCol := lightgray;
        NorFCol := Black;
        LoFCol := blue;
        HiFCol := Lightgray;
        HiBCol := blue;
        LeftChar := ' ';
        RightChar := ' ';
    end;
    Paint_Screen;
    Menu_Loop;
    Delete_All_Topics(Utility_Menu);
    Delete_All_Topics(File_Menu);
    Delete_All_Topics(Main_Menu);
    Delete_All_Topics(Dummy_Menu);
    Reset_StartUp_Mode;
end.

