;   _______________________________________________________________
;  |                                                               |
;  |            Copyright (C) 1989,1990  Steven Lutrov             |
;  |_______________________________________________________________|____
;  |                                                               |    |
;  |  Program Title : FastGrp.Asm                                  |    | ___
;  |  Author        : Steven Lutrov                                |    |    |
;  |  Revision      : 2.01                                         |    |    |
;  |  Date          : 1990-03-16                                   |    |    |
;  |  Language      : Turbo Assembler                              |    |    |
;  |                                                               |    |    |
;  |  Description   : Assembly Functions For Graphics screen       |    |    |
;  |                : movement and primitive screen management.    |    |    |
;  |                : Tested on Turbo Pascal 5.0 & 5.5             |    |    |
;  |                                                               |    |    |
;  |_______________________________________________________________|    |    |
;      |                                                                |    |
;      |________________________________________________________________|    |
;          |                                                                 |
;          |_________________________________________________________________|
;


Code Segment Word Public

Assume Cs:Code,Ds:Data


Public Screendown,Screenleft,Screenright,Screenup,Fillscreen,Clearpage
Public Drawbox,Copyclear,Swappage,Restorescreen,Savescreen,Scrollx,Scrolly

Data    Segment
        Extrn  Video_Buff : Word
        Extrn  Snow_Check : Byte
        Extrn  Errreturn  : Byte
Data    Ends


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Screendown(Box: Pointer; Var X_Pos,Y_Pos: Byte; X_Num,Y_Pos: Byte);
;
;
;
;
Screendown Proc Far
                Push Bp                         ;Preserve Register Bp
                Mov  Bp,Sp                      ;Set Stack Frame
                Push Ds                         ;Save Turbo'S Ds
                Mov  Dx,Video_Buff              ;Grab Video_Buff
                Push Dx                         ;Save It
                Les  Di,Dword Ptr[Bp+14]        ;Es:Di Pts To X_Pos
                Mov  Al,Snow_Check              ;Grab Snow_Check
                Mov  [Bp+16],Al                 ;Save On Stack
                Sub  Cx,Cx                      ;
                Mov  Cl,Es:[Di]                 ;Get Column Position
                Jcxz Screendf1                  ;Quit If Column Is Zero
                Dec  Cx                         ;Count From Zero
                Cmp  Cx,79                      ;In Range?
                Jna  Screendg1                  ;Jump Ahead If So
Screendf1:      Jmp  Screendm1                  ;Else Quit
Screendg1:      Mov  Ax,[Bp+20]                 ;Segment Of Box
                Mov  Es,Ax                      ;Load In Es
                Mov  Di,[Bp+18]                 ;Offset Of Box
                Mov  Byte Ptr[Bp+7],0           ;Zero Out High Byte
                Mov  Ax,[Bp+6]                  ;Y_Pos To Ax
                Dec  Ax                         ;Dec For Test
                Cmp  Ax,24                      ;In Range?
                Jna  Screendh1                  ;Jump Ahead If So
                Jmp  Screendm1                  ;Else Quit Routine
Screendh1:      Inc  Ax                         ;Readjust
                Mov  Byte Ptr[Bp+9],0           ;Zero Out High Byte
                Mov  Bx,[Bp+8]                  ;X_Num To Bx
                Dec  Bx                         ;Dec For Test
                Cmp  Bx,79                      ;In Range?
                Jna  Screendi1                  ;Jump Ahead If So
                Jmp  Screendm1                  ;Else Quit
Screendi1:      Inc  Bx                         ;Readjust
                Mul  Bl                         ;X_Num Times Y_Pos
                Shl  Ax,1                       ;Double For Attributes
                Add  Ax,Di                      ;Offset To End Of Box
                Mov  [Bp+14],Ax                 ;End Of Box Ptr To Stack
                Mov  Di,Ax                      ;Pt Es:Di To End Of Box
                Lds  Si,Dword Ptr[Bp+10]        ;Point Ds:Si To Y_Pos
                Sub  Ax,Ax                      ;
                Mov  Al,[Si]                    ;Get Y_Pos Value
                Dec  Ax                         ;Count From Zero
                Cmp  Ax,24                      ;In Range?
                Jna  Screendk1                  ;Jump Ahead If So
Screendj1:      Jmp  Screendm1                  ;Else Quit
Screendk1:      Mov  Bx,Ax                      ;Copy In Bx
                Add  Bx,[Bp+6]                  ;Add Y_Pos
                Cmp  Bx,24                      ;Edge Of Screen?
                Ja   Screendj1                  ;Quit If So
                Add  Ax,2                       ;Inc Old Y_Pos Value
                Mov  [Si],Al                    ;Reset Y_Pos Variable
                Sub  Ax,2                       ;Back To Old Value
                Mov  Bl,160                     ;Bytes Per Y_Pos
                Mul  Bl                         ;Calculate Y_Pos Offset
                Shl  Cx,1                       ;X_Pos Offset
                Add  Ax,Cx                      ;Add To Y_Pos Offset
                Mov  Si,Ax                      ;Si Pts To Topleft Corner
                Mov  [Bp+12],Si                 ;Save On Stack
                Mov  Ax,Dx                      ;Video_Buff
                Mov  Ds,Ax                      ;Move To Ds
                Mov  Ax,[Bp+6]                  ;Y_Pos
                Mov  Cl,160                     ;Bytes Per Y_Pos
                Mul  Cl                         ;Times Y_Pos
                Add  Si,Ax                      ;Ds:Si Pts To Topright
                Mov  [Bp+10],Si                 ;Copy Position On Stack
                Pop  Bx                         ;Video_Buff
                Cld                             ;Set Direction
                Mov  Cx,[Bp+8]                  ;X_Num
                Shl  Cx,1                       ;Double For Attributes
                Call Boxd_Screen                ;Write A Char
                Mov  Ax,Ds                      ;Ds To Ax
                Mov  Es,Ax                      ;Now Es Pts To Screen Too
                Mov  Di,[Bp+10]                 ;New Bottom Right Pos
                Mov  Si,Di                      ;Copy To Si
                Sub  Si,160                     ;Si One Y_Pos Higher
                Mov  Ax,[Bp+6]                  ;Y_Pos To Ax
Screendl1:      Mov  Cx,[Bp+8]                  ;X_Num To Cx
                Push Di                         ;Save Target Ptr
                Push Si                         ;Save Source Ptr
                Shl  Cx,1                       ;Dbl X_Num For Attributes
                Call Boxd_Screen                ;Write A Char
                Pop  Si                         ;Restore Ptr
                Pop  Di                         ;Restore Ptr
                Sub  Di,160                     ;Ptr Up One Y_Pos
                Sub  Si,160                     ;Ditto
                Dec  Ax                         ;Dec Y_Pos Counter
                Jnz  Screendl1                  ;Loop Till Finished
                Mov  Ax,[Bp+20]                 ;Segment Of Box
                Mov  Ds,Ax                      ;Move To Ds
                Mov  Si,[Bp+18]                 ;Offset Of Box
                Mov  Di,[Bp+12]                 ;Es:Di Pts To Topleft
                Mov  Dx,[Bp+8]                  ;X_Num
                Shl  Dx,1                       ;Double For Attributes
                Mov  Cx,Dx                      ;Use As Counter
                Call Boxd_Screen                ;Write A Char
                Mov  Ax,Ds                      ;Ds Pts To Box
                Mov  Es,Ax                      ;Now Es Does Too
                Mov  Di,[Bp+18]                 ;Offset To Start Of Box
                Mov  Si,Di                      ;Copy To Si
                Add  Si,Dx                      ;Offset To Second Y_Pos
                Mov  Ax,[Bp+6]                  ;Y_Pos
                Mov  Cx,[Bp+8]                  ;X_Num
                Mul  Cl                         ;Size Of Box
                Mov  Cx,Ax                      ;Move To Cx As Counter
                Rep  Movsw                      ;Shift All Upwards
                Jmp  Short Screendn1            ;Jump To End
Screendm1:      Pop  Bx                         ;Balance Stack If Error
Screendn1:      Sti                             ;Reenable Interrupts
                Pop  Ds                         ;Restore Ds And Quit
                Pop  Bp                         ;Restore Bp
                Ret  16
Screendown Endp



;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Screenleft(Box:Pointer; Var X_Pos,Y_Pos: Byte; X_Num,Y_Pos: Byte);
;
;
;
;
Screenleft Proc Far
                Push Bp                         ;Preserve Register Bp
                Mov  Bp,Sp                      ;Set Stack Frame
                Push Ds                         ;Save Turbo'S Ds
                Mov  Dx,Video_Buff              ;Grab Video_Buff
                Push Dx                         ;Save It
                Les  Di,Dword Ptr[Bp+14]        ;Es:Di Pts To X_Pos
                Mov  Al,Snow_Check              ;Grab Snow_Check
                Mov  [Bp+16],Al                 ;Save On Stack
                Sub  Cx,Cx                      ;
                Mov  Cl,Es:[Di]                 ;Get Column Position
                Jcxz Screenlj1                  ;Quit If Column Is Zero
                Dec  Cx                         ;Count From Zero
                Cmp  Cx,79                      ;In Range?
                Jna  Screenli1                  ;Jump Ahead If So
                Jmp  Screenlt1                  ;Else Quit
Screenli1:      Cmp  Cx,2                       ;Not On Left Edge?
                Jnb  Screenlk1                  ;Jump Ahead If Not
Screenlj1:      Jmp  Screenlt1                  ;Else Quit Routine
Screenlk1:      Dec  Cx                         ;Old X_Pos Minus 2
                Mov  Es:[Di],Cl                 ;Change The Setting
                Inc  Cx                         ;Restore Old X_Pos Pos
                Mov  Ax,[Bp+20]                 ;Segment Of Box
                Mov  Es,Ax                      ;Load In Es
                Mov  Di,[Bp+18]                 ;Offset Of Box
                Mov  Byte Ptr[Bp+7],0           ;Zero Out High Byte
                Mov  Ax,[Bp+6]                  ;Y_Pos To Ax
                Dec  Ax                         ;Dec For Test
                Cmp  Ax,24                      ;In Range?
                Jna  Screenll1                  ;Jump Ahead If So
                Jmp  Screenlt1                  ;Else Quit Routine
Screenll1:      Inc  Ax                         ;Readjust
                Mov  Byte Ptr[Bp+9],0           ;Zero Out High Byte
                Mov  Bx,[Bp+8]                  ;X_Num To Bx
                Dec  Bx                         ;Dec For Test
                Cmp  Bx,79                      ;In Range?
                Jna  Screenlm1                  ;Jump Ahead If So
                Jmp  Screenlt1                  ;Else Quit
Screenlm1:      Inc  Bx                         ;Readjust
                Mul  Bl                         ;X_Num Times Y_Pos
                Shl  Ax,1                       ;Double For Attributes
                Add  Ax,Di                      ;Offset To End Of Box
                Mov  [Bp+14],Ax                 ;End Of Box Ptr To Stack
                Mov  Di,Ax                      ;Pt Es:Di To End Of Box
                Lds  Si,Dword Ptr[Bp+10]        ;Ds:Si Pts To Y_Pos
                Sub  Ax,Ax                      ;
                Mov  Al,[Si]                    ;Get Y_Pos Value
                Dec  Ax                         ;Count From Zero
                Cmp  Ax,24                      ;In Range?
                Jna  Screenln1                  ;Jump Ahead If So
                Jmp  Screenlt1                  ;Else Quit
Screenln1:      Mov  Bl,160                     ;Bytes Per Y_Pos
                Mul  Bl                         ;Calculate Y_Pos Offset
                Shl  Cx,1                       ;X_Pos Offset
                Add  Ax,Cx                      ;Add To Y_Pos Offset
                Mov  Si,Ax                      ;Si Pts To Topleft Corner
                Mov  [Bp+12],Si                 ;Save On Stack
                Mov  Ax,Dx                      ;Video_Buff
                Mov  Ds,Ax                      ;Move To Ds
                Mov  Ax,[Bp+8]                  ;X_Num
                Shl  Ax,1                       ;Double For Attributes
                Add  Si,Ax                      ;Ds:Si Pts To Topright
                Mov  [Bp+10],Si                 ;Copy Position On Stack
                Pop  Bx                         ;Video_Buff
                Cld                             ;Set Direction
                Mov  Si,[Bp+12]                 ;Point To Topleft Corner
                Sub  Si,4                       ;Minus Two Columns
                Mov  Cx,[Bp+6]                  ;Y_Pos
                Mov  Dx,Si                      ;Dx Holds Start X_Pos
Screenlo1:      Mov  Si,Dx                      ;Set Start X_Pos
                Call Boxl_Screen                ;Write A Char
                Call Boxl_Screen                ;Write Another
                Add  Dx,160                     ;Forward One Y_Pos
                Loop Screenlo1                  ;Do Next Y_Pos
                Mov  Ax,Ds                      ;Ds To Ax
                Mov  Es,Ax                      ;Now Es Pts To Screen Too
                Mov  Si,[Bp+12]                 ;Top Left Position
                Mov  Di,Si                      ;Copy To Di
                Sub  Di,4                       ;Will Shift Right By 2
                Mov  Dx,[Bp+6]                  ;Y_Pos
                Mov  Ax,[Bp+8]                  ;X_Num
Screenlp1:      Mov  Cx,Ax                      ;X_Num To Cx
                Push Di                         ;Save Target Start
                Push Si                         ;Save Source Start
Screenlq1:      Call Boxl_Screen                ;Write A Char
                Loop Screenlq1                  ;Go Do Next
                Pop  Si                         ;Restore Source Start
                Pop  Di                         ;Restore Target Start
                Add  Di,160                     ;Forward Dest Ptr
                Add  Si,160                     ;Forward Source Ptr
                Dec  Dx                         ;Dec Y_Pos Counter
                Jnz  Screenlp1                  ;Loop Till Image Shifted
                Mov  Ax,[Bp+20]                 ;Segment Of Box
                Mov  Ds,Ax                      ;Move To Ds
                Mov  Si,[Bp+18]                 ;Offset Of Box
                Mov  Di,[Bp+10]                 ;Es:Di Pts To Old Topleft
                Sub  Di,4                       ;Leftwards By 2 Cols
                Mov  Cx,[Bp+6]                  ;Y_Pos
                Mov  Dx,[Bp+8]                  ;X_Num
                Sub  Dx,2                       ;Minus 2 For 2 Columns
                Shl  Dx,1                       ;Double For Attributes
Screenlr1:      Add  Si,Dx                      ;Forward Box Ptr
                Call Boxl_Screen                ;Write A Char
                Call Boxl_Screen                ;Write Another
                Add  Di,156                     ;Forward Target Ptr
                Loop Screenlr1                  ;Do Next Y_Pos
                Std                             ;Reverse Direction Flag
                Mov  Ax,Ds                      ;Ds Pts To Box
                Mov  Es,Ax                      ;Now Es Does Too
                Mov  Di,[Bp+14]                 ;Offset To End Of Box
                Dec  Di                         ;Dec Screen Ptr
                Dec  Di                         ;Again
                Mov  Si,Di                      ;Copy To Si
                Sub  Si,4                       ;Source Pos 2 Chars Left
                Mov  Ax,[Bp+6]                  ;Y_Pos
                Mov  Cx,[Bp+8]                  ;X_Num
                Mul  Cl                         ;Size Of Box
                Mov  Cx,Ax                      ;Move To Cx As Counter
                Rep  Movsw                      ;Shift All Downwards
                Mov  Di,[Bp+18]                 ;Offset Of Box
                Mov  Si,[Bp+14]                 ;Offset Of X_Pos
                Mov  Cx,[Bp+6]                  ;Y_Pos
                Cld                             ;Direction Flag Forward
Screenls1:      Movsw                           ;Move First Word Of Two
                Movsw                           ;Move The Next
                Add  Di,Dx                      ;Forward Target Ptr
                Loop Screenls1                  ;Go Move 2 More Chars
                Jmp  Short Screenlu1            ;Jump To End
Screenlt1:      Pop  Bx                         ;Balance Stack If Error
Screenlu1:      Sti                             ;Reenable Interrupts
                Pop  Ds                         ;Restore Ds And Quit
                Pop  Bp                         ;Restore Bp
                Ret  16
Screenleft Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Screenright(Box:Pointer; Var X_Pos,Y_Pos: Byte; X_Num,Y_Pos: Byte);
;
;
;
;
Screenright Proc Far
                Push Bp                         ;Save Bp
                Mov  Bp,Sp                      ;Set Stack Frame
                Push Ds                         ;Save Turbo'S Ds
                Mov  Dx,Video_Buff              ;Grab Video_Buff
                Mov  Bl,Snow_Check              ;Grab Snow_Check
                Push Bx                         ;Save It
                Les  Di,Dword Ptr[Bp+14]        ;Es:Di Pts To X_Pos
                Sub  Cx,Cx                      ;
                Mov  Cl,Es:[Di]                 ;Get Column Position
                Jcxz Screenrti1                 ;Quit If Column Is Zero
                Dec  Cx                         ;Count From Zero
                Mov  Ax,Cx                      ;Copy To Ax
                Mov  Byte Ptr[Bp+9],0           ;Zero Out High Byte
                Add  Ax,[Bp+8]                  ;Add X_Num
                Cmp  Ax,78                      ;In Range?
                Jna  Screenrtj1                 ;Jump Ahead If So
Screenrti1:     Jmp  Screenrtt1                 ;Else Quit Routine
Screenrtj1:     Add  Cx,3                       ;Add 2 (+ Inc) To X_Pos Pos
                Mov  Es:[Di],Cl                 ;Change The Setting
                Sub  Cx,3                       ;Back To Old X_Pos Position
                Mov  Ax,[Bp+20]                 ;Segment Of Box
                Mov  Es,Ax                      ;Load In Es
                Mov  Di,[Bp+18]                 ;Offset Of Box
                Mov  Byte Ptr[Bp+7],0           ;Zero Out High Byte
                Mov  Ax,[Bp+6]                  ;Y_Pos To Ax
                Dec  Ax                         ;Dec For Test
                Cmp  Ax,24                      ;In Range?
                Jna  Screenrtk1                 ;Jump Ahead If So
                Jmp  Screenrtt1                 ;Else Quit Routine
Screenrtk1:     Inc  Ax                         ;Readjust
                Mov  Bx,[Bp+8]                  ;X_Num To Bx
                Dec  Bx                         ;Dec For Test
                Cmp  Bx,79                      ;In Range?
                Jna  Screenrtl1                 ;Jump Ahead If So
                Jmp  Screenrtt1                 ;Else Quit
Screenrtl1:     Inc  Bx                         ;Readjust
                Mul  Bl                         ;X_Num Times Y_Pos
                Shl  Ax,1                       ;Double For Attributes
                Add  Ax,Di                      ;Offset To End Of Box
                Mov  [Bp+14],Ax                 ;End Of Box Ptr To Stack
                Mov  Di,Ax                      ;Pt Es:Di To End Of Box
                Lds  Si,Dword Ptr[Bp+10]        ;Ds:Si Pts To Y_Pos
                Sub  Ax,Ax                      ;
                Mov  Al,[Si]                    ;Get Y_Pos Value
                Dec  Ax                         ;Count From Zero
                Cmp  Ax,24                      ;In Range?
                Jna  Screenrtm1                 ;Jump Ahead If So
                Jmp  Screenrtt1                 ;Else Quit
Screenrtm1:     Mov  Bl,160                     ;Bytes Per Y_Pos
                Mul  Bl                         ;Calculate Y_Pos Offset
                Shl  Cx,1                       ;X_Pos Offset
                Add  Ax,Cx                      ;Add To Y_Pos Offset
                Mov  Si,Ax                      ;Si Pts To Topleft Corner
                Mov  [Bp+12],Si                 ;Save On Stack
                Mov  Ax,Dx                      ;Video_Buff
                Mov  Ds,Ax                      ;Move To Ds
                Mov  Ax,[Bp+8]                  ;X_Num
                Shl  Ax,1                       ;Double For Attributes
                Add  Si,Ax                      ;Ds:Si Pts To Topright
                Mov  [Bp+10],Si                 ;Copy Position On Stack
                Pop  Bx                         ;Restore Procedure Ptr
                Cld                             ;Set Direction
                Mov  Cx,[Bp+6]                  ;Y_Pos
                Mov  Dx,Si                      ;Dx Holds Start X_Pos
Screenrtn1:     Mov  Si,Dx                      ;Set Start X_Pos
                Call Boxr_Screen                ;Write A Char
                Call Boxr_Screen                ;Write Another
                Add  Dx,160                     ;Forward One Y_Pos
                Loop Screenrtn1                 ;Do Next Y_Pos
                Mov  Ax,Ds                      ;Ds To Ax
                Mov  Es,Ax                      ;Now Es Pts To Screen Too
                Mov  Si,[Bp+10]                 ;Top Right Position + 2
                Sub  Si,2                       ;Minus 2
                Mov  Di,Si                      ;Copy To Di
                Add  Di,4                       ;Will Shift Right By 2
                Std                             ;Reverse Direction Flag
                Cmp  Ax,0B800H                  ;Graphics Card?
                Jb   Screenrto1                 ;Jump If Monochrome
                Inc  Di                         ;Forward Ptr To Start
                Inc  Si                         ;Other Ptr
Screenrto1:     Mov  Dx,[Bp+6]                  ;Y_Pos
                Mov  Ax,[Bp+8]                  ;X_Num
Screenrtp1:     Mov  Cx,Ax                      ;X_Num To Cx
                Push Di                         ;Save Target Start
                Push Si                         ;Save Source Start
Screenrtq1:     Call Boxr_Screen                ;Write A Char
                Loop Screenrtq1                 ;Go Do Next
                Pop  Si                         ;Restore Source Start
                Pop  Di                         ;Restore Target Start
                Add  Di,160                     ;Forward Dest Ptr
                Add  Si,160                     ;Forward Source Ptr
                Dec  Dx                         ;Dec Y_Pos Counter
                Jnz  Screenrtp1                 ;Loop Till Image Shifted
                Cld                             ;Reset Direction Flag
                Mov  Ax,[Bp+20]                 ;Segment Of Box
                Mov  Ds,Ax                      ;Move To Ds
                Mov  Si,[Bp+18]                 ;Offset Of Box
                Mov  Di,[Bp+12]                 ;Es:Di Pts To Old Topleft
                Mov  Cx,[Bp+6]                  ;Y_Pos
                Mov  Dx,[Bp+8]                  ;X_Num
                Sub  Dx,2                       ;Minus 2 For 2 Columns
                Shl  Dx,1                       ;Double For Attributes
Screenrtr1:     Call Boxr_Screen                ;Write A Char
                Call Boxr_Screen                ;Write Another
                Add  Di,156                     ;Forward Target Ptr
                Add  Si,Dx                      ;Forward Source Ptr
                Loop Screenrtr1                 ;Do Next Y_Pos
                Mov  Ax,[Bp+20]                 ;Segment Of Box
                Mov  Es,Ax                      ;Move To Es
                Mov  Di,[Bp+18]                 ;Offset Of Box
                Mov  Ax,[Bp+16]                 ;Segment Of X_Pos
                Mov  Ds,Ax                      ;Move To Ds
                Mov  Si,[Bp+14]                 ;Offset Of X_Pos
                Add  Di,4                       ;Di To New Start Of Box
                Mov  Cx,[Bp+6]                  ;Y_Pos
Screenrts1:     Add  Di,Dx                      ;Forward Target Ptr
                Movsw                           ;Move One Char Of Two
                Movsw                           ;Move The Next
                Loop Screenrts1                 ;Go Move 2 More Chars
                Mov  Di,[Bp+18]                 ;Offset To Start Of Box
                Mov  Si,Di                      ;Copy To Si
                Add  Si,4                       ;Si 2 Chars To The Right
                Mov  Ax,[Bp+6]                  ;Y_Pos
                Mov  Cx,[Bp+8]                  ;X_Num
                Mul  Cl                         ;Size Of Box
                Mov  Cx,Ax                      ;Move To Cx As Counter
                Rep  Movsw                      ;Shift All Downwards
                Jmp  Short Screenrtu1           ;Jump To End
Screenrtt1:     Pop  Bx                         ;Balance Stack If Error
Screenrtu1:     Sti                             ;Reenable Interrupts
                Pop  Ds                         ;Restore Ds And Quit
                Pop  Bp                         ;Restore Bp
                Ret  16
Screenright Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Screenup(Box: Pointer; Var X_Pos,Y_Pos: Byte; X_Num,Y_Pos: Byte);
;
;
;
;
Screenup Proc Far
                Push Bp                         ;Save Bp
                Mov  Bp,Sp                      ;Set Stack Frame
                Push Ds                         ;Save Turbo'S Ds
                Mov  Dx,Video_Buff              ;Grab Video_Buff
                Push Dx                         ;Save It
                Les  Di,Dword Ptr[Bp+14]        ;Point Es:Di To X_Pos
                Mov  Al,Snow_Check              ;Grab Snow_Check
                Mov  [Bp+16],Al                 ;Save On Stack
                Sub  Cx,Cx                      ;
                Mov  Cl,Es:[Di]                 ;Get Column Position
                Jcxz Scrupf1                    ;Quit If Column Is Zero
                Dec  Cx                         ;Count From Zero
                Cmp  Cx,79                      ;In Range?
                Jna  Scrupg1                    ;Jump Ahead If So
Scrupf1:        Jmp  Scrupm1                    ;Else Quit
Scrupg1:        Les  Di,Dword Ptr[Bp+18]        ;Point Es:Di To Byte Array
                Mov  Byte Ptr[Bp+7],0           ;Zero Out High Byte
                Mov  Ax,[Bp+6]                  ;Y_Pos To Ax
                Dec  Ax                         ;Dec For Test
                Cmp  Ax,24                      ;In Range?
                Jna  Scruph1                    ;Jump Ahead If So
                Jmp  Scrupm1                    ;Else Quit Routine
Scruph1:        Inc  Ax                         ;Readjust
                Mov  Byte Ptr[Bp+9],0           ;Zero Out High Byte
                Mov  Bx,[Bp+8]                  ;X_Num To Bx
                Dec  Bx                         ;Dec For Test
                Cmp  Bx,79                      ;In Range?
                Jna  Scrupi1                    ;Jump Ahead If So
                Jmp  Scrupm1                    ;Else Quit
Scrupi1:        Inc  Bx                         ;Readjust
                Mul  Bl                         ;X_Num Times Y_Pos
                Shl  Ax,1                       ;Double For Attributes
                Add  Ax,Di                      ;Offset To End Of Box
                Mov  [Bp+14],Ax                 ;End Of Box Ptr To Stack
                Mov  Di,Ax                      ;Pt Es:Di To End Of Box
                Lds  Si,Dword Ptr[Bp+10]        ;Point Ds:Si To Y_Pos
                Sub  Ax,Ax                      ;
                Mov  Al,[Si]                    ;Get Y_Pos Value
                Cmp  Ax,1                       ;Top Y_Pos Already?
                Je   Scrupj1                    ;Quit If So
                Dec  Ax                         ;Count From Zero
                Cmp  Ax,24                      ;In Range?
                Jna  Scrupk1                    ;Jump Ahead If So
Scrupj1:        Jmp  Scrupm1                    ;Else Quit
Scrupk1:        Mov  Bx,Ax                      ;Copy In Bx
                Add  Bx,[Bp+6]                  ;Add Y_Pos
                Cmp  Bx,25                      ;In Range?
                Ja   Scrupj1                    ;Quit If So
                Mov  [Si],Al                    ;Reset Y_Pos Variable
                Mov  Bl,160                     ;Bytes Per Y_Pos
                Mul  Bl                         ;Calculate Y_Pos Offset
                Shl  Cx,1                       ;X_Pos Offset
                Add  Ax,Cx                      ;Add To Y_Pos Offset
                Mov  Si,Ax                      ;Si Pts To Topleft Corner
                Mov  [Bp+12],Si                 ;Save On Stack
                Mov  Ax,Dx                      ;Video_Buff
                Mov  Ds,Ax                      ;Move To Ds
                Mov  Ax,[Bp+6]                  ;Y_Pos
                Mov  Cl,160                     ;Bytes Per Y_Pos
                Mul  Cl                         ;Times Y_Pos
                Add  Si,Ax                      ;Ds:Si Pts To Topright
                Mov  [Bp+10],Si                 ;Copy Position On Stack
                Pop  Bx                         ;Video_Buff
                Cld                             ;Set Direction
                Mov  Si,[Bp+12]                 ;Topright Position
                Sub  Si,160                     ;Y_Pos Higher
                Mov  Cx,[Bp+8]                  ;X_Num
                Shl  Cx,1                       ;Double For Movsb
                Call Boxu_Screen                ;Write A Char
                Mov  Ax,Ds                      ;Ds To Ax
                Mov  Es,Ax                      ;Now Es Pts To Screen Too
                Mov  Di,[Bp+12]                 ;Top Left Position
                Mov  Si,Di                      ;Copy To Si
                Sub  Di,160                     ;Di One Y_Pos Higher
                Mov  Ax,[Bp+6]                  ;Y_Pos To Ax
Scrupl1:        Mov  Cx,[Bp+8]                  ;X_Num To Cx
                Push Di                         ;Save Target Ptr
                Push Si                         ;Save Source Ptr
                Shl  Cx,1                       ;Double X_Num For Movsb
                Call Boxu_Screen                ;Write A Char
                Pop  Si                         ;Restore Ptr
                Pop  Di                         ;Restore Ptr
                Add  Di,160                     ;Ptr Down One Y_Pos
                Add  Si,160                     ;Ditto
                Dec  Ax                         ;Dec Y_Pos Counter
                Jnz  Scrupl1                    ;Loop Till Finished
                Mov  Ax,[Bp+20]                 ;Segment Of Box
                Mov  Ds,Ax                      ;Move To Ds
                Mov  Si,[Bp+14]                 ;Offset Of End Of Box
                Mov  Di,[Bp+10]                 ;Es:Di Pts To Bottomleft
                Sub  Di,160                     ;One Y_Pos Higher
                Mov  Dx,[Bp+8]                  ;X_Num
                Shl  Dx,1                       ;Double For Attributes
                Sub  Si,Dx                      ;Ds:Si Pts To Last Y_Pos
                Mov  Cx,Dx                      ;Use As Counter
                Call Boxu_Screen                ;Write A Char
                Std                             ;Reverse Direction Flag
                Mov  Ax,Ds                      ;Ds Pts To Box
                Mov  Es,Ax                      ;Now Es Does Too
                Mov  Di,[Bp+14]                 ;Offset To End Of Box
                Sub  Di,2                       ;Last Char Of Box
                Mov  Si,Di                      ;Copy To Si
                Sub  Si,Dx                      ;Offset To Second Y_Pos
                Mov  Ax,[Bp+6]                  ;Y_Pos
                Dec  Ax                         ;Minus One Y_Pos
                Mov  Cx,[Bp+8]                  ;X_Num
                Mul  Cl                         ;Size Of Box Minus 1 Y_Pos
                Mov  Cx,Ax                      ;Move To Cx As Counter
                Rep  Movsw                      ;Shift All Upwards
                Mov  Di,[Bp+18]                 ;Offset Of Box
                Mov  Si,[Bp+14]                 ;End Of Box
                Mov  Cx,[Bp+8]                  ;X_Num
                Cld                             ;Direction Flag Forward
                Rep  Movsw                      ;Move New Data
                Jmp  Short Scrupn1              ;Jump To End
Scrupm1:        Pop  Bx                         ;Balance Stack If Error
Scrupn1:        Sti                             ;Reenable Interrupts
                Pop  Ds                         ;Restore Ds
                Pop  Bp                         ;Restore Bp
                Ret
Screenup Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Fillscreen(Ch: Char; X_Pos,Y_Pos,X_Num,Y_Pos,Colour: Byte);
;
;
;
;
Fillscreen Proc Far
                Push Bp                         ;Save Bp
                Mov  Bp,Sp                      ;Set Stack Frame
                Cld                             ;Set Direction Flag
                Mov  Ax,Video_Buff              ;Fetch Video_Buff
                Mov  Es,Ax                      ;Es Pts To Screen
                Mov  Si,Bx                      ;Procedure Addr To Si
                Sub  Ax,Ax                      ;
                Mov  Al,[Bp+12]                 ;Get Y_Pos
                Dec  Ax                         ;Count From 0
                Mov  Dl,160                     ;Bytes In A Y_Pos
                Mul  Dl                         ;Times Y_Pos
                Sub  Dx,Dx                      ;
                Mov  Dl,[Bp+14]                 ;Get Column
                Dec  Dx                         ;Count From 0
                Shl  Dx,1                       ;Double For Attributes
                Add  Ax,Dx                      ;Add To Y_Pos Offset
                Mov  Di,Ax                      ;Es:Di Pts To First Char
                Sub  Bx,Bx                      ;
                Mov  Bl,[Bp+10]                 ;X_Num In Bx
                Or   Bx,Bx                      ;Test For Zero
                Jz   Fillscrl6                  ;Quit If Zero
                Sub  Dx,Dx                      ;
                Mov  Dl,[Bp+8]                  ;Y_Pos In Dx
                Or   Dx,Dx                      ;Test For Zero
                Jz   Fillscrl6                  ;Quit If Zero
                Mov  Al,[Bp+16]                 ;Char In Al
                Mov  Ah,[Bp+6]                  ;Attribute In Ah
Fillscrl1:      Mov  Cx,Bx                      ;X_Num To Cx As Counter
                Push Di                         ;Save Starting Point
                Push Dx                         ;Save Y_Pos Counter
Fillscrl2:      Cmp  Snow_Check,0               ;Protect Against Snow?
                Je   Fillscrl5                  ;Jump Ahead If Not
                Mov  Dx,3Dah                    ;Status Byte Address
                Mov  Si,Ax                      ;Save Ax Contents
Fillscrl3:      In   Al,Dx                      ;Get Status Byte
                Test Al,1                       ;Test Bit
                Jnz  Fillscrl3                  ;Loop Till 0
                Cli                             ;Disable Interrupts
Fillscrl4:      In   Al,Dx                      ;Get Status Byte
                Test Al,1                       ;Test Bit
                Jz   Fillscrl4                  ;Loop Till 1
                Mov  Ax,Si                      ;Restore Ax Contents
Fillscrl5:      Stosw                           ;Write Char And Attribute
                Loop Fillscrl2                  ;Go Do Next
                Pop  Dx                         ;Restore Y_Pos Counter
                Pop  Di                         ;Restore Starting Point
                Add  Di,160                     ;Forward Ptr One Y_Pos
                Dec  Dx                         ;Dec Y_Pos Counter
                Jnz  Fillscrl1                  ;Go Do Next Y_Pos
Fillscrl6:      Sti                             ;Reenable Interrupts
                Pop  Bp                         ;Restore Bp
                Ret  12
Fillscreen Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Clearpage(Pagenumber,Colour: Byte);
;
;
Clearpage Proc Far
                Push Bp                         ;Save Bp
                Mov  Bp,Sp                      ;Set Stack Frame
                Mov  Bh,[Bp+8]                  ;Page Number To Bh
                Mov  Ah,2                       ;Bios Func To Set Cursor
                Sub  Dx,Dx                      ;Y_Pos And Column Are 0,0
                Int  10H                        ;Set The Cursor
                Mov  Ah,9                       ;Bios Write Function
                Mov  Al,32                      ;Clear With Space Char
                Mov  Bl,[Bp+6]                  ;Attribute To Bl
                Mov  Cx,2000                    ;Chars To Write
                Int  10H                        ;Clear The Page
                Pop  Bp                         ;Restore Bp
                Ret  4
Clearpage Endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Drawbox(Char_X ,Char_Y :Char;X_Pos,Y_Pos,X_Num,Y_Pos,Colour:Byte);
;
;
;
;
Drawbox Proc  Far

                Push Bp                         ;Save Bp
                Mov  Errreturn,1                ;1 = Y_Pos Out Of Range
                Mov  Bp,Sp                      ;Set Up Stack Frame
                Mov  Al,[Bp+18]                 ;Horz Double Or Single?
                Je   Drawboxe1                  ;Jump Ahead If So
                Cmp  Al,'D'                     ;Double Line?
                Je   Drawboxe1                  ;Jump Ahead If So
                Mov  Dh,196                     ;Else Single Line
Drawboxe1:      Mov  Al,[Bp+16]                 ;Vert Double Or Single?
                Mov  Dl,186                     ;Assume Double Line
                Cmp  Al,'D'                     ;Double Line?
                Je   Drawboxg1                  ;Jump Ahead If So
                Cmp  Al,'D'                     ;Double Line?
                Je   Drawboxg1                  ;Jump Ahead If So
                Mov  Dl,179                     ;Else Single Line
                Cmp  Dh,196                     ;Horizontal Single?
                Jne  Drawboxf1                  ;Jump Ahead If Not
                Mov  Ax,0Dabfh                  ;Top Sngl Vert, Sngl Horz
                Mov  Bx,0C0D9H                  ;Bot Sngl Vert, Sngl Horz
                Jmp  Short Drawboxi1            ;Registers Set
Drawboxf1:      Mov  Ax,0D5B8H                  ;Top Sngl Vert, Dbl Horz
                Mov  Bx,0D4Beh                  ;Bot Sngl Vert, Dbl Horz
                Jmp  Short Drawboxi1            ;Registers Set
Drawboxg1:      Cmp  Dh,196                     ;Horizontal Single?
                Jne  Drawboxh1                  ;Jump Ahead If Not
                Mov  Ax,0D6B7H                  ;Top Dbl Vert, Sngl Horz
                Mov  Bx,0D3Bdh                  ;Bot Dbl Vert, Sngl Horz
                Jmp  Short Drawboxi1            ;Registers Set
Drawboxh1:      Mov  Ax,0C9Bbh                  ;Top Dbl Vert, Dbl Horz
                Mov  Bx,0C8Bch                  ;Bot Dbl Vert, Dbl Horz
Drawboxi1:      Mov  [Bp+18],Ax                 ;Save Top Corners
                Mov  [Bp+16],Bx                 ;Save Bottom Corners
                Mov  Ax,Video_Buff              ;Get Ptr To Video_Buff
                Mov  Es,Ax                      ;Move To Es
                Sub  Ax,Ax                      ;
                Mov  Al,[Bp+12]                 ;Y_Pos To Ax
                Dec  Ax                         ;Count From 0
                Cmp  Ax,24                      ;In Range?
                Jbe  Drawboxj1                  ;Jump Ahead If So
                Jmp  Drawboxo1                  ;Else Quit Routine
Drawboxj1:      Inc  Errreturn                  ;2 = Column Out Of Range
                Mov  Cl,160                     ;Bytes In A Y_Pos
                Mul  Cl                         ;Times Y_Pos
                Sub  Cx,Cx                      ;
                Mov  Cl,[Bp+14]                 ;Column To Cx
                Dec  Cx                         ;Count From 0
                Cmp  Cx,79                      ;In Range?
                Jna  Drawboxk1                  ;Jump Ahead If Ok
                Jmp  Drawboxo1                  ;Else Quit
Drawboxk1:      Inc  Errreturn                  ;3 = X_Num Out Of Range
                Shl  Cx,1                       ;Double For Attributes
                Add  Ax,Cx                      ;Buffer Offset
                Mov  Di,Ax                      ;Es:Di Pts To Offset
                Sub  Bx,Bx                      ;
                Mov  Bl,[Bp+10]                 ;X_Num To Bx
                Dec  Bx                         ;Count From 0
                Dec  Bx                         ;Ready For Test
                Cmp  Bx,78                      ;Out Of Range?
                Ja   Drawboxo1                  ;Quit If So
                Inc  Errreturn                  ;4 = Y_Pos Out Of Range
                Inc  Bx                         ;Readjust After Test
                Shl  Bx,1                       ;Double For Attributes
                Mov  Ah,[Bp+6]                  ;Attribute To Ah
                Mov  Al,[Bp+19]                 ;Topleft Corner To Al
                Call Drawb_Screen               ;Write The Character
                Add  Di,Bx                      ;Add Offset To Scrn Ptr
                Mov  Al,[Bp+18]                 ;Topright Corner To Al
                Call Drawb_Screen               ;Write The Character
                Sub  Di,Bx                      ;Sub Offset From Scrn Ptr
                Sub  Cx,Cx                      ;
                Mov  Cl,[Bp+8]                  ;Get Box Y_Pos
                Dec  Cx                         ;Minus 2
                Dec  Cx                         ;  For Corners
                Cmp  Cx,23                      ;Test Length
                Ja   Drawboxo1                  ;Quit If Out Of Range
                Mov  Errreturn,0                ;Else No Error
                Push Di                         ;Save Initial Position
                Add  Di,160                     ;Forward Screen Ptr
                Jcxz Drawboxm1                  ;Jump If No Chr To Write
                Mov  Al,Dl                      ;Vertical Char To Al
Drawboxl1:      Call Drawb_Screen               ;Write The Character
                Add  Di,Bx                      ;Add Offset To Scrn Ptr
                Call Drawb_Screen               ;Write The Character
                Sub  Di,Bx                      ;Sub Offset From Scrn Ptr
                Add  Di,160                     ;Forward Screen Ptr
                Loop Drawboxl1                  ;On To Next Vert Chars
Drawboxm1:      Mov  Al,[Bp+17]                 ;Bottomleft Corner To Al
                Call Drawb_Screen               ;Write The Character
                Mov  Al,[Bp+16]                 ;Bottomright Corner To Al
                Add  Di,Bx                      ;Add Offset To Scrn Ptr
                Call Drawb_Screen               ;Write The Character
                Sub  Di,Bx                      ;Sub Offset From Scrn Ptr
                Mov  Bx,Di                      ;Save Bottom Left Pos
                Pop  Di                         ;Restore Top Left Pos
                Mov  Al,Dh                      ;Horizontal Char To Al
                Sub  Cx,Cx                      ;
                Mov  Cl,[Bp+10]                 ;Get X_Num
                Dec  Cx                         ;Minus 2
                Dec  Cx                         ;  For Corners
                Jcxz Drawboxo1                  ;Quit If No Chrs To Print
                Inc  Di                         ;Forward Scrn Ptr
                Inc  Di                         ;  To 1St Position On Top
Drawboxn1:      Call Drawb_Screen               ;Write The Character
                Inc  Di                         ;Forward Base Ptr
                Inc  Di                         ;...Again
                Inc  Bx                         ;Forward Scrn Ptr
                Inc  Bx                         ;  For Bottom Line
                Xchg Di,Bx                      ;Get Ready To Write
                Call Drawb_Screen               ;Write The Character
                Xchg Di,Bx                      ;Restore Scrn Ptr
                Loop Drawboxn1                  ;Go Do Next Char
Drawboxo1:      Sti                             ;Reenable Interrupts
                Pop  Bp                         ;Restore Bp And Quit
                Ret  14
Drawbox Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Copyclear(Box: Pointer; X_Pos,Y_Pos,X_Num,Y_Pos,Colour: Byte);
;
;
;
;
Copyclear Proc Far
                Push Bp                         ;Save Bp
                Mov  Bp,Sp                      ;Set Stack Frame
                Push Ds                         ;Save Ds
                Mov  Bl,Snow_Check              ;Grab Snow_Check
                Mov  Ax,Video_Buff              ;Fetch Video Address
                Mov  Ds,Ax                      ;Ds Points To Buffer
                Les  Di,Dword Ptr[Bp+16]        ;Es:Di Pts To Byte Array
                Sub  Ax,Ax                      ;
                Mov  Al,[Bp+12]                 ;Y_Pos In Ax
                Dec  Ax                         ;Count Y_Pos From 0
                Mov  Dl,160                     ;160 Bytes Per Y_Pos
                Mul  Dl                         ;Ax Times 160
                Sub  Dx,Dx                      ;
                Mov  Dl,[Bp+14]                 ;X_Pos In Dx
                Dec  Dx                         ;Count Cols From 0
                Shl  Dx,1                       ;Double For Attributes
                Add  Ax,Dx                      ;Offset Of Topleft Corner
                Mov  Dh,[Bp+10]                 ;X_Num In Dh
                Mov  Dl,[Bp+8]                  ;Y_Pos In Dl
                Mov  Ch,[Bp+6]                  ;Fill Attribute
                Mov  Cl,32                      ;Space Char For Fill
                Mov  Bp,Ax                      ;Scrn Ptr Copy In Bp
                Mov  Ah,Bl                      ;Move Snow_Check
                Mov  Bx,Cx                      ;Copy In Bx
                Sub  Cx,Cx                      ;Clear Loop Counter
                Cld                             ;Set Direction Flag
Copyclear1:     Mov  Si,Bp                      ;Set Ds:Si Scrn Ptr
                Mov  Cl,Dh                      ;Count Box X_Num
                Push Dx                         ;Save X_Num,Y_Pos Ctr
Copyclear2:     Cmp  Ah,0                       ;Protect Against Snow?
                Je   Copyclear7                 ;Jump Ahead If Not
                Mov  Dx,3Dah                    ;Status Byte Port Addr
Copyclear3:     In   Al,Dx                      ;Get Status Byte
                Test Al,1                       ;Test Bit
                Jnz  Copyclear3                 ;Loop Till 0
                Cli                             ;Disable Interrupts
Copyclear4:     In   Al,Dx                      ;Get Status Byte
                Test Al,1                       ;Test Bit
                Jz   Copyclear4                 ;Loop Till 1
                Movsw                           ;Transfer Word To Buffer
                Sub  Si,2                       ;Pull Back Screen Ptr
Copyclear5:     In   Al,Dx                      ;Get Status Byte
                Test Al,1                       ;Test Bit
                Jnz  Copyclear5                 ;Loop Till 0
Copyclear6:     In   Al,Dx                      ;Get Status Byte
                Test Al,1                       ;Test Bit
                Jz   Copyclear6                 ;Loop Till 1
                Mov  [Si],Bx                    ;Clear Cell On Screen
                Add  Si,2                       ;Move Scrn Ptr Back
                Jmp  Short Copyclear8           ;Jump Ahead
Copyclear7:     Movsw                           ;Monochrome: Transf Char
                Mov  [Si-2],Bx                  ;Clear Screen Cell
Copyclear8:     Loop Copyclear2                 ;Go Do Next
                Pop  Dx                         ;Restore X_Num,Y_Pos Ctrs
                Add  Bp,160                     ;Forward Ptr To Next Y_Pos
                Dec  Dl                         ;Dec Y_Pos Counter
                Jnz  Copyclear1                 ;Loop If Another Line
Copyclear9:     Sti                             ;Reenable Interrupts
                Pop  Ds                         ;Restore Ds
                Pop  Bp                         ;Restore Bp
                Ret  14
Copyclear Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Swappage(Box: Pointer; Pagenumber: Byte);
;
;
;
;
Swappage Proc Far
                Push Bp                         ;Save Bp
                Mov  Bp,Sp                      ;Set Stack Frame
                Push Ds                         ;Save Ds
                Mov  Bl,Snow_Check              ;Fetch Snow_Check
                Cld                             ;Set Direction Flag
                Mov  Cx,Video_Buff              ;Get Video Buffer Addr
                Mov  Dl,[Bp+6]                  ;Get Page Number
                Mov  Ax,1000H                   ;Page Size
                Mul  Dl                         ;Times Number Pages
                Add  Ax,Cx                      ;Add To Buffer Offset
                Mov  Es,Ax                      ;Es Pts To Page
                Lds  Si,Dword Ptr[Bp+8]         ;Ds:Si Pts To Byte Array
                Mov  Cx,2000                    ;Number Words To Exchange
                Sub  Di,Di                      ;Point Di To 0 Offset
                Cmp  Bl,0                       ;Snow_Check?
                Je   Swappagel1                 ;Jump If Not
                Mov  Dx,3D8H                    ;Cga Mode Select Register
                Mov  Al,25H                     ;Shuts Off Screen
                Out  Dx,Al                      ;Disable Video
Swappagel1:     Mov  Ax,Es:[Di]                 ;Get Video Word
                Xchg Ax,[Si]                    ;Xchg With Word In Box
                Stosw                           ;Move Box Word To Screen
                Add  Si,2                       ;Forward Box Ptr
                Loop Swappagel1                 ;Go Do Next Word
                Cmp  Bl,0                       ;Snow Protect?
                Je   Swappagel2                 ;Jump Ahead If Not
                Mov  Dx,3D8H                    ;Cga Mode Select Register
                Mov  Al,41                      ;80X25, Blink Enabled
                Out  Dx,Al                      ;Reenable Video
Swappagel2:     Pop  Ds                         ;Restore Ds
                Pop  Bp                         ;Restore Bp
                Ret  6
Swappage Endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Restorescreen(Box: Pointer; X_Pos,Y_Pos,X_Num,Y_Pos: Byte);
;
;
;
;
Restorescreen Proc Far
                Push Bp                         ;Save Bp
                Mov  Bp,Sp                      ;Set Stack Frame
                Mov  Bl,Snow_Check              ;Grab Snow_Check
                Push Ds                         ;Save Ds
                Cld                             ;Set Direction Flag
                Mov  Ax,Video_Buff              ;Fetch Video Address
                Mov  Es,Ax                      ;Es Points To Screen
                Lds  Si,Dword Ptr[Bp+14]        ;Ds:Si Pts To Byte Array
                Mov  [Bp+14],Bl                 ;Save Snow_Check On Stack
                Sub  Ax,Ax                      ;
                Mov  Al,[Bp+10]                 ;Y_Pos In Ax
                Dec  Ax                         ;Count Y_Pos From 0
                Mov  Dl,160                     ;160 Bytes Per Y_Pos
                Mul  Dl                         ;Ax Times 160
                Sub  Dx,Dx                      ;
                Mov  Dl,[Bp+12]                 ;X_Pos In Dx
                Dec  Dx                         ;Count Cols From 0
                Shl  Dx,1                       ;Double For Attributes
                Add  Ax,Dx                      ;Offset Of Topleft Corner
                Mov  Bx,Ax                      ;Move Scrn Ptr To Bx
                Mov  Dh,[Bp+8]                  ;X_Num In Bx
                Mov  Dl,[Bp+6]                  ;Y_Pos In Dx
                Sub  Cx,Cx                      ;Clear Cx
Restorescrl1:   Mov  Di,Bx                      ;Set Es:Di Scrn Ptr
                Mov  Cl,Dh                      ;X_Num Counter
                Push Dx                         ;Save X_Num,Y_Pos Ctrs
Restorescrl2:   Cmp  Byte Ptr[Bp+14],0          ;Protect Against Snow?
                Je   Restorescrl5               ;Jump Ahead If Not
                Mov  Dx,3Dah                    ;Status Byte Address
Restorescrl3:   In   Al,Dx                      ;Get Status Byte
                Test Al,1                       ;Test Bit
                Jnz  Restorescrl3               ;Loop Till 0
                Cli                             ;Disable Interrupts
Restorescrl4:   In   Al,Dx                      ;Get Status Byte
                Test Al,1                       ;Test Bit
                Jz   Restorescrl4               ;Loop Till 1
Restorescrl5:   Movsw                           ;Transfer Char To Scrn
                Loop Restorescrl2               ;Go Do Next In Y_Pos
                Pop  Dx                         ;Restore X_Num,Y_Pos Ctrs
                Add  Bx,160                     ;Forward Ptr To Next Y_Pos
                Dec  Dl                         ;Dec Y_Pos Counter
                Jnz  Restorescrl1               ;Loop If Another Line
Restorescrl6:   Sti                             ;Reenable Interrupts
                Pop  Ds                         ;Restore Ds
                Pop  Bp                         ;Restore Bp
                Ret  12
Restorescreen Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Savescreen(Box: Pointer; X_Pos,Y_Pos,X_Num,Y_Pos: Byte);
;
;
;
;
Savescreen Proc Far
                Push Bp                         ;Save Bp
                Mov  Bp,Sp                      ;Set Stack Frame
                Push Ds                         ;Ds Changed
                Mov  Bl,Snow_Check              ;Getch Snow_Check
                Mov  Ax,Video_Buff              ;Fetch Video Address
                Mov  Ds,Ax                      ;Ds Points To Buffer
                Les  Di,Dword Ptr[Bp+14]        ;Es:Di Pts To Box
                Sub  Ax,Ax                      ;
                Mov  Al,[Bp+10]                 ;Y_Pos In Ax
                Dec  Ax                         ;Count Y_Pos From 0
                Mov  Dl,160                     ;160 Bytes Per Y_Pos
                Mul  Dl                         ;Ax Times 160
                Sub  Dx,Dx                      ;
                Mov  Dl,[Bp+12]                 ;X_Pos In Dx
                Dec  Dx                         ;Count Cols From 0
                Shl  Dx,1                       ;Double For Attributes
                Add  Ax,Dx                      ;Offset Of Topleft Corner
                Mov  Dh,[Bp+8]                  ;X_Num To Dh
                Mov  Dl,[Bp+6]                  ;Y_Pos To Dl
                Sub  Cx,Cx                      ;Clear Cx
                Cld                             ;Set Direction Flag
Savescrl1:      Mov  Si,Ax                      ;Set Ds:Si Scrn Ptr
                Mov  Cl,Dh                      ;X_Num Counter
                Push Dx                         ;Save X_Num, Y_Pos Ctrs
                Push Ax                         ;Save Line Start Ptr
Savescrl2:      Or   Bl,Bl                      ;Protect Against Snow?
                Je   Savescrl5                  ;Jump Ahead If Not
                Mov  Dx,3Dah                    ;Status Byte Address
Savescrl3:      In   Al,Dx                      ;Get Status Byte
                Test Al,1                       ;Test Bit
                Jnz  Savescrl3                  ;Loop Till 0
                Cli                             ;Disable Interrupts
Savescrl4:      In   Al,Dx                      ;Get Status Byte
                Test Al,1                       ;Test Bit
                Jz   Savescrl4                  ;Loop Till 1
Savescrl5:      Movsw                           ;Move Word To Buffer
                Loop Savescrl2                  ;Go Do Next In Y_Pos
                Pop  Ax                         ;Restore Line Start Ptr
                Pop  Dx                         ;Restore X_Num,Y_Pos Ctrs
                Add  Ax,160                     ;Forward Ptr To Next Y_Pos
                Dec  Dl                         ;Dec Y_Pos Counter
                Jnz  Savescrl1                  ;Loop If Another Line
Savescrl6:      Sti                             ;Reenable Interrupts
                Pop  Ds                         ;Restore Ds
                Pop  Bp                         ;Restore Bp
                Ret  12
Savescreen Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Scrollx(Where: Char; X_Pos,Y_Pos,X_Num,Y_Pos,Cols,Colour: Byte);
;
;
;
;
Scrollx Proc Far
                Push Bp                         ;Save Bp
                Mov  Bp,Sp                      ;Set Stack Frame
                Push Ds                         ;Save Turbo'S Ds
                Mov  Ax,Video_Buff              ;Fetch Video_Buff
                Mov  Bl,Snow_Check              ;Get Snow_Check Before Change Ds
                Mov  Es,Ax                      ;Move To Es
                Mov  Ds,Ax                      ;Copy In Ds
                Sub  Ax,Ax                      ;
                Mov  Al,[Bp+14]                 ;Top Left Y_Pos To Ax
                Mov  [Bp+14],Bl                 ;Save Snow_Check
                Dec  Ax                         ;Count From 0
                Cmp  Ax,24                      ;In Range?
                Jna  Scrollxl2                  ;Jump Ahead If So
Scrollxl1:      Jmp  Scrollxl8                  ;Else Quit Routine
Scrollxl2:      Mov  Cl,160                     ;Bytes Per Y_Pos
                Mul  Cl                         ;Times Y_Pos Count
                Sub  Cx,Cx                      ;
                Mov  Cl,[Bp+16]                 ;Top Left X_Pos To Cx
                Dec  Cx                         ;Count From 0
                Cmp  Cx,79                      ;In Range?
                Ja   Scrollxl1                  ;Quit If Not
                Shl  Cx,1                       ;Double For Attributes
                Add  Ax,Cx                      ;Add To Y_Pos Offset
                Sub  Dx,Dx                      ;
                Mov  Dl,[Bp+10]                 ;Y_Pos To Dx
                Or   Dx,Dx                      ;Test For Zero Length
                Jz   Scrollxl1                  ;Quit If Zero
                Mov  Cl,[Bp+18]                 ;Get Direction Flag
                Cmp  Cl,'L'                     ;Test For 'L'
                Je   Scrollxl3                  ;Jump Ahead If 'L'
                Cmp  Cl,'L'                     ;Test For 'L'
                Je   Scrollxl3                  ;Jump Ahead If 'L'
                Sub  Cx,Cx                      ;
                Mov  Cl,[Bp+12]                 ;X_Num To Cx
                Dec  Cx                         ;Adjust
                Shl  Cx,1                       ;Double For Attributes
                Add  Ax,Cx                      ;Add To X,Y Position
                Mov  Di,Ax                      ;Es:Di Pts To Top Right
                Sub  Cx,Cx                      ;
                Mov  Cl,[Bp+8]                  ;Get Cols To Scroll
                Shl  Cx,1                       ;Double For Attributes
                Sub  Ax,Cx                      ;Sub From Top Right Pos
                Mov  Si,Ax                      ;Ds:Si Pts To Source
                Std                             ;Set Direction For 'R'
                Jmp  Short Scrollxl4            ;Jump Ahead
Scrollxl3:      Sub  Cx,Cx                      ;
                Mov  Cl,[Bp+8]                  ;Cols To Cx
                Shl  Cx,1                       ;Double For Attributes
                Mov  Di,Ax                      ;Es:Di Pts Leftmost Char
                Add  Ax,Cx                      ;Offset To Lst Scrl Char
                Mov  Si,Ax                      ;Ds:Si Pts Scrl Char
                Cld                             ;Set Direction For 'L'
Scrollxl4:      Sub  Cx,Cx                      ;
                Mov  Cl,[Bp+12]                 ;Box X_Num To Dx
                Or   Cx,Cx                      ;Test For Zero X_Num
                Jz   Scrollxl8                  ;Quit Routine If Zero
                Sub  Ax,Ax                      ;
                Mov  Al,[Bp+8]                  ;Number Cols To Scroll
                Or   Ax,Ax                      ;Test For Zero Cols
                Jnz  Scrollxl5                  ;Jump Ahead If Not Zero
                Xchg Ax,Cx                      ;Else Cols = X_Num
                Jmp  Short Scrollxl6            ;Jump Ahead
Scrollxl5:      Sub  Cx,Ax                      ;X_Num Minus Cols
                Cmp  Cx,0                       ;More Cols Than X_Num?
                Jge  Scrollxl6                  ;Jump Ahead If Not
                Sub  Ax,Ax                      ;
                Mov  Al,[Bp+12]                 ;Else Cols = X_Num
                Mov  Cx,0                       ;Scroll = 0
Scrollxl6:      Push Ax                         ;Save Number Cols
                Push Cx                         ;Save X_Num Counter
                Push Si                         ;Save Source Ptr
                Push Di                         ;Save Destination Ptr
                Push Dx                         ;Save Y_Pos Counter
                Push Ax                         ;Save Number Cols
                Cmp  Byte Ptr[Bp+14],0          ;Protect Against Snow?
                Je   Scrollxl7                  ;Jump Ahead If Not
                Mov  Dx,3D8H                    ;Cga Mode Select Register
                Mov  Al,25H                     ;Shut Off Screen
                Out  Dx,Al                      ;Do It
Scrollxl7:      Pop  Ax                         ;Restore Number Cols
                Pop  Dx                         ;Restore Y_Pos Counter
                Rep  Movsw                      ;Move A Y_Pos
                Mov  Cx,Ax                      ;Number Cols Scrolled
                Mov  Al,32                      ;Clear With Spc Char
                Mov  Ah,[Bp+6]                  ;Attribute For Clear
                Rep  Stosw                      ;Clear Opened Area
                Pop  Di                         ;Restore Destination Ptr
                Add  Di,160                     ;Forward To Next Line
                Pop  Si                         ;Restore Source Ptr
                Add  Si,160                     ;Forward To Next Line
                Pop  Cx                         ;Restore X_Num Counter
                Pop  Ax                         ;Restore Num Cols
                Dec  Dx                         ;Dec The Y_Pos Counter
                Jnz  Scrollxl6                  ;Loop Until Finished
                Cmp  Byte Ptr[Bp+14],0          ;Protected Against Snow?
                Je   Scrollxl8                  ;Jump If Not
                Mov  Dx,3D8H                    ;Cga Mode Select Register
                Mov  Al,41                      ;80X25, Blink Enabled
                Out  Dx,Al                      ;Reenable Video
Scrollxl8:      Pop  Ds                         ;Restore Ds
                Pop  Bp                         ;Restore Bp
                Ret  14
Scrollx Endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Scrolly(Where: Char; X_Pos,Y_Pos,X_Num,Y_Num,Lines,Colour: Byte);
;
;
;
;
Scrolly Proc Far
                Push Bp                         ;Save Bp
                Mov  Bp,Sp                      ;Set Stack Frame
                Mov  Ah,7                       ;Assume Downward Scroll
                Mov  Al,[Bp+18]                 ;Get Direction Code
                Cmp  Al,'D'                     ;Downward Scroll?
                Je   Scrollyl1                  ;Jump Ahead If So
                Cmp  Al,'D'                     ;Downward Scroll?
                Je   Scrollyl1                  ;Jump Ahead If So
                Mov  Ah,6                       ;Else Code To Scroll Up
Scrollyl1:      Mov  Cl,[Bp+16]                 ;Top Left X_Pos In Cl
                Dec  Cl                         ;Count From 0
                Mov  Ch,[Bp+14]                 ;Top Left Y_Pos In Ch
                Dec  Ch                         ;Count From 0
                Mov  Dl,[Bp+12]                 ;X_Num In Dl
                Dec  Dl                         ;Adjust
                Add  Dl,Cl                      ;Bottom Right X_Pos In Dl
                Mov  Dh,[Bp+10]                 ;Y_Pos In Dh
                Dec  Dh                         ;Adjust
                Add  Dh,Ch                      ;Bottom Right Y_Pos In Dh
                Mov  Al,[Bp+8]                  ;Number Lines In Al
                Mov  Bh,[Bp+6]                  ;Fill Attribute
                Int  10H                        ;Make The Scroll
                Pop  Bp                         ;Restore Bp And Quit
                Ret  14
Scrolly Endp


; Code Ends

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;                 Local Procedures Used By Other Procedures
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

Boxd_Screen Proc
                Push Dx                         ;Save Dx
                Push Ax                         ;Save Ax
                Mov  Dx,3Dah                    ;Status Byte Address
                Mov  Bx,Es                      ;Get Target Segment
                Mov  Ax,Ds                      ;Get Source Segment
                Cmp  Ax,Bx                      ;Is Source Larger?
                Jna  Boxdscra1                  ;Jump If Not
                Mov  Bx,Ax                      ;Else Use Source
Boxdscra1:      Cmp  Byte Ptr[Bp+16],0          ;Protect Against Snow?
                Je   Boxdscrd1                  ;Jump Ahead If Not
Boxdscrb1:      In   Al,Dx                      ;Get Status Byte
                Test Al,1                       ;Test Bit
                Jnz  Boxdscrb1                  ;Loop Till 0
                Cli                             ;Disable Interrupts
Boxdscrc1:      In   Al,Dx                      ;Get Status Byte
                Test Al,1                       ;Test Bit
                Jz   Boxdscrc1                  ;Loop Till 1
Boxdscrd1:      Movsb                           ;Move A Character
                Loop Boxdscra1                  ;Go Do Next
                Pop  Ax                         ;Restore Ax
                Pop  Dx                         ;Restore Dx
                Ret                             ;
Boxd_Screen Endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
Boxl_Screen Proc
                Push Dx                         ;Save Dx
                Push Ax                         ;Save Ax Too
                Mov  Dx,Es                      ;Get Target Segment
                Mov  Ax,Ds                      ;Get Source Segment
                Cmp  Ax,Dx                      ;Is Source Larger?
                Jna  Boxlscra1                  ;Jump If Not
                Mov  Dx,Ax                      ;Else Use Source
Boxlscra1:      Cmp  Byte Ptr[Bp+16],0          ;Protect Against Snow?
                Je   Boxlscrf1                  ;Jump Ahead If Not
                Mov  Dx,3Dah                    ;Status Byte Address
Boxlscrb1:      In   Al,Dx                      ;Get Status Byte
                Test Al,1                       ;Test Bit
                Jnz  Boxlscrb1                  ;Loop Till 0
                Cli                             ;Disable Interrupts
Boxlscrc1:      In   Al,Dx                      ;Get Status Byte
                Test Al,1                       ;Test Bit
                Jz   Boxlscrc1                  ;Loop Till 1
                Movsb                           ;Write A Char
Boxlscrd1:      In   Al,Dx                      ;Get Status Byte
                Test Al,1                       ;Test Bit
                Jnz  Boxlscrd1                  ;Loop Till 0
Boxlscre1:      In   Al,Dx                      ;Get Status Byte
                Test Al,1                       ;Test Bit
                Jz   Boxlscre1                  ;Loop Till 1
                Movsb                           ;Write A Char
                Jmp  Short Boxlscrg1            ;Jump Ahead And Quit
Boxlscrf1:      Movsw                           ;Move The Character
Boxlscrg1:      Pop  Ax                         ;Restore Ax
                Pop  Dx                         ;Restore Dx
                Ret                             ;
Boxl_Screen Endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
Boxr_Screen Proc
                Push Dx                         ;Save Dx
                Push Bx                         ;Save Bx
                Push Ax                         ;Save Ax
                Mov  Dx,Es                      ;Get Target Segment
                Mov  Ax,Ds                      ;Get Source Segment
                Cmp  Ax,Dx                      ;Is Source Larger?
                Jna  Boxriscra1                 ;Jump If Not
                Mov  Dx,Ax                      ;Else Use Source
Boxriscra1:     Cmp  Bl,0                       ;Protect Against Snow?
                Je   Boxriscrf1                 ;Jump Ahead If Not
                Mov  Dx,3Dah                    ;Status Byte Address
Boxriscrb1:     In   Al,Dx                      ;Get Status Byte
                Test Al,1                       ;Test Bit
                Jnz  Boxriscrb1                 ;Loop Till 0
Boxriscrc1:     In   Al,Dx                      ;Get Status Byte
                Test Al,1                       ;Test Bit
                Jz   Boxriscrc1                 ;Loop Till 1
                Movsb                           ;Move A Character
Boxriscrd1:     In   Al,Dx                      ;Get Status Byte
                Test Al,1                       ;Test Bit
                Jnz  Boxriscrd1                 ;Loop Till 0
Boxriscre1:     In   Al,Dx                      ;Get Status Byte
                Test Al,1                       ;Test Bit
                Jz   Boxriscre1                 ;Loop Till 1
                Movsb                           ;Move A Character
                Jmp  Short Boxriscrg1           ;Jump Ahead And Quit
Boxriscrf1:     Movsw                           ;Move The Character
Boxriscrg1:     Pop  Ax                         ;Restore Ax
                Pop  Bx                         ;Restore Bx
                Pop  Dx                         ;Restore Dx
                Ret                             ;
Boxr_Screen Endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
Boxu_Screen  Proc
                Push Dx                         ;Save Dx
                Push Ax                         ;Save Ax
                Mov  Dx,3Dah                    ;Status Byte Address
                Mov  Bx,Es                      ;Get Target Segment
                Mov  Ax,Ds                      ;Get Source Segment
                Cmp  Ax,Bx                      ;Is Source Larger?
                Jna  Boxuscra1                  ;Jump If Not
                Mov  Bx,Ax                      ;Else Use Source
Boxuscra1:      Cmp  Byte Ptr[Bp+16],0          ;Protect Against Snow?
                Je   Boxuscrd1                  ;Jump Ahead If Not
Boxuscrb1:      In   Al,Dx                      ;Get Status Byte
                Test Al,1                       ;Test Bit
                Jnz  Boxuscrb1                  ;Loop Till 0
                Cli                             ;Disable Interrupts
Boxuscrc1:      In   Al,Dx                      ;Get Status Byte
                Test Al,1                       ;Test Bit
                Jz   Boxuscrc1                  ;Loop Till 1
Boxuscrd1:      Movsb                           ;Move A Character
                Loop Boxuscra1                  ;Go Do Next
                Pop  Ax                         ;Restore Ax
                Pop  Dx                         ;Restore Dx
                Ret                             ;
Boxu_Screen  Endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
Drawb_Screen Proc                               ;Procedures Writes Char,
                Push Dx                         ;Fix Snow
                Push Bx                         ;Save Dx And Bx
                Cld                             ;Set Direction Flag
                Cmp  Snow_Check,0               ;Protect Against Snow?
                Je   Dboxscrc1                  ;Jump Ahead If Not
                Mov  Dx,3Dah                    ;Status Byte Address
                Mov  Bx,Ax                      ;Store Ax Contents
Dboxscra1:      In   Al,Dx                      ;Get Status Byte
                Test Al,1                       ;Test Bit
                Jnz  Dboxscra1                  ;Loop Till 0
                Cli                             ;Disable Interrupts
Dboxscrb1:      In   Al,Dx                      ;Get Status Byte
                Test Al,1                       ;Test Bit
                Jz   Dboxscrb1                  ;Loop Till 1
                Mov  Ax,Bx                      ;Restore Ax Contents
Dboxscrc1:      Stosw                           ;Write The Character
                Dec  Di                         ;Pull Ptr Back
                Dec  Di                         ;Again
                Pop  Bx                         ;Restore Bx
                Pop  Dx                         ;Restore Dx And Return
                Ret
Drawb_Screen    Endp


Code Ends

End


