{$F+} { Compiler Directive: Generate far procedure calls: On }
{$O+} { Compiler Directive: Generate overlay code: On }

(*****************************************************************************

  Text demonstration 2
    Version 1.01

  This unit is designed to go with TextDemo.

  Copyright 1994, all rights reserved.
    P. A. R. Renaud

  Compiler:
    Turbo Pascal versions 5.0 to 6.0

  Versions
    1.01 - Corrected to work with the improved pointer unit.

  System:
    MS-DOS, MDOS

*****************************************************************************)

Unit TDemo2;

  Interface

    Uses
      CRT,
      DOS,
      Core,
      Menu,
      Pick,
      Editor,
      Windows,
      KeyBoard,
      TextLink,
      TextLine,
      TextEdit,
      Indicators,
      TextCorrect,
      String_Utilities;

    Var
     { Used to save the default message attributes }
      Save_Message_Normal,
      Save_Message_HighLight: Byte;
     { Used to signal which way the exit process is going to work. }
      Exit_Character: Char;
     { Used to assign the window interface for the pointer. }
      Extra_Interface: Procedure;

(***********************************************************

  Procedure: Function key help.
    This procedure displays the help screen for the function
    key code.

***********************************************************)

    Procedure Function_Key_Help( Width: Byte );

(***********************************************************

  Procedure: Alter global variables.
    This procedure allows the user to alter the global text
    editing operation variables.

***********************************************************)

    Procedure Alter_Global_Variables;

(***********************************************************

  Function: Display bar menu.
    This function calls up the main bar menu so that the
    user can select one of the functions.

***********************************************************)

    Procedure Display_Bar_Menu( Var Command: Byte; Var Character: Char );

(*************************************************

  Procedure: Main system.
    This procedure allows the user to use the main
    menu and system.

*************************************************)

    Procedure Main_System;

{----------------------------------------------------------------------------}

  Implementation

    Var
     { Hold the old help procedure. }
      Old_Help: Procedure;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Pick file name.
    This procedure offers the user with a list of
    files in a menu from which to choose the file
    name for the operation.  If it is out of
     memory, it uses the old routine.

*************************************************)

    Procedure Pick_File_Name( Width, Height, BackGround: Byte; The_Label: String; Var Data: String );
      Var
        Okay: Boolean;
        Center_Row,
        Center_Column: Byte;
      Begin
        Center_Row := Height div 2;
        Center_Column := Width div 2;
        Okay := Open_Window( Frame_1, Window_Pop, Center_Column - 13, Center_Row - 7, Center_Column + 13, Center_Row + 7,
                             Black_Character + Background );
        If Okay
          then
            Begin
              Label_Window( White_Character + Background, The_Label );
              Extra_Interface;
            End
          else
            ClrScr;
        Data := Pick_File( '' );
        If Okay
          then
             Close_Window( Window_Pop );
        If not Pick_Okay
          then
            Get_File_Name_Default( Data );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get file name.
    This procedure allows the user to enter a file
    name.

*************************************************)

    Procedure Get_File_Name( Width, Height, BackGround: Byte; The_Label: String; Var Data: String );
      Var
        Okay: Boolean;
        Center_Row,
        Center_Column: Byte;
      Begin
        Center_Row := Height div 2;
        Center_Column := Width div 2;
        Okay := Open_Window( Frame_2, Window_Down, Center_Column - 25, Center_Row - 5, Center_Column + 25, Center_Row + 5,
                             Red_Character + Background );
        If Okay
          then
            Label_Window( Red_Character + Background, The_Label )
          else
            ClrScr;
        Write( Screen, 'Please enter the file name.' );
        Data := '            ';
        Get_String( 2, 1, Data );
        While ( Data[ 1 ] = ' ' ) and ( Length( Data ) > 0 ) do
          Delete( Data, 1, 1 );
        If Okay
          then
            Close_Window( Window_Pop );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get read file name new.
    This procedure allows the user to pick a file
    name for the read block function.

*************************************************)

    Procedure Get_Read_File_Name_New( Var Data: String ); Far;
      Var
        Width,
        Height: Byte;
      Begin
        Width := Pred( Right_Of_Window^ - Left_Of_Window^ );
        Height := ( Bottom_Of_Window^ - Top_Of_Window^ );
        Pick_File_Name( Width, Height, Green_BackGround, 'Read Block', Data )
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get write file name new.
    This procedure allows the user to pick a file
    name for the write block function. If the user
    presses escape, a screen which allows creating
    a new file name is displayed.

*************************************************)

    Procedure Get_Write_File_Name_New( Var Data: String ); Far;
      Var
        Width,
        Height: Byte;
      Begin
        Width := Pred( Right_Of_Window^ - Left_Of_Window^ );
        Height := ( Bottom_Of_Window^ - Top_Of_Window^ );
        Pick_File_Name( Width, Height, Blue_BackGround, 'Write Block', Data );
        If ( Data = '' )
          then
            Get_File_Name( Width, Height, White_BackGround, 'Write Block', Data );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Wait for key.
    This procedure displays a message on the
    screen and waits for the user to press Enter.

*************************************************)

    Procedure Wait_For_Key( BackGround_Color: Byte );
      Begin
        Message_Normal := Cyan_Character + BackGround_Color;
        Message_HighLight := White_Character + BackGround_Color;
        Pause_For_Key;
        Message_Normal := Save_Message_Normal;
        Message_HighLight := Save_Message_HighLight;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Write search failure new.
    This procedure writes the failure screen when
    the search fails to find something.

*************************************************)

    Procedure Write_Search_Failure_New; Far;
      Begin
        If Open_Window( Frame_3, Window_Pop, 1, 1, 40, 7, White_Character + Red_BackGround )
          then
            Begin
              Label_Window( Red_Character + White_Background, 'Search' );
              TextAttr := Flashing + White_Character + Red_BackGround;
              WriteLn( Screen );
              WriteLn( Screen, ' Search failure!' );
              WriteLn( Screen );
              Write( Screen, ' ' );
              Wait_For_Key( Red_BackGround );
              Close_Window( Window_Pop );
            End
          else
            Write_Search_Failure_Default;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Display screen.
    This procedure draws the main screen.

*************************************************)

    Procedure Display_Screen( Width: Byte );
      Begin
        TextAttr := White_Character + Red_BackGround;
        ClrScr;
        WriteLn( Screen, Expand( '-', Width ) );
        WriteLn( Screen, Center( ' Text editor demonstration program ', Width, ' ' ) );
        WriteLn( Screen, Expand( '-', Width ) );
        Write( Screen, Center( 'By P. Renaud', Width, ' ' ) );
        WriteLn( Screen, Center( 'CopyRight 1994, all rights reserved.', Width, ' ' ) );
        WriteLn( Screen );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Get name.
    This function allows the user to select a
    file name from the existing ones, otherwise
    the user is allowed to enter a file name.

*************************************************)

    Function Get_Name( Width, Height: Byte; Var Data: String ): Boolean;
      Var
        Count,
        Center_Row,
        Center_Column: Byte;
      Begin
        Exclude_BackUps := True;
        Pick_File_Name( Width, Height, Green_BackGround, 'Open a document', Data );
        Capitalize( Data );
        Get_Name := ( Data <> '' );
        Exclude_BackUps := False;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Find file.
    This function returns true if a file exists
    by the given name.

*************************************************)

    Function Find_File( Name: String ): Boolean;
      Var
        DirInfo: SearchRec;
      Begin
        FindFirst( Name, 0 , DirInfo );
        Find_File := ( DosError = 0 );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Get new name.
    This function allows the user to enter a name
    for a new file.  Only names that aren't used
    are allowed to be entered.  If it fails, or
    escape is pressed, it returns false.

*************************************************)

    Function Get_New_Name( Width, Height: Byte; Var Data: String ): Boolean;
      Var
        Count,
        Center_Row,
        Center_Column: Byte;
        Okay,
        Done: Boolean;
      Begin
        Center_Row := Height div 2;
        Center_Column := Width div 2;
        Okay := Open_Window( Frame_1, Window_Pop, Center_Column - 20, Center_Row - 2, Center_Column + 20, Center_Row + 3,
                             White_Character + Green_Background );
        If Okay
          then
            Label_Window( White_Character + Green_Background, 'Create new document' );
        TextAttr := Black_Character + Green_BackGround;
        WriteLn( Screen, 'Please enter a new file name.' );
        WriteLn( Screen );
        Write( Screen, '> ' );
        Repeat
          TextAttr := White_Character + Green_BackGround;
          ReadLn( Keys, Data );
          Done := ( Data = '' ) or ( not Find_File( Data ) );
          If ( not Done )
            then
              Begin
                TextAttr := Black_Character + Green_BackGround;
                WriteLn( Screen, 'Sorry, that name is already used.' );
                WriteLn( Screen, 'Please try again.' );
                Write( Screen, '> ' );
              End;
        Until Done;
        If Okay
          then
            Close_Window( Window_Pop );
        For Count := 1 to Length( Data ) do
          Data[ Count ] := UpCase( Data[ Count ] );
        Get_New_Name := ( Data <> '' );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Read text.
    This function is called to read in the
    document.  It returns true only if it's
    successful.

*************************************************)

    Function Read_Text( Var The_File: Text; Var All: All_Type; Width, Height: Byte ): Boolean;
      Var
        Okay: Boolean;
        Center_Row,
        Center_Column: Byte;
      Begin
        Center_Row := Height div 2;
        Center_Column := Width div 2;
        Okay := Open_Window( Frame_1, Window_Pop, Center_Column - 11, Center_Row - 2, Center_Column + 11, Center_Row + 2,
                             Black_Character + White_Background );
        If Okay
          then
            Begin
              Label_Window( White_Character + Black_BackGround, 'Reading document' );
              TextAttr := TextAttr + Flashing;
              Write( Screen, Center( 'Please wait', 20, ' ' ) );
            End
          else
            Begin
              ClrScr;
              Write( Screen, 'Please wait, while reading document.' );
            End;
        Message_Normal := Cyan_Character + White_BackGround;
        Message_HighLight := Blue_Character + White_BackGround;
        Read_Text := Read_Text_File( The_File, All );
        Message_Normal := Save_Message_Normal;
        Message_HighLight := Save_Message_HighLight;
        If Okay
          then
            Close_Window( Window_Pop );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Write text.
    This procedure takes care of making sure the
    file is being written.  If it fails, it
    generates a run-time error, otherwise it
    completes the task.

*************************************************)

    Procedure Write_Text( Var The_File: String; Var All: All_Type; Width, Height: Byte );
      Var
        Okay: Boolean;
        Where,
        Center_Row,
        Center_Column: Byte;
        Old_Text: Text;
        Old_Name: String;
      Begin
        Center_Row := Height div 2;
        Center_Column := Width div 2;
        Okay := Open_Window( Frame_1, Window_Pop, Center_Column - 17, Center_Row - 2, Center_Column + 17, Center_Row + 2,
                             Black_Character + White_Background );
        If Okay
          then
            Begin
              Label_Window( White_Character + Black_BackGround, 'Writing document' );
              TextAttr := TextAttr + Flashing;
              Write( Screen, Center( 'Please wait', 32, ' ' ) );
            End
          else
            Begin
              ClrScr;
              Write( Screen, 'Please wait, while writing document.' );
            End;
       { Find the name of the backup file. }
        Where := Pos( '.', The_File );
        If ( Where = 0 )
          then
            Old_Name := The_File + '.BAK'
          else
            Old_Name := Copy( The_File, 1, Where ) + 'BAK';
       { If the backup file exists erase it. }
        If Find_File( Old_Name )
          then
            Begin
              Assign( Old_Text, Old_Name );
              Erase( Old_Text );
            End;
       { Make the current file the backup file. }
        If Find_File( The_File )
          then
            Begin
              Assign( Old_Text, The_File );
              Rename( Old_Text, Old_Name );
            End;
       { Save the new file. }
        Message_Normal := Cyan_Character + White_BackGround;
        Message_HighLight := Blue_Character + White_BackGround;
        If ( not Write_Text_File( The_File, All ) )
          then
            RunError;
        Message_Normal := Save_Message_Normal;
        Message_HighLight := Save_Message_HighLight;
        If Okay
          then
            Close_Window( Window_Pop );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Write out.
    This procedure makes writing out parts of the
    help screen much quicker.

*************************************************)

    Procedure Write_Out( Data1, Data2: String; Width: Byte );
      Begin
        TextAttr := Message_HighLight;
        Write( Screen, Data1 );
        TextAttr := Message_Normal;
        Write( Screen, Push_To( '', Data2, Width, '.' ), Data2 );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Separator.
    This procedure helps write out parts of the
    help screen quickly.

*************************************************)

    Procedure Separator( Data: String; Width: Byte );
      Begin
        TextAttr := Message_Normal;
        WriteLn( Screen, Expand( '-', Width ) );
        TextAttr := Message_HighLight;
        WriteLn( Screen, Center( Data, Width, ' ' ) );
        TextAttr := Message_Normal;
        WriteLn( Screen, Expand( '-', Width ) );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Function key help.
    As previously defined.

*************************************************)

    Procedure Function_Key_Help( Width: Byte );
      Begin
        ClrScr;
        TextAttr := Message_HighLight;
        WriteLn( Screen, Center( 'Help Screen', Width, ' ' ) );
        Separator( 'Function keys', Width );
        Write_Out( 'F1', 'Help', 20 );
        Write_Out( '  [Shift] F1', 'Function keys', 14 );
        WriteLn( Screen );
        Write_Out( 'F2', 'Save and continue', 20 );
        Write_Out( '  [Shift] F2', 'Save and exit', 14 );
        WriteLn( Screen );
        Write_Out( 'F3', 'Continue search', 20 );
        Write_Out( '  [Shift] F3', 'Search', 14 );
        Write_Out( '  [Ctrl] F3', 'Search & Replace', 18 );
        WriteLn( Screen );
        Write_Out( 'F4', 'Print text', 20 );
        Write_Out( '  [Shift] F4', 'Print block', 14 );
        WriteLn( Screen );
        Write_Out( 'F5', 'Reform paragraph', 20 );
        Write_Out( '  [Shift] F5', 'Reform block', 14 );
        Write_Out( '  [Ctrl] F5', 'Reform text', 18 );
        WriteLn( Screen );
        Write_Out( 'F6', 'Center line', 20 );
        Write_Out( '  [Shift] F6', 'Set < margin', 14 );
        Write_Out( '  [Ctrl] F6', 'Set > margin', 18 );
        WriteLn( Screen );
        Write_Out( 'F7', 'Set block start', 20 );
        Write_Out( '  [Shift] F7', 'Goto block start', 18 );
        WriteLn( Screen );
        Write_Out( 'F8', 'Set block finish', 20 );
        Write_Out( '  [Shift] F8', 'Goto block finish', 18 );
        WriteLn( Screen );
        Write_Out( 'F9', 'Show location', 20 );
        Write_Out( '  [Shift] F9', 'Goto line', 14 );
        WriteLn( Screen );
        Write_Out( 'F10', 'Menu', 19 );
        WriteLn( Screen );
        WriteLn( Screen );
        Pause_For_Key;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Help new.
    This procedure appends the new function keys
    onto the help routine.  Plus it shows the
    function key help screen as well.

*************************************************)

    Procedure Help_New; Far;
      Var
        Width: Byte;
      Begin
        Width := Pred( Right_Of_Window^ - Left_Of_Window^ );
        { Add new help code here! }
        Old_Help;
        Function_Key_Help( Width );
        ClrScr;
        TextAttr := Message_HighLight;
        WriteLn( Screen, Center( 'Help Screen', Width, ' ' ) );
        Separator( 'Exiting commands', Width );
        TextAttr := Message_Normal;
        Write( Screen, Push_To( 'Exit editor', '^KQ', 37, '.' ) );
        TextAttr := Message_HighLight;
        WriteLn( Screen, '^KQ' );
        TextAttr := Message_Normal;
        Write( Screen, Push_To( 'Save file and exit', '^KD', 37, '.' ) );
        TextAttr := Message_HighLight;
        WriteLn( Screen, '^KD' );
        TextAttr := Message_Normal;
        Write( Screen, Push_To( 'Save file and continue', '^JS', 37, '.' ) );
        TextAttr := Message_HighLight;
        WriteLn( Screen, '^JS' );
        Separator( 'Option commands', Width );
        TextAttr := Message_Normal;
        Write( Screen, Push_To( 'Alter editor environment', '^JA', 37, '.' ) );
        TextAttr := Message_HighLight;
        WriteLn( Screen, '^JA' );
        WriteLn( Screen );
        Pause_For_Key;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Verify save.
    This function prompts the user to verify the
    saving of the file.  It returns true if the
    user wishes to save the document, false if
    not.  Done is set to true if the user pressed
    escape.

*************************************************)

    Function Verify_Save( Width, Height: Byte; Var Done: Boolean ): Boolean;
      Var
        Okay: Boolean;
        Selection,
        Center_Row,
        Center_Column: Byte;
        The_Menu: Bar_Menu_Type;
      Begin
        Center_Row := Height div 2;
        Center_Column := Width div 2;
        Okay := Open_Window( Frame_1, Window_Pop, Center_Column - 20, Center_Row - 3, Center_Column + 20, Center_Row + 3,
                             White_Character + Blue_Background );
        If Okay
          then
            Begin
              Label_Window( Blue_Character + White_BackGround, 'Document' );
              TextAttr := White_Character + Blue_BackGround;
              ClrScr;
              WriteLn( Screen );
              WriteLn( Screen, Center( 'Should this document be saved?', 38, ' ' ) );
            End
          else
            Begin
              ClrScr;
              WriteLn( Screen, 'Should this document be saved?' );
            End;
        WriteLn( Screen );
        Initialize_Bar_Menu( The_Menu, '                Yes   No' );
        Repeat
          Offer_Bar_Menu( The_Menu, Selection );
        Until ( Menu.Command in [ Enter_Key, Escape_Key ] );
        Verify_Save := ( Selection = 1 );
        Done := ( Selection <> 0 );
        If Okay
          then
            Close_Window( Window_Pop );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Verify exit.
    This function prompts the user to verify the
    abandoning of the file.  It returns true if the
    user wishes to abandon the document, false if
    not or escape is pressed.

*************************************************)

    Function Verify_Exit( Width, Height: Byte ): Boolean;
      Var
        Okay: Boolean;
        Selection,
        Center_Row,
        Center_Column: Byte;
        The_Menu: Bar_Menu_Type;
      Begin
        Center_Row := Height div 2;
        Center_Column := Width div 2;
        Okay := Open_Window( Frame_1, Window_Pop, Center_Column - 20, Center_Row - 2, Center_Column + 20, Center_Row + 2,
                             White_Character + Blue_Background );
        If Okay
          then
            Begin
              Label_Window( Blue_Character + White_BackGround, 'Document' );
              TextAttr := White_Character + Blue_BackGround;
              ClrScr;
              WriteLn( Screen );
              WriteLn( Screen, Center( 'Abandon this document?', 38, ' ' ) );
            End
          else
            Begin
              ClrScr;
              WriteLn( Screen, 'Abandon this document?' );
            End;
        WriteLn( Screen );
        Initialize_Bar_Menu( The_Menu, '                Yes   No' );
        Repeat
          Offer_Bar_Menu( The_Menu, Selection );
        Until ( Menu.Command in [ Enter_Key, Escape_Key ] );
        Verify_Exit := ( Selection = 1 );
        If Okay
          then
            Close_Window( Window_Pop );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Edit the text.
    This procedure allows the user to edit an
    existing file and save it afterwards.

*************************************************)

    Procedure Edit_The_Text( Width, Height: Byte );
      Var
        Data: String;
        InFile: Text;
        Done,
        Okay,
        Changed: Boolean;
        The_Text: ^All_Type;
      Begin
       { Allocate and initialize the data structure to hold the text. }
        New( The_Text );
        If ( The_Text <> Nil )
          then
            Begin
              Initialize_The_Text( The_Text^ );
             { Get the name for the file. }
              If Get_Name( Width, Height, Data )
                then
                  If Find_File( Data )
                    then
                      Begin
                       { Open the file }
                        Assign( InFile, Data );
                        Reset( InFile );
                       { Read the file into the text structure and edit it. }
                        If Read_Text( InFile, The_Text^, Width, Height )
                          then
                            Repeat
                             { Edit the text structure. }
                              Exit_Character := ' ';
                              Edit_Text( The_Text^, Changed );
                              Close( InFile );
                              Case Exit_Character of
                                'C': Begin
                                       Write_Text( Data, The_Text^, Width, Height );
                                       Reset( InFile );
                                     End;
                                'S': Write_Text( Data, The_Text^, Width, Height );
                                ' ': If Changed
                                       then
                                         Begin
                                           If Verify_Save( Width, Height, Done )
                                             then
                                               Write_Text( Data, The_Text^, Width, Height )
                                             else
                                               If ( not Done )
                                                 then
                                                   Begin
                                                     Exit_Character := 'R';
                                                     Reset( InFile );
                                                   End
                                         End
                                       else
                                         If not Verify_Exit( Width, Height )
                                           then
                                             Begin
                                               Exit_Character := 'R';
                                               Reset( InFile );
                                             End;
                              End; { Case }
                            Until ( Exit_Character in [ ' ', 'S' ] );
                      End
                    else
                      Write_Error( 2 );
              Dispose( The_Text );
            End
          else
            Write_Error( 600 );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Create text.
    This procedure allows the user to create a new
    document and save it afterwards.

*************************************************)

    Procedure Create_Text( Width, Height: Byte );
      Var
        Data: String;
        Done,
        Changed: Boolean;
        The_Text: ^All_Type;
      Begin
       { Allocate and initialize the data structure to hold the text. }
        New( The_Text );
        If ( The_Text <> Nil )
          then
            Begin
              Initialize_The_Text( The_Text^ );
             { Get the name for the file. }
              If Get_New_Name( Width, Height, Data )
                then
                  Repeat
                   { Edit the text structure. }
                    Exit_Character := ' ';
                    Edit_Text( The_Text^, Changed );
                    Case Exit_Character of
                      'C', 'S': Write_Text( Data, The_Text^, Width, Height );
                      ' ': If Changed
                             then
                               If Verify_Save( Width, Height, Done )
                                 then
                                   Write_Text( Data, The_Text^, Width, Height )
                                 else
                                   If ( not Done )
                                     then
                                       Exit_Character := 'R';
                    End; { Case }
                  Until ( Exit_Character in [ ' ', 'S' ] );
              Dispose( The_Text );
            End
          else
            Write_Error( 600 );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Alter global variables.
    As previously defined.

*************************************************)

    Procedure Alter_Global_Variables;
      Var
        Width,
        Save_Row,
        Save_Column: Byte;
        Value: Char;
        Temporary: String;
      Begin
        TextAttr := Message_Normal;
        ClrScr;
        Width := Pred( Right_Of_Window^ - Left_Of_Window^ );
        Separator( 'Environmental options', Width );
        WriteLn( Screen );
        TextAttr := Message_HighLight;
        WriteLn( Screen, 'Please press appropriate number.' );
        Repeat
          Cursor_Row := 6;
          GotoXY( 1, Succ( Cursor_Row ) );
          Case Insert_Tab of
            True: Temporary := 'Inserts spaces in insert mode';
            False: Temporary := 'Skips spaces in insert mode';
          End; { Case }
          TextAttr := Message_HighLight;
          Write( Screen, ' 1 ' );
          TextAttr := Message_Normal;
          Write( Screen, Push_To( 'Tab key', Temporary, 50, '.' ) );
          TextAttr := Message_HighLight;
          WriteLn( Screen, Temporary );
          Case Insert_At_EoLn of
            True: Temporary := 'Add characters to end of line';
            False: Temporary := 'Stops at end of line';
          End; { Case }
          Write( Screen, ' 2 ' );
          TextAttr := Message_Normal;
          Write( Screen, Push_To( 'Insert mode', Temporary, 50, '.' ) );
          TextAttr := Message_HighLight;
          WriteLn( Screen, Temporary );
          Case Automatic_Return of
            True: Temporary := 'Cursor moves to next line';
            False: Temporary := 'Cursor stays on the same line';
          End; { Case }
          Write( Screen, ' 3 ' );
          TextAttr := Message_Normal;
          Write( Screen, Push_To( 'At end of line', Temporary, 50, '.' ) );
          TextAttr := Message_HighLight;
          WriteLn( Screen, Temporary );
          Case Automatic_Paragraph_Reform of
            True: Temporary := 'Automatic word wrapping';
            False: Temporary := 'Insert extends lines';
          End; { Case }
          Write( Screen, ' 4 ' );
          TextAttr := Message_Normal;
          Write( Screen, Push_To( 'Entry mode', Temporary, 50, '.' ) );
          TextAttr := Message_HighLight;
          WriteLn( Screen, Temporary );
          Str( Tab_Amount:3, Temporary );
          Write( Screen, ' 5 ' );
          TextAttr := Message_Normal;
          Write( Screen, Push_To( 'Tab spacing', Temporary, 50, '.' ) );
          TextAttr := Message_HighLight;
          Save_Row := WhereY;
          Save_Column := Pred( WhereX );
          WriteLn( Screen, Temporary );
          Case Space_Right of
            True: Temporary := 'Moves past end of line';
            False: Temporary := 'Stays at end of line';
          End; { Case }
          Write( Screen, ' 6 ' );
          TextAttr := Message_Normal;
          Write( Screen, Push_To( 'Right arrow', Temporary, 50, '.' ) );
          TextAttr := Message_HighLight;
          WriteLn( Screen, Temporary );
          TextAttr := Message_Normal;
          WriteLn( Screen );
          Write( Screen, 'Press ' );
          TextAttr := Message_HighLight;
          Write( Screen, 'Escape' );
          TextAttr := Message_Normal;
          WriteLn( Screen, ' to exit' );
          Repeat
            Get_Command( Value, Command );
          Until ( Command in [ Press_Numbers, Press_Escape, Pointer_Down ] );
          If ( Command = Pointer_Down )
            then
              Begin
                Case Adjust_Amount of
                  1: Value := '1';
                  2: Value := '2';
                  3: Value := '3';
                  4: Value := '4';
                  5: Value := '5';
                  6: Value := '6';
                  else Value := '0';
                End; { Case }
                Delay( 200 );
              End;
          Case Value of
            '1': Insert_Tab := not Insert_Tab;
            '2': Insert_At_EoLn := not Insert_At_EoLn;
            '3': Automatic_Return := not Automatic_Return;
            '4': Automatic_Paragraph_Reform := not Automatic_Paragraph_Reform;
            '5': Edit_Byte( Save_Row, Save_Column, Tab_Amount );
            '6': Space_Right := not Space_Right;
          End; { Case }
        Until ( Command = Press_Escape );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: About screen.
    This procedure displays the screen holding
    information on the program.

*************************************************)

    Procedure About_Screen( Width: Byte );
      Var
        Okay: Boolean;
        Center_Column: Byte;
      Begin
        Center_Column := Width div 2;
        Okay := Open_Window( Frame_1, Window_Pop, Center_Column - 20, 5, Center_Column + 20, 18,
                             White_Character + Yellow_Background );
        If Okay
          then
            Label_Window( TextAttr, ' About ' );
        WriteLn( Screen );
        TextAttr := Blue_Character + Yellow_BackGround;
        WriteLn( Screen, Center( 'Text editor demo', Width - 40, ' ' ) );
        WriteLn( Screen );
        TextAttr := Cyan_Character + Yellow_BackGround;
        WriteLn( Screen, Center( 'Version 1.0', Width - 40, ' ' ) );
        WriteLn( Screen );
        TextAttr := Red_Character + Yellow_BackGround;
        WriteLn( Screen, Center( 'CopyRight 1994, all rights reserved', Width - 40, ' ' ) );
        WriteLn( Screen );
        TextAttr := Cyan_Character + Yellow_BackGround;
        WriteLn( Screen, Center( 'by Paul Renaud', Width - 40, ' ' ) );
        WriteLn( Screen );
        Write( Screen, '       ' );
        Wait_For_Key( Yellow_BackGround );
        If Okay
          then
            Close_Window( Window_Pop );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Write error new.
    This procedure is called when an error occurs
    in the editor to write the error and allow the
    program to continue.

*************************************************)

    Procedure Write_Error_New( Code: Word ); Far;
      Begin
        If Open_Window( Frame_3, Window_Pop, 20, 5, 60, 10, White_Character + Red_Background )
          then
            Begin
              Label_Window( Red_Character + White_Background, ' Error! ' );
              TextAttr := Flashing + White_Character + Red_Background;
              WriteLn( Screen, ' Operation failure error!' );
              WriteLn( Screen, ' Error code: ', Code:5 );
              Wait_For_Key( Red_BackGround );
              Close_Window( Window_Pop );
            End
          else
            Write_Search_Failure_Default;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Confirm changes new.
    This procedure is called to confirm that the
    changes were made during a search and replace
    operation.

*************************************************)

    Procedure Confirm_Changes_New( Amount: Word ); Far;
      Begin
        If Open_Window( Frame_1, Window_Pop, 1, 1, 30, 7, White_Character + Blue_Background )
          then
            Begin
              Label_Window( White_Character + Blue_BackGround, 'Changes complete' );
              WriteLn( Screen );
              WriteLn( Screen, ' ', Amount, ' items were altered.' );
              WriteLn( Screen );
              Write( Screen, ' ' );
              Wait_For_Key( Blue_BackGround );
              Close_Window( Window_Pop );
            End
          else
            Confirm_Changes_Default( Amount );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Display file menu.
    This function calls up the file menu so that
    the user can select one of the functions.

*************************************************)

    Function Display_File_Menu( Var Command: Byte; Var Character: Char ): Boolean;
      Var
        Result: Word;
        Menu_Okay,
        Window_Okay: Boolean;
        Box_Menu: Box_Menu_Type;
      Begin
        Initialize_Box_Menu( Box_Menu );
        Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Save', 1 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Save & Quit', 2 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Merge...', 3 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bar_Bottom_Box_Menu( Box_Menu, 3 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Exit...', 4 );
        Window_Okay := Open_Window( Frame_6, Window_Down, 2, 2, 22, 8, White_Character + Green_Background );
        Display_File_Menu := True;
        If Menu_Okay
          then
            Begin
              Offer_Box_Menu( Box_Menu, Result );
              Case Result of
                0: Display_File_Menu := False;
                1: Begin { Save }
                     Command := Press_Control_J;
                     Character := 'S';
                   End;
                2: Begin { Save and exit }
                     Command := Press_Control_K;
                     Character := 'D';
                   End;
                3: Command := Press_Read_Block; { Merge }
                4: Command := Press_Escape;
              End; { Case }
            End;
        If Window_Okay
          then
            Close_Window( Window_Up );
        Dispose_Box_Menu( Box_Menu );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Display edit menu.
    This function calls up the edit menu so that
    the user can select one of the functions.

*************************************************)

    Function Display_Edit_Menu( Var Command: Byte; Var Character: Char ): Boolean;
      Var
        Result: Word;
        Menu_Okay,
        Window_Okay: Boolean;
        Box_Menu: Box_Menu_Type;
      Begin
        Initialize_Box_Menu( Box_Menu );
        Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Restore line', 1 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bar_Bottom_Box_Menu( Box_Menu, 3 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Delete block', 2 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Copy block', 3 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Move block', 4 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Read block...', 5 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Write block...', 6 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bar_Bottom_Box_Menu( Box_Menu, 3 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Center text', 7 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Reform paragraph', 8 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Reform block', 9 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Reform text', 10 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bar_Bottom_Box_Menu( Box_Menu, 3 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Set left margin', 11 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Set right margin', 12 );
        Window_Okay := Open_Window( Frame_6, Window_Down, 8, 2, 28, 18, White_Character + Green_Background );
        Display_Edit_Menu := True;
        If Menu_Okay
          then
            Begin
              Offer_Box_Menu( Box_Menu, Result );
              Case Result of
                0: Display_Edit_Menu := False;
                1: Command := Press_Restore_Line;  { Restore line }
                2: Command := Press_Delete_Block;  { Delete block }
                3: Command := Press_Copy_Block;    { Copy block }
                4: Command := Press_Move_Block;    { Move block }
                5: Command := Press_Read_Block;    { Read block }
                6: Command := Press_Write_Block;   { Write block }
                7: Command := Press_Center_Text;   { Center text }
                8: Command := Press_Control_B;     { Reform paragraph }
                9: Begin                           { Reform block }
                     Command := Press_Control_J;
                     Character := 'K';
                   End;
                10: Begin                          { Reform text }
                      Command := Press_Control_J;
                      Character := 'Q';
                    End;
                11: Command := Press_Left_Margin;  { Left margin }
                12: Command := Press_Right_Margin; { Right margin }
              End; { Case }
            End;
        If Window_Okay
          then
            Close_Window( Window_Up );
        Dispose_Box_Menu( Box_Menu );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Display correct menu.
    This function calls up the correct menu so
    that the user can select one of the functions.

*************************************************)

    Function Display_Correct_Menu( Var Command: Byte; Var Character: Char ): Boolean;
      Var
        Result: Word;
        Menu_Okay,
        Window_Okay: Boolean;
        Box_Menu: Box_Menu_Type;
      Begin
        Initialize_Box_Menu( Box_Menu );
        Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Check line', 1 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Check block', 2 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Check all', 3 );
        Window_Okay := Open_Window( Frame_6, Window_Down, 15, 7, 35, 11, White_Character + Blue_Background );
        Display_Correct_Menu := True;
        If Menu_Okay
          then
            Begin
              Offer_Box_Menu( Box_Menu, Result );
              Case Result of
                0: Display_Correct_Menu := False;
                1: Begin { Line }
                     Command := Press_Control_Q;
                     Character := 'W';
                   End;
                2: Begin { Block }
                     Command := Press_Control_K;
                     Character := 'L';
                   End;
                3: Begin { Text }
                     Command := Press_Control_Q;
                     Character := 'L';
                   End;
              End; { Case }
            End;
        If Window_Okay
          then
            Close_Window( Window_Up );
        Dispose_Box_Menu( Box_Menu );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Display search menu.
    This function calls up the search menu so that
    the user can select one of the functions.

*************************************************)

    Function Display_Search_Menu( Var Command: Byte; Var Character: Char ): Boolean;
      Var
        Result: Word;
        Done,
        Menu_Okay,
        Window_Okay: Boolean;
        Box_Menu: Box_Menu_Type;
      Begin
        Initialize_Box_Menu( Box_Menu );
        Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Find...', 1 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Find & Replace...', 2 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Find next', 3 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Check spelling '#16, 4 );
        Window_Okay := Open_Window( Frame_6, Window_Down, 14, 2, 34, 7, White_Character + Green_Background );
        Display_Search_Menu := True;
        If Menu_Okay
          then
            Repeat
              Done := True;
              Offer_Box_Menu( Box_Menu, Result );
              Case Result of
                0: Display_Search_Menu := False;
                1: Command := Press_Search;
                2: Command := Press_Replace;
                3: Command := Press_Control_L;
                4: Done := Display_Correct_Menu( Command, Character );
              End; { Case }
            Until Done;
        If Window_Okay
          then
            Close_Window( Window_Up );
        Dispose_Box_Menu( Box_Menu );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Display print menu.
    This function calls up the print menu so that
    the user can select one of the functions.

*************************************************)

    Function Display_Print_Menu( Var Command: Byte; Var Character: Char ): Boolean;
      Var
        Result: Word;
        Done,
        Menu_Okay,
        Window_Okay: Boolean;
        Box_Menu: Box_Menu_Type;
      Begin
        Initialize_Box_Menu( Box_Menu );
        Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Print block', 1 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Print text', 2 );
        Window_Okay := Open_Window( Frame_6, Window_Down, 22, 2, 42, 5, White_Character + Green_Background );
        Display_Print_Menu := True;
        If Menu_Okay
          then
            Repeat
              Done := True;
              Offer_Box_Menu( Box_Menu, Result );
              Case Result of
                0: Display_Print_Menu := False;
                1: Command := Press_Print_Block;
                2: Begin
                     Command := Press_Control_J;
                     Character := 'P';
                   End;
              End; { Case }
            Until Done;
        If Window_Okay
          then
            Close_Window( Window_Up );
        Dispose_Box_Menu( Box_Menu );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Alter color.
    This function allows the user to alter the
    color attribute.

*************************************************)

    Procedure Alter_Color( Var Color: Byte; Data: String );
      Var
        Window_Okay: Boolean;
      Begin
        Window_Okay := Open_Window( Frame_6, Window_Pop, 1, 1, 40, 25, White_Character + Green_Background );
        If Window_Okay
          then
            Label_Window( White_Character + Green_BackGround, Data )
          else
            Window( 1, 1, 80, 25 );
        TextAttr := White_Character + Green_BackGround;
        Change_Attribute( Normal );
        If Window_Okay
          then
            Close_Window( Window_Pop )
          else
            ClrScr;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Display color menu.
    This function calls up the color menu so that
    the user can select one of the functions.

*************************************************)

    Function Display_Color_Menu( Var Command: Byte; Var Character: Char ): Boolean;
      Var
        Result: Word;
        Done,
        Menu_Okay,
        Window_Okay: Boolean;
        Box_Menu: Box_Menu_Type;
      Begin
        Display_Color_Menu := False;
        Initialize_Box_Menu( Box_Menu );
        Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Normal text', 1 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Blocked text', 2 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Message text', 3 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Message highlight', 4 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Search highlight', 5 );
        Window_Okay := Open_Window( Frame_6, Window_Down, 30, 11, 52, 17, White_Character + Blue_Background );
        If Menu_Okay
          then
            Begin
              Done := False;
              Repeat
                Offer_Box_Menu( Box_Menu, Result );
                Case Result of
                  0: Done := True;
                  1: Alter_Color( Normal, 'Normal text' );
                  2: Alter_Color( HighLight, 'Blocked text' );
                  3: Alter_Color( Message_Normal, 'Message text' );
                  4: Alter_Color( Message_HighLight, 'Message highlight' );
                  5: Alter_Color( Search_HighLight, 'Search highlight' );
                End; { Case }
              Until Done;
            End;
        If Window_Okay
          then
            Close_Window( Window_Up );
        Dispose_Box_Menu( Box_Menu );
        Save_Message_Normal := Message_Normal;
        Save_Message_HighLight := Message_HighLight;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Display options menu.
    This function calls up the options menu so
    that the user can select one of the functions.

*************************************************)

    Function Display_Options_Menu( Var Command: Byte; Var Character: Char ): Boolean;
      Var
        Result: Word;
        Done,
        Menu_Okay,
        Window_Okay: Boolean;
        Box_Menu: Box_Menu_Type;
      Begin
        Initialize_Box_Menu( Box_Menu );
        Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Hide block marks', 1 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bar_Bottom_Box_Menu( Box_Menu, 3 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Goto line number...', 2 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Goto block top', 3 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Goto block bottom', 4 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bar_Bottom_Box_Menu( Box_Menu, 3 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Alter environment...', 5 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Alter colors '#16, 6 );
        Window_Okay := Open_Window( Frame_6, Window_Down, 29, 2, 51, 11, White_Character + Green_Background );
        Display_Options_Menu := True;
        If Menu_Okay
          then
            Repeat
              Done := True;
              Offer_Box_Menu( Box_Menu, Result );
              Case Result of
                0: Display_Options_Menu := False;
                1: Command := Press_Hide_Block;
                2: Begin
                     Command := Press_Control_J;
                     Character := 'N';
                   End;
                3: Command := Press_Move_Block_Top;
                4: Command := Press_Move_Block_End;
                5: Begin
                     Command := Press_Control_J;
                     Character := 'A';
                   End;
                6: Done := Display_Color_Menu( Command, Character );
              End; { Case }
            Until Done;
        If Window_Okay
          then
            Close_Window( Window_Up );
        Dispose_Box_Menu( Box_Menu );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Display help menu.
    This function calls up the help menu so that
    the user can select one of the functions.

*************************************************)

    Function Display_Help_Menu( Var Command: Byte; Var Character: Char ): Boolean;
      Var
        Result: Word;
        Done,
        Do_About,
        Menu_Okay,
        Window_Okay,
        Do_Functions: Boolean;
        Box_Menu: Box_Menu_Type;
      Begin
        Do_About := False;
        Do_Functions := False;
        Initialize_Box_Menu( Box_Menu );
        Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Function keys...', 1 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'Key commands...', 2 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bar_Bottom_Box_Menu( Box_Menu, 3 );
        If Menu_Okay
          then
            Menu_Okay := Insert_Bottom_Box_Menu( Box_Menu, 'About...', 3 );
        Window_Okay := Open_Window( Frame_6, Window_Down, 38, 2, 58, 7, White_Character + Green_Background );
        Display_Help_Menu := True;
        If Menu_Okay
          then
            Repeat
              Done := True;
              Offer_Box_Menu( Box_Menu, Result );
              Case Result of
                0: Display_Help_Menu := False;
                1: Do_Functions := True;
                2: Command := Press_Help;
                3: Do_About := True;
              End; { Case }
            Until Done;
        If Window_Okay
          then
            Close_Window( Window_Up );
        If Do_About
          then
            About_Screen( Pred( Right_Of_Window^ - Left_Of_Window^ ) )
          else
            If Do_Functions
              then
                Begin
                  TextAttr := White_Character + Black_BackGround;
                  Function_Key_Help( Pred( Right_Of_Window^ - Left_Of_Window^ ) );
                End;
        Dispose_Box_Menu( Box_Menu );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Display bar menu.
    As previously defined.

*************************************************)

    Procedure Display_Bar_Menu( Var Command: Byte; Var Character: Char );
      Var
        Done: Boolean;
        Save_Exit: Boolean;
        Result,
        Save_Row,
        Save_Attribute: Byte;
        Data_Character: Char;
        Main_Menu: Bar_Menu_Type;
      Begin
        Save_Exit := Exit_On_Arrows;
        Exit_On_Arrows := True;
        Save_Row := WhereY;
        Save_Attribute := TextAttr;
        Initialize_Bar_Menu( Main_Menu, 'File  Edit  Search  Print  Options  Help' );
        Menu.Command := 0;
        Case Command of
          Press_Alternate_F:
            Begin
              Menu.Command := Press_Capital_Letters;
              Data_Character := 'F';
            End;
          Press_Alternate_E:
            Begin
              Menu.Command := Press_Capital_Letters;
              Data_Character := 'E';
            End;
          Press_Alternate_S:
            Begin
              Menu.Command := Press_Capital_Letters;
              Data_Character := 'S';
            End;
          Press_Alternate_P:
            Begin
              Menu.Command := Press_Capital_Letters;
              Data_Character := 'P';
            End;
          Press_Alternate_O:
            Begin
              Menu.Command := Press_Capital_Letters;
              Data_Character := 'O';
            End;
          Press_Alternate_H:
            Begin
              Menu.Command := Press_Capital_Letters;
              Data_Character := 'H';
            End;
        End; { Case }
        Repeat
          GotoXY( 1, 1 );
          TextAttr := White_Character + Green_BackGround;
          Sensitive_Mode := True;
          Offer_Bar_Menu_Update( Main_Menu, Result, Menu.Command, Data_Character );
          Sensitive_Mode := False;
          Case Result of
            0: Done := True;
            1: Done := Display_File_Menu( Command, Character );
            2: Done := Display_Edit_Menu( Command, Character );
            3: Done := Display_Search_Menu( Command, Character );
            4: Done := Display_Print_Menu( Command, Character );
            5: Done := Display_Options_Menu( Command, Character );
            6: Done := Display_Help_Menu( Command, Character );
          End; { Case }
        Until Done;
        GotoXY( 1, Save_Row );
        TextAttr := Save_Attribute;
        Exit_On_Arrows := Save_Exit;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Offer menu.
    This procedure offers the user the main menu
    for the program.  The user can select any one
    of the given choices and the result is
    returned.

*************************************************)

    Procedure Offer_Menu( Width, Height: Byte; Var Result: Word );
      Var
        Okay: Boolean;
        Center_Row,
        Center_Column: Byte;
        Main_Menu: Box_Menu_Type;
      Begin
        Result := 0;
        Center_Row := Height div 2;
        Center_Column := Width div 2;
        If Open_Window( Frame_13, Window_Down, Center_Column - 10, Center_Row - 5, Center_Column + 10, Center_Row + 5,
                        White_Character + Black_BackGround )
          then
            Begin
              Label_Window( Black_Character + White_BackGround, 'Main Menu' );
              Initialize_Box_Menu( Main_Menu );
              Okay := Insert_Top_Box_Menu( Main_Menu, 'Open a document', 1 );
              If Okay
                then
                  Okay := Insert_Bottom_Box_Menu( Main_Menu, 'Open new document', 2 );
              If Okay
                then
                  Okay := Insert_Bar_Bottom_Box_Menu( Main_Menu, 3 );
              If Okay
                then
                  Okay := Insert_Bottom_Box_Menu( Main_Menu, 'Adjust editor', 3 );
              If Okay
                then
                  Okay := Insert_Bar_Bottom_Box_Menu( Main_Menu, 4 );
              If Okay
                then
                  Okay := Insert_Bottom_Box_Menu( Main_Menu, 'Read dictionary', 4 );
              If Okay
                then
                  Okay := Insert_Bottom_Box_Menu( Main_Menu, 'Write dictionary', 5 );
              If Okay
                then
                  Okay := Insert_Bar_Bottom_Box_Menu( Main_Menu, 4 );
              If Okay
                then
                  Okay := Insert_Bottom_Box_Menu( Main_Menu, 'Exit', 0 );
              If Okay
                then
                  Offer_Box_Menu( Main_Menu, Result );
              Dispose_Box_Menu( Main_Menu );
              Close_Window( Window_Up );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Read the dictionary.
    This function allows the user to select a file
    from which to add the words to the dictionary.

*************************************************)

    Procedure Read_The_Dictionary( Width, Height: Byte );
      Var
        Data: String;
      Begin
        Width := Pred( Right_Of_Window^ - Left_Of_Window^ );
        Height := ( Bottom_Of_Window^ - Top_Of_Window^ );
        Pick_File_Name( Width, Height, Green_BackGround, 'Read Dictionary', Data );
        If ( Data <> '' )
          then
            Read_Dictionary( Data );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Write the dictionary.
    This procedure allows the user to select a
    file to dump the dictionary to, or to write it
    to a new file.

*************************************************)

    Procedure Write_The_Dictionary( Width, Height: Byte );
      Var
        Data: String;
      Begin
        Width := Pred( Right_Of_Window^ - Left_Of_Window^ );
        Height := ( Bottom_Of_Window^ - Top_Of_Window^ );
        Pick_File_Name( Width, Height, Blue_BackGround, 'Write Block', Data );
        If ( Data = '' )
          then
            Get_File_Name( Width, Height, White_BackGround, 'Write Block', Data );
        If ( Data <> '' )
          then
            Write_Dictionary( Data );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Main system.
    As previously defined.

*************************************************)

    Procedure Main_System;
      Var
        Width,
        Height: Byte;
        Result: Word;
      Begin
        Width := Succ( Lo( WindMax ) - Lo( WindMin ) );
        Height := Succ( Hi( WindMax ) - Hi( WindMin ) );
        Repeat
          Display_Screen( Pred( Width ) );
          Offer_Menu( Width, Height, Result );
          Case Result of
            1: Edit_The_Text( Width, Height );
            2: Create_Text( Width, Height );
            3: Alter_Global_Variables;
            4: Read_The_Dictionary( Width, Height );
            5: Write_The_Dictionary( Width, Height );
          End; { Case }
        Until ( Result = 0 );
        ClrScr;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Main initialization section.
    Initialize the routine pointers to the new
    routines.

*************************************************)

    Begin
      Old_Help := Help;
      Help := Help_New;
      Write_Error := Write_Error_New;
      Confirm_Changes := Confirm_Changes_New;
      Get_Read_File_Name := Get_Read_File_Name_New;
      Get_Write_File_Name := Get_Write_File_Name_New;
      Write_Search_Failure := Write_Search_Failure_New;
      Save_Message_Normal := Message_Normal;
      Save_Message_HighLight := Message_HighLight;
      Extra_Interface := Procedure_Default;
    End.
