(*****************************************************************************

  Program:  Matrices demonstration.

  Purpose:
    This unit demonstrates the abilities of the matrices unit.

  Features:
    This unit generates a matrix and writes it out.
    Then it times itself as it tries to calculate the determinate of that
      matrix using the fast and slow methods.
    This process is repeated until escape is pressed.

  Copyright 1994, All rights reserved.
    P. Renaud.

  Compilers:
    Turbo Pascal versions 4.0 to 6.0
    Speed Pascal/2 version 1.5

  Systems:
    MS-DOS, MDOS, OS/2

*****************************************************************************)

Program Matrices_Demonstration( Input, Output );

  Uses
    Time,
    Matrices;

  Var
    Matrix: Pointer;
    Fast,
    Slow: Matrix_Number;
    Data: Char;
    Hold: Real;
    Finished: Boolean;
  Begin
    WriteLn( 'Matrices unit demonstration program.' );
    WriteLn( 'Copyright 1994, All rights reserved.' );
    WriteLn( 'by P. Renaud.' );

   { To test the program using 8087 software emulation, in the command
     processor enter the command 'Set 87=N'.  To cancel this, enter the
     command 'Set 87='. }

   {$IFNDEF VER40}
    {$IFOPT N+}
    Case Test8087 of
      0: WriteLn( 'Using 8087 software emulation.' );
      1: WriteLn( 'Using the system 8087.' );
      2: WriteLn( 'Using the system 80287.' );
      3: WriteLn( 'Using the system 80387.' );
    End; { Case }
    {$ENDIF}
   {$ENDIF}
    WriteLn;
    WriteLn( 'This program uses the Matrices unit to perform a matrix operation' );
    WriteLn( 'on a matrix.  The matrix is randomly generated and this program merely' );
    WriteLn( 'times the amount of seconds to find the determinate of that matrix using' );
    WriteLn( 'one of the two possible methods.  This will continue until the escape key' );
    WriteLn( 'is pressed.' );
    WriteLn;
    WriteLn( 'Please press [enter] to continue.' );
    ReadLn;

    Matrix := Allocate_Matrix( 7, 7 );
    Randomize;
    Repeat

      Generate_Matrix( Matrix );

      Write_Out_Matrix( Output, Matrix );

      Start_Timer;
      Fast := Determinate_Fast( Matrix );
      Hold := End_Timer;
      WriteLn( 'Fast Determinate is ', Fast );
      WriteLn( 'Amount of time necessary was ', Hold:10:2, ' seconds.' );

      Start_Timer;
      Slow := Determinate_Slow( Matrix );
      Hold := End_Timer;
      WriteLn( 'Slow Determinate is ', Slow );
      WriteLn( 'Amount of time necessary was ', Hold:10:2, ' seconds.' );

      WriteLn( 'Enter "Q" to quit, anything else to repeat.' );
      Read( Data );
      Finished := ( UpCase( Data ) = 'Q' );

    Until ( Abs( Slow - Fast ) > 1e34 ) or Finished;
    If not Finished
      then
        WriteLn( 'The results are unequal ', Fast, ' <> ', Slow );

  End.

