(*****************************************************************************

  Look
    Version 1.0b

  Purpose:
    To examine the computer system upon which the program is running.

  How it works!
    This unit test for the appropriate hardward on the computer system on
    which it runs.  It uses assembly code to test the processor and a
    special sequence of mode changes to test the video board.

  Features:
    Uses assembly language to perform some of the testing.

  Limitations:
    Has not been verified with the 80486 processor, nor the Pentium class
      processors, yet.

  Versions:
    1.0a - Added code to accomidate earlier compilers.
    1.0b - Removed assembly code from unit and put into assembler file to
           create complete compatability with compiler versions 4.0
           through 5.0.

  { Portions are provided curtesy of Intel corporation }
  The rest is copyright 1993, 1995, All rights reserved by P. Renaud.

  Compiler:
    Turbo Pascal version 4.0 and later.

  System:
    MS-DOS, MDOS

*****************************************************************************)

Unit Look;

  Interface

    Uses
      DOS;

(***********************************************************

  Function: Test processor.

    This function performs a test on the system micro-
    processor to determine which type of processor it is.
    The result is returned as a word, either an 8086,
    (includes 8088 and 80186) an 80286, an 80386, (includes
    the 80386sx) an 80486 and the 80586, ( or Pentium (R) )

***********************************************************)

    Function Test_Processor: Word;

(***********************************************************

  Function: Test video system.

    This function performs a test on the system video card
    to determine which type of video subsystem it has.  The
    result is returned in a character as...
      'H': Hercules compatable at best.
      'M': IBM - Monochrome display adaptor.
      'C': IBM - Color graphics adaptor.
      'E': IBM - Enhanced graphics adaptor.
      'G': IBM - Multi-color graphics array.
      'V': IBM - Video graphics array.
      'X': IBM - Extended graphics array?
      'P': IBM - Professional graphics controller.
      'S': Super video graphics array.
      '0': no video adaptor on the system.
      '?': Unknown.
    This test attempts to be as non-distructive as possible
    with the video system.

***********************************************************)

    Function Test_Video_System: Char;

{----------------------------------------------------------------------------}

  Implementation

{----------------------------------------------------------------------------}

  {$F+} { Please do not remove }
  {$L LookCode}
 
(*************************************************

  Function: Test processor.
    As previously defined.

*************************************************)

    Function Test_Processor: Word; External;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Get video mode.
    This function returns the current video mode
    from the BIOS.

*************************************************)

    Function Get_Video_Mode: Byte;
      Var
        The_Registers: Registers;
      Begin
        The_Registers.AH := $F;
        Intr( $10, The_Registers );
        Get_Video_Mode := The_Registers.AL;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Set video mode.
    This procedure sets the current video mode to
    the given value.

*************************************************)

    Procedure Set_Video_Mode( Mode: Byte );
      Var
        The_Registers: Registers;
      Begin
        The_Registers.AH := $0;
        The_Registers.AL := Mode;
        Intr( $10, The_Registers );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get where.
    This procedure returns the current cursor
    position from the BIOS.

*************************************************)

    Procedure Get_Where( Var Row, Column, Page: Byte );
      Var
        The_Registers: Registers;
      Begin
        The_Registers.AH := $F;
        Intr( $10, The_Registers );
        Page := The_Registers.BH;
        The_Registers.AH := $3;
        Intr( $10, The_Registers );
        Row := The_Registers.DH;
        Column := The_Registers.DL;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Set where.
    This procedure sets the current cursor
    position.

*************************************************)

    Procedure Set_Where( Row, Column, Page: Byte );
      Var
        The_Registers: Registers;
      Begin
        The_Registers.AH := $2;
        The_Registers.DH := Row;
        The_Registers.DL := Column;
        The_Registers.BH := Page;
        Intr( $10, The_Registers );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Find EGA or VGA.
    This function attempts to identify a VGA or
    greater card in a non distrutive manner.  It
    returns true only if the card supports VGA
    commands.

*************************************************)

    Function Find_EGA_or_VGA: Boolean;
      Const
        Same = $81;
      Var
        The_Registers: Registers;
      Begin
       { In this test, we try to get video configuration information }
        Find_EGA_or_VGA := True;
        The_Registers.AH := $12;
        The_Registers.BL := $10;
        The_Registers.BH := Same;
        Intr( $10, The_Registers );
        Find_EGA_or_VGA := ( The_Registers.BH <> Same );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Find SVGA.
    This function attempts to identify a super VGA
    or card in a non distrutive manner.  It
    returns true only if the card supports SVGA
    commands.

*************************************************)

    Function Find_SVGA: Boolean;
      Const
       {$IFDEF VER40}
        Test_Mode = $D0;
       {$ELSE}
        Test_Mode = ( $50 or $80 );
       {$ENDIF}
      Var
        Row,
        Page,
        Column,
        Save_Mode: Byte;
      Begin
        Save_Mode := Get_Video_Mode;
        Get_Where( Row, Column, Page );
      { In this test, we try to get video configuration information }
        Set_Video_Mode( Test_Mode );
        Find_SVGA := ( Get_Video_Mode = Test_Mode );
        If ( Save_Mode <> Get_Video_Mode )
          then
            Set_Video_Mode( Save_Mode or $80 );
        Set_Where( Row, Column, Page );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function:  Translate_Video.
    This function attempts to map the numeric
    values to the appropriate video adaptors.

*************************************************)

    Function Translate_Video( Number: Byte ): Char;
      Begin
        Case Number of
          0: Translate_Video := '0';  { none }
          1: Translate_Video := 'M';  { MDA }
          2: Translate_Video := 'C';  { CGA }
          4: Translate_Video := 'E';  { EGA with color monitor }
          5: Translate_Video := 'E';  { EGA with monochrome monitor }
          6: Translate_Video := 'P';  { PGA }
          7: Translate_Video := 'V';  { VGA with monochrome display }
          8: Translate_Video := 'V';  { VGA with color display }
          11: Translate_Video := 'G'; { MCGA with monochrome display }
          12: Translate_Video := 'G'; { MCGA with color display }
          else Translate_Video := '?'; { Unknown }
        End; { Case }
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function:  Find higher video mode.
    This function attempts to pick the better of
    the two video modes.

*************************************************)

    Function Find_Higher_Video_Mode( Mode1, Mode2: Char ): Char;
      Var
        Result: Char;
      Begin
        Result := Mode1;
        If ( Result = 'M' ) and ( Mode2 in [ 'C', 'E', 'P', 'V', 'G' ] )
          then
            Result := Mode2
          else
            If ( Result = 'C' ) and ( Mode2 in [ 'E', 'P', 'V', 'G' ] )
              then
                Result := Mode2
              else
                If ( Result = 'E' ) and ( Mode2 in [ 'P', 'V', 'G' ] )
                  then
                    Result := Mode2
                  else
                    If ( Result = 'G' ) and ( Mode2 in [ 'P', 'V' ] )
                      then
                        Result := Mode2
                      else
                        If ( Result = 'V' ) and ( Mode2 = 'P' )
                          then
                            Result := Mode2;
        If ( Result = 'V' ) and Find_SVGA
          then
            Result := 'S';
        Find_Higher_Video_Mode := Result;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Get adaptor.
    This function attempts to identify the video
    adaptors by asking the BIOS.

*************************************************)

    Function Get_Adaptor: Char;
      Var
        Value1: Char;
        Value2: Char;
        The_Registers: Registers;
      Begin
       { In this test, we try to get video configuration information }
        The_Registers.AH := $1A;
        The_Registers.AL := $0;
        The_Registers.BX := $FFFF;
        Intr( $10, The_Registers );
        If ( The_Registers.BX = $FFFF )
          then
            If Find_EGA_or_VGA
              then
                Get_Adaptor := 'E'
              else
                Case Get_Video_Mode of
                  7: { Can be HRC or MGA }
                     Get_Adaptor := 'M';
                  else Get_Adaptor := 'C';
                End { Case }
          else
            Begin
              Value1 := Translate_Video( The_Registers.BL );
              Value2 := Translate_Video( The_Registers.BH );
              If ( Value2 = '0' )
                then
                  Begin
                    If ( ( Value1 = 'V' ) and Find_SVGA )
                      then
                        Get_Adaptor := 'S'
                      else
                        Get_Adaptor := Value1
                  End
                else
                  Get_Adaptor := Find_Higher_Video_Mode( Value1, Value2 );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Test video system.
    As previously defined.

*************************************************)

    Function Test_Video_System: Char;
      Begin
        Test_Video_System := Get_Adaptor;
      End;

{----------------------------------------------------------------------------}

  End.
