(* This file was mangled by Mangler 1.40 (c) Copyright 1993-1994 by Berend de Boer *)
{ Created : 1992-09-24

Unit to provide uniformed acces to all kinds of memory. Supported are:
- Conventional memory
- XHeap
- EMS 4.0
- XMS
- Disk

Memory can be allocated up to MaxLongInt size. Memory can be divided into
chunks of up to MaxConventionalMemoryBlock size.

Use the function GetObjMemory with the memfXXXX flags to designate the
types of memory and a Size to get a memory object obeying your memfXXXX
flags.


Bugs:
- not tested of StreamRead/Write for XMS and EMS work correctly with
  different Pos. It seems ok though.

Last changes :
93-05-10  Removed XMS and EMS interfaces for DPMI
93-12-16  TConvHugeMemory's MoveTo and MoveFrom contained a bug
93-01-22  Changed MoveTo to same parameter order as recMoveTo
          The number of inserted and deleted records is now counted
94-08-16  Changed parameters of BlockRead and BlockWrite
94-09-08  Moved EMS and XMS parts to different units
}



{$IFDEF MsDos}
{$F+,O+}
{.$DEFINE XForceXMS}     { force XMS even for small allocations, you will }
                        { run out of handles with this very quickly!     }
{.$DEFINE ForceXMS}
{$ENDIF}

{$X+,R-,Q-,S-,I-}
unit ObjMemory;

interface

uses
  Objects
{$IFDEF Windows}
  , BBObject
{$ENDIF}
{$IFDEF MsDos}
  , EMS, XMS
{$ENDIF}
  ;


const
  memfConventional      = $01;
  memfConventionalLast  = memfConventional;
  memfConventionalFirst = $02;
  memfXHeap             = $04;
  memfEMS               = $08;
  memfXMS               = $10;
  memfDisk              = $20;
  memfAll               = memfConventional + memfXHeap + memfXMS + memfEMS + memfDisk;

const
  MaxConventionalMemoryBlock = 65528;


{ if a memory block is asked with a size below ConvMemLimit, we always first }
{ try to return a conventional memory block                                  }
const
  ConvMemLimit:word = 8192;


type
  PObjMemory = ^TObjMemory;
  TObjMemory = object(TObject)
    Size : longint;          {* size of memory *}
    RecSize : word;          {* record size if memory is array *}
    TotalRecords : longint;
    constructor Init(ASize : longint; ARecSize : word);
    procedure BlockRead(var f : file; BlockSize : longint);  virtual;
    procedure BlockWrite(var f : file; BlockSize : longint);  virtual;
    procedure CopyFrom(Source : PObjMemory);  virtual;
    procedure Delete(APos, ASize : longint);  virtual;
    procedure FillChar(Value : byte);
    procedure MoveFrom(const Source; Pos, ASize : longint);  virtual;
    procedure MoveTo(Pos, ASize : longint; var Dest);  virtual;
    procedure StreamRead(var S : TStream; APos, ASize : longint);  virtual;
    procedure StreamWrite(var S : TStream; APos, ASize : longint);  virtual;

  {* record methods *}
    procedure recDelete(Item : longint);  virtual;
    procedure recInsert(const Source; Item : longint);  virtual;
    procedure recMoveFrom(const Source; Item : longint);
    procedure recMoveTo(Item : longint; var Dest);
    procedure recWrite(var f : file; recCount : longint);  virtual;
  end;

{$IFDEF MsDos}
  PEMSMemory = ^TEMSMemory;
  TEMSMemory = object(TObjMemory)
    Handle : TEMSHandle;
    TotalPages : word;
    constructor Init(ASize : longint; ARecSize : word; var Result : Boolean);
    destructor Done;  virtual;
    procedure BlockRead(var f : file; BlockSize : longint);  virtual;
    procedure BlockWrite(var f : file; BlockSize : longint);  virtual;
    procedure Delete(APos, ASize : longint);  virtual;
    procedure MoveFrom(const Source; Pos, ASize : longint);  virtual;
    procedure MoveTo(Pos, ASize : longint; var Dest);  virtual;
    procedure StreamRead(var S : TStream; APos, ASize : longint);  virtual;
    procedure StreamWrite(var S : TStream; APos, ASize : longint);  virtual;
    procedure Map4Pages(var LogicalPage : word);

  {* record methods *}
    procedure recDelete(Item : longint);  virtual;
  end;
{$ENDIF}


{$IFDEF MsDos}
  PXMSMemory = ^TXMSMemory;
  TXMSMemory = object(TObjMemory)
    Handle : TXMSHandle;
    constructor Init(ASize : longint; ARecSize : word; var Result : Boolean);
    destructor Done;  virtual;
    procedure BlockRead(var f : file; BlockSize : longint);  virtual;
    procedure BlockWrite(var f : file; BlockSize : longint);  virtual;
    procedure Delete(APos, ASize : longint);  virtual;
    procedure MoveFrom(const Source; Pos, ASize : longint);  virtual;
    procedure MoveTo(Pos, ASize : longint; var Dest);  virtual;
    procedure StreamRead(var S : TStream; APos, ASize : longint);  virtual;
    procedure StreamWrite(var S : TStream; APos, ASize : longint);  virtual;

  {* record methods *}
    procedure recDelete(Item : longint);  virtual;

  private
    function  SaveByte(Pos : longint) : byte;
    procedure RestoreByte(Pos : longint; b : byte);
  end;
{$ENDIF}


  PConvMax64Memory = ^TConvMax64Memory;
  TConvMax64Memory = object(TObjMemory)
    Mem : PByteArray;
    constructor Init(ASize : longint; ARecSize : word; var Result : Boolean);
    destructor Done;  virtual;
    procedure BlockRead(var f : file; BlockSize : longint);  virtual;
    procedure BlockWrite(var f : file; BlockSize : longint);  virtual;
    procedure StreamRead(var S : TStream; APos, ASize : longint);  virtual;
    procedure StreamWrite(var S : TStream; APos, ASize : longint);  virtual;
    procedure Delete(APos, ASize : longint);  virtual;
    procedure MoveFrom(const Source; Pos, ASize : longint);  virtual;
    procedure MoveTo(Pos, ASize : longint; var Dest);  virtual;

  {* record methods *}
    procedure recDelete(Item : longint);  virtual;
    procedure recInsert(const Source; Item : longint);  virtual;
  end;


const
  MaxMemPtrs = 32;

type
  PConvHugeMemory = ^TConvHugeMemory;
  TConvHugeMemory = object(TObjMemory)
    MemSizes : array[0..MaxMemPtrs-1] of word;
    MemPtrs : array[0..MaxMemPtrs-1] of pointer;
    TotalMemPtrs : integer;
    constructor Init(ASize : longint; ARecSize : word; var Result : Boolean);
    destructor Done;  virtual;
    procedure BlockRead(var f : file; BlockSize : longint);  virtual;
    procedure BlockWrite(var f : file; BlockSize : longint);  virtual;
    procedure StreamRead(var S : TStream; APos, ASize : longint);  virtual;
    procedure StreamWrite(var S : TStream; APos, ASize : longint);  virtual;
    procedure Delete(APos, ASize : longint);  virtual;
    procedure MoveFrom(const Source; Pos, ASize : longint);  virtual;
    procedure MoveTo(Pos, ASize : longint; var Dest);  virtual;

  {* record methods *}
    procedure recDelete(Item : longint);  virtual;
    procedure recInsert(const Source; Item : longint);  virtual;

  private
  {* specific for this object *}
    function CalculateIndex(Pos : longint; var RelativePos : word) : word;
  end;



{* call this procedure before calling any other routine! Initializes XMS and
   EMS units too if compiled for MsDos *}

procedure InitObjMemory;


{* call this function to get a memory object *}

function  GetObjMemory(Size : longint; RecSize, AFlags : word) : PObjMemory;



 IMPLEMENTATION USES {$IFNDEF Windows}DOS ,{$ENDIF}BBUTIL ,BBGUI ,BBERROR ,BBFILE {$IFDEF Debug},ASSERTIONS {$ENDIF};
TYPE Ol1I1l1ll=ARRAY [ 0 .. MAXWORD- 1 ]  OF BYTE;CONSTRUCTOR TOBJMEMORY.INIT (ASIZE:LONGINT;ARECSIZE:WORD);
BEGIN INHERITED INIT ;SIZE :=ASIZE ;RECSIZE :=ARECSIZE ;END ;PROCEDURE TOBJMEMORY.BLOCKREAD (VAR F:FILE ;
BLOCKSIZE:LONGINT);BEGIN ABSTRACT ;END ;PROCEDURE TOBJMEMORY.BLOCKWRITE (VAR F:FILE ;BLOCKSIZE:LONGINT);BEGIN ABSTRACT ;
END ;PROCEDURE TOBJMEMORY.COPYFROM (SOURCE:POBJMEMORY);CONST OO00O1O1Il=32768 ;VAR OI10I1ll0l01:POINTER;
O10OIOOOlI1I1:LONGINT;Olll0IOI11:LONGINT;O101l00lOI0IO:LONGINT;BEGIN GETMEM (OI10I1ll0l01 ,OO00O1O1Il );
{$IFDEF DEBUG}ASSERT (OI10I1ll0l01 <> NIL ,'Could not allocate Cache!');{$ENDIF}O101l00lOI0IO :=0 ;Olll0IOI11 :=0 ;
O10OIOOOlI1I1 :=MIN (SOURCE ^.SIZE ,SIZE );WHILE O10OIOOOlI1I1 > 0  DO BEGIN SOURCE ^.MOVETO (Olll0IOI11 ,MIN (OO00O1O1Il
,O10OIOOOlI1I1 ),OI10I1ll0l01 ^);MOVEFROM (OI10I1ll0l01 ^,O101l00lOI0IO ,MIN (OO00O1O1Il ,O10OIOOOlI1I1 ));DEC
(O10OIOOOlI1I1 ,OO00O1O1Il );INC (Olll0IOI11 ,OO00O1O1Il );INC (O101l00lOI0IO ,OO00O1O1Il );END ;FREEMEM (OI10I1ll0l01
,OO00O1O1Il );TOTALRECORDS :=SOURCE ^.TOTALRECORDS ;RECSIZE :=SOURCE ^.RECSIZE ;END ;PROCEDURE TOBJMEMORY.DELETE
(APOS,ASIZE:LONGINT);BEGIN ABSTRACT ;END ;PROCEDURE TOBJMEMORY.FILLCHAR (VALUE:BYTE);CONST OO00O1O1Il=32768 ;
VAR OI10I1ll0l01:POINTER;O10OIOOOlI1I1:LONGINT;OIOllI0O1OI:LONGINT;BEGIN GETMEM (OI10I1ll0l01 ,OO00O1O1Il );
{$IFDEF DEBUG}ASSERT (OI10I1ll0l01 <> NIL ,'Could not allocate Cache!');{$ENDIF}SYSTEM.FILLCHAR (OI10I1ll0l01 ^,MIN
(OO00O1O1Il ,SIZE ),0 );OIOllI0O1OI :=0 ;O10OIOOOlI1I1 :=SIZE ;WHILE O10OIOOOlI1I1 > 0  DO BEGIN MOVEFROM (OI10I1ll0l01
^,OIOllI0O1OI ,MIN (OO00O1O1Il ,O10OIOOOlI1I1 ));DEC (O10OIOOOlI1I1 ,OO00O1O1Il );INC (OIOllI0O1OI ,OO00O1O1Il );END ;
FREEMEM (OI10I1ll0l01 ,OO00O1O1Il );END ;PROCEDURE TOBJMEMORY.MOVEFROM (CONST SOURCE;POS,ASIZE:LONGINT);BEGIN ABSTRACT ;
END ;PROCEDURE TOBJMEMORY.MOVETO (POS,ASIZE:LONGINT;VAR DEST);BEGIN ABSTRACT ;END ;PROCEDURE TOBJMEMORY.STREAMREAD
(VAR S:TSTREAM;APOS,ASIZE:LONGINT);BEGIN PRINTERROR ('Abstract method TObjMemory.StreamRead',0 );ABSTRACT ;END ;
PROCEDURE TOBJMEMORY.STREAMWRITE (VAR S:TSTREAM;APOS,ASIZE:LONGINT);BEGIN PRINTERROR
('Abstract method TObjMemory.StreamWrite',0 );ABSTRACT ;END ;PROCEDURE TOBJMEMORY.RECDELETE (ITEM:LONGINT);
BEGIN {$IFDEF Debug}ASSERT ((TOTALRECORDS > 0 ),'No record to delete.');ASSERT ((ITEM >= 0 )AND (ITEM < TOTALRECORDS
),'Invalid Item to delete.');{$ENDIF}DEC (TOTALRECORDS );DELETE (ITEM * RECSIZE ,RECSIZE );END ;
PROCEDURE TOBJMEMORY.RECINSERT (CONST SOURCE;ITEM:LONGINT);VAR OI1OllllOl1:POINTER;OIlO:LONGINT;BEGIN GETMEM (OI1OllllOl1
,RECSIZE );FOR OIlO :=TOTALRECORDS - ITEM - 1 DOWNTO ITEM  DO BEGIN RECMOVETO (OIlO ,OI1OllllOl1 ^);RECMOVEFROM
(OI1OllllOl1 ^,OIlO + 1 );END ;FREEMEM (OI1OllllOl1 ,RECSIZE );RECMOVEFROM (SOURCE ,ITEM );INC (TOTALRECORDS );END ;
PROCEDURE TOBJMEMORY.RECMOVEFROM (CONST SOURCE;ITEM:LONGINT);BEGIN {$IFDEF Debug}ASSERT ((ITEM >= 0 )AND ((ITEM + 1 )*
RECSIZE <= SIZE ),'recMoveFrom index out of bounds.');{$ENDIF}MOVEFROM (SOURCE ,ITEM * RECSIZE ,RECSIZE )END ;
PROCEDURE TOBJMEMORY.RECMOVETO (ITEM:LONGINT;VAR DEST);BEGIN {$IFDEF Debug}ASSERT ((ITEM >= 0 )AND ((ITEM + 1 )* RECSIZE
<= SIZE ),'recMoveTo index out of bounds.');{$ENDIF}MOVETO (ITEM * RECSIZE ,RECSIZE ,DEST )END ;
PROCEDURE TOBJMEMORY.RECWRITE (VAR F:FILE ;RECCOUNT:LONGINT);BEGIN BLOCKWRITE (F ,RECCOUNT * RECSIZE );END ;
{$IFDEF MSDOS}CONSTRUCTOR TEMSMEMORY.INIT (ASIZE:LONGINT;ARECSIZE:WORD;VAR RESULT:BOOLEAN);BEGIN INHERITED INIT (ASIZE
,ARECSIZE );RESULT :=EMS_ALLOCATE (HANDLE ,TOTALPAGES ,SIZE );{$IFDEF Debug}IF NOT RESULT THEN BEGIN LOGERROR
('EMS allocation failed. result code: 0'+ HEXB (EMSRESULT )+ 'h');LOGERROR ('EMS free pages: '+ STRW (EMS_NUMBER_OF_PAGES
));FAIL ;END ;{$ENDIF}END ;DESTRUCTOR TEMSMEMORY.DONE ;BEGIN IF (HANDLE <> 0 )AND NOT EMS_DISPOSE (HANDLE )THEN
PRINTERROR ('Error '+ STRW (EMSRESULT )+ ' deallocating EMS.',0 );INHERITED DONE ;END ;PROCEDURE TEMSMEMORY.BLOCKREAD
(VAR F:FILE ;BLOCKSIZE:LONGINT);VAR O1010O1II0I01:WORD;OI101IOOIO0l:WORD;OIOO101OlII:LONGINT;BEGIN OI101IOOIO0l :=0 ;
OIOO101OlII :=BLOCKSIZE ;WHILE (INOUTRES =0 )AND (OIOO101OlII > 0 ) DO BEGIN IF OIOO101OlII > MAXCONVENTIONALMEMORYBLOCK
THEN O1010O1II0I01 :=MAXCONVENTIONALMEMORYBLOCK ELSE O1010O1II0I01 :=OIOO101OlII ;MAP4PAGES (OI101IOOIO0l );
SYSTEM.BLOCKREAD (F ,EMSFRAME ^,O1010O1II0I01 );DEC (OIOO101OlII ,O1010O1II0I01 );END ;END ;
PROCEDURE TEMSMEMORY.BLOCKWRITE (VAR F:FILE ;BLOCKSIZE:LONGINT);VAR O1010l1OIOO1O:WORD;OI101IOOIO0l:WORD;
OIOO101OlII:LONGINT;BEGIN OI101IOOIO0l :=0 ;OIOO101OlII :=BLOCKSIZE ;WHILE (INOUTRES =0 )AND (OIOO101OlII > 0
) DO BEGIN IF OIOO101OlII > MAXCONVENTIONALMEMORYBLOCK THEN O1010l1OIOO1O :=MAXCONVENTIONALMEMORYBLOCK ELSE O1010l1OIOO1O
:=OIOO101OlII ;MAP4PAGES (OI101IOOIO0l );SYSTEM.BLOCKWRITE (F ,EMSFRAME ^,O1010l1OIOO1O );DEC (OIOO101OlII ,O1010l1OIOO1O
);END ;END ;PROCEDURE TEMSMEMORY.DELETE (APOS,ASIZE:LONGINT);BEGIN {$IFDEF DEBUG}ASSERT (APOS + ASIZE <= SIZE
,'Move after max memory size.');ASSERT (ASIZE >= 0 ,'Size is negative.');{$ENDIF}EMS_MOVE_REGION (HANDLE ,APOS + ASIZE
,HANDLE ,APOS ,SIZE - (APOS + ASIZE ));END ;PROCEDURE TEMSMEMORY.MOVEFROM (CONST SOURCE;POS,ASIZE:LONGINT);
BEGIN {$IFDEF DEBUG}ASSERT (POS + ASIZE <= SIZE ,'Move after max memory size.');ASSERT (ASIZE >= 0 ,'Size is negative.');
{$ENDIF}EMS_MOVE_REGION (0 ,LONGINT (@ SOURCE ),HANDLE ,POS ,ASIZE );END ;PROCEDURE TEMSMEMORY.MOVETO (POS,ASIZE:LONGINT;
VAR DEST);BEGIN EMS_MOVE_REGION (HANDLE ,POS ,0 ,LONGINT (@ DEST ),ASIZE );END ;PROCEDURE TEMSMEMORY.MAP4PAGES
(VAR LOGICALPAGE:WORD);VAR OIlO:WORD;BEGIN FOR OIlO :=0 TO 3  DO BEGIN IF LOGICALPAGE < TOTALPAGES THEN
BEGIN EMS_MAP_MEMORY (HANDLE ,OIlO ,LOGICALPAGE );INC (LOGICALPAGE );END ;END ;END ;PROCEDURE TEMSMEMORY.STREAMREAD
(VAR S:TSTREAM;APOS,ASIZE:LONGINT);VAR O1010O1II0I01:WORD;OI101IOOIO0l:WORD;OIOO101OlII:LONGINT;O10OIIlllI10O:LONGINT;
OOlIll0O0lll:POINTER;O1lO01OlI1lO:WORD;BEGIN {$IFDEF Debug}ASSERT (APOS =0 ,'');{$ENDIF}IF MAXAVAIL <
MAXCONVENTIONALMEMORYBLOCK THEN O1lO01OlI1lO :=MAXAVAIL ELSE O1lO01OlI1lO :=MAXCONVENTIONALMEMORYBLOCK ;GETMEM
(OOlIll0O0lll ,O1lO01OlI1lO );SYSTEM.FILLCHAR (OOlIll0O0lll ^,O1lO01OlI1lO ,$CC );O10OIIlllI10O :=APOS ;OI101IOOIO0l :=0
;OIOO101OlII :=ASIZE ;WHILE (OIOO101OlII > 0 )AND (S.STATUS =STOK ) DO BEGIN IF OIOO101OlII > O1lO01OlI1lO THEN
O1010O1II0I01 :=O1lO01OlI1lO ELSE O1010O1II0I01 :=OIOO101OlII ;S.READ (OOlIll0O0lll ^,O1010O1II0I01 );EMS_MOVE_REGION (0
,LONGINT (OOlIll0O0lll ),HANDLE ,O10OIIlllI10O ,O1010O1II0I01 );INC (O10OIIlllI10O ,O1010O1II0I01 );DEC (OIOO101OlII
,O1010O1II0I01 );END ;FREEMEM (OOlIll0O0lll ,O1lO01OlI1lO );END ;PROCEDURE TEMSMEMORY.STREAMWRITE (VAR S:TSTREAM;
APOS,ASIZE:LONGINT);VAR O1010l1OIOO1O:WORD;O10OIIlllI10O:LONGINT;OI101IOOIO0l:WORD;OIOO101OlII:LONGINT;
OOlIll0O0lll:POINTER;O1lO01OlI1lO:WORD;BEGIN {$IFDEF Debug}ASSERT (APOS =0 ,'');{$ENDIF}IF MAXAVAIL <
MAXCONVENTIONALMEMORYBLOCK THEN O1lO01OlI1lO :=MAXAVAIL ELSE O1lO01OlI1lO :=MAXCONVENTIONALMEMORYBLOCK ;GETMEM
(OOlIll0O0lll ,O1lO01OlI1lO );O10OIIlllI10O :=APOS ;OI101IOOIO0l :=0 ;OIOO101OlII :=ASIZE ;WHILE (OIOO101OlII > 0 )AND
(S.STATUS =STOK ) DO BEGIN IF OIOO101OlII > O1lO01OlI1lO THEN O1010l1OIOO1O :=O1lO01OlI1lO ELSE O1010l1OIOO1O
:=OIOO101OlII ;EMS_MOVE_REGION (HANDLE ,O10OIIlllI10O ,0 ,LONGINT (OOlIll0O0lll ),O1010l1OIOO1O );S.WRITE (OOlIll0O0lll
^,O1010l1OIOO1O );INC (O10OIIlllI10O ,O1010l1OIOO1O );DEC (OIOO101OlII ,O1010l1OIOO1O );END ;FREEMEM (OOlIll0O0lll
,O1lO01OlI1lO );END ;PROCEDURE TEMSMEMORY.RECDELETE (ITEM:LONGINT);BEGIN EMS_MOVE_REGION (HANDLE ,(ITEM + 1 )* RECSIZE
,HANDLE ,ITEM * RECSIZE ,SIZE - ((ITEM - 1 )* RECSIZE ));DEC (TOTALRECORDS );END ;
{$ENDIF}{$IFDEF MSDOS}FUNCTION O100llIO11OlO (OO01:LONGINT):LONGINT ;ASSEMBLER;ASM {} MOV AX , WORD PTR OO01{}
MOV BX , AX {} AND AX , 01h {} JZ @@even {} MOV AX , BX {} MOV DX , WORD PTR OO01+ 2 {} ADD AX , 1 {} ADC DX , 0 {}
JMP @@end {} @@even : {} MOV AX , BX {} MOV DX , WORD PTR OO01+ 2 {} @@end : {} END;CONSTRUCTOR TXMSMEMORY.INIT
(ASIZE:LONGINT;ARECSIZE:WORD;VAR RESULT:BOOLEAN);VAR O1IO1111l:LONGINT;BEGIN IF ARECSIZE > 0 THEN BEGIN O1IO1111l :=ASIZE
DIV ARECSIZE ;IF ASIZE MOD ARECSIZE <> 0 THEN INC (O1IO1111l );ARECSIZE :=O100llIO11OlO (ARECSIZE );END ELSE O1IO1111l
:=0 ;IF O1IO1111l * ARECSIZE > ASIZE THEN ASIZE :=O1IO1111l * ARECSIZE ELSE ASIZE :=O100llIO11OlO (ASIZE );
INHERITED INIT (ASIZE ,ARECSIZE );RESULT :=XMS_ALLOCATE (HANDLE ,SIZE );{$IFDEF Debug}IF NOT RESULT THEN BEGIN LOGERROR
('XMS allocation failed. result code: 0'+ HEXB (XMSRESULT )+ 'h');LOGERROR ('XMS max avail: '+ STRW (XMS_MAXAVAIL ));
FAIL ;END ;{$ENDIF}IF NOT RESULT THEN FAIL ;END ;DESTRUCTOR TXMSMEMORY.DONE ;BEGIN IF (HANDLE <> 0 )AND NOT XMS_DISPOSE
(HANDLE )THEN PRINTERROR ('Error '+ STRW (XMSRESULT )+ ' deallocating XMS.',0 );INHERITED DONE ;END ;
PROCEDURE TXMSMEMORY.BLOCKREAD (VAR F:FILE ;BLOCKSIZE:LONGINT);VAR O1010O1II0I01:WORD;OIOO101OlII:LONGINT;
OOlIll0O0lll:POINTER;O1lO01OlI1lO:LONGINT;O10OIIlllI0OI:LONGINT;OIO1:BYTE;BEGIN IF ODD (BLOCKSIZE )THEN OIO1 :=SAVEBYTE
(BLOCKSIZE );OIOO101OlII :=BLOCKSIZE ;O10OIIlllI0OI :=0 ;IF MAXAVAIL > MAXCONVENTIONALMEMORYBLOCK THEN O1lO01OlI1lO
:=MAXCONVENTIONALMEMORYBLOCK ELSE O1lO01OlI1lO :=O100llIO11OlO (MAXAVAIL - 2 );GETMEM (OOlIll0O0lll ,O1lO01OlI1lO );
WHILE (INOUTRES =0 )AND (OIOO101OlII > 0 ) DO BEGIN IF OIOO101OlII >= O1lO01OlI1lO THEN O1010O1II0I01 :=O1lO01OlI1lO ELSE
O1010O1II0I01 :=OIOO101OlII ;SYSTEM.BLOCKREAD (F ,OOlIll0O0lll ^,O1010O1II0I01 );IF NOT XMS_MOVE_EMB (0 ,LONGINT
(OOlIll0O0lll ),HANDLE ,O10OIIlllI0OI ,O100llIO11OlO (O1010O1II0I01 ))THEN PRINTERROR ('Error '+ STRW (XMSRESULT )+
' moving to XMS -- TXMSMemory.BlockRead --',0 );DEC (OIOO101OlII ,O1010O1II0I01 );INC (O10OIIlllI0OI ,O1010O1II0I01 );
END ;FREEMEM (OOlIll0O0lll ,O1lO01OlI1lO );IF ODD (BLOCKSIZE )THEN RESTOREBYTE (BLOCKSIZE ,OIO1 );END ;
PROCEDURE TXMSMEMORY.BLOCKWRITE (VAR F:FILE ;BLOCKSIZE:LONGINT);VAR O1010l1OIOO1O:WORD;OIOO101OlII:LONGINT;
OOlIll0O0lll:POINTER;O1lO01OlI1lO:LONGINT;O10OIIlllI0OI:LONGINT;OIO1:BYTE;BEGIN IF ODD (BLOCKSIZE )THEN OIOO101OlII
:=BLOCKSIZE - 1 ELSE OIOO101OlII :=BLOCKSIZE ;O10OIIlllI0OI :=0 ;IF MAXAVAIL > MAXCONVENTIONALMEMORYBLOCK THEN
O1lO01OlI1lO :=MAXCONVENTIONALMEMORYBLOCK ELSE O1lO01OlI1lO :=O100llIO11OlO (MAXAVAIL - 2 );GETMEM (OOlIll0O0lll
,O1lO01OlI1lO );WHILE (INOUTRES =0 )AND (OIOO101OlII > 0 ) DO BEGIN IF OIOO101OlII > O1lO01OlI1lO THEN O1010l1OIOO1O
:=O1lO01OlI1lO ELSE O1010l1OIOO1O :=OIOO101OlII ;IF XMS_MOVE_EMB (HANDLE ,O10OIIlllI0OI ,0 ,LONGINT (OOlIll0O0lll
),O1010l1OIOO1O )THEN SYSTEM.BLOCKWRITE (F ,OOlIll0O0lll ^,O1010l1OIOO1O )ELSE PRINTERROR ('Error '+ STRW (XMSRESULT )+
' moving from XMS -- TXMSMemory.BlockWrite --',0 );DEC (OIOO101OlII ,O1010l1OIOO1O );INC (O10OIIlllI0OI ,O1010l1OIOO1O );
END ;FREEMEM (OOlIll0O0lll ,O1lO01OlI1lO );IF ODD (BLOCKSIZE )THEN BEGIN OIO1 :=SAVEBYTE (O10OIIlllI0OI );
SYSTEM.BLOCKWRITE (F ,OIO1 ,1 )END ;END ;PROCEDURE TXMSMEMORY.DELETE (APOS,ASIZE:LONGINT);BEGIN {$IFDEF DEBUG}ASSERT
(APOS + ASIZE <= SIZE ,'Move after max memory size.');ASSERT (ASIZE >= 0 ,'Size is negative.');{$ENDIF}XMS_MOVE_EMB
(HANDLE ,APOS + ASIZE ,HANDLE ,APOS ,O100llIO11OlO (SIZE - (APOS + ASIZE )));END ;PROCEDURE TXMSMEMORY.STREAMREAD
(VAR S:TSTREAM;APOS,ASIZE:LONGINT);VAR O1010O1II0I01:WORD;OIOO101OlII:LONGINT;OOlIll0O0lll:POINTER;O1lO01OlI1lO:LONGINT;
O10OIIlllI0OI:LONGINT;OIO1:BYTE;BEGIN IF ODD (ASIZE )THEN OIO1 :=SAVEBYTE (APOS + ASIZE );OIOO101OlII :=ASIZE ;
O10OIIlllI0OI :=APOS ;IF MAXAVAIL > MAXCONVENTIONALMEMORYBLOCK THEN O1lO01OlI1lO :=MAXCONVENTIONALMEMORYBLOCK ELSE
O1lO01OlI1lO :=O100llIO11OlO (MAXAVAIL - 2 );GETMEM (OOlIll0O0lll ,O1lO01OlI1lO );WHILE (INOUTRES =0 )AND (OIOO101OlII >
0 ) DO BEGIN IF OIOO101OlII > O1lO01OlI1lO THEN O1010O1II0I01 :=O1lO01OlI1lO ELSE O1010O1II0I01 :=OIOO101OlII ;S.READ
(OOlIll0O0lll ^,O1010O1II0I01 );IF NOT XMS_MOVE_EMB (0 ,LONGINT (OOlIll0O0lll ),HANDLE ,O10OIIlllI0OI ,O100llIO11OlO
(O1010O1II0I01 ))THEN PRINTERROR ('Error '+ STRW (XMSRESULT )+ ' moving to XMS -- TXMSMemory.StreamRead --',0 );DEC
(OIOO101OlII ,O1010O1II0I01 );INC (O10OIIlllI0OI ,O1010O1II0I01 );END ;FREEMEM (OOlIll0O0lll ,O1lO01OlI1lO );IF ODD
(ASIZE )THEN RESTOREBYTE (APOS + ASIZE ,OIO1 );END ;PROCEDURE TXMSMEMORY.STREAMWRITE (VAR S:TSTREAM;APOS,ASIZE:LONGINT);
VAR O1010l1OIOO1O:WORD;OIOO101OlII:LONGINT;OOlIll0O0lll:POINTER;O1lO01OlI1lO:LONGINT;O10OIIlllI0OI:LONGINT;OIO1:BYTE;
BEGIN IF ODD (ASIZE )THEN OIOO101OlII :=ASIZE - 1 ELSE OIOO101OlII :=ASIZE ;O10OIIlllI0OI :=APOS ;IF MAXAVAIL >
MAXCONVENTIONALMEMORYBLOCK THEN O1lO01OlI1lO :=MAXCONVENTIONALMEMORYBLOCK ELSE O1lO01OlI1lO :=O100llIO11OlO (MAXAVAIL - 2
);GETMEM (OOlIll0O0lll ,O1lO01OlI1lO );WHILE (INOUTRES =0 )AND (OIOO101OlII > 0 ) DO BEGIN IF OIOO101OlII > O1lO01OlI1lO
THEN O1010l1OIOO1O :=O1lO01OlI1lO ELSE O1010l1OIOO1O :=OIOO101OlII ;IF XMS_MOVE_EMB (HANDLE ,O10OIIlllI0OI ,0 ,LONGINT
(OOlIll0O0lll ),O1010l1OIOO1O )THEN S.WRITE (OOlIll0O0lll ^,O1010l1OIOO1O )ELSE PRINTERROR ('Error '+ STRW (XMSRESULT )+
' moving from XMS -- TXMSMemory.StreamWrite --',0 );DEC (OIOO101OlII ,O1010l1OIOO1O );INC (O10OIIlllI0OI ,O1010l1OIOO1O
);END ;FREEMEM (OOlIll0O0lll ,O1lO01OlI1lO );IF ODD (ASIZE )THEN BEGIN OIO1 :=SAVEBYTE (O10OIIlllI0OI );S.WRITE (OIO1 ,1
)END ;END ;PROCEDURE TXMSMEMORY.MOVEFROM (CONST SOURCE;POS,ASIZE:LONGINT);VAR OIOO:ARRAY [ 0 .. 1 ]  OF BYTE;
BEGIN {$IFDEF Debug}ASSERT (POS + ASIZE <= SIZE ,'Move after max memory size.');ASSERT (ASIZE >= 0 ,'Size is negative.');
{$ENDIF}IF ODD (ASIZE )THEN BEGIN IF ASIZE > 1 THEN XMS_MOVE_EMB (0 ,LONGINT (@ SOURCE ),HANDLE ,POS ,ASIZE - 1 );
END ELSE XMS_MOVE_EMB (0 ,LONGINT (@ SOURCE ),HANDLE ,POS ,ASIZE );IF ODD (ASIZE )THEN BEGIN XMS_MOVE_EMB (HANDLE ,POS +
ASIZE - 1 ,0 ,LONGINT (@ OIOO ),2 );OIOO [ 0 ] :=Ol1I1l1ll (SOURCE )[ ASIZE - 1 ] ;XMS_MOVE_EMB (0 ,LONGINT (@ OIOO
),HANDLE ,POS + ASIZE - 1 ,2 );END ;END ;PROCEDURE TXMSMEMORY.MOVETO (POS,ASIZE:LONGINT;VAR DEST);VAR OIOO:ARRAY [ 0 .. 1
]  OF BYTE;BEGIN IF ODD (ASIZE )THEN BEGIN IF ASIZE > 1 THEN XMS_MOVE_EMB (HANDLE ,POS ,0 ,LONGINT (@ DEST ),ASIZE - 1 );
END ELSE XMS_MOVE_EMB (HANDLE ,POS ,0 ,LONGINT (@ DEST ),ASIZE );IF ODD (ASIZE )THEN BEGIN XMS_MOVE_EMB (HANDLE ,POS +
ASIZE - 1 ,0 ,LONGINT (@ OIOO ),2 );Ol1I1l1ll (DEST )[ ASIZE - 1 ] :=OIOO [ 0 ] ;END ;END ;
PROCEDURE TXMSMEMORY.RECDELETE (ITEM:LONGINT);BEGIN XMS_MOVE_EMB (HANDLE ,(ITEM + 1 )* RECSIZE ,HANDLE ,ITEM * RECSIZE
,SIZE - ((ITEM - 1 )* RECSIZE ));DEC (TOTALRECORDS );END ;FUNCTION TXMSMEMORY.SAVEBYTE (POS:LONGINT):BYTE ;
VAR OOII:ARRAY [ 0 .. 1 ]  OF BYTE;BEGIN XMS_MOVE_EMB (HANDLE ,POS - 1 ,0 ,LONGINT (@ OOII ),2 );SAVEBYTE :=OOII [ 1 ] ;
END ;PROCEDURE TXMSMEMORY.RESTOREBYTE (POS:LONGINT;B:BYTE);VAR OOII:ARRAY [ 0 .. 1 ]  OF BYTE;BEGIN XMS_MOVE_EMB (HANDLE
,POS - 1 ,0 ,LONGINT (@ OOII ),2 );OOII [ 1 ] :=B ;XMS_MOVE_EMB (0 ,LONGINT (@ OOII ),HANDLE ,POS - 1 ,2 );END ;
{$ENDIF}CONSTRUCTOR TCONVMAX64MEMORY.INIT (ASIZE:LONGINT;ARECSIZE:WORD;VAR RESULT:BOOLEAN);BEGIN INHERITED INIT (ASIZE
,ARECSIZE );RESULT :=MAXAVAIL >= SIZE ;IF RESULT THEN GETMEM (MEM ,SIZE )ELSE FAIL ;END ;
DESTRUCTOR TCONVMAX64MEMORY.DONE ;BEGIN IF MEM <> NIL THEN FREEMEM (MEM ,SIZE );INHERITED DONE ;END ;
PROCEDURE TCONVMAX64MEMORY.BLOCKREAD (VAR F:FILE ;BLOCKSIZE:LONGINT);BEGIN {$IFDEF Debug}ASSERT (ISFILEOPEN (F )AND
(BLOCKSIZE <= SIZE ),'');{$ENDIF}SYSTEM.BLOCKREAD (F ,MEM ^,BLOCKSIZE );END ;PROCEDURE TCONVMAX64MEMORY.BLOCKWRITE
(VAR F:FILE ;BLOCKSIZE:LONGINT);BEGIN {$IFDEF Debug}ASSERT (ISFILEOPEN (F )AND (BLOCKSIZE <= SIZE ),'');
{$ENDIF}SYSTEM.BLOCKWRITE (F ,MEM ^,BLOCKSIZE );END ;PROCEDURE TCONVMAX64MEMORY.STREAMREAD (VAR S:TSTREAM;
APOS,ASIZE:LONGINT);BEGIN S.READ (MEM ^[ APOS ] ,ASIZE );END ;PROCEDURE TCONVMAX64MEMORY.STREAMWRITE (VAR S:TSTREAM;
APOS,ASIZE:LONGINT);BEGIN S.WRITE (MEM ^[ APOS ] ,ASIZE );END ;PROCEDURE TCONVMAX64MEMORY.DELETE (APOS,ASIZE:LONGINT);
BEGIN MOVEFROM (MEM ^[ APOS + ASIZE ] ,APOS ,SIZE - (APOS + ASIZE ));END ;PROCEDURE TCONVMAX64MEMORY.MOVEFROM
(CONST SOURCE;POS,ASIZE:LONGINT);BEGIN {$IFDEF DEBUG}ASSERT (POS + ASIZE <= SIZE ,'Move after max memory size.');ASSERT
(ASIZE >= 0 ,'Size is negative.');{$ENDIF}MOVE (SOURCE ,MEM ^[ POS ] ,ASIZE );END ;PROCEDURE TCONVMAX64MEMORY.MOVETO
(POS,ASIZE:LONGINT;VAR DEST);BEGIN MOVE (MEM ^[ POS ] ,DEST ,ASIZE );END ;PROCEDURE TCONVMAX64MEMORY.RECDELETE
(ITEM:LONGINT);BEGIN DEC (TOTALRECORDS );MOVE (PBYTEARRAY (MEM )^[ (ITEM + 1 )* RECSIZE ] ,PBYTEARRAY (MEM )^[ (ITEM )*
RECSIZE ] ,(TOTALRECORDS - ITEM )* RECSIZE );END ;PROCEDURE TCONVMAX64MEMORY.RECINSERT (CONST SOURCE;ITEM:LONGINT);
BEGIN MOVE (PBYTEARRAY (MEM )^[ (ITEM )* RECSIZE ] ,PBYTEARRAY (MEM )^[ (ITEM + 1 )* RECSIZE ] ,(TOTALRECORDS - ITEM )*
RECSIZE );MOVE (SOURCE ,PBYTEARRAY (MEM )^[ ITEM * RECSIZE ] ,RECSIZE );INC (TOTALRECORDS );END ;
CONSTRUCTOR TCONVHUGEMEMORY.INIT (ASIZE:LONGINT;ARECSIZE:WORD;VAR RESULT:BOOLEAN);VAR O1011100OO11O:LONGINT;
BEGIN INHERITED INIT (ASIZE ,ARECSIZE );RESULT :=MEMAVAIL >= SIZE ;IF RESULT THEN BEGIN O1011100OO11O :=0 ;
WHILE O1011100OO11O < SIZE  DO BEGIN IF SIZE - O1011100OO11O > MAXCONVENTIONALMEMORYBLOCK THEN BEGIN IF MAXAVAIL >=
MAXCONVENTIONALMEMORYBLOCK THEN MEMSIZES [ TOTALMEMPTRS ] :=MAXCONVENTIONALMEMORYBLOCK ELSE MEMSIZES [ TOTALMEMPTRS ]
:=MAXAVAIL ;END ELSE MEMSIZES [ TOTALMEMPTRS ] :=SIZE - O1011100OO11O ;GETMEM (MEMPTRS [ TOTALMEMPTRS ] ,MEMSIZES [
TOTALMEMPTRS ] );INC (O1011100OO11O ,MEMSIZES [ TOTALMEMPTRS ] );INC (TOTALMEMPTRS );END ;END ELSE FAIL ;END ;
DESTRUCTOR TCONVHUGEMEMORY.DONE ;VAR OIlO:INTEGER;BEGIN FOR OIlO :=0 TO TOTALMEMPTRS - 1  DO FREEMEM (MEMPTRS [ OIlO ]
,MEMSIZES [ OIlO ] );INHERITED DONE ;END ;PROCEDURE TCONVHUGEMEMORY.BLOCKREAD (VAR F:FILE ;BLOCKSIZE:LONGINT);
VAR OII0OO0lllO:INTEGER;OI10I0OlO1lO:WORD;O10OII0IIOI1O:WORD;BEGIN {$IFDEF Debug}ASSERT (ISFILEOPEN (F ),'');
{$ENDIF}OII0OO0lllO :=CALCULATEINDEX (0 ,OI10I0OlO1lO );IF OI10I0OlO1lO + BLOCKSIZE >= MEMSIZES [ OII0OO0lllO ] THEN
BEGIN O10OII0IIOI1O :=MEMSIZES [ OII0OO0lllO ] - OI10I0OlO1lO ;WHILE BLOCKSIZE > 0  DO BEGIN SYSTEM.BLOCKREAD (F
,PBYTEARRAY (MEMPTRS [ OII0OO0lllO ] )^[ OI10I0OlO1lO ] ,O10OII0IIOI1O );DEC (BLOCKSIZE ,O10OII0IIOI1O );INC (OII0OO0lllO
);OI10I0OlO1lO :=0 ;IF BLOCKSIZE > MEMSIZES [ OII0OO0lllO ] THEN O10OII0IIOI1O :=MEMSIZES [ OII0OO0lllO ] ELSE
O10OII0IIOI1O :=BLOCKSIZE ;END ;END ELSE SYSTEM.BLOCKREAD (F ,PBYTEARRAY (MEMPTRS [ OII0OO0lllO ] )^[ OI10I0OlO1lO ]
,BLOCKSIZE );END ;PROCEDURE TCONVHUGEMEMORY.BLOCKWRITE (VAR F:FILE ;BLOCKSIZE:LONGINT);VAR OII0OO0lllO:INTEGER;
OI10I0OlO1lO:WORD;O10OII0IIOI1O:WORD;BEGIN {$IFDEF Debug}ASSERT (ISFILEOPEN (F ),'');{$ENDIF}OII0OO0lllO :=CALCULATEINDEX
(0 ,OI10I0OlO1lO );IF OI10I0OlO1lO + BLOCKSIZE >= MEMSIZES [ OII0OO0lllO ] THEN BEGIN O10OII0IIOI1O :=MEMSIZES [
OII0OO0lllO ] - OI10I0OlO1lO ;WHILE BLOCKSIZE > 0  DO BEGIN SYSTEM.BLOCKWRITE (F ,PBYTEARRAY (MEMPTRS [ OII0OO0lllO ] )^[
OI10I0OlO1lO ] ,O10OII0IIOI1O );DEC (BLOCKSIZE ,O10OII0IIOI1O );INC (OII0OO0lllO );OI10I0OlO1lO :=0 ;IF BLOCKSIZE >
MEMSIZES [ OII0OO0lllO ] THEN O10OII0IIOI1O :=MEMSIZES [ OII0OO0lllO ] ELSE O10OII0IIOI1O :=BLOCKSIZE ;END ;END ELSE
SYSTEM.BLOCKWRITE (F ,PBYTEARRAY (MEMPTRS [ OII0OO0lllO ] )^[ OI10I0OlO1lO ] ,BLOCKSIZE );END ;
PROCEDURE TCONVHUGEMEMORY.STREAMREAD (VAR S:TSTREAM;APOS,ASIZE:LONGINT);VAR OII0OO0lllO:INTEGER;OI10I0OlO1lO:WORD;
O10OII0IIOI1O:WORD;BEGIN OII0OO0lllO :=CALCULATEINDEX (APOS ,OI10I0OlO1lO );IF OI10I0OlO1lO + ASIZE >= MEMSIZES [
OII0OO0lllO ] THEN BEGIN O10OII0IIOI1O :=MEMSIZES [ OII0OO0lllO ] - OI10I0OlO1lO ;WHILE ASIZE > 0  DO BEGIN S.READ
(PBYTEARRAY (MEMPTRS [ OII0OO0lllO ] )^[ OI10I0OlO1lO ] ,O10OII0IIOI1O );DEC (ASIZE ,O10OII0IIOI1O );INC (OII0OO0lllO );
OI10I0OlO1lO :=0 ;IF ASIZE > MEMSIZES [ OII0OO0lllO ] THEN O10OII0IIOI1O :=MEMSIZES [ OII0OO0lllO ] ELSE O10OII0IIOI1O
:=ASIZE ;END ;END ELSE S.READ (PBYTEARRAY (MEMPTRS [ OII0OO0lllO ] )^[ OI10I0OlO1lO ] ,ASIZE );END ;
PROCEDURE TCONVHUGEMEMORY.STREAMWRITE (VAR S:TSTREAM;APOS,ASIZE:LONGINT);VAR OII0OO0lllO:INTEGER;OI10I0OlO1lO:WORD;
O10OII0IIOI1O:WORD;BEGIN OII0OO0lllO :=CALCULATEINDEX (APOS ,OI10I0OlO1lO );IF OI10I0OlO1lO + ASIZE >= MEMSIZES [
OII0OO0lllO ] THEN BEGIN O10OII0IIOI1O :=MEMSIZES [ OII0OO0lllO ] - OI10I0OlO1lO ;WHILE ASIZE > 0  DO BEGIN S.WRITE
(PBYTEARRAY (MEMPTRS [ OII0OO0lllO ] )^[ OI10I0OlO1lO ] ,O10OII0IIOI1O );DEC (ASIZE ,O10OII0IIOI1O );INC (OII0OO0lllO );
OI10I0OlO1lO :=0 ;IF ASIZE > MEMSIZES [ OII0OO0lllO ] THEN O10OII0IIOI1O :=MEMSIZES [ OII0OO0lllO ] ELSE O10OII0IIOI1O
:=ASIZE ;END ;END ELSE S.WRITE (PBYTEARRAY (MEMPTRS [ OII0OO0lllO ] )^[ OI10I0OlO1lO ] ,ASIZE );END ;
PROCEDURE TCONVHUGEMEMORY.DELETE (APOS,ASIZE:LONGINT);PROCEDURE O1l1lI0O01l1 (VAR OII0OO0lllO:INTEGER;
VAR OI10I0OlO1lO:WORD;O1lIIOl11IlO:WORD);BEGIN {$IFDEF Debug}ASSERT (OI10I0OlO1lO + O1lIIOl11IlO <= MEMSIZES [
OII0OO0lllO ] ,'');{$ENDIF}IF OI10I0OlO1lO + O1lIIOl11IlO =MEMSIZES [ OII0OO0lllO ] THEN BEGIN INC (OII0OO0lllO );
OI10I0OlO1lO :=0 ;END ELSE BEGIN INC (OI10I0OlO1lO ,O1lIIOl11IlO );END ;END ;VAR O1Ol1ll1OI0O,OIIOO0OllO:INTEGER;
O1l01ll1l0OO,OI0lO1lIO011:WORD;O10OII0IIOI1O:WORD;OOlOIlO1lll0:LONGINT;BEGIN IF ASIZE =0 THEN EXIT ;O1Ol1ll1OI0O
:=CALCULATEINDEX (APOS + ASIZE ,O1l01ll1l0OO );OIIOO0OllO :=CALCULATEINDEX (APOS ,OI0lO1lIO011 );OOlOIlO1lll0 :=SIZE -
(APOS + ASIZE );WHILE OOlOIlO1lll0 > 0  DO BEGIN O10OII0IIOI1O :=MIN (MEMSIZES [ O1Ol1ll1OI0O ] - O1l01ll1l0OO ,MEMSIZES
[ OIIOO0OllO ] - OI0lO1lIO011 );MOVE (PBYTEARRAY (MEMPTRS [ O1Ol1ll1OI0O ] )^[ O1l01ll1l0OO ] ,PBYTEARRAY (MEMPTRS [
OIIOO0OllO ] )^[ OI0lO1lIO011 ] ,O10OII0IIOI1O );O1l1lI0O01l1 (O1Ol1ll1OI0O ,O1l01ll1l0OO ,O10OII0IIOI1O );O1l1lI0O01l1
(OIIOO0OllO ,OI0lO1lIO011 ,O10OII0IIOI1O );DEC (OOlOIlO1lll0 ,O10OII0IIOI1O );END ;END ;
PROCEDURE TCONVHUGEMEMORY.MOVEFROM (CONST SOURCE;POS,ASIZE:LONGINT);VAR OII0OO0lllO:INTEGER;OI10I0OlO1lO:WORD;
O10OII0IIOI1O:WORD;Olll0IOI11:WORD;BEGIN {$IFDEF DEBUG}ASSERT (POS + ASIZE <= SIZE ,'Move after max memory size.');
ASSERT (ASIZE >= 0 ,'Size is negative.');{$ENDIF}OII0OO0lllO :=CALCULATEINDEX (POS ,OI10I0OlO1lO );IF OI10I0OlO1lO +
ASIZE >= MEMSIZES [ OII0OO0lllO ] THEN BEGIN O10OII0IIOI1O :=MEMSIZES [ OII0OO0lllO ] - OI10I0OlO1lO ;Olll0IOI11 :=0 ;
WHILE ASIZE > 0  DO BEGIN MOVE (Ol1I1l1ll (SOURCE )[ Olll0IOI11 ] ,PBYTEARRAY (MEMPTRS [ OII0OO0lllO ] )^[ OI10I0OlO1lO ]
,O10OII0IIOI1O );DEC (ASIZE ,O10OII0IIOI1O );INC (OII0OO0lllO );OI10I0OlO1lO :=0 ;INC (Olll0IOI11 ,O10OII0IIOI1O );IF
ASIZE > MEMSIZES [ OII0OO0lllO ] THEN O10OII0IIOI1O :=MEMSIZES [ OII0OO0lllO ] ELSE O10OII0IIOI1O :=ASIZE ;END ;END ELSE
MOVE (SOURCE ,PBYTEARRAY (MEMPTRS [ OII0OO0lllO ] )^[ OI10I0OlO1lO ] ,ASIZE );END ;PROCEDURE TCONVHUGEMEMORY.MOVETO
(POS,ASIZE:LONGINT;VAR DEST);VAR OII0OO0lllO:INTEGER;OI10I0OlO1lO:WORD;O10OII0IIOI1O:WORD;O101l00lOI0IO:WORD;
BEGIN OII0OO0lllO :=CALCULATEINDEX (POS ,OI10I0OlO1lO );IF OI10I0OlO1lO + ASIZE >= MEMSIZES [ OII0OO0lllO ] THEN
BEGIN O10OII0IIOI1O :=MEMSIZES [ OII0OO0lllO ] - OI10I0OlO1lO ;O101l00lOI0IO :=0 ;WHILE ASIZE > 0  DO BEGIN MOVE
(PBYTEARRAY (MEMPTRS [ OII0OO0lllO ] )^[ OI10I0OlO1lO ] ,Ol1I1l1ll (DEST )[ O101l00lOI0IO ] ,O10OII0IIOI1O );DEC (ASIZE
,O10OII0IIOI1O );INC (OII0OO0lllO );OI10I0OlO1lO :=0 ;INC (O101l00lOI0IO ,O10OII0IIOI1O );IF ASIZE > MEMSIZES [
OII0OO0lllO ] THEN O10OII0IIOI1O :=MEMSIZES [ OII0OO0lllO ] ELSE O10OII0IIOI1O :=ASIZE ;END ;END ELSE MOVE (PBYTEARRAY
(MEMPTRS [ OII0OO0lllO ] )^[ OI10I0OlO1lO ] ,DEST ,ASIZE );END ;PROCEDURE TCONVHUGEMEMORY.RECDELETE (ITEM:LONGINT);
BEGIN DEC (TOTALRECORDS );DELETE (ITEM * RECSIZE ,RECSIZE );END ;PROCEDURE TCONVHUGEMEMORY.RECINSERT (CONST SOURCE;
ITEM:LONGINT);VAR OI1OllllOl1:POINTER;OIlO:LONGINT;BEGIN GETMEM (OI1OllllOl1 ,RECSIZE );FOR OIlO :=TOTALRECORDS - ITEM -
1 DOWNTO ITEM  DO BEGIN RECMOVETO (OIlO ,OI1OllllOl1 ^);RECMOVEFROM (OI1OllllOl1 ^,OIlO + 1 );END ;FREEMEM (OI1OllllOl1
,RECSIZE );RECMOVEFROM (SOURCE ,ITEM );INC (TOTALRECORDS );END ;FUNCTION TCONVHUGEMEMORY.CALCULATEINDEX (POS:LONGINT;
VAR RELATIVEPOS:WORD):WORD ;VAR OII0OO0lllO:WORD;OIOO:LONGINT;BEGIN OII0OO0lllO :=0 ;WHILE POS >= MEMSIZES [ OII0OO0lllO
]  DO BEGIN DEC (POS ,MEMSIZES [ OII0OO0lllO ] );INC (OII0OO0lllO );END ;RELATIVEPOS :=POS ;CALCULATEINDEX :=OII0OO0lllO
;END ;PROCEDURE INITOBJMEMORY ;BEGIN {$IFDEF MsDos}EMS_INIT ;{$IFDEF Debug}IF EMSINSTALLED THEN BEGIN LOGERROR
('EMS version: '+ HEXSTR (EMSVERSION ));LOGERROR ('EMS free pages: '+ STRW (EMS_NUMBER_OF_PAGES ));END ;{$ENDIF}XMS_INIT
;{$IFDEF Debug}IF XMSINSTALLED THEN BEGIN LOGERROR ('XMS version: '+ HEXSTR (XMSVERSION ));LOGERROR ('XMS mem avail: '+
STRW (XMS_MEMAVAIL )+ 'KB');END ;{$ENDIF}{$ENDIF}END ;FUNCTION GETOBJMEMORY (SIZE:LONGINT;
RECSIZE,AFLAGS:WORD):POBJMEMORY ;VAR OIO11IOOlO0:BOOLEAN;BEGIN {$IFNDEF XForceXMS}IF (AFLAGS AND MEMFCONVENTIONALFIRST <>
0 )OR (SIZE <= CONVMEMLIMIT )THEN BEGIN IF SIZE <= MAXCONVENTIONALMEMORYBLOCK THEN GETOBJMEMORY :=NEW (PCONVMAX64MEMORY
,INIT (SIZE ,RECSIZE ,OIO11IOOlO0 ))ELSE GETOBJMEMORY :=NEW (PCONVHUGEMEMORY ,INIT (SIZE ,RECSIZE ,OIO11IOOlO0 ));IF
OIO11IOOlO0 THEN EXIT ;END ;{$ENDIF}{$IFDEF MsDos}{$IFNDEF ForceXMS}IF (AFLAGS AND MEMFEMS <> 0 )AND EMSINSTALLED THEN
BEGIN GETOBJMEMORY :=NEW (PEMSMEMORY ,INIT (SIZE ,RECSIZE ,OIO11IOOlO0 ));IF OIO11IOOlO0 THEN EXIT ;END ;{$ENDIF}IF
(AFLAGS AND MEMFXMS <> 0 )AND XMSINSTALLED THEN BEGIN GETOBJMEMORY :=NEW (PXMSMEMORY ,INIT (SIZE ,RECSIZE ,OIO11IOOlO0
));IF OIO11IOOlO0 THEN EXIT ;END ;{$ENDIF}IF (AFLAGS AND MEMFCONVENTIONAL <> 0 )THEN BEGIN IF SIZE <=
MAXCONVENTIONALMEMORYBLOCK THEN GETOBJMEMORY :=NEW (PCONVMAX64MEMORY ,INIT (SIZE ,RECSIZE ,OIO11IOOlO0 ))ELSE
GETOBJMEMORY :=NEW (PCONVHUGEMEMORY ,INIT (SIZE ,RECSIZE ,OIO11IOOlO0 ));IF OIO11IOOlO0 THEN EXIT ;END ;IF (AFLAGS AND
MEMFDISK <> 0 )THEN BEGIN END ;LOGERROR ('No memory allocated. Request size: '+ STRL (SIZE ));GETOBJMEMORY :=NIL ;END ;
END .
