{ TIMLIB.PAS : Time/Date routine library

  Title   : TIMLIB
  Version : 5.0
  Date    : Nov 10,1996
  Author  : J.R. Ferguson
  Language: Turbo Pascal v4.0 through 7.0 (all targets)
  Usage   : Unit
}

UNIT TIMLIB;

INTERFACE
uses
{$IFDEF WINDOWS}
  WinDos,
{$ELSE}
  Dos,
{$ENDIF}
  DtmLib;


type

{$IFDEF WINDOWS}
  Registers  = TRegisters;
{$ENDIF}

  TimDateRec = record
                 Year     : 1980..2099;
                 Month    : 1..12;
                 Day      : 1..31;
               end;

  TimTimeRec = record
                 Hours    : 0..23;
                 Minutes  : 0..59;
                 Seconds  : 0..59;
                 CentiSec : 0..99  { hundreths of a second }
               end;



function TimPackDate(date: TimDateRec; var n: longint): boolean;
{ Pack date. Function result true if successful. }

function TimPackTime(time: TimTimeRec; var n: longint): boolean;
{ Pack time. Function result true if successful. }

function TimUnpackDate(n: longint; var date: TimDateRec): boolean;
{ Unpack date. Function result true if successful. }

function TimUnpackTime(n: longint; var time: TimTimeRec): boolean;
{ Unpack time. Function result true if successful. }

procedure TimGetDate(var date: TimDateRec);
{ Get current system date. }

function TimSetDate(date: TimDateRec): boolean;
{ Set system date. If the date parameter holds an invalid date, the
  function result will be FALSE and the system date is not altered. }

procedure TimGetTime(var time: TimTimeRec);
{ Get current system time. }

function TimSetTime(time: TimTimeRec): boolean;
{ Set system time. If the time parameter holds invalid time information,
  the function result will be FALSE and the system time is not altered. }


IMPLEMENTATION


function TimPackDate(date: TimDateRec; var n: longint): boolean;
var dtm: DtmDateRec;
begin
  dtm.Fn        := DtmFnYmd;
  dtm.Ymd.Year  := date.Year;
  dtm.Ymd.Month := date.Month;
  dtm.Ymd.Day   := date.Day;
  if DtmConvert(dtm) then begin
    n:= dtm.Idf;
    TimPackDate:= true;
  end
  else TimPackDate:= false;
end;


function TimPackTime(time: TimTimeRec; var n: longint): boolean;
begin with time do begin
  n:= ((longint(Hours)    *  60 +
        longint(Minutes)) *  60 +
        longint(Seconds)) * 100 +
        longint(CentiSec);
  TimPackTime:= true;
end end;


function TimUnpackDate(n: longint; var date: TimDateRec): boolean;
var dtm: DtmDateRec;
begin
  dtm.Fn := DtmFnIdf;
  dtm.Idf:= n;
  if DtmConvert(dtm) then begin
    if (dtm.Ymd.Year >= 1980) then begin
      date.Year  := dtm.Ymd.Year;
      date.Month := dtm.Ymd.Month;
      date.Day   := dtm.Ymd.Day;
      TimUnpackDate:= true;
    end
    else TimUnpackdate:= false;
  end
  else TimUnpackDate:= false;
end;


function TimUnpackTime(n: longint; var time: TimTimeRec): boolean;
begin
  if (n >= 0) and (n < 8640000) then begin
    time.CentiSec := n mod 100; n          := n div 100;
    time.Seconds  := n mod  60; n          := n div  60;
    time.Minutes  := n mod  60; time.Hours := n div  60;
    TimUnpackTime := true;
  end
  else TimUnpackTime:= false;
end;


procedure TimGetDate(var date: TimDateRec);
const cpuregs: Registers = ( AX:$2A00 );
begin with cpuregs, date do begin
  MsDos(cpuregs);
  Year:= CX; Month:= DH; Day:= DL;
end end;


function TimSetDate(date: TimDateRec): boolean;
const cpuregs: Registers = ( AX:$2B00 );
begin with cpuregs, date do begin
  CX:= Year; DH:= Month; DL:= Day;
  MsDos(cpuregs);
  TimSetDate:= AL=0;
end end;


procedure TimGetTime(var time: TimTimeRec);
const cpuregs: Registers = ( AX:$2C00 );
begin with cpuregs, time do begin
  MsDos(cpuregs);
  Hours:= CH; Minutes:= CL; Seconds:= DH; CentiSec:= DL;
end end;


function TimSetTime(time: TimTimeRec): boolean;
const cpuregs: Registers = ( AX:$2D00 );
begin with cpuregs, time do begin
  CH:= Hours; CL:= Minutes; DH:= Seconds; DL:= CentiSec;
  MsDos(cpuregs);
  TimSetTime:= AL=0;
end end;

END.
