CODE      SEGMENT
%TITLE "Convert numeric value to a hex string"

;-----------------------------------------------------------------------;
;                                                                       ;
;  PURPOSE :    This assembly PROC will convert any numeric value from  ;
;               a byte to a LONGINT into a Hex string.                  ;
;                                                                       ;
;               THIS CODE IS NOT MINE and all creative credit           ;
;               belongs to Borland Personnel.  All I did was enter this ;
;               the code and convert it to a TPascal MODEL.             ;
;                                                                       ;
;   AUTHOR  :   Borland International, Inc.                             ;
;                                                                       ;
;-----------------------------------------------------------------------;

                .MODEL TPascal

                .CODE

;---------------  Insert PUBLIC code declarations here

                PUBLIC    HexStr

%NEWPAGE
;---------------------------------------------------------------;
;--  FUNCTION HexStr ( VAR num                   ;            --;
;--                         count                : BYTE )     --;
;--                                              : STRING     --;
;--                                                           --;
;---------------------------------------------------------------;
;--                                                           --;
;--   INPUT :                                                 --;
;--             num       :  POINTER                          --;
;--                        - any ORDINAL variable ( no REALS )--;
;--             byteCount :  BYTE                             --;
;--                        -  a non-zero value indicating the --;
;--                           number of bytes to num occupies --;
;--                                                           --;
;---------------------------------------------------------------;
;--                                                           --;
;--  RETURN:  A STRING type with the hex equivilant of num.   --;
;--                                                           --;
;---------------------------------------------------------------;
;--                                                           --;
;--  EXAMPLE CALL FROM PASCAL:                                --;
;--                                                           --;
;--  s := HexStr ( longinteger , SizeOf ( LONGINT ) ) ;       --;
;--                                                           --;
;---------------------------------------------------------------;

HexStr PROC FAR num:DWORD,byteCount:BYTE RETURNS resultPtr:DWORD

                LOCALS  @@

                les     di,resultPtr    ;get address of function result

                mov     dx,ds           ;save Turbo's DS in DX

                lds     si,num          ;get number address

                mov     al,byteCount    ;how many bytes?

                xor     ah,ah           ;make a word

                mov     cx,ax           ;keep track of bytes in CX

                add     si,ax           ;start from MS byte of number

                dec     si

                shl     ax,1            ;how many digits? (byte/2)

                cld                     ;store # digits (going forward)

                stosb                   ;in destination string's length
                                        ; byte

@@HexLoop:
                std                     ;scan number from MSB to LSB

                lodsb                   ;get next byte

                mov     ah,al           ;save it

                shr     al,1            ;extract high nibble

                shr     al,1

                shr     al,1

                shr     al,1

                add     al,90h          ;special hex conversion
                                        ; sequence

                daa                     ;using ADDs and DAA's

                adc     al,40h

                daa                     ;nibble now converted to ASCII

                cld                     ;store ASCII going up

                stosb

                mov     al,ah           ;repeat conversion for low
                                        ; nibble

                and     al,0Fh

                add     al,90h

                daa

                adc     al,40h

                daa

                stosb

                loop    @@HexLoop       ;keep going until done

                mov     ds,dx           ;restore Turbo's DS

                ret

ENDP            HexStr

ENDS            CODE

                END                     ; END OF SOURCE
