
{*******************************************************}
{                                                       }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1994 Stefan Milius                }
{                                                       }
{*******************************************************}

{ Portions Copyright (c) 1992 Borland International }

{
  GVSTDDLG.TXT GVSTDDLG.DOC GINFO.TXT NEW.TXT GV.VER
}

Unit GVStdDlg;

{$A+,B-,D+,F+,G+,O+,R-,S-,X+,I-,V-}

Interface

{$ifdef Windows}
uses Objects, Drivers, WinGr, Views, GVViews, GVDialog, GVMsgBox, WinDos, Dos;
{$else}
uses Objects, Drivers, Views, GVViews, GVDialog, GVMsgBox, Dos;
{$endif}

Const

{ Palettes }

  CFileInfoPane = #141#140;

{ Commands }

  cmFileOpen    = 800;   { Returned from TFileDialog when Open pressed }
  cmFileReplace = 801;   { Returned from TFileDialog when Replace pressed }
  cmFileClear   = 802;   { Returned from TFileDialog when Clear pressed }
  cmFileInit    = 803;   { Used by TFileDialog internally }
  cmChangeDir   = 804;   { Used by TChDirDialog internally }
  cmRevert      = 805;   { Used by TChDirDialog internally }

{ Messages }

  cmFileFocused = 806;    { A new file was focused in the TFileList }
  cmFileDoubleClicked     { A file was selected in the TFileList }
                = 807;

Type

{ TSearchRec record }

  {  Record used to store directory information by TFileDialog }

  TSearchRec = record
    Attr: Byte;
    Time: LongInt;
    Size: LongInt;
    Name: String[12];
  end;

Type

{ TFileInputLine object }

  { TFileInputLine is a special input line that is used by      }
  { TFileDialog that will update its contents in response to a  }
  { cmFileFocused command from a TFileList.                     }

  PFileInputLine = ^TFileInputLine;
  TFileInputLine = Object (TInputLine)
    constructor Init(var Bounds: TRect; AMaxLen: Integer);
    procedure HandleEvent(var Event: TEvent); virtual;
  end;

{ TFileCollection object }

  { TFileCollection is a collection of TSearchRec's.            }

  PFileCollection = ^TFileCollection;
  TFileCollection = Object (TSortedCollection)
    function Compare (Key1, Key2: Pointer): Integer; virtual;
    procedure FreeItem (Item: Pointer); virtual;
    function GetItem (var S: TStream): Pointer; virtual;
    procedure PutItem (var S: TStream; Item: Pointer); virtual;
  end;

{ TSortedListBox object }

  { TSortedListBox is a TListBox that assumes it has a          }
  { TSortedCollection instead of just a TCollection.  It will   }
  { perform an incremental search on the contents.              }

  PSortedListBox = ^TSortedListBox;
  TSortedListBox = Object (TListBox)
    SearchPos: Word;
    ShiftState: Byte;
    constructor Init(var Bounds: TRect; AScrollBar: PScrollBar);
    procedure HandleEvent (var Event: TEvent); virtual;
    function GetKey (var S: String): Pointer; virtual;
    procedure NewList (AList: PCollection); virtual;
  end;

{ TFileList object }

  { TFileList is a TSortedList box that assumes it contains     }
  { a TFileCollection as its collection.  It also communicates  }
  { through broadcast messages to TFileInput and TInfoPane      }
  { what file is currently selected.                            }

  PFileList = ^TFileList;
  TFileList = Object (TSortedListBox)
    constructor Init (var Bounds: TRect; AWildCard: PathStr;
      AScrollBar: PScrollBar);
    destructor Done; virtual;
    function DataSize: Word; virtual;
    procedure FocusItem (Item: Integer); virtual;
    procedure GetData (var Rec); virtual;
    function GetText (Item: Integer; MaxLen: Integer): String; virtual;
    function GetKey (var S: String): Pointer; virtual;
    procedure HandleEvent (var Event: TEvent); virtual;
    procedure ReadDirectory (AWildCard: PathStr);
    procedure SetData (var Rec); virtual;
  end;

{ TFileInfoPane object }

  { Palette layout }
  { 1 = Background }
  { 2 = Text       }

  { TFileInfoPane is a TView that displays the information      }
  { about the currently selected file in the TFileList          }
  { of a TFileDialog.                                           }

  PFileInfoPane = ^TFileInfoPane;
  TFileInfoPane = Object (TGView)
    S: TSearchRec;
    constructor Init(var Bounds: TRect);
    constructor Load(var Str: TStream);
    procedure ChangeBounds (var Bounds: TRect); virtual;
    procedure Draw; virtual;
    function GetPalette: PPalette; virtual;
    procedure HandleEvent (var Event: TEvent); virtual;
    procedure SetState (AState: Word; Enable: Boolean); virtual;
  private
    Flag: Boolean;
    Path: PathStr;
  end;

  { TFileDialog is a standard file name input dialog            }

  TWildStr = PathStr;

const

  fdOkButton      = $0001;      { Put an OK button in the dialog }
  fdOpenButton    = $0002;      { Put an Open button in the dialog }
  fdReplaceButton = $0004;      { Put a Replace button in the dialog }
  fdClearButton   = $0008;      { Put a Clear button in the dialog }
  fdHelpButton    = $0010;      { Put a Help button in the dialog }
  fdNoLoadDir     = $0100;      { Do not load the current directory }
				{ contents into the dialog at Init. }
                                { This means you intend to change the }
                                { WildCard by using SetData or store }
                                { the dialog on a stream. }

type

{ TFileDialog object }

  PFileDialog = ^TFileDialog;
  TFileDialog = Object (TDialog)
    FileName: PFileInputLine;
    FileList: PFileList;
    WildCard: TWildStr;
    Directory: PString;
    constructor Init (AWildCard: TWildStr; ATitle: String;
      InputName: String; AOptions: Word; HistoryId: Byte);
    constructor Load (var S: TStream);
    destructor Done; virtual;
    procedure GetData (var Rec); virtual;
    procedure GetFileName (var S: PathStr);
    procedure HandleEvent (var Event: TEvent); virtual;
    procedure SetData (var Rec); virtual;
    procedure Store (var S: TStream);
    function Valid (Command: Word): Boolean; virtual;
  private
    procedure ReadDirectory;
  end;

{ TDirEntry record }

  PDirEntry = ^TDirEntry;
  TDirEntry = Record
    DisplayOpt: Word;
    Directory: PString;
  end;

{ TDirCollection object }

  { TDirCollection is a collection of TDirEntry's used by       }
  { TDirListBox.                                                }

  PDirCollection = ^TDirCollection;
  TDirCollection = Object (TCollection)
    function GetItem (var S: TStream): Pointer; virtual;
    procedure FreeItem (Item: Pointer); virtual;
    procedure PutItem (var S: TStream; Item: Pointer); virtual;
  end;

{ TDirListBox object }

  { TDirListBox displays a tree of directories for use in the }
  { TChDirDialog.                                               }

  PDirListBox = ^TDirListBox;
  TDirListBox = Object (TListBox)
    Dir: DirStr;
    Cur: Word;
    constructor Init (var Bounds: TRect; AScrollBar: PScrollBar);
    destructor Done; virtual;
    procedure DrawItemText (Item: Integer; R: TRect); virtual;
    function GetText (Item: Integer; MaxLen: Integer): String; virtual;
    procedure HandleEvent (var Event: TEvent); virtual;
    function IsSelected (Item: Integer): Boolean; virtual;
    procedure NewDirectory (var ADir: DirStr);
    procedure SetState (AState: Word; Enable: Boolean); virtual;
  end;

{ TChDirDialog object }

  { TChDirDialog is a standard change directory dialog.         }

Const

  cdNormal     = $0000; { Option to use dialog immediately }
  cdNoLoadDir  = $0001; { Option to init the dialog to store on a stream }
  cdHelpButton = $0002; { Put a help button in the dialog }

Type

  PChDirDialog = ^TChDirDialog;
  TChDirDialog = object(TDialog)
    DirInput: PInputLine;
    DirList: PDirListBox;
    OkButton: PButton;
    ChDirButton: PButton;
    constructor Init (AOptions: Word; HistoryId: Byte);
    constructor Load (var S: TStream);
    function DataSize: Word; virtual;
    procedure GetData (var Rec); virtual;
    procedure HandleEvent (var Event: TEvent); virtual;
    procedure SetData (var Rec); virtual;
    procedure Store (var S: TStream);
    function Valid (Command: Word): Boolean; virtual;
  private
    procedure SetUpDialog;
  end;

Const

{ TStream registration records }

  RFileInputLine: TStreamRec = (
     ObjType: 160;
     VmtLink: Ofs(TypeOf(TFileInputLine)^);
     Load:    @TFileInputLine.Load;
     Store:   @TFileInputLine.Store);

  RFileCollection: TStreamRec = (
     ObjType: 161;
     VmtLink: Ofs(TypeOf(TFileCollection)^);
     Load:    @TFileCollection.Load;
     Store:   @TFileCollection.Store);

  RFileList: TStreamRec = (
     ObjType: 162;
     VmtLink: Ofs(TypeOf(TFileList)^);
     Load:    @TFileList.Load;
     Store:   @TFileList.Store);

  RFileInfoPane: TStreamRec = (
     ObjType: 163;
     VmtLink: Ofs(TypeOf(TFileInfoPane)^);
     Load:    @TFileInfoPane.Load;
     Store:   @TFileInfoPane.Store);

  RFileDialog: TStreamRec = (
     ObjType: 164;
     VmtLink: Ofs(TypeOf(TFileDialog)^);
     Load:    @TFileDialog.Load;
     Store:   @TFileDialog.Store);

  RDirCollection: TStreamRec = (
     ObjType: 165;
     VmtLink: Ofs(TypeOf(TDirCollection)^);
     Load:    @TDirCollection.Load;
     Store:   @TDirCollection.Store);

  RDirListBox: TStreamRec = (
     ObjType: 166;
     VmtLink: Ofs(TypeOf(TDirListBox)^);
     Load:    @TDirListBox.Load;
     Store:   @TDirListBox.Store);

  RChDirDialog: TStreamRec = (
     ObjType: 167;
     VmtLink: Ofs(TypeOf(TChDirDialog)^);
     Load:    @TChDirDialog.Load;
     Store:   @TChDirDialog.Store);

procedure RegisterGVStdDlg;

Implementation

{$ifdef Windows}
uses GvApp, OMemory, ExtGraph, Misc, GvTexts;
{$else}
uses GVDriver, GVApp, Memory, Gr, MetaGr, ExtGraph, Misc, MyFonts, GVTexts;
{$endif}

const

{ TDirEntry DisplayOpt values }

  doDrivesText = 0;
  doDrive      = 256;
  doPathDir    = 512;
  doFirstDir   = 768;
  doMiddleDir  = 1024;
  doLastDir    = 1280;

Type PSearchRec = ^TSearchRec;

(************************** Internal used procedures ************************)

(*function DriveValid (Drive: Char): Boolean; assembler;
asm
        CALL    DosVersion
        CMP     AL,3
        JL      @@0
        MOV     AX, 4408H
	MOV	BL, Drive
        SUB	BL,'A'-1
        INT     21H
        CMP     AX,1       { exitierte ebenfalls nicht     }
        JZ      @@1        { nderung S.M. vorher: JNC @@1 }
@@0:    MOV	AH, 36H
        MOV     DL,Drive
        SUB	DL,'A'-1
        INT	21H
        INC	AX
        JE	@@2
@@1:	MOV	AL,1
@@2:
End;*)


{ modified TV 1.0 routine replaced by TV 2.0 routine }

function DriveValid(Drive: Char): Boolean; near; assembler;
asm
	MOV	AH,19H          { Save the current drive in BL }
        INT	21H
        MOV	BL,AL
 	MOV	DL,Drive	{ Select the given drive }
        SUB	DL,'A'
        MOV	AH,0EH
        INT	21H
        MOV	AH,19H		{ Retrieve what DOS thinks is current }
        INT	21H
        MOV	CX,0		{ Assume false }
        CMP	AL,DL		{ Is the current drive the given drive? }
	JNE	@@1
        MOV	CX,1		{ It is, so the drive is valid }
	MOV	DL,BL		{ Restore the old drive }
        MOV	AH,0EH
        INT	21H
@@1:	XCHG	AX,CX		{ Put the return value into AX }
end;

function PathValid(var Path: PathStr): Boolean;
var
  ExpPath: PathStr;
  F: File;
  SR: SearchRec;
begin
  ExpPath := FExpand(Path);
  if Length(ExpPath) <= 3 then PathValid := DriveValid(ExpPath[1])
  else
  begin
    if ExpPath[Length(ExpPath)] = '\' then Dec(ExpPath[0]);
    FindFirst(ExpPath, Directory, SR);
    PathValid := (DosError = 0) and (SR.Attr and Directory <> 0);
  end;
end;

function ValidFileName(var FileName: PathStr): Boolean;
const
  IllegalChars = ';,=+<>|"[] \';
var
  Dir: DirStr;
  Name: NameStr;
  Ext: ExtStr;

{ Contains returns true if S1 contains any characters in S2 }
function Contains(S1, S2: String): Boolean; near; assembler;
asm
	PUSH	DS
        CLD
        LDS	SI,S1
        LES	DI,S2
        MOV	DX,DI
        XOR	AH,AH
        LODSB
        MOV	BX,AX
        OR      BX,BX
        JZ      @@2
        MOV	AL,ES:[DI]
        XCHG	AX,CX
@@1:	PUSH	CX
	MOV	DI,DX
	LODSB
        REPNE	SCASB
        POP	CX
        JE	@@3
	DEC	BX
        JNZ	@@1
@@2:	XOR	AL,AL
	JMP	@@4
@@3:	MOV	AL,1
@@4:	POP	DS
end;

begin
  ValidFileName := True;
  FSplit(FileName, Dir, Name, Ext);
  if not ((Dir = '') or PathValid(Dir)) or Contains(Name, IllegalChars) or
    Contains(Dir, IllegalChars) then ValidFileName := False;
end;

function GetCurDir: DirStr;
var
  CurDir: DirStr;
begin
  GetDir(0, CurDir);
  if Length(CurDir) > 3 then
  begin
    Inc(CurDir[0]);
    CurDir[Length(CurDir)] := '\';
  end;
  GetCurDir := CurDir;
end;

function IsWild(var S: String): Boolean;
begin
  IsWild := (Pos('?',S) > 0) or (Pos('*',S) > 0);
end;

function IsDir(var S: String): Boolean;
var SR: SearchRec;
begin
  FindFirst(S, Directory, SR);
  if DosError = 0 then
    IsDir := SR.Attr and Directory <> 0
  else IsDir := False;
end;

(************************** TFileInputLine object ***************************)

constructor TFileInputLine.Init;
begin
  TInputLine.Init (Bounds, AMaxLen);
  EventMask := EventMask or evBroadcast;
end;

procedure TFileInputLine.HandleEvent;
var Dir: DirStr;
    Name: NameStr;
    Ext: ExtStr;
Begin
  TInputLine.HandleEvent(Event);
  If (Event.What = evBroadcast) and (Event.Command = cmFileFocused) and
    (State and sfSelected = 0) then Begin
    If PSearchRec(Event.InfoPtr)^.Attr and Directory <> 0 then
      Data^:=PSearchRec(Event.InfoPtr)^.Name+'\'+PFileDialog(Owner)^.WildCard
    Else
      Data^ := PSearchRec(Event.InfoPtr)^.Name;
    DrawView;
  End;
End;

(************************** TFileCollection object **************************)

function TFileCollection.Compare;
Begin
  If PSearchRec (Key1)^.Name = PSearchRec (Key2)^.Name then Compare:=0
  Else
    If PSearchRec(Key1)^.Name = '..' then Compare:=1
    Else
      If PSearchRec(Key2)^.Name = '..' then Compare:=-1
      Else
        If (PSearchRec(Key1)^.Attr and Directory <> 0) and
           (PSearchRec(Key2)^.Attr and Directory = 0) then Compare:=1
        Else
          If (PSearchRec(Key2)^.Attr and Directory <> 0) and
             (PSearchRec(Key1)^.Attr and Directory = 0) then Compare:=-1
          Else
            If PSearchRec(Key1)^.Name > PSearchRec(Key2)^.Name then Compare:=1
            Else
              Compare := -1;
end;

procedure TFileCollection.FreeItem;
Begin Dispose(PSearchRec(Item)) End;

function TFileCollection.GetItem;
var Item: PSearchRec;
Begin
  New (Item);
  S.Read (Item^, SizeOf (TSearchRec));
  GetItem:=Item;
End;

procedure TFileCollection.PutItem;
Begin
  S.Write (Item^, SizeOf (TSearchRec));
End;

(************************** TSortedListBox object ***************************)

constructor TSortedListBox.Init;
Begin
  TListBox.Init (Bounds, AScrollBar);
  SearchPos:=0;
End;

procedure TSortedListBox.HandleEvent;
var CurString, NewString: String;
    K: Pointer;
    Value, OldPos, OldValue: Integer;
    T: Boolean;

 function Equal(var S1: String; var S2: String; Count: Word): Boolean;
 var I: Word;
 Begin
   Equal:=False;
   if (Length(S1) < Count) or (Length(S2) < Count) then Exit;
   for I:=1 to Count do
     if UpCase(S1[I]) <> UpCase(S2[I]) then Exit;
   Equal:=True;
 End;

Begin
  OldValue := Focused;
  TListBox.HandleEvent (Event);
  If OldValue <> Focused then SearchPos:=0;
  If Event.What = evKeyDown then Begin
    If Event.CharCode <> #0 then Begin
      Value:=Focused;
      If Value < Range then CurString:=GetText(Value, 255)
                       else CurString:='';
      OldPos := SearchPos;
      While CurString [1]=' ' do Delete (CurString,1,1);
      If Event.KeyCode = kbBack then Begin
        If SearchPos = 0 then Exit;
        Dec (SearchPos);
        If SearchPos = 0 then ShiftState := GetShiftState;
        CurString[0]:=Char (SearchPos);
      End
      Else If (Event.CharCode = '.') then SearchPos:=Pos('.',CurString)
           Else Begin
             Inc(SearchPos);
             if SearchPos = 1 then ShiftState := GetShiftState;
             CurString[0]:=Char (SearchPos);
             CurString[SearchPos]:=Event.CharCode;
           End;
      K := GetKey (CurString);
      T := PSortedCollection (List)^.Search (K, Value);
      If Value < Range then Begin
        If Value < Range then NewString:=GetText (Value, 255)
                         else NewString := '';
        While NewString [1]=' ' do Delete (NewString,1,1);
        If Equal (NewString, CurString, SearchPos) then Begin
          If Value <> OldValue then FocusItem (Value);
        End
        Else SearchPos:=OldPos;
      End
      Else SearchPos:=OldPos;
      If (SearchPos <> OldPos) or (Event.CharCode in ['A'..'Z','a'..'z']) then
        ClearEvent (Event);
    End;
  End;
End;

function TSortedListBox.GetKey;
Begin GetKey:=@S End;

procedure TSortedListBox.NewList;
Begin
  TListBox.NewList (AList);
  SearchPos:=0;
End;

(****************************** TFileList object ****************************)

constructor TFileList.Init;
Begin
  TSortedListBox.Init(Bounds, AScrollBar);
End;

destructor TFileList.Done;
Begin
  If List <> nil then Dispose (List, Done);
  TListBox.Done;
End;

function TFileList.DataSize;
Begin DataSize:=0 End;

procedure TFileList.FocusItem;
var OldF: Integer;
Begin
  OldF:=Focused;
  TSortedListBox.FocusItem (Item);
  {If OldF<>Focused then}
    Message (GOwner, evBroadcast, cmFileFocused, List^.At(Item));
End;

procedure TFileList.GetData;
Begin
End;

function TFileList.GetKey;
Const SR: TSearchRec = ();

 procedure UpStr(var S: String);
 var I: Integer;
 Begin
   For I:=1 to Length (S) do S[I]:=UpCase(S[I]);
 End;

Begin
  If (ShiftState and $03 <> 0) or ((S <> '') and (S[1]='.')) then
    SR.Attr:=Directory
  Else SR.Attr:=0;
  SR.Name:=S;
  UpStr (SR.Name);
  GetKey:=@SR;
End;

function TFileList.GetText;
var S: String;
    SR: PSearchRec;
Begin
  SR:=PSearchRec(List^.At(Item));
  S:=SR^.Name;
  If SR^.Attr and Directory <> 0 then Begin
    S[Length (S)+1]:='\';
    Inc (S[0]);
  End;
  GetText:='    '+S;
End;

procedure TFileList.HandleEvent;
Begin
  If (Event.What = evMouseDown) and (Event.Double) then Begin
    If MouseInView (Event.Where) then Begin
       Event.What:=evCommand;
       Event.Command:=cmDefault;
       PutEvent(Event);
       ClearEvent(Event);
    End
  End
  Else TSortedListBox.HandleEvent(Event);
End;

procedure TFileList.ReadDirectory;
const FindAttr = ReadOnly + Archive;
      AllFiles = '*.*';
      PrevDir  = '..';

var S: SearchRec;
    P: PSearchRec;
    FileList: PFileCollection;
    NumFiles: Word;
    CurPath: PathStr;
    Dir: DirStr;
    Name: NameStr;
    Ext: ExtStr;
    Event: TEvent;
    Tmp: PathStr;
    Flag: Integer;

Begin
  NumFiles:=0;
  AWildCard:=FExpand (AWildCard);
  FSplit (AWildCard, Dir, Name, Ext);
  FileList:=New (PFileCollection, Init (5,5));
  FindFirst (AWildCard, FindAttr, S);
  P:=@P;
  While (P <> nil) and (DosError = 0) do Begin
    If (S.Attr and Directory = 0) then Begin
      P:=MemAlloc (SizeOf(P^));
      If P<>nil then Begin
        System.Move (S.Attr, P^, SizeOf(P^));
        FileList^.Insert(P);
      End;
    End;
    FindNext(S);
  end;
  Tmp:=Dir+AllFiles;
  FindFirst (Tmp, Directory, S);
  While (P <> nil) and (DosError = 0) do Begin
    If (S.Attr and Directory <> 0) and (S.Name[1] <> '.') then Begin
      P:=MemAlloc (SizeOf(P^));
      If P <> nil then Begin
        System.Move (S.Attr, P^, SizeOf(P^));
        FileList^.Insert (PObject(P));
      End;
    End;
    FindNext(S);
  End;
  If Length (Dir) > 4 then Begin
    P:=MemAlloc (SizeOf(P^));
    If P <> nil then Begin
      FindFirst (Tmp, Directory, S);
      FindNext (S);
      If (DosError = 0) and (S.Name = PrevDir) then
        System.Move (S.Attr, P^, SizeOf(P^))
      Else Begin
        P^.Name:=PrevDir;
        P^.Size:=0;
        P^.Time:=$210000;
        P^.Attr:=Directory;
      End;
      FileList^.Insert(PObject(P));
    End;
  End;
  If P = nil then MessageBox (GetStr(89), nil, mfOkButton + mfWarning);
  NewList (FileList);
  If List^.Count > 0 then Begin
    Event.What:=evBroadcast;
    Event.Command:=cmFileFocused;
    Event.InfoPtr:=List^.At(0);
    GOwner^.HandleEvent(Event);
  End;
End;

procedure TFileList.SetData;
Begin
  With PFileDialog (GOwner)^ do
    Self.ReadDirectory (Directory^+WildCard);
End;

(************************** TFileInfoPane object ****************************)

constructor TFileInfoPane.Init;
Begin
  TGView.Init(Bounds);
  EventMask:=EventMask or evBroadcast;
  Flag:=False;
  Path:=' ';
End;

constructor TFileInfoPane.Load;
Begin
  TGView.Load (Str);
  Flag:=False;
  Path:=' ';
End;

procedure TFileInfoPane.ChangeBounds;
Begin
  Path[2]:=' ';
  TGView.ChangeBounds (Bounds);
End;

procedure TFileInfoPane.Draw;
var R: TRect;
    D: String[11];
    M: String[3];
    C: Word;
    Time: DateTime;
    P: PathStr;
    FmtId: String;
    Params: array[0..6] of LongInt;
    Str: String[80];
const
  sFileLine: String[34] = ' %-12s %-9d %3s %2d, %4d  %2d:%02d';
begin
  SetViewPort;
  HideMouse;
  { Display path }
  P:=' '+FExpand(PFileDialog(GOwner)^.Directory^+PFileDialog(GOwner)^.WildCard);
  If P<>Path then Begin Path:=P; Flag:=True End;
  SetFillStyle (SolidFill, GetColor (1));
  C:=GetColor (2);
  SetGVStyle (ftMonoSpace);
  If Flag then Begin
    Bar (0, 0, Size.X-1, 14);
    R.Assign (1, 1, Size.X-1, 14);
    OutGVText (R.A, Path, C,C, R.B, False);
    Flag := false;
  End;
  { Display file }
  Params[0] := LongInt(@S.Name);
  If S.Attr and Directory <> 0 then
  Begin
    FmtId:=GetStr(90);
    D:=GetStr(103);
    Params[1] := LongInt(@D);
  End
  Else Begin
    FmtId:=sFileLine;
    Params[1]:=S.Size;
  End;
  UnpackTime (S.Time, Time);
  M:=GetStr(90 + Time.Month);
  Params[2]:=LongInt(@M);
  Params[3]:=Time.Day;
  Params[4]:=Time.Year;
  Params[5]:=Time.Hour;
  Params[6]:=Time.Min;
  FormatStr (Str, FmtId, Params);
  Bar (0, 15, Size.X-1, Size.Y-1);
  R.Assign (1, 16, Size.X-1, 14);
  OutGVText (R.A, Str, C,C, R.B, False);
  ShowMouse;
  RestoreViewPort;
end;

function TFileInfoPane.GetPalette;
const P: String [Length (CFileInfoPane)] = CFileInfoPane;
Begin
  GetPalette := @P;
End;

procedure TFileInfoPane.HandleEvent(var Event: TEvent);
begin
  TGView.HandleEvent(Event);
  If (Event.What = evBroadcast) and (Event.Command = cmFileFocused) then Begin
    S := PSearchRec (Event.InfoPtr)^;
    DrawView;
  End;
End;

procedure TFileInfoPane.SetState;
Begin
  {
  If (AState and sfExposed <>0) and Enable and not Exposed then Flag:=True;
  }
  If (AState = sfDragging) and not Enable then Flag := true;
  TGView.SetState (AState, Enable);
End;

(*************************** TFileDialog object *****************************)

constructor TFileDialog.Init;
var Control: PGView;
    R: TRect;
    S: String;
    Opt: Word;
    ACurDir: PathStr;
begin
  R.Assign(0,0,365,305);
  TDialog.Init (R, ATitle);
  Options:=Options or ofCentered;
  WildCard := AWildCard;

  R.Assign(15,53,203,73);
  FileName := New (PFileInputLine, Init(R, 79));
  FileName^.Data^ := WildCard;
  SetTextParams (ftSansSerif,0,0,True);
  R.Assign (15,30,25+TextWidth (InputName),50);
  Control:=New (PLabel, Init (R, InputName, FileName));
  Insert (FileName);
  Insert (Control);
  R.Assign(202, 53, 220, 73);
  Control := New(PHistory, Init(R, FileName, HistoryId));
  Insert(Control);

  R.Assign (202,110,220,251);
  Control:=New (PScrollBar, Init(R));
  R.Assign(15,110,203,251);
  FileList:=New (PFileList, Init (R, WildCard, PScrollBar(Control)));
  Insert (Control);
  R.Assign (15,85,80,105);
  Control:=New (PLabel, Init (R, GetStr(104), FileList));
  Insert (FileList);
  Insert (Control);

  R.Assign (240,30,340,55);
  Opt:=bfDefault;
  If AOptions and fdOpenButton <> 0 then Begin
    Insert (New (PButton, Init (R, GetStr(105), cmFileOpen, Opt)));
    Opt:=bfNormal;
    R.Move (0,35);
  End;
  If AOptions and fdOkButton <> 0 then Begin
    Insert (New (PButton, Init (R, GetStr(106), cmFileOpen, Opt)));
    Opt:=bfNormal;
    R.Move (0,35);
  End;
  If AOptions and fdReplaceButton <> 0 then Begin
    Insert (New (PButton, Init (R, GetStr(107),cmFileReplace, Opt)));
    Opt:=bfNormal;
    R.Move (0,35);
  End;
  If AOptions and fdClearButton <> 0 then Begin
    Insert (New (PButton, Init (R, GetStr(108),cmFileClear, Opt)));
    Opt:=bfNormal;
    R.Move (0,35);
  End;
  Insert (New (PButton, Init (R, GetStr(109), cmCancel, bfNormal)));
  R.Move (0,35);
  If AOptions and fdHelpButton <> 0 then Begin
    Control:=New (PButton, Init (R, GetStr(110),cmHelp, bfNormal));
    Insert (Control);
    R.Move (0,35);
  End;

  GetExtent (R);
  R.Grow (-6,-6);
  R.A.Y:=R.B.Y-30;
  Control := New (PFileInfoPane, Init(R));
  Insert(Control);

  SelectNext (false);

  If AOptions and fdNoLoadDir = 0 then ReadDirectory;
End;

constructor TFileDialog.Load;
var ACurDir: DirStr;
    ViewId: Word;
Begin
  TDialog.Load(S);
  S.Read (WildCard, SizeOf(TWildStr));
  GetSubViewPtr(S, FileName);
  GetSubViewPtr(S, FileList);

  ReadDirectory;
  SelectNext (false);
End;

destructor TFileDialog.Done;
Begin
  DisposeStr (Directory);
  TDialog.Done;
End;

procedure TFileDialog.GetData;
Begin
  GetFilename (PathStr(Rec));
End;

procedure TFileDialog.GetFileName;
var Path: PathStr;
    Name: NameStr;
    Ext: ExtStr;
    TPath: PathStr;
    TName: NameStr;
    TExt: NameStr;

 function LTrim (S: String): String;
 var I: Integer;
 Begin
   I:=1;
   While (I < Length(S)) and (S[I] = ' ') do Inc(I);
   LTrim:=Copy(S, I, 255);
 End;

 function RTrim (S: String): String;
 var I: Integer;
 Begin
   While S[Length(S)] = ' ' do Dec(S[0]);
   RTrim:=S;
 End;

 function RelativePath (var S: PathStr): Boolean;
 var I, J: Integer;
     P: PathStr;
 Begin
   S:=LTrim(RTrim(S));
   If (S <> '') and ((S[1] = '\') or (S[2] = ':')) then RelativePath:=False
                                                   else RelativePath:=True;
 End;

 function NoWildChars(S: String): String; Assembler;
 asm
	 PUSH	DS
	 LDS	SI,S
         XOR     AX,AX
	 LODSB
	 XCHG	AX,CX
         LES     DI,@Result
         INC     DI
         JCXZ    @@3
 @@1:	 LODSB
	 CMP	AL,'?'
	 JE	@@2
	 CMP	AL,'*'
	 JE	@@2
	 STOSB
 @@2:	 LOOP	@@1
 @@3:    XCHG	AX,DI
	 MOV	DI,WORD PTR @Result
	 SUB	AX,DI
         DEC     AX
	 STOSB
	 POP	DS
 End;

Begin
  S:=FileName^.Data^;
  If RelativePath (S) then S:=FExpand (Directory^ + S)
                      else S:=FExpand (S);
  FSplit (S, Path, Name, Ext);
  If ((Name = '') or (Ext = '')) and not IsDir(S) then Begin
    FSplit (WildCard, TPath, TName, TExt);
    If ((Name = '') and (Ext = '')) then S := Path + TName + TExt
    Else
      If Name = '' then S := Path + TName + Ext
      Else
	If Ext = '' then Begin
          If IsWild(Name) then S := Path + Name + TExt
          Else
            S := Path + Name + NoWildChars(TExt);
	End;
  End;
End;

procedure TFileDialog.HandleEvent;
Begin
  TDialog.HandleEvent(Event);
  If Event.What = evCommand then
    Case Event.Command of
      cmFileOpen, cmFileReplace, cmFileClear:
        Begin
          EndModal (Event.Command);
          ClearEvent (Event);
        End;
    End;
End;

procedure TFileDialog.SetData;
Begin
  TDialog.SetData (Rec);
  If (PathStr(Rec) <> '') and (IsWild (TWildStr(Rec))) then Begin
    Valid (cmFileInit);
    FileName^.Select;
  End;
End;

procedure TFileDialog.ReadDirectory;
Begin
  FileList^.ReadDirectory (WildCard);
  Directory:=NewStr (GetCurDir);
End;

procedure TFileDialog.Store;
Begin
  TDialog.Store(S);
  S.Write (WildCard, SizeOf (TWildStr));
  PutSubViewPtr (S, FileName);
  PutSubViewPtr (S, FileList);
End;

function TFileDialog.Valid;
var T: Boolean;
    FName: PathStr;
    Dir: DirStr;
    Name: NameStr;
    Ext: ExtStr;

 function CheckDirectory (var S: PathStr): Boolean;
 Begin
   If not PathValid (S) then Begin
     MessageBox (GetStr(111), nil, mfError + mfOkButton);
     FileName^.Select;
     CheckDirectory:=False;
   End
   Else CheckDirectory:=True;
 End;

Begin
  If Command = 0 then Begin
    Valid:=True;
    Exit;
  End
  Else Valid := False;
  If TDialog.Valid (Command) then Begin
    GetFileName (FName);
    If (Command <> cmCancel) and (Command <> cmFileClear) and (Command <> cmClose) then Begin
      If IsWild (FName) then Begin
        FSplit (FName, Dir, Name, Ext);
        If CheckDirectory (Dir) then Begin
          DisposeStr (Directory);
          Directory:=NewStr (Dir);
          WildCard:=Name+Ext;
          If Command <> cmFileInit then FileList^.Select;
          FileList^.ReadDirectory (Directory^+WildCard);
        End
      End
      Else If IsDir (FName) then Begin
             If CheckDirectory (FName) then Begin
               DisposeStr (Directory);
	       Directory:=NewStr (FName+'\');
               If Command <> cmFileInit then FileList^.Select;
               FileList^.ReadDirectory(Directory^+WildCard);
             End
           End
           Else If ValidFileName (FName) then Valid:=True
                Else Begin
                  MessageBox(GetStr(112), nil, mfError + mfOkButton);
                  Valid:=False;
                End
      End
      Else Valid:=True;
  End;
End;

(************************** TDirCollection object ***************************)

function TDirCollection.GetItem;
var DirItem: PDirEntry;
Begin
  New (DirItem);
  S.Read(DirItem^.DisplayOpt, SizeOf(Word));
  DirItem^.Directory:=S.ReadStr;
  GetItem:=DirItem;
End;

procedure TDirCollection.FreeItem;
var DirItem: PDirEntry absolute Item;
Begin
  DisposeStr (DirItem^.Directory);
  Dispose (DirItem);
End;

procedure TDirCollection.PutItem;
var DirItem: PDirEntry absolute Item;
Begin
  S.Write(DirItem^.DisplayOpt, SizeOf(Word));
  S.WriteStr (DirItem^.Directory);
End;

(**************************** TDirListBox object ****************************)

constructor TDirListBox.Init;
Begin
  TListBox.Init(Bounds, AScrollBar);
  Dir:='';
End;

destructor TDirListBox.Done;
Begin
  If List <> nil then Dispose (List, Done);
  TListBox.Done;
End;

procedure TDirListBox.DrawItemText(Item: Integer; R: TRect);
var S: String;
    CurOpt: Word;
    Color: Word;
    Icon: Word;
Begin
  S := GetText(Item, $FF);
  CurOpt := PDirEntry(List^.At(Item))^.DisplayOpt;

  While TextWidth(S) > R.B.X do Dec(S[0]);
  If Length(S) <> 3 then
    While Pos('\',S) <> 0 do Delete(S, 1, Pos('\',S))
  Else If CurOpt and $FF00 = doDrive then Dec(S[0], 2);
  R.Grow(-5, 0);
  SetSubRect(R);

  If (State and sfSelected<>0) and (Item = Focused) then Color := 15
						    else Color := 0;
  case CurOpt and $FF00 of
    doPathDir:
      If IsSelected(Item) then Icon := 27 else Icon := 26;
    doDrive:
      Icon := 27 + GetDriveType(S[1]);
    doDrivesText:
      begin
	Dec(R.A.X, 10);
	Icon := 0;
      end;
   else
     Icon := 25;
  end;

  If Icon <> 0
  then DrawColIcon(R.A.X + Lo(CurOpt) * 10,
    (R.A.Y + R.B.Y - DrawIcon(0, 0, Icon, $FFFF)) div 2, Icon, Color);

  Dec(R.B.Y, R.A.Y);
  OutTextXY(R.A.X + 20 + Lo(CurOpt) * 10, R.A.Y + R.B.Y div 2 + 1, S);
End;

function TDirListBox.GetText;
Begin
  GetText:=PDirEntry (List^.At(Item))^.Directory^;
End;

procedure TDirListBox.HandleEvent;
Begin
  If (Event.What = evMouseDown) and (Event.Double) then Begin
    Event.What:=evCommand;
    Event.Command:=cmChangeDir;
    PutEvent(Event);
    ClearEvent(Event);
  End
  Else TListBox.HandleEvent(Event);
End;

function TDirListBox.IsSelected;
Begin
  IsSelected:=Item=Cur;
End;

procedure TDirListBox.NewDirectory;
const{ PathDir            = '';
      FirstDir           =   '';
      MiddleDir          =   ' ';
      LastDir            =   ' ';}
      IndentSize         = '  ';

var AList: PCollection;
    NewDir, Dirct: DirStr;
    C, OldC: Char;
    S: String[80];
    P: PString;
    isFirst: Boolean;
    SR: SearchRec;
    I: Integer;
    DirEntry: PDirEntry;

    Opt: Word;
    Indent: Byte;

 function NewDirEntry (DisplayOpt: Word; Directory: String): PDirEntry; near;
 var DirEntry: PDirEntry;
 Begin
   New (DirEntry);
   DirEntry^.DisplayOpt:=DisplayOpt;
   DirEntry^.Directory:=NewStr (Directory);
   NewDirEntry:=DirEntry;
 End;

 function GetCurDrive: Char; Assembler;
 Asm
	 MOV	AH,19H
         INT	21H
	 ADD	AL,'A'
 End;

Begin
  Dir:=ADir;
  AList:=New (PDirCollection, Init(5,5));
  AList^.Insert (NewDirEntry (doDrivesText,GetStr(113)));
  If Dir = GetStr(113) then Begin
    isFirst:=True;
    OldC:=' ';
    for C:='A' to 'Z' do Begin
      If ((C < 'C') and (GetDriveType(C) <> dtInvalid)) or DriveValid(C)
      then Begin
	If OldC <> ' ' then Begin
          If isFirst then Begin
	    Opt:=doDrive;
            isFirst:=False;
          End
          Else Opt:=doDrive;
	  AList^.Insert (NewDirEntry (Opt + 1, OldC + ':\'));
        End;
        If C = GetCurDrive then Cur := AList^.Count;
        OldC:=C;
      End;
    End;
    If OldC <> ' ' then AList^.Insert (NewDirEntry (doDrive + 1, OldC + ':\'));
  End
  Else Begin
    Indent:=1;
    NewDir:=Dir;
    Dirct:=Copy (NewDir,1,3);
    AList^.Insert (NewDirEntry(doPathDir + Indent, Dirct));
    Inc(Indent);
    NewDir:=Copy(NewDir,4,255);
    While NewDir <> '' do Begin
      I:=Pos ('\',NewDir);
      If I <> 0 then Begin
        S:=Copy (NewDir,1,I-1);
	Dirct := Dirct + S;
        AList^.Insert (NewDirEntry (doPathDir + Indent , Dirct));
        NewDir:=Copy(NewDir,I+1,255);
      End
      Else Begin
        Dirct:=Dirct + NewDir;
        AList^.Insert (NewDirEntry (doPathDir + Indent, Dirct));
	NewDir:='';
      End;
      Inc(Indent);
      Dirct:=Dirct + '\';
    End;
    Cur:=AList^.Count-1;
    isFirst:=True;
    NewDir:=Dirct + '*.*';
    FindFirst (NewDir, Directory, SR);
    While DosError = 0 do Begin
      If (SR.Attr and Directory <> 0) and (SR.Name[1] <> '.') then Begin
        If isFirst then	Begin
	  Opt:=doFirstDir;
	  isFirst:=False;
	End
        Else Opt:=doMiddleDir;
        AList^.Insert (NewDirEntry (Indent + Opt, Dirct + SR.Name));
      End;
      FindNext (SR);
    End;
    {
    P:=PDirEntry (AList^.At (AList^.Count-1))^.DisplayOpt;
    I:=Pos('',P^);
    If I = 0 then Begin
      I:=Pos('',P^);
      If I <> 0 then P^[I]:='';
    End
    Else Begin
      P^[I+1]:='';
      P^[I+2]:='';
    End;
    }
  End;
  NewFocus := Cur;
  If TopItem <> 0 then TopItem := 0;
  NewList (AList);
End;

procedure TDirListBox.SetState;
Begin
  TListBox.SetState (AState, Enable);
  if (AState and sfFocused <> 0) and
     (PChDirDialog(GOwner)^.ChDirButton<>nil) then
    PChDirDialog(GOwner)^.ChDirButton^.MakeDefault (Enable);
End;

(************************** TChDirDialog object *****************************)

constructor TChDirDialog.Init;
var R: TRect;
    Control: PGView;
    CurDir: DirStr;
Begin
  R.Assign(0, 0, 435, 270);
  TDialog.Init(R, GetStr(114));
  Options:=Options or (ofCenterX+ofCenterY);

  R.Assign(15, 62, 263, 82);
  DirInput:=New (PInputLine, Init(R, 68));
  R.Assign (15, 40, 150, 60);
  Control:=New (PLabel, Init (R, GetStr(119), DirInput));
  Insert (DirInput);
  Insert (Control);
  R.Assign(262, 62, 280, 82);
  Control := New(PHistory, Init(R, DirInput, HistoryId));
  Insert(Control);

  R.Assign (262, 125, 280, 252);
  Control:=New (PScrollBar, Init (R));
  R.Assign(15, 125, 263, 252);
  DirList:=New (PDirListBox, Init (R, PScrollBar(Control)));
  Insert (Control);

  R.Assign (15, 100, 150, 120);
  Control:=New (PLabel, Init (R, GetStr(120), DirList));
  Insert (DirList);
  Insert(Control);

  R.Assign(300, 40, 420, 65);
  OkButton:=New (PButton, Init(R, GetStr(115), cmOK, bfDefault));
  Insert (OkButton);
  R.Move (0,35);
  ChDirButton:=New (PButton, Init (R, GetStr(116), cmChangeDir, bfNormal));
  Insert (ChDirButton);
  R.Move (0,35);
  Insert (New (PButton, Init (R, GetStr(117), cmRevert, bfNormal)));
  If AOptions and cdHelpButton <> 0 then Begin
    R.Move (0,35);
    Control:=New (PButton, Init (R, GetStr(118), cmHelp, bfNormal));
    Insert (Control);
  End;

  If AOptions and cdNoLoadDir = 0 then SetUpDialog;

  SelectNext (false);
End;

constructor TChDirDialog.Load;
var CurDir: DirStr;
Begin
  TDialog.Load(S);
  GetSubViewPtr(S, DirList);
  GetSubViewPtr(S, DirInput);
  GetSubViewPtr(S, OkButton);
  GetSubViewPtr(S, ChDirbutton);
  SetUpDialog;
End;

function TChDirDialog.DataSize;
Begin DataSize:=0 End;

procedure TChDirDialog.GetData;
Begin
End;

procedure TChDirDialog.HandleEvent;
var CurDir: DirStr;
    P: PDirEntry;
Begin
  TDialog.HandleEvent (Event);
  Case Event.What of
    evCommand:
      Begin
        Case Event.Command of
          cmRevert: GetDir (0,CurDir);
          cmChangeDir:
            Begin
              P:=DirList^.List^.At(DirList^.Focused);
              If (P^.Directory^ = GetStr(113)) or DriveValid(P^.Directory^[1]) then
                CurDir := P^.Directory^
              Else Exit;
            End;
         else Exit;
        End;
	If (Length(CurDir) > 3) and (CurDir[Length(CurDir)] = '\') then
          CurDir:=Copy (CurDir,1,Length (CurDir)-1);
        DirList^.NewDirectory (CurDir);
        DirInput^.Data^:=CurDir;
        DirInput^.DrawView;
        DirList^.Select;
        ClearEvent(Event);
      End;
  End;
End;

procedure TChDirDialog.SetData;
Begin
End;

procedure TChDirDialog.SetUpDialog;
var CurDir: DirStr;
Begin
  If DirList <> nil then Begin
    CurDir:=GetCurDir;
    DirList^.NewDirectory (CurDir);
    If (Length(CurDir) > 3) and (CurDir[Length(CurDir)] = '\') then
      CurDir:=Copy(CurDir,1,Length(CurDir)-1);
    If DirInput <> nil then Begin
      DirInput^.Data^:=CurDir;
      DirInput^.DrawView;
    End;
  End;
End;

procedure TChDirDialog.Store;
Begin
  TDialog.Store (S);
  PutSubViewPtr (S, DirList);
  PutSubViewPtr (S, DirInput);
  PutSubViewPtr (S, OkButton);
  PutSubViewPtr (S, ChDirButton);
End;

function TChDirDialog.Valid;
var P: PathStr;
Begin
  Valid:=True;
  If Command = cmOk then Begin
    P:=FExpand (DirInput^.Data^);
    If (Length(P) > 3) and (P[Length(P)] = '\') then Dec(P[0]);
    {$I-}
    ChDir (P);
    If IOResult <> 0 then Begin
      MessageBox(GetStr(121), nil, mfError + mfOkButton);
      Valid := False;
      ChDir(DirList^.Dir);
    End;
    {$I+}
  End;
End;

(*********************** Stream registration procedure **********************)

procedure RegisterGVStdDlg;
Begin
  RegisterType (RFileInputLine);
  RegisterType (RFileCollection);
  RegisterType (RFileList);
  RegisterType (RFileInfoPane);
  RegisterType (RFileDialog);
  RegisterType (RDirCollection);
  RegisterType (RDirListBox);
  RegisterType (RChDirDialog);
End;

End.
