unit GvFiler;

{ Graphics Vision Filer
  Copr. 1996 Matthias Koeppe
}

{$A+,B-,F+,G+,I-,O+,P-,Q-,R-,S-,T-,V+,X+}

interface

uses Objects, Drivers, GvViews, GvDialog;

const
{ FilerBar flags
}
  fbConstantWidth     = $0000;
  fbProportionalWidth = $8000;

type
  PFilerSheet = ^TFilerSheet;
  TFilerSheet = object(TGGroup)
    Title: PString;
    constructor Init(var Bounds: TRect; ATitle: string);
    destructor Done; virtual;
    function GetTitle: string; virtual;
  end;

  PSheetCollection = ^TSheetCollection;
  TSheetCollection = object(TCollection)
    procedure FreeItem(Item: pointer); virtual;
  end;

  PFilerBar = ^TFilerBar;
  TFilerBar = object(TListBox)
    constructor Init(var Bounds: TRect; AFlags: Word);
    destructor Done; virtual;
    procedure Draw; virtual;
    procedure DrawItem(Item: Integer); virtual;
    procedure FocusItem(Item: Integer); virtual;
    function GetItemColors(Item: Integer): LongInt; virtual;
    procedure GetItemRect(Item: Integer; var R: TRect); virtual;
    procedure GetItemSubRect(var R: TRect); virtual;
    function GetText(Item: Integer; MaxLen: Integer): string; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    function InsertSheet(Sheet: PFilerSheet): PFilerSheet;
  end;

implementation

{$ifdef Windows}
uses ExtGraph, WinGr;
{$else}
uses ExtGraph, MetaGr, MyFonts;
{$endif}

type
  TItemColors = record
    Text: Byte;
    Back: Byte;
    Shade: Byte;
    Frame: Byte
  end;

{ TFilerSheet object 
}
constructor TFilerSheet.Init;
var
  R: TRect;
begin
  inherited Init(Bounds);
  Title := NewStr(ATitle);
  GrowMode := gfGrowHiX + gfGrowHiY;
  GetExtent(R);
  Insert(New(PBackground, Init(R)));
end;

destructor TFilerSheet.Done;
begin
  DisposeStr(Title);
  inherited Done
end;

function TFilerSheet.GetTitle;
begin
  If Title = nil
  then GetTitle := ''
  else GetTitle := Title^
end;

{ TSheetCollection object 
}

procedure TSheetCollection.FreeItem;
begin
end;

{ TFilerBar object 
}

constructor TFilerBar.Init;
begin
  inherited Init(Bounds, nil);
  Flags := Flags or AFlags;
  NewList(New(PSheetCollection, Init(8, 8)));
  GrowMode := gfGrowHiX;
  Options := (Options and not ofSelectable) or ofPostProcess
end;

destructor TFilerBar.Done;
begin
  NewList(nil);
  inherited Done
end;

procedure TFilerBar.Draw;
var
  I: Integer;
Begin
  SetFillStyle(SolidFill, GetColor(1));
  Bar(0, 0, Size.X - 1, Size.Y - 4);
  SetFillStyle(SolidFill, GetColor(2));
  Bar(0, Size.Y - 3, Size.X - 1, Size.Y - 1);
  For I := TopItem to TopItem + GetPageSize + (Flags and lfPartialLines) do
    If I < Range then DrawItem (I);
End;

procedure TFilerBar.DrawItem;
var
  R, Sub: TRect;
  Cols, LeftCols: TItemColors;
  Radius: Integer;
begin
  SetViewport;
  GetItemRect(Item, R);
  SetSubRect(R);
  LongInt(Cols) := GetItemColors(Item);
  LongInt(LeftCols) := GetItemColors(Item - 1);
  SetColor(Cols.Frame);
  SetFillStyle(SolidFill, Cols.Back);
  Bar(R.A.X, R.A.Y, R.B.X - 1, R.B.Y - 1);
  Rectangle(R.A.X, R.A.Y, R.B.X - 1, R.B.Y);
  Radius := (R.B.Y - R.A.Y) div 2;

  SetFillStyle(SolidFill, Cols.Shade);
  Bar(R.A.X + 1, R.B.Y - 3, R.B.X - 2, R.B.Y - 1);

  Sub.Assign(R.A.X, R.A.Y, R.A.X + Radius, R.A.Y + Radius);
  SetSubRect(Sub);
  SetFillStyle(SolidFill, GetColor(1));
  Bar(0, 0, Size.X, Size.Y);
  SetFillStyle(SolidFill, Cols.Back);
  SetColor(Cols.Frame);
  FillCircle(R.A.X + Radius, R.A.Y + Radius, Radius);

  Sub.Assign(R.B.X - Radius - 1, R.A.Y, R.B.X, R.A.Y + Radius);
  SetSubRect(Sub);
  SetFillStyle(SolidFill, GetColor(1));
  Bar(0, 0, Size.X, Size.Y);
  SetFillStyle(SolidFill, Cols.Back);
  SetColor(Cols.Frame);
  FillCircle(R.B.X - Radius - 1, R.A.Y + Radius, Radius);

  R.Grow(-3, 0);
  SetTextJustify(LeftText, CenterText);
  SetTextParams(ftSansSerif, 0, Cols.Text, false);
  DrawItemText(Item, R);
  RestoreViewport
end;

procedure TFilerBar.FocusItem;
var
  Old: Integer;
  SaveOpt: Word;
begin
  Old := Focused;
  inherited FocusItem(Item);
  If Old <> Item
  then begin
    If Old < List^.Count then
      with PGView(List^.At(Old))^ do
      begin
	SaveOpt := Options;
	Options := Options and not ofSelectable;
	Hide;
	Options := SaveOpt
      end;
    If Item < List^.Count then
      with PGView(List^.At(Item))^ do
      begin
	SaveOpt := Options;
	Options := Options and not ofSelectable;
	Show;
	Options := SaveOpt
      end
  end
end;

function TFilerBar.GetItemColors;
var
  Colors: TItemColors;
begin
  If Item = -1
  then begin
    Colors.Back := 15;
    Colors.Text := 15;
    Colors.Frame := 15;
    Colors.Shade := 15
  end
  else
  If IsSelected(Item)
  then begin
    Colors.Back := PGView(List^.At(Item))^.GetColor(1);
    Colors.Text := 15;
    Colors.Frame := 0;
    Colors.Shade := Colors.Back
  end
  else begin
    Colors.Back := 15;
    Colors.Text := 0;
    Colors.Frame := 0;
    Colors.Shade := 0
  end;
  GetItemColors := LongInt(Colors)
end;

procedure TFilerBar.GetItemRect(Item: Integer; var R: TRect);
var
  i, max, width: Integer;
begin
  If Item >= Range
  then begin
    R.Assign(0, Size.Y+1, 0, Size.Y+1);
    Exit
  end;
  SetTextParams(ftSansSerif, 0, 0, false);
  GetItemSubRect(R);
  If Flags and fbProportionalWidth = 0
  then begin
    max := 0;
    For i := 0 to Range - 1 do
    begin
      width := TextWidth(GetText(i, 255)) + Size.Y;
      If width > max then max := width
    end;
    i := Item - TopItem;
    Inc(R.A.X, i * max);
    R.B.X := R.A.X + max
  end
  else begin
    max := 0;
    width := 0;
    For i := TopItem to Item do
    begin
      Inc(max, width + 2);
      width := TextWidth(GetText(i, 255)) + Size.Y;
    end;
    Inc(R.A.X, max);
    R.B.X := R.A.X + width
  end
end;

procedure TFilerBar.GetItemSubRect;
begin
  GetExtent(R);
  R.A.X := -3;
  Inc(R.A.Y)
end;

function TFilerBar.GetText;
begin
  GetText := PFilerSheet(List^.At(Item))^.GetTitle
end;

procedure TFilerBar.HandleEvent(var Event: TEvent);
begin
  If Event.What = evKeyDown then
    case Event.KeyCode of
      kbPgDn:
	begin
	  Event.KeyCode := kbDown;
	  inherited HandleEvent(Event);
	  ClearEvent(Event)
	end;
      kbPgUp:
	begin
	  Event.KeyCode := kbUp;
	  inherited HandleEvent(Event);
	  ClearEvent(Event)
	end;
    end
  else
    inherited HandleEvent(Event)
end;

function TFilerBar.InsertSheet;
begin
  If Range > 0 then Sheet^.Hide;
  List^.Insert(Sheet);
  Inc(Range);
  If GOwner <> nil then GOwner^.Insert(Sheet);
  InsertSheet := Sheet
end;

end.
