unit Gv20;

{ This unit provides more compatibility with Graphics Vision 2.0.

  Copr. 1995 Matthias Kppe
}
interface

uses Objects, Views, GvViews, GvEdit;

type
  TWindow = object(GvViews.TWindow)
    Background: PBackground;
    constructor Init(var Bounds: TRect; ATitle: TTitleStr);
    procedure InitBackground; virtual;
  end;
  PWindow = ^TWindow;

  TEditWindow = object(GvEdit.TEditWindow)
    constructor Init(var Bounds: TRect; FileName: FNameStr);
  end;
  PEditWindow = ^TEditWindow;

implementation

constructor TWindow.Init;
begin
  GvViews.TWindow.Init(Bounds, ATitle, 0);
  InitBackGround;
  If BackGround <> nil then Insert(BackGround)
end;

procedure TWindow.InitBackGround;
var
  R: TRect;
begin
  GetExtent(R);
  R.Grow(-4, -4);
  R.A.Y := 23;
  BackGround := New(PBackGround, Init(R))
end;

constructor TEditWindow.Init;
begin
  GvEdit.TEditWindow.Init(Bounds, FileName, 0)
end;

end.