{$A+,B+,D-,E+,F-,G+,I-,L-,N-,O-,R-,S-,V-,X+}
{****************************************************************************
 * Author           : Stefan Goehler, Germany                               *
 * Version          : official 1.2                                          *
 * Task             : Mousedriver for the unit graphics                     *
 * Copyright : You can use this unit entired in your own programs. Using    *
 *             parts of it or ripping any code off is not allowed without   *
 *             my permission. If you wanna use this unit in commercial      *
 *             products, I mean if you wanna get ANY money or other for     *
 *             software based on one of my units, you'll have to contact me *
 *             - we'll find a way.                                          *
 ****************************************************************************
 * I don't know any bugs - if there are any, please email me:               *
 * stefan.goehler@gmx.de                                                    *
 * my homepage      : http://www.sourcenet.home.pages.de                    *
 *    ^^there is always the newest version available (included in grafx)    *
 * This mouseunit works similar to the unit drivers, which you get with your*
 * copy of TP. Especially the event-handling.                               *
 ******* HISTORY ************************************************************
 * History                                                                  *
 * Version 1.0 : first public availible Version (11. Aug. 1997)             *
 * Version 1.1 : +added support to specify the area to move (setmousearea)  *
 *               +added procedure setmousepos to set cursorposition         *
 * Version 1.11: *changed all a little bit so that it can run correctly with*
 *                setviewport                                               *
 * Version 1.2 : +added support for animated cursors                        *
 *               *mousedr7 uses now instead of the old not very flexible    *
 *                format windows .cur and .ani files                        *
 *               +cursors are now loadable from harddisk                    *
 *               *made unit more compatible - programming bugs do not cause *
 *                any crashes                                               *
 *               *event-engine improved                                     *
 *               +added direct mouseaccess- unit also without mousedriver   *
 *                runable, when the mouse is a MS-compatible on a Comport   *
 ****************************************************************************}

unit mousedr7;
interface
uses dos,graphics,gr_vars;
type
  mouse_tevent = record
    buttons : byte   ;
    what    : integer;
    where   : pointtype;
  end;

const
{  sensitivy   : byte = 0;{Speed of the cursor}
  cursor      : byte = 1;{Actual cursor}
  buttons     : byte = 0;{pressed buttons; internal}
  evNothing   = $0000;
  evMouseDown = $0001;
  evMouseUp   = $0002;
  evMouseMove = $0004;
  evMouseAuto = $0008;
  directmouse : boolean = false;
{  win95active : boolean = false;}
var
  msx,msy   : integer;{posx,posy; internal}
  ps        : pointtype;{internal}
  event     : mouse_tevent; {public record filled by getmouseevent}
  mactive   : byte   ;{hidemouse increases, showmouse decreases this number -
                     to give showmouse the information, how much hidemouse
                     was called and showmouse should be called to see the
                     cursor}
  movearea  : record
    x1,y1,x2,y2 : integer;
  end;
  mouseport : byte;

  procedure initevents   ;{should be called after set256mode}
  procedure doneevents   ;{should be called before closegraph}
  function  getmousetype : string;
  procedure showmouse    ;{show the mouse}
  procedure hidemouse    ;{show the mouse}
  procedure getmouseevent;{get the mouse events}
  procedure notmovemouse ;{stop the mousemoving, but don't hide the mouse -
                        to do some graphical actions without overdraw the mousecursor}
  procedure letmovemouse;{call it, when you have finished the drawings after notmovemouse}
  procedure changecursor(c : byte);{change the actual cursor}
  function  mousethere(x1,y1,x2,y2 : integer) : boolean;{this function checks,
              if there is any part of the cursor in the specified rectangle}
  function  pointerthere(x1,y1,x2,y2 : integer) : boolean;{this function checks,
                 if there is the top of the cursor in the specified rectangle}
  procedure setmousearea(x1,y1,x2,y2 : integer);
  procedure setmousepos(x,y : integer);
{  procedure setmousespeed(x,y : integer);}

  function  openani(name : string;num : byte) : boolean;
  function  opencur(name : string;num : byte) : boolean;
  function  closecursor(num : byte) : boolean;

implementation
var
  olmsx,olmsy,i     : integer;{last positions}
  mp,mpp            : pointer;{mousecursor in the memory}
  mssize            : word   ;{memory size of the cursor (x*y+4)}
  first,active,run  : boolean;{first : first draw on the screen (after showmouse)
                               active: was already initmouse called?
                               run   : can the mousecursor be moved?}
  hotspot : pointtype;        {the position in the mouseimage where the
                               clicking point is}
  cursors : array[5..19] of record
    p       : pointer;
    memsize : word;
    is_ani  : boolean;
  end;

const
  RxR=0;
  TxR=0;
  IER=1;
  MCR=4;
  LCR=3;
  LSR=5;
  MSR=6;
  DLL=0;
  DLH=1;

  N=0;
  O=8;
  E=24;

  com_irqaddr : array[1..4] of word =(4,3,4,3);

var
  oldint           : pointer;
  com_irq,com_base : word;
  dataqueue        : array[0..2] of byte;
  queuesize        : byte;
  com_baseaddr     : array[1..4] of word;

  procedure mdr_std;external;
  {$L mdr_std}
  procedure mdr_text;external;
  {$L mdr_text}
  procedure mdr_hand;external;
  {$L mdr_hand}
  procedure mdr_wait;external;
  {$L mdr_wait}

function getmousetype : string;
var
  t : byte;
begin
  if not directmouse then begin
    asm
      mov   ax,0024h
      int   33h
      mov   t,ch
    end;
  end else t := 2;
  case t of
    1 : getmousetype := 'Bus-Mouse';
    2 : getmousetype := 'Serial Mouse';
    3 : getmousetype := 'InPort Mouse';
    4 : getmousetype := 'PS/2 Mouse';
    5 : getmousetype := 'HP Mouse';
  end;
end;

function getbit(value,bit : byte) : boolean;assembler;
asm
  mov   cl,bit
  mov   bl,1
  shl   bl,cl
  mov   al,value
  and   al,bl
end;

procedure loadico(p,out : pointer);
{ I know I'd better convert this to asm, but there's no time for such }
{ things yet...                                                       }
const
  convert : array[0..15] of byte=(0,4,2,6,1,5,3,8,7,12,10,14,9,13,11,15);
var
  sx,sy,x,y,bitdepth,i       : word;
  imagestart,mempos,imgsize  : word;
  pixel                      : array[0..639] of byte;
  conv2                      : array[0..255] of byte;
begin
  sx := mem[seg(p^):ofs(p^)+6]-1;
  sy := mem[seg(p^):ofs(p^)+7]-1;
  hotspot.x := memw[seg(p^):ofs(p^)+10];
  hotspot.y := memw[seg(p^):ofs(p^)+12];
  memw[seg(out^):ofs(out^)] := sx;
  memw[seg(out^):ofs(out^)+2] := sy;
  imagestart := mem[seg(p^):ofs(p^)+18]+104;
  bitdepth := mem[seg(p^):ofs(p^)+14+imagestart-104];
  if bitdepth = 4 then begin
  mempos  := succ(sx)*succ(sy)+4;
  imgsize := succ(sx)*succ(sy) div 2;
  for y := sy downto 0 do begin
    dec(mempos,succ(sx));
    asm
      mov   cx,sx
      inc   cx
      shr   cx,1
      les   di,p

      mov   dx,sy
      sub   dx,y
      mov   ax,sx
      inc   ax
      mul   dx
      shr   ax,1
      add   di,ax
      add   di,imagestart
      xor   si,si
      @lp:
        xor   bh,bh
        mov   bl,es:[di]
        mov   al,bl
        shr   al,4
        and   bl,0Fh
        mov   ah,byte ptr convert[bx]
        mov   bl,al
        mov   al,byte ptr convert[bx]
        mov   word ptr pixel[si],ax
        add   si,2
        inc   di
        dec   cx
      jnz   @lp
    end;
    for x := 0 to sx do begin
      if not getbit(mem[seg(p^):ofs(p^)+imgsize+124+imagestart-y
                    shl 2+x shr 3],7-x and 7) then
                   mem[seg(out^):ofs(out^)+x+mempos] := pixel[x]
              else mem[seg(out^):ofs(out^)+x+mempos] := 255;
    end;
  end;
  end else if bitdepth = 8 then begin
  mempos  := succ(sx)*succ(sy)+imagedatasize;
  imgsize := succ(sx)*succ(sy);
  inc(imagestart,(256-16)*4);
  for i := 0 to 255 do begin
    conv2[i] := findnearcol(mem[seg(p^):ofs(p^)+i*4+imagestart-1024+2] shr 2,
             mem[seg(p^):ofs(p^)+i*4+imagestart-1024+1] shr 2,
             mem[seg(p^):ofs(p^)+i*4+imagestart-1024] shr 2);
  end;
  for y := sy downto 0 do begin
    dec(mempos,succ(sx));
    for x := 0 to sx do begin
      if not getbit(mem[seg(p^):ofs(p^)+imgsize+124+imagestart-y
                    shl 2+x shr 3],7-x and 7) then
              mem[seg(out^):ofs(out^)+x+mempos] :=
              conv2[mem[seg(p^):ofs(p^)+imagestart+(sy-y)*succ(sx)+x]] else
              mem[seg(out^):ofs(out^)+x+mempos] := 255;
    end;
   end;
  end;
end;

function mousethere(x1,y1,x2,y2 : integer) : boolean;
begin
if (msx+mousedr7.ps.x < x1)or(msy+mousedr7.ps.y < y1)or
   (msx > x2)or(msy > y2) then mousethere := false
   else mousethere := true;
end;

function pointerthere(x1,y1,x2,y2 : integer) : boolean;
begin
if (event.where.x < x1)or(event.where.y < y1)or
   (event.where.x > x2)or(event.where.y > y2) then pointerthere := false
   else pointerthere := true;
end;

function calcbank(x,y : integer) : word;assembler;
{calculates position x,y in GFXmem, sets bank and
 gives position out}
asm
  db    66h;xor cx,cx
  db    66h;xor ax,ax
  mov   bx,x
  mov   cx,bytesperscanline
  add   ax,y
  db    66h;mul cx
  mov   cx,bx
  db    66h;add ax,cx
  mov   si,ax
  db    66h;shr ax,16
  push  ax
  call  setbank2
  @end:
  mov   ax,si
end;

(*procedure resetwritemode;assembler;
asm
  mov  dx,3CEh      {GDC               }
  mov  ax,0003h
  out  dx,ax        {reset to old values}
end;

procedure restorewritemode;assembler;
asm
  MOV  DX,3CEh      {GDC               }
  MOV  AL,3         {Function select   }
  MOV  AH,writemode {HEHEEE :>         }
  SHL  AH,3
  OUT  DX,AX
end;*)

{procedure setmousespeed(x,y : integer);assembler;
asm
  mov   ax,$000F
  mov   cx,x
  mov   dx,y
  int   33h
end;}

procedure putimage(x,y: integer;p1 : pointer);
var
  sizex,sizey,i,i2,i3,i4,oli2,putmaxx : word;
  switched      : boolean;
begin
 {resetwritemode;}
  sizex := succ(memw[seg(p1^):ofs(p1^)]);
  sizey := memw[seg(p1^):ofs(p1^)+2];
  if sizey+y > mxy then sizey := mxy-y;
  if longint(sizex)*sizey > 65524 then exit;
  if (x < maxx)and(x+sizex > 0)and(y+sizey > -1)and(y < maxy) then begin
    i4 := 4;
    if y < 0 then begin
      i4 := i4-(y*sizex);
      sizey := sizey+y;
      y := 0;
    end;
    if x < 0 then begin
      i4 := i4-x;
      putmaxx := sizex+x;
      x := 0;
    end else begin
      if x+sizex > maxx then putmaxx := maxx-x+1 else
      putmaxx := sizex;
    end;
    if putmaxx+x > maxx then putmaxx := maxx-x;
    inc(y,pageadd);
    i2 := calcbank(x,y);
    oli2 := i2;
    switched := false;
    for i := y to y+sizey do begin
      if i2 < i2+putmaxx then begin
        if (oli2 > i2)and(not switched) then incbank;
        move2screen(ptr(seg(p1^),ofs(p1^)+i4)^,ptr(writeptr,i2)^,putmaxx);
        switched := false;
      end else begin
        i3 := 0-i2;
        move2screen(ptr(seg(p1^),ofs(p1^)+i4)^,ptr(writeptr,i2)^,i3);
        incbank;
        switched := true;
        move2(ptr(seg(p1^),ofs(p1^)+i4+i3)^,ptr(writeptr,0)^,putmaxx-i3);
      end;
      inc(i4,sizex);
      oli2 := i2;
      inc(i2,bytesperscanline);
    end;
  end;
{ restorewritemode;}
end;


procedure getputimage(x,y: integer;p1,p2 : pointer;key : byte);
var
  sizex,sizey,i,i2,i3,i4,oli2,putmaxx : word;
  switched      : boolean;
begin
{ resetwritemode;}
  sizex := succ(memw[seg(p1^):ofs(p1^)]);
  sizey := memw[seg(p1^):ofs(p1^)+2];
  memw[seg(p2^):ofs(p2^)]   := sizex-1;
  memw[seg(p2^):ofs(p2^)+2] := sizey;
  if sizey+y > mxy then sizey := mxy-y;
  if longint(sizex)*sizey > 65524 then exit;
  if (x < maxx)and(x+sizex > 0)and(y+sizey > -1)and(y < maxy) then begin
    i4 := 4;
    if y < 0 then begin
      i4 := i4-(y*sizex);
      sizey := sizey+y;
      y := 0;
    end;
    if x < 0 then begin
      i4 := i4-x;
      putmaxx := sizex+x;
      x := 0;
    end else begin
      if x+sizex > maxx then putmaxx := maxx-x+1 else
      putmaxx := sizex;
    end;
    if putmaxx+x > maxx then putmaxx := maxx-x;
    inc(y,pageadd);
    i2 := calcbank(x,y);
    oli2 := i2;
    switched := false;
    for i := y to y+sizey do begin
      if i2 < i2+putmaxx then begin
        if (oli2 > i2)and(not switched) then incbank;
        movefromscreen(ptr(writeptr,i2)^,ptr(seg(p2^),ofs(p2^)+i4)^,putmaxx);
        sprite2mem(ptr(seg(p1^),ofs(p1^)+i4)^,ptr(writeptr,i2)^,putmaxx,key);
        switched := false;
      end else begin
        i3 := 0-i2;
        movefromscreen(ptr(writeptr,i2)^,ptr(seg(p2^),ofs(p2^)+i4)^,i3);
        sprite2mem(ptr(seg(p1^),ofs(p1^)+i4)^,ptr(writeptr,i2)^,i3,key);
        incbank;
        switched := true;
        move2(ptr(writeptr,0)^,ptr(seg(p2^),ofs(p2^)+i4+i3)^,putmaxx-i3);
        sprite2mem(ptr(seg(p1^),ofs(p1^)+i4+i3)^,ptr(writeptr,0)^,putmaxx-i3,key);
      end;
      inc(i4,sizex);
      oli2 := i2;
      inc(i2,bytesperscanline);
    end;
  end;
{ restorewritemode;}
end;

procedure putputimage(x,y: integer;p1,p2 : pointer;key : byte);
var
  sizex,sizey,i,i2,i3,i4,oli2,putmaxx : word;
  switched      : boolean;
begin
{ resetwritemode;}
  sizex := succ(memw[seg(p1^):ofs(p1^)]);
  sizey := memw[seg(p1^):ofs(p1^)+2];
  memw[seg(p2^):ofs(p2^)]   := sizex-1;
  memw[seg(p2^):ofs(p2^)+2] := sizey;
  if sizey+y > mxy then sizey := mxy-y;
  if longint(sizex)*sizey > 65524 then exit;
  if (x < maxx)and(x+sizex > 0)and(y+sizey > -1)and(y < maxy) then begin
    i4 := 4;
    if y < 0 then begin
      i4 := i4-(y*sizex);
      sizey := sizey+y;
      y := 0;
    end;
    if x < 0 then begin
      i4 := i4-x;
      putmaxx := sizex+x;
      x := 0;
    end else begin
      if x+sizex > maxx then putmaxx := maxx-x+1 else
      putmaxx := sizex;
    end;
    if putmaxx+x > maxx then putmaxx := maxx-x;
    inc(y,pageadd);
    i2 := calcbank(x,y);
    oli2 := i2;
    switched := false;
    for i := y to y+sizey do begin
      if i2 < i2+putmaxx then begin
        if (oli2 > i2)and(not switched) then incbank;
        move2screen(ptr(seg(p2^),ofs(p2^)+i4)^,ptr(writeptr,i2)^,putmaxx);
        sprite2mem(ptr(seg(p1^),ofs(p1^)+i4)^,ptr(writeptr,i2)^,putmaxx,key);
        switched := false;
      end else begin
        i3 := 0-i2;
        move2screen(ptr(seg(p2^),ofs(p2^)+i4)^,ptr(writeptr,i2)^,i3);
        sprite2mem(ptr(seg(p1^),ofs(p1^)+i4)^,ptr(writeptr,i2)^,i3,key);
        incbank;
        switched := true;
        move2(ptr(writeptr,0)^,ptr(seg(p2^),ofs(p2^)+i4+i3)^,putmaxx-i3);
        sprite2mem(ptr(seg(p1^),ofs(p1^)+i4+i3)^,ptr(writeptr,0)^,putmaxx-i3,key);
      end;
      inc(i4,sizex);
      oli2 := i2;
      inc(i2,bytesperscanline);
    end;
  end;
{ restorewritemode;}
end;

procedure drawcursor;far;
var
  bank : word;
begin
  bank := lastbank;
  if not first then putimage(olmsx,olmsy,mp);
  getputimage(msx,msy,mpp,mp,255);
  if lastbank <> bank then setbank2(bank);
end;

var
  nomove,moveint : boolean;

procedure mouse;far;assembler;
var
  sds : word;
asm
  pusha
  cli
  mov   sds,ds
  mov   si,seg @DATA
  mov   ds,si
  cmp   nomove,1 {if animated cursor is changin', then better exit}
  je    @exit
  mov   moveint,1
  mov   ax,msx
  mov   olmsx,ax
  mov   ax,msy
  mov   olmsy,ax
  mov   ax,000bh
  int   33h
{  cmp   sensitivy,0
  je    @next
  sar   cx,1
  sar   dx,1
  @next:}
  mov   si,msx
  mov   di,msy
  add   si,cx
  add   di,dx
  mov   ax,movearea.x1
  cmp   si,ax
  jnl   @cxnotb0
  mov   si,ax
  @cxnotb0:
  cmp   si,movearea.x2
  jng   @cxnotamxx
  mov   si,movearea.x2
  @cxnotamxx:

  mov   ax,movearea.y1
  cmp   di,ax
  jnl   @dxnotb0
  mov   di,ax
  @dxnotb0:
  cmp   di,movearea.y2
  jng   @dxnotamxy
  mov   di,movearea.y2
  @dxnotamxy:
  mov   msx,si
  mov   msy,di
  mov   buttons,bl
  cmp   run,0
  je    @exit
  call  drawcursor
  mov   first,0
  mov   ds,sds
@exit:
  sti
  popa
  mov   moveint,0
end;

procedure mouseint_com;interrupt;
label
  endint;
var
  px,py : shortint;
begin
  dataqueue[queuesize] := port[com_base+RxR];
  inc(queuesize);
  if queuesize = 3 then begin
    queuesize := 0;
    if nomove then goto endint;
    moveint := true;
    buttons := dataqueue[0] and 48 shr 4 ;
    case buttons of
      1 : buttons := 2;
      2 : buttons := 1;
    end;
    px := (dataqueue[1] and 63)+(dataqueue[0] and 3) shl 6;
    py := (dataqueue[2] and 63)+(dataqueue[0] and 12) shl 4;
    olmsx := msx;
    olmsy := msy;
    msx := msx+px;
    msy := msy+py;
    if msx < movearea.x1 then msx := movearea.x1;
    if msx > movearea.x2 then msx := movearea.x2;
    if msy < movearea.y1 then msy := movearea.y1;
    if msy > movearea.y2 then msy := movearea.y2;
    if not run then goto endint;
    drawcursor;
    first := false;
    moveint := false;
  end;
endint:
  port[$20] := $20;
end;

procedure searchint_com;interrupt;
begin
  if queuesize < 2 then begin
    dataqueue[queuesize] := port[com_base+RxR];
    inc(queuesize);
  end;
  port[$20] := $20;
end;


procedure setmousearea(x1,y1,x2,y2 : integer);
var
  temp : boolean;
begin
  hidemouse;
  movearea.x1 := x1;
  movearea.y1 := y1;
  movearea.x2 := x2;
  movearea.y2 := y2;
  if (msx < movearea.x1) then msx := movearea.x1;
  if (msy < movearea.y1) then msy := movearea.y1;
  if (msx > movearea.x2) then msx := movearea.x2;
  if (msy > movearea.y2) then msy := movearea.y2;
  dec(movearea.x1,hotspot.x);
  dec(movearea.y1,hotspot.y);
  dec(movearea.x2,hotspot.x);
  dec(movearea.y2,hotspot.y);
  showmouse;
end;

procedure setmousepos(x,y : integer);
begin
  hidemouse;
  msx := x;
  msy := y;
  if (msx < movearea.x1) then msx := movearea.x1;
  if (msy < movearea.y1) then msy := movearea.y1;
  if (msx > movearea.x2) then msx := movearea.x2;
  if (msy > movearea.y2) then msy := movearea.y2;
  dec(msx,hotspot.x);
  dec(msy,hotspot.y);
  showmouse;
end;

procedure notmovemouse;assembler;
asm
  mov   nomove,1
end;

procedure letmovemouse;assembler;
asm
  mov   al,mactive
  or    al,al
  jnz   @end
  mov   nomove,0
  @end:
end;


procedure showmouse;assembler;
asm
  cli
  mov   nomove,1
  mov   cl,mactive
  mov   bl,1
  mov   al,active
  or    al,al
  jz    @end
  mov   first,bl
  cmp   cl,bl
  jg @end2
    mov   first,1
    call  drawcursor
    mov   first,0
    mov   run,1
    jmp   @end
  @end2:
  dec   cl
  @end:
  mov   mactive,cl
  mov   nomove,0
  sti
end;

procedure hidemouse;assembler;
asm
  cli
  mov   nomove,1
  cmp   active,0
  je    @end
  xor   al,al
  mov   run,al
  inc   mactive
  cmp   first,1
  je    @end
  mov   first,al
  push  msx
  push  msy
  push  word ptr mp[2]
  push  word ptr mp[0]
  call  putimage
  @end:
  mov   nomove,0
  sti
end;


type
  riffheader = record{20}
    riff      : array[0..3] of char;
    chunksize : longint;
    acon      : array[0..3] of char;
  end;
  list = record
    list : array[0..3] of char;
    size : longint;
    name : array[0..7] of char;
  end;

var
  pixel                : array[0..639] of byte;
  f                    : file;
  p                    : pointer;
  h                    : riffheader;
  mempos               : word;
  l                    : list;
  anih : record
    pics      : longint;{real saved images}
    anipics   : longint;{pictures used in animation}
    crap1     : array[0..15] of byte;
    stdjiffies: longint;{1 Jiffie= 1/60 sec}
    crap2     : array[0..3] of byte;
  end;
  jiffylist,seqlist : pointer;
  jiffyav,seqav     : boolean;

var
  anitime   : real;
  incer     : word;
  lasttime  : word;
  Int1CSave : pointer;
  anirun    : boolean;

procedure anicursor;interrupt;
var
  time,i2   : word;
  bank      : word;
begin
  asm
    pushf
    call  Int1CSave
  end;
  if jiffyav then time := round(memw[seg(jiffylist^):ofs(jiffylist^)+i*4]/60*18.2) else
  time := round(anih.stdjiffies/60*18.2);
  inc(incer);
  if incer >= lasttime+time then
  begin
    lasttime := incer;
    inc(i);
    if not seqav then inc(mempos,memw[seg(p^):ofs(p^)+mempos+4]+8)
    else begin
      i2 := memw[seg(seqlist^):ofs(seqlist^)+i*4];
      mempos := 0;
      for i2 := 1 to i2 do inc(mempos,memw[seg(p^):ofs(p^)+mempos+4]+8)
    end;
    if i = anih.anipics then begin
      mempos := 0;
      i      := 0;
    end;
      loadico(ptr(seg(p^),ofs(p^)+mempos+8),mpp);
    if not moveint then begin
      nomove := true;
      bank := lastbank;
      putputimage(msx,msy,mpp,mp,255);
      if lastbank <> bank then setbank2(bank);
      nomove := false;
    end else moveint := false;
  end;
end;


procedure loadani(inp : pointer);
var
  loadpos,i2 : word;

  procedure pread(var out;size : word);
  begin
    move2(ptr(seg(inp^),ofs(inp^)+loadpos)^,out,size);
    inc(loadpos,size);
  end;

begin
  jiffyav := false;
  loadpos := 0;
  pread(h,sizeof(h));
  repeat
    pread(l,sizeof(l));
    if l.list = 'anih' then
    begin
      dec(loadpos,4);
      pread(anih,l.size-4);
    end else
    if l.list = 'rate' then
    begin
      jiffylist := ptr(seg(inp^),ofs(inp^)+loadpos-8);
      inc(loadpos,l.size-8);
      jiffyav := true;
    end else
    if l.list = 'seq ' then
    begin
      seqlist := ptr(seg(inp^),ofs(inp^)+loadpos-8);
      inc(loadpos,l.size-8);
      seqav := true;
    end else
    if l.name = 'framicon' then
    else inc(loadpos,l.size-8);
  until (l.name = 'framicon');
  dec(loadpos,4);

  p := ptr(seg(inp^),ofs(inp^)+loadpos);
  mempos := 0;
  i := 0;
  loadico(ptr(seg(p^),ofs(p^)+mempos+8),mpp);
  inc(i);
  if not seqav then inc(mempos,memw[seg(p^):ofs(p^)+mempos+4]+8)
  else begin
    i2 := memw[seg(seqlist^):ofs(seqlist^)+i*4];
    mempos := 0;
    for i2 := 1 to i2 do inc(mempos,memw[seg(p^):ofs(p^)+mempos+4]+8)
  end;
  getintvec($1C,Int1CSave);
  setintvec($1C,@anicursor);
  anirun := true;
end;


function openani(name : string;num : byte) : boolean;
var
  f : file;
begin
  openani := false;
  if (num < 5) or (num > 19) then exit;
  if cursors[num].p <> nil then exit;
  assign(f,name);
  filemode := 64;
  reset(f,1);
  if ioresult <> 0 then exit;
  cursors[num].memsize := filesize(f);
  cursors[num].is_ani  := true;
  getmem(cursors[num].p,cursors[num].memsize);
  blockread(f,cursors[num].p^,cursors[num].memsize);
  close(f);
  openani := true;
end;


function opencur(name : string;num : byte) : boolean;
var
  f : file;
begin
  opencur := false;
  if (num < 5) or (num > 19) then exit;
  if cursors[num].p <> nil then exit;
  assign(f,name);
  filemode := 64;
  reset(f,1);
  if ioresult <> 0 then exit;
  cursors[num].memsize := filesize(f);
  cursors[num].is_ani  := false;
  getmem(cursors[num].p,cursors[num].memsize);
  blockread(f,cursors[num].p^,cursors[num].memsize);
  close(f);
  opencur := true;
end;


function closecursor(num : byte) : boolean;
begin
  closecursor := false;
  if cursors[num].p = nil then exit;
  freemem(cursors[num].p,cursors[num].memsize);
  closecursor := true;
end;


procedure changecursor(c : byte);
begin
  if cursor <> c then begin
    cursor := c;
    hidemouse;
    if anirun then setintvec($1C,int1csave);
    anirun := false;
    inc(movearea.x1,hotspot.x);
    inc(movearea.y1,hotspot.y);
    inc(movearea.x2,hotspot.x);
    inc(movearea.y2,hotspot.y);
    inc(msx,hotspot.x);
    inc(msy,hotspot.y);
    case cursor of
      1 : loadico(@mdr_std,mpp);
      2 : loadico(@mdr_hand,mpp);
      3 : loadani(@mdr_wait);
      4 : loadico(@mdr_text,mpp);
      5..19 : if cursors[cursor].p <> nil then
      begin
        if cursors[cursor].is_ani then
        loadani(cursors[cursor].p) else
        loadico(cursors[cursor].p,mpp);
      end;
      else begin
        cursor := 1;
        loadico(@mdr_std,mpp);
      end;
    end;
    dec(msx,hotspot.x);
    dec(msy,hotspot.y);
    dec(movearea.x1,hotspot.x);
    dec(movearea.y1,hotspot.y);
    dec(movearea.x2,hotspot.x);
    dec(movearea.y2,hotspot.y);
    showmouse;
  end;
end;

procedure com_openport(p: word;intproc: pointer);
begin
  com_irq  := com_irqaddr[p];
  com_base := com_baseaddr[p];
  getintvec(com_irq+8,oldint);
  setintvec(com_irq+8,intproc);
  port[$21]          := Port[$21] and not (1 shl com_irq);
  port[com_base+MCR] := 11;
  port[com_base+IER] := 1;
end;

procedure com_closeport;
begin
  setintvec(com_irq+8,oldint);
  port[com_base+MCR] := 0;
  port[com_base+IER] := 0;
  port[$21] := port[$21] or (1 shl com_irq);
end;

procedure com_setspeed(bps: longint);
var
  divisor : word;
begin
  port[com_base+LCR] := port[com_base+LCR] or 128;
  divisor            := 115200 div bps;
  port[com_base+DLL] := lo(divisor);
  port[com_base+DLH] := hi(divisor);
  port[com_base+LCR] := port[com_base+LCR] and not 128;
end;

procedure com_setparam(data,parity,stop : word);
begin
  port[com_base+LCR]:= (data-5)+parity+(stop-1) shl 2;
end;

var
  endtime : longint;

function currenttime : longint;assembler;
asm
  mov es,[seg0040]
  mov ax,es:[6Ch]
  mov dx,es:[6Eh]
end;

function searchmouse_com(p : byte) : boolean;
begin
  queuesize := 0;
  com_openport(p,@searchint_com);
  com_setspeed(1200);
  com_setparam(7,N,1);
  endtime := currenttime+18;
  repeat
    if queuesize > 1 then if (dataqueue[queuesize-1] = ord('M')) then break;
  until (queuesize >= 2)or(currenttime >= endtime);
  com_closeport;
  if (queuesize > 0)and(dataqueue[queuesize-1] = ord('M')) then
  searchmouse_com := true else searchmouse_com := false;
end;


function initmouse_com(p : byte) : boolean;
begin
  queuesize := 0;
  com_openport(p,@mouseint_com);
  com_setspeed(1200);
  com_setparam(7,N,1);
  endtime := currenttime+18;
  repeat
    if queuesize > 1 then if (dataqueue[queuesize-1] = ord('M')) then break;
  until (queuesize >= 2)or(currenttime >= endtime);
  queuesize := 0;
end;

procedure donemouse_com;
begin
  com_closeport;
end;


procedure initevents;
begin
  if not gfx_inited then
  begin
    writeln('Mouseunit: Can''t initialize the mouse without graphical mode',#7);
    halt(20);
  end;
  active := true;
  first := true;
  run := true;
{  getimagesize(mp2,ps.x,ps.y);
  mssize := ImageSize(0,0,ps.x,ps.y);}
  mssize := imagesize(0,0,31,31);
  getmem(mpp,mssize);
  getmem(mp ,mssize);
  loadico(@mdr_std,mpp);
  movearea.x1 := -hotspot.x;
  movearea.y1 := -hotspot.y;
  movearea.x2 := mxx-hotspot.x;
  movearea.y2 := mxy-hotspot.y;
  msx := -hotspot.x;
  msy := -hotspot.y;
  if not directmouse then
  asm
    {set the pointer to the mouseprocedure}
    mov   ax,12
    mov   cx,0FFFFh
    mov   dx,offset cs:mouse
    push  cs
    pop   es
    int   33h
    {reset mouseposition}
    mov   ax,000bh
    int   33h
  end else initmouse_com(mouseport);
  mactive := 0;
end;


procedure doneevents;
begin
  if active then begin
    hidemouse;
    if not directmouse then
    asm
      mov   ax,12
      xor   cx,cx
      xor   dx,dx
      mov   es,cx
      int   33h
    end else donemouse_com;
    active := false;
    freemem(mp ,mssize);
    freemem(mpp,mssize);
    if anirun then setintvec($1C,int1csave);
    anirun := false;
  end;
end;

(*procedure getmouseevent;assembler;
asm
  mov   al,active
  or    al,al
  jz    @notchanged
  mov   al,event.buttons
{  mov   buttons,al}
  xor   ax,ax
  mov   event.what,ax
{  mov   ax,3
  int   33h}
  mov   bl,buttons
  cmp   bl,event.buttons
  jne   @end
  mov   event.what,evmousemove
  @end:
  mov   event.buttons,bl

  mov   ax,msx
  mov   bx,msy
  add   ax,hotspot.x
  add   bx,hotspot.y
  mov   event.where.x,ax
  mov   event.where.y,bx
  mov   al,buttons
  mov   bl,event.buttons
  cmp   al,bl
  je    @notchanged
  or    al,al
  jz    @next
  mov   event.what,evmouseup
  jmp   @notchanged
  @next:
  or    bl,bl
  jz    @notchanged
  mov   event.what,evmousedown
  @notchanged:
end;*)
procedure getmouseevent;
begin
  if not active then exit;
  event.what    := 0;
  if (event.buttons and 1 = 0)and(buttons and 1 <> 0) then event.what := event.what or evmousedown else
  if (event.buttons and 1 <> 0)and(buttons and 1 = 0) then event.what := event.what or evmouseup;
  if (event.buttons and 2 = 0)and(buttons and 2 <> 0) then event.what := event.what or evmousedown else
  if (event.buttons and 2 <> 0)and(buttons and 2 = 0) then event.what := event.what or evmouseup;
  event.buttons := buttons;

  if (event.where.x <> msx+hotspot.x)and(event.where.y <> msy+hotspot.y) then begin
    if buttons = 0 then event.what := event.what or evmousemove else
    event.what := event.what or evmouseauto;
  end;
  event.where.x := msx+hotspot.x;
  event.where.y := msy+hotspot.y;
end;


var
  ports : integer;

begin
  asm
    xor   ax,ax
    xor   bx,bx
    int   33h
    mov   i,ax
  end;
  if i = 0 then begin
    writeln('Mouseunit: No driver found, searching mouse...');
    for i := 0 to 3 do com_baseaddr[i+1] := memw[seg0040:i shl 1];
    ports := 0;
    for i := 1 to 4 do if com_baseaddr[i] <> 0 then inc(ports) else break;
    directmouse := false;
    for mouseport := 1 to ports do if searchmouse_com(mouseport) = true then begin
      directmouse := true;
      writeln('Microsoft-compatible mouse found at Com ',mouseport);
      break;
    end;
    if directmouse then
    else begin
      writeln('No Microsoft-compatible mouse found, program cannot be started');
      halt;
    end;
  end;
{  asm
    mov   ax,160Ah
    int   2Fh
    mov   i,bx
  end;
  if i <> 0 then if i shr 8 >= 4 then win95active := true;
  asm
    xor   ax,ax
    int   33h
  end;}
end.






