{$A+,B+,D-,E-,F-,G+,I-,L-,N-,O-,P+,Q-,R-,S-,T-,V-,X+,Y-}
{****************************************************************************
 * Author           : Stefan Goehler, Germany                               *
 * Version          : official 1.1                                          *
 *******                                                                    *
 * my mail-adress   : stefan.goehler@gmx.de                                 *
 * my homepage      : http://sourcenet.home.pages.de                        *
 ****** HISTORY *************************************************************
 * Version 1.1  +added procedure fadecircle                                 *
 ****************************************************************************}

unit fadelib;
interface
uses graphics,gr_vars;

const
  fade_norm  = 0;
  fade_down  = 1;
  fade_right = 2;

procedure fade2white;
procedure fadeout;
procedure fadeshades;
procedure faderollo(direction,col : byte);
procedure fadein;
procedure fadecircle(direction,col : byte);

implementation
var
  i,i2 : integer;

procedure fade2white;
begin
  getpal;
  for i2 := 63 downto 0 do begin
    waitretrace;
    for i := 1 to 255 do begin
      if Pal^[i].r < 63 then inc(Pal^[i].r);
      if Pal^[i].g < 63 then inc(Pal^[i].g);
      if Pal^[i].b < 63 then inc(Pal^[i].b);
    end;
    setpal;
  end;
end;

procedure fadeout;
begin
  getpal;
  for i2 := 63 downto 0 do begin
  waitretrace;
    for i := 1 to 255 do begin
        if Pal^[i].r > 0 then dec(Pal^[i].r);
        if Pal^[i].g > 0 then dec(Pal^[i].g);
        if Pal^[i].b > 0 then dec(Pal^[i].b);
    end;
    setpal;
  end;
end;

procedure fadeshades;
begin
  fade2white;
  for i := 0 to mxx div 32 do
  for i2 := 0 to 31 do
  vline(i*32+i2,0,maxy,i2+1+i*2);
  for i := 1 to 64 do
  setrgbpalette(i,31+i div 2-1,31+i div 2-1,31+i div 2-1);
  fadeout;
end;

procedure faderollo(direction,col : byte);
begin
  case direction of
    fade_down,fade_norm:
    for i := 0 to 19 do begin
      waitretrace;
      for i2 := 0 to mxy div 10 do hline(0,i2*20+i,maxx,col);
    end;
    fade_right:
    for i := 0 to 19 do begin
      waitretrace;
      for i2 := 0 to mxx div 10 do vline(i2*20+i,0,maxy,col);
    end;
    fade_down+fade_right:
    for i := 0 to 19 do begin
      waitretrace;
      for i2 := 0 to mxx div 10 do begin
        vline(i2*20+i,0,maxy,col);

        if i2*10 < mxy then hline(0,i2*20+i,maxx,col);
      end;
    end;
  end;
end;

procedure fadein;
var
  pal2 : ^paltype;
  i2   : integer;
begin
  new(pal2);
  pal2^ := pal^;
  for i := 0 to 255 do begin
    pal^[i].r := 0;
    pal^[i].g := 0;
    pal^[i].b := 0;
  end;
  for i2 := 0 to 63 do begin
    for i := 0 to 255 do begin
      if pal^[i].r < pal2^[i].r then inc(pal^[i].r);
      if pal^[i].g < pal2^[i].g then inc(pal^[i].g);
      if pal^[i].b < pal2^[i].b then inc(pal^[i].b);
    end;
    waitretrace;
    setpal;
  end;
  dispose(pal2);
end;

procedure fadecircle(direction,col : byte);
var
  x,y : integer;
begin
  setfillstyle(solidfill,col);
  case direction of
    fade_norm:
    for i := 0 to 28 do begin
      waitretrace;
      for y := 0 to mxy div 40 do
      for x := 0 to mxx div 40 do fillcircle(x*40+20,y*40+20,i);
    end;
    fade_down:
    for i := -mxy div 40 to 28 do begin
      waitretrace;
      for y := 0 to mxy div 40 do
      for x := 0 to mxx div 40 do
      if mxy div 40-y+i < 29 then fillcircle(x*40+20,y*40+20,mxy div 40-y+i);
    end;
    fade_right:
    for i := -mxx div 40 to 28 do begin
      waitretrace;
      for y := 0 to mxy div 40 do
      for x := 0 to mxx div 40 do
      if mxx div 40-x+i < 29 then fillcircle(x*40+20,y*40+20,mxx div 40-x+i);
    end;
    fade_right+fade_down:
    for i := -mxx div 40 to 60 do begin
      waitretrace;
      for y := 0 to mxy div 40 do
      for x := 0 to mxx div 40 do
      if mxx div 40-x-y+i < 29 then fillcircle(x*40+20,y*40+20,mxx div 40-x-y+i);
    end;
  end;
end;


begin
end.





