{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Streams/Filebuf.pas              [x] Protected mode

  This program demonstrates buffered file I/O with streams.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFFILE;


const BufferSize  = 1000; { Buffer size for the data stream }
      TextSegment = 100;  { Characters in display buffer }

var MyStream : tIFile; Text : array [1..TextSegment] of char;


begin
     { Initialize buffered file stream }
     MyStream.Initialize ('..\hamlet.dat', BufferSize);
                          { Filename }     { Buffer size in bytes }

     while not MyStream.IsEnd do begin

           { Read some text from the stream }
           MyStream.Read (Text, SizeOf(Text));

           { Write it on the screen }
           System.Write ( Copy (Text, 1, MyStream.LastTransfer) );
                                       { Number of bytes transferred }

      end;

      MyStream.Intercept;
end.