{$I-,O-,R-}

unit Extend;

{ This unit allows a program to open more than the standard DOS maximum of 20
  open files at one time.  You must also be sure to set a FILES=XX statement
  in your CONFIG.SYS file.  This program installs a special interrupt handler
  under DOS 2.x and uses some semi-documented features under DOS 3.x.  This
  unit USES the DOS unit and should be used before any other units other than
  the DOS unit.  This code was based upon earlier work by Randy Forgaard, Bela
  Lubkin and Kim Kokkonen.  See EXTEND.DOC for more information.

  Scott Bussinger
  Professional Practice Systems
  110 South 131st Street
  Tacoma, WA  98444
  (206)531-8944
  Compuserve [72247,2671]

  Version 3.2 --  9/25/1988 -- Added O- compiler directive to prevent overlaying
                               Moved extended handle table off of heap to support overlay manager
                               Used DosVersion from DOS unit
                               Turned off Range and I/O checking directives
                               Fix exit procedure to chain first rather than last
                               Compiled EXTEND.ASM with TASM
                               Moved USES statement to implementation section
          3.1 --  4/21/1988 -- Removed compiler directives (just uses defaults)
          3.0 -- 10/16/1987 -- Reworked as a UNIT for use with Turbo Pascal 4
                               EXTEND.ASM reworked to be compatible with A86 assembler
                               Added support for DOS 3.3
          2.5 --  3/16/1987 -- EXTEND.ASM worked on by Kim Kokkonen and Brian Foley to work
                                 with Turbo Extender and whittle off a few clock cycles
          2.4 -- 12/16/1986 -- Fixed a problem with DUP under DOS 2.x
                               Now allocates the new handle table on heap
                                 under DOS 3.x (compatible with TDebug+)
          2.3 -- 11/18/1986 -- EXTEND now only affects DOS calls made from
                                 same code segment it was installed from (fixes
                                 problems with EXEC and batch files and already
                                 resident TSR programs
          2.2 -- 10/04/1986 -- Fixed problem with EXEC function destroying all
                                 registers including the stack
                               Changed way that original handle number is kept
                               Permit FORCEDUP to change a standard handle
                               Improve some comments
          2.1 -- 10/02/1986 -- Fixed problem of Turbo assuming the registers
                                 valid after the DOS call
          2.0 -- 10/01/1986 -- Initial release of interrupt handler version
          1.5                  Last version of EXTEND.PAS using explicit
                                 calls to extend files. }

interface

implementation

uses Dos;

type HandleArray = array[0..254] of byte;
     HandleArrayPtr = ^HandleArray;

var ExitSave: pointer;                           { Previous exit procedure }
    NewHandleTable: array[0..254] of byte;       { New table for handles }
    OldInt21: pointer;                           { Save old INT 21 }
    OldHandleTable: pointer;                     { Pointer to original table }
    OldNumHandles: byte;                         { Original number of handles }


{$L EXTEND }
procedure ExtendInit; external;                  { Initialize interrupt handler }
procedure ExtendHandler; external;               { Replacement INT 21 handler }


procedure ExtendHandles;
  { Install the extended handles interrupt.  No files (other than
    standard handles) should be open when unit starts up. }
  begin
  if lo(DosVersion) = 2
   then
    begin
    GetIntVec($21,OldInt21);                     { Install interrupt handler under DOS 2.x }
    SetIntVec($21,@ExtendHandler);
    ExtendInit                                   { Initialize the interrupt handler }
    end
   else
    begin
    fillchar(NewHandleTable,sizeof(NewHandleTable),$FF); { Initialize new handles as unused }
    OldNumHandles := mem[prefixseg:$0032];               { Get old table length }
    OldHandleTable := pointer(ptr(prefixseg,$0034)^);    { Save address of old table }
    mem[prefixseg:$0032] := sizeof(NewHandleTable);      { Set new table length }
    pointer(meml[prefixseg:$0034]) := @NewHandleTable;   { Point to new handle table }
    move(OldHandleTable^,NewHandleTable,OldNumHandles)   { Copy the current handle table to the new handle table }
    end
  end;

{$F+}
procedure UnExtendHandles;
  { Uninstall the extended handles interrupt.  All files (other
    than standard handles) should be closed before unit exits. }
  begin
  ExitProc := ExitSave;                          { Chain to next exit routine }
  if lo(DosVersion) = 2
   then
    SetIntVec($21,OldInt21)                      { Restore old INT21 handler }
   else
    begin
    mem[prefixseg:$0032] := OldNumHandles;             { Restore old table length }
    pointer(meml[prefixseg:$0034]) := OldHandleTable;  { Restore original handle table }
    move(NewHandleTable,OldHandleTable^,OldNumHandles) { Now copy the current handle table back }
    end
  end;
{$F-}

begin
ExitSave := ExitProc;                            { Remember the previous exit routine }
ExitProc := @UnExtendHandles;                    { Install our exit routine }
ExtendHandles                                    { Install the extended handles }
end.
