.nr W 7i
.po -0.5
.tr %\\
.S 11
.SA 1
.TL 
BM User Manual
.AF
.AU "Dave Trulli, NN2Z"
.MT 4 1

.H 1 "What is BM ?"
\f3BM\f1 is designed to serve as the mail user-interface for the 
KA9Q TCP/IP inter-networking package. It provides a full set 
of mail services to the user which allows the sending and receipt
of electronic mail.

.H 1 "BM Installation"
To install \f3BM\f1 requires the modification of the supplied configuration files
and the creation of the proper directory structure.
The following sections describe the file and directory structure
used by \f3BM\f1 and SMTP.

.H 2 "Directory Structure"
.VL 16
.LI %spool%mqueue
This directory holds the outbound mail jobs for SMTP. Each job
consists of 2 files a xxxx.txt and xxxx.wrk file where 
xxxx is a unique numerical prefix.
The format of the files are described in a later section.

.LI %spool%rqueue
This directory is used by SMTP for jobs that have been received
and will be processed by a user defined mail routing program.
This directory is not used directly by \f3BM\f1.

.LI %spool%mail
This directory holds the individual mailboxes for each user name on your
system. The extension .txt is add to the user name to form the mailbox
name. Mail received by the SMTP server is appended to the mailbox file.

.H 2 "Configuration Files"

.H 3 "The %bm.rc file"
The \\bm.rc file provides \f3BM\f1 with the configuration needed for
the operation of the mailer.

The format for the \\bm.rc file is:
.DS I
variable <space>  value <newline>
.DE

The following variables are valid in the bm.rc file:
.sp
.HU "smtp  <mail path>"
defines the path to the directory containing the mailbox files.
The default directory is \\spool\\mail on the current drive.

.HU "host <your host name>"
Is used to set the local hostname for use
in the RFC822 mail headers. This is a required field.

.HU "user <user name>"
Defines the user name of the person who is sending mail.
This is also used as the default mailbox for reading mail.
On the AMPRNET this is usually set to your call.
There is a DOS limit of 8 characters for the user name.

.HU "edit  <path of your editor>"
Defines the name of your favorite editor which can be used
to construct and  edit the text of outgoing messages.
The use of edit is optional.

.HU "fullname <your full name>"
Is used to provide your full name
to the mailer for use in the comment portion of "From:" header line.
The use of fullname is optional.

.HU "reply  <return address>"
Defines the address where you wish to receive replies to messages sent.
This option is useful if you are operating your pc on a local area
network and would like your mail replies sent to a more "well known host".
The address specified by reply is used to generate a "Reply-To:" header 
in outbound mail. The "Reply-To:" header overrides the "From:" header
which is the address normally used to reply to mail. This field is optional.

.HU "maxlet  <number of messages>"
defines the maximum number of messages that can be processed
by \f3BM\f1  in one mailbox file. The default value of maxlet is 100.

.HU "mbox <filename>"
Specifies the default file to be used for the "save" command.
This file is in the same format as a mailbox and may later be viewed using
the -f option of \f3BM\f1. If this option is not used then the default is set
to mbox.

.HU  "record <filename>"
If defined a copy of each message sent will be saved
in <filename>.

.HU "folder <directory name>"
If defined folder contains the path used by the save command.

.HU "screen [bios | direct]"
In the Turboc compiled version of \f3BM\f1, screen sets the display output mode
to use either direct writes to screen memory or the ROM BIOS.
The default is direct which provides the fastest output mode.
If you are using a windowing system
such as Desqview you should set the mode to bios.
.sp
Here is a sample bm.rc file.
.DS I
host nn2z.ampr
user nn2z
fullname Dave Trulli
# send my replies to the Sun
reply nn2z@ka9q.bellcore.com
screen	direct
edit /bin/vi
mbox c:/folder/mbox
record c:/folder/outmail
folder c:/folder
maxlet 200
.DE

.H 3 "The %alias file" 
The alias file provides an easy way to maintain mailing lists.
An alias can be any string of characters not containing the "@" symbol.
The format for the alias file is:
.DS I
alias	recip1 recip2 recip3
<tab>	recip4
.DE
Note that a long list of aliases can be continued on an additional line
by placing a tab or space on the continuation line.
.sp
Some examples aliases are:
.DS I
dave	nn2z@nn2z.ampr

phil	karn@ka9q.bellcore.com

# mail to local nnj users
nnj	wb2cop@wb2cop.ampr karn@ka9q.bellcore.com
	wb0mpq@home.wb0mpq.ampr w2kb@w2kb.ampr ka2tsm@ka2tsm.ampr
.DE
In the above example, when specifying nnj as the recipient,
\f3BM\f1 will expand the alias into the
list of recipients from the alias file.
At this time an alias may not contain any other aliases.

.H 3 "%spool%mqueue%sequence.seq"
The sequence file maintains a message counter which is used
by \f3BM\f1 and \f3SMTP\f1 to generate message ids and unique filenames.
This file is created by \f3BM\f1.

.H 2 "Environment"
The timezone used in mail headers is obtained from the DOS
environment variable TZ. An example TZ setting is:
.DS I
set TZ=EDT4	
.DE
It is set in your AUTOEXEC.BAT file. The first 3 characters are the
timezone and the fourth character is the number of hours
from GMT time. If TZ is not set, GMT is assumed.

.H 1 "Commands"
All \f3BM\f1 commands are single letters followed by optional arguments.
The command list has been designed to make those familiar with Berkeley
mailers comfortable with \f3BM\f1.

.H 2 "Main menu commands"
.HU "m [ userlist ]
The mail command is used to send a message to one or more recipients.
All local recipient names ( those which don't contain an '@' ) are
checked for possible aliases.
If no arguments are supplied you will be prompted for a recipient list.
While entering a message into the text buffer several commands are
available such as: invoking an editor, and reading in text from other messages
or files. See the section below for a description of these commands.
To end a message enter a line containing a single period.
.P
It is important to remember that the input line buffer has a 128 character
limit. You should format your text by entering a carriage return at the
end of each line. Typing excessively long lines may cause data loss
due to truncation when passing the message through other hosts.
Keeping lines less than 80 characters is always a good idea.

.HU "d [ msglist ]"
Mark messages for deletion.
Messages marked for deletion are removed when exiting \f3BM\f1 via the
\f3q\f1 command or when changing to an alternate mailbox with the
\f3n\f1 command.

.HU h
Display message headers. The message headers contain the message
number, the status indicating whether it has been read or deleted, the sender,
size, date, and subject.

.HU "u [ msglist ]"
Undelete a message that is marked for deletion. The status
of a message can be determined by looking at the status field of the
message using the \f3h\f1 command.

.HU "n [ mailbox ]"
Display or change mailbox. The \f3n\f1 command with no arguments
will display a list of mailboxes containing mail. If an argument
is supplied, then the current mailbox is closed and a
new mailbox is opened.

.HU "! cmd"
Run a DOS command from inside \f3BM\f1. An error message will result if 
there is not enough memory available to load the command.

.HU ?
Print a help menu for \f3BM\f1 commands.

.HU "s [ msglist ] [ file ]"
The \f3s\f1 command is used to save 
messages in a file. If no filename is given the default from 
the mbox variable in \\bm.rc is used.
If no message number is supplied then the current message is saved.
The message is stored in the same format as a mailbox file with
all mail headers left intact.

.HU "p [ msglist ]"
The \f3p\f1 command is used to send messages to the printer.
This command uses the DOS device \f3PRN\f1 for output.
This command is equivalent to:
.DS CB
s [ msglist ] PRN
.DE

.HU "w [ msglist ] file"
The \f3w\f1 command is used to save messages
in a file. Only the message body is saved. All mail headers
are removed.
If no message number is supplied then the current message is saved.

.HU "f [ msg ]"
The \f3f\f1 command is used to forward a mail message to another recipient.
If no message number is supplied the current message is used.
The user is prompted for the recipients and a subject. The RFC822
header is added to the message text while retaining the complete
original message in the body.
Also see the ~m command.

.HU "b [ msg ]"
Bounce a message. Bounce is similar to forwarding but instead of
your user information,
the original sender information is maintained.
If no message number is supplied the current message is used.

.HU "r [ msg ]"
Reply to a message. Reply reads the header information in order
to construct a reply to the sender. 
The destination information is taken from the "From:" 
or the "Reply-To:"header, if included.
If no message number is supplied the current message is used.

.HU msg #
Entering  a message number from the header listing will
cause the message text to be displayed.

.HU l
List outbound messages.
The job number, the sender, and the destination for each message
is displayed. A status of "L" will appear if the SMTP sender
has the file locked.

.HU "k [ msglist ]"
Remove an outbound message from the mqueue.
A message can be removed from the send
queue by specifying the job number obtained by the l command.
If the message is locked you will be warned that you may
be removing a file that is currently being sent by SMTP. You
will asked if this job should still be killed.


.HU $
Update the mailbox. This command updates the mailbox, deleting messages
marked for deletion and reading in any new mail that may have
arrived since entering \f3BM\f1.

.HU x
Exit to DOS without changing the data in the mailbox.

.HU q
Quit to DOS updating the mailbox.

.H 2 "Text input commands"
The following commands are available while entering message text into
the message buffer.
.VL 15
.LI "~r <filename>"
read <filename> into the message buffer.
.LI "~m <msg #>"
read <msg #> into the message buffer.
.LI ~p
display the text in the message buffer.
.LI ~e
invoke the editor defined in \\bm.rc with
a temporary file containing the text in the message buffer.
.LI ~q
Abort the current message. No data is sent.
.LI ~~
Insert a single tilda character into the message.
.LI ~?
Display help menu of tilda escape commands.
.LE

.H 1 "Mailer Operation"
.H 2 "Command Line Options"
\f3BM\f1 may be invoked as follows:
.DS I
To send mail:
bm [ -s subject ] recip1 .. .. recipN

To read mail:
bm [ -u mailbox | -f file ]
.DE
.VL 15
.LI "-s subject"
This option sets the subject to the text on the command line.

.LI "-u mailbox"
Specify which mailbox to read. This overides the default from the bm.rc.

.LI "-f file"
Read message from "file" instead of a mailbox.
.LE
.H 2 "Sending Mail"
.H 2 "Reading Mail"
.H 1 "BM/SMTP Interface"
.H 2 "File Formats"
.H 1 "Bug Reports"
Please send any comments, suggestions or bug reports to:
.DS CE
Dave Trulli 
Usenet: nn2z@ka9q.bellcore.com
packet: nn2z@nn2z
AMPRNET: nn2z@nn2z.ampr [44.64.0.10]
.DE
