
   NNAAMMEE
      date - display or set system date and time

   SSYYNNOOPPSSIISS
      ddaattee [ -h ] [ -u ] [ _m_m_d_d_h_h_m_m[_y_y] ] [ +_f_o_r_m_a_t ]

   DDEESSCCRRIIPPTTIIOONN
      If no argument is given, or if the argument begins with +, ddaattee
      displays the current date and time.  Otherwise, the current date
      and time is set.

      When setting the date, the first _m_m is the month number; _d_d is the
      day number in the month; _h_h is the hour number (given in the 24
      hour system); the second _m_m is the minute number; _y_y is the last 2
      digits of the year number and is optional.  The current year is the
      default if no year is mentioned.

      If the argument begins with ++, the output of ddaattee is under the
      control of the user.  The format for the output is similar to that
      of the first argument to printf(3S).  All output fields are of
      fixed size (zero padded if necessary).  Each field descriptor is
      preceded by %% and will be replaced in the output by its
      corresponding value.  A single %% is displayed with %%%%.  All other
      characters are copied to the output without change.  The string is
      always terminated with a new-line character.

      Field Descriptors:
         n  insert a new-line character
         t  insert a tab character
         m  month of year - 01 to 12
         d  day of month - 01 to 31
         y  last 2 digits of year - 00 to 99
         Y  all 4 digits of year
         D  date as mm/dd/yy
         H  hour - 00 to 23
         M  minute - 00 to 59
         S  second - 00 to 59
         T  time as HH:MM:SS
         j  day of year - 001 to 366
         w  day of week - Sunday = 0
         a  abbreviated weekday - Sun to Sat
         h  abbreviated month - Jan to Dec
         r  time in AM/PM notation
         z  current timezone

   OOPPTTIIOONNSS
      --hh Display a short help message.

      --uu Display the date in GMT (universal time).  This option makes
         sense only if the TZ environment variable is set.

   EEXXAAMMPPLLEESS
         date 10090842

      Would set the date to October 9, 8:42 AM.

      If the year were 1992, and the date was set as above,
         date "+DATE: %m/%d/%y%nTIME: %H:%M:%S"

      would generate as output:

           DATE: 10/09/92
           TIME: 08:42:00

   CCooppyyrriigghhtt  ((cc))  11999922  FFrraannkk  EE..  WWhhaalleeyy  AAllll  rriigghhttss  rreesseerrvveedd
