/*
 * Handle the module end record
 *
 * If a LINK PASS seperator is found during pass 1, the module end record
 *   will never be encountered.  We are ignoring the MAIN MODULE flag;
 *   in a DOS .COM file it would be used to move the main module to the
 *   head of the file but we have a relocatable start address.
 *
 * OMF specs say a link pass seperator can't be present in a module with
 *   a specified start address, implying a gathering of start address during
 *   pass 1.  We ignore this, gathering the start address during pass 2
 *   when the pass seperator is ignored.  There seems to be no good reason
 *   for limiting the gathering to pass 1; in fact borland assembler ignores
 *   the note and puts a link pass seperator into modules that have
 *   defined start addresses.
 */
#include <stdio.h>
#include "utype.h"
#include "module.h"
#include "fixup.h"
#include "modend.h"
#include "error.h"


/* The start address, fixed up */
uint StartAddress = 0;

/* A bool telling we have loaded the start address */
static BOOL HasStartAddress = FALSE;

/*
 * Routine to read the modend record
 */
void ModEnd( BOOL is32, BYTE *buffer, int size, char *name, uint pass)
{
  // Get the type
  uint modtype = ReadByte(&buffer, &size);

  // Quit if pass 1
  if (pass == 1) return;

  // If has start address either issue error or read in the fixup record
  if (modtype & ME_START) {
    if (HasStartAddress)
			Error("Multiple start address defined in %s", name);
		else {
			uint address, tsize;
			HasStartAddress = TRUE;
			StartAddress = (uint)ReadFixupRecord(is32, &buffer, &size, name,
				 &address, &tsize, TRUE);
		}
	}
  CheckSize(size);
}
/*
 * Called from main program to theck if a start address has been defined
 */
void CheckEnd(void)
{
  if (!HasStartAddress)
		Error("No start address specified");
#ifdef DEBUG
    printf("Program start address offset %x\n", StartAddress);
#endif
}