/*
   IRQR -- Report status of IRQs in the H248 computer, PC/AT or compatibles.
   Copyright 1988 by Lawrence R. Steeger

   Based upon IRQS by Joseph Katz (Copyright 1988 by Joseph Katz), which
   was published in Katz's "C Notes" in SEXTANT No. 34 - Late Spring 1988.

   (Microsoft C Version 5)

 */

#include "stdio.h"
#include "conio.h"

#define NUMPORTS 2

typedef struct {
		unsigned int number;
		char* name;
	} irqport;

unsigned int    status,
		bit,
		p8259;

static irqport  port[] = {{0x21,"0x21"},
			  {0xA1,"0xA1"}};

static char     free[] = ">FREE",
		used[] = " used";

static char*    ibm[] = {"Timer",
			 "Keyboard",
			 "2nd 8259",
			 "COM2",
			 "COM1",
			 "LPT2",
			 "Floppy Disk",
			 "LPT1",
			 "Clock",
			 "Redirected IRQ2",
			 "(reserved)",
			 "(reserved)",
			 "(reserved)",
			 "Coprocessor",
			 "Hard Disk",
			 "(reserved)"};

static char*    oem[] = {"",
			 "",
			 "Autofax Imager",
			 "",
			 "",
			 "MS Bus Mouse",
			 "",
			 "",
			 "",
			 "",
			 "",
			 "",
			 "",
			 "",
			 "",
			 ""};

main()
{
	puts("IRQR --\tReport Status of 8259 Hardware Interrupt Channels");
	puts("\tCopyright 1988 by Lawrence R. Steeger\n");
	puts("\t8259  IRQ  Status   IBM Assignments  OEM Assignments");
	puts("\t----  ---  ------   ---------------  ---------------");

	/* display status of 8259 IRQs */

	for (p8259 = 0; p8259 < NUMPORTS; p8259++) {

		/* get 8259 status port information */

		status = inp(port[p8259].number);

		for (bit = 0; bit <= 7; bit++) {
			printf("\t%-4s  %3d  %6s   %-15s  %s\n",
			((bit == 0) ? port[p8259].name : ""),
			(bit + (p8259 * 8)),
			((status >> bit) & 1) ? free : used,
			ibm[(bit + (p8259 * 8))], oem[(bit + (p8259 * 8))]);
		}

		if ((p8259 + 1) < NUMPORTS) puts("");
	}

	exit(0);
}

/* end of IRQR.C */

