unit ppchi2_u;

interface
  uses ppnd_u,gamain_u;

function ppchi2(p,v,g:double;var ifault:integer):double;

implementation

function ppchi2(p,v,g:double;var ifault:integer):double;

{
c
c     algorithm as 91  appl statist (1975) vol 24, no 3, pp 385-388
c
c     to evaluate the percentage points of the chi-squared
c     probability distribution function.
c     p must lie in the range 0.000002 to 0.999998, v must be positive,
c     g must be supplied and should equal ln(gamma(v/2.0))
c
}
const
  e = 0.5E-6;
  aa = 0.6931471805;

var
  x,xx,
  ch,
  a,b,c,
  q,
  p1,p2,
  t,tdjm,
  s1,s2,s3,s4,s5,s6
    : double;
  if1
    : integer;

label
  label6,
  label4;

begin

{     after defining acuracy and ln(2), test arguments and initialise }

      ppchi2 := -1.0;
      ifault := 1;
      if (p < 0.000002) or (p>0.999998) then
        exit;

      ifault := 2;
      if (v<=0.0) then
        exit;

      ifault := 0;
      xx := 0.5*v;
      c := xx - 1.0;
{
     starting approximation for small chi-squared.
}
      if(v<-1.24*ln(p)) then
      begin
        ch := exp(ln(p*xx*exp(g+xx*aa))*(1.0/xx));
        if(ch-e < 0.0) then
          goto label6
        else
          goto label4;
      end
      else

{     starting approximation for v less than or equal to 0.32
}
      {    1 continue}

      if (v<=0.32) then
      begin
        ch := 0.4;
        a := ln(1.0-p);
        repeat
       { 2} q := ch;
          p1 := 1.0 + ch * (4.67+ch);
          p2 := ch*(6.73+ch*(6.66 + ch));
          t := -0.5 + (4.67 + 2.0*ch)/p1 -
           (6.73 + ch*(13.32 + 3.0*ch))/p2;
          ch := ch - (1.0-exp(a+g+0.5*ch + c*aa)*p2/p1)/t;
        until(abs(q/ch-1.0) - 0.01 <= 0.0) { 4, 4, 2 }
      end
      else
      begin
{
c     call to algorithm as 70 - note that p has been tested above.
}
      { 3} x := ppnd(p,if1);
{
c     starting approximation using wilson and hilferty estimate.
}
        p1 := 0.222222 / v;
        tdjm := x*sqrt(p1) + 1.0 - p1;
        ch := v * tdjm*sqr(tdjm);
{
c     starting approximation for p tending to 1.
}
      if(ch>2.2*v+6.0) then
        ch := -2.0*(ln(1.0-p)-c*ln(0.5*ch)+g);

     end;
{
c     call to algorithm as 32 and calculation of seven term
c     taylor series.
}
     label4:
     repeat
   { 4} q := ch;
      p1 := 0.5*ch;
      p2 := p-gamain(p1,xx,g,if1);
      if(if1<>0) then
      begin
        ifault := 3;
        exit;
      end;
    {5} t := p2*exp(xx*aa+g+p1-c*ln(ch));
      b := t / ch;
      a := 0.5*t-b*c;

      s1:=(2.1e2+a*(1.4e2+a*(1.05e2+a*(8.4e1+a*(7.0e1+6.0e1*a)))))/4.2e2;
      s2:=(4.2e2+a*(7.35e2+a*(9.66e2+a*(1.141e3+1.278e3*a))))/2.52e3;
      s3:=(2.1e2+a*(4.62e2+a*(7.07e2+9.32e2*a)))/2.52e3;
      s4:=(2.52e2+a*(6.72e2+1.182e3*a)+c*(2.94e2+a*(8.89e2+1.74e3*a)))/
                             5.04e3;
      s5 := (8.4e1+2.64e2*a + c*(1.75e2+6.06e2*a))/2.52e3;
      s6:=(1.2e2+c*(3.46e2+1.27e2*c))/5.04e3;

      ch := ch+t*(1.0+0.5*t*s1-b*c*(s1-b*(s2-b*(s3-b*(s4-b*(s5-b*s6))))));
     until (abs(q/ch-1.0)<=e);

    label6:
      ppchi2 := ch;
end;

end.
