//------------------------------------------------------------------------
//
// Last update: 18 Feb 2000
//------------------------------------------------------------------------

#include "grid.h"
extern "C"
{
#include "memory.h"
}
#include "labels.h"
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "file.h"
//------------------------------------------------------------------------
void Grid::TwistBlockVars()
{
	int t;

	if(block.y1> block.y2)
	{
		t = block.y1;
		block.y1 = block.y2;
		block.y2 = t;
	}

	if(block.x1 > block.x2)
	{
		t = block.x1;
		block.x1 = block.x2;
		block.x2 = t;
	}



}
//------------------------------------------------------------------------
//Get block vars
//if the ending coordinates are greater than the starting cooordinates
//twist them to normal
void Grid::GetBlockVars()
{
	int t;

	block.x1 = orgcx;
	block.y1 = orgcy;
	block.x2 = letters[scrncol] -'A';
	block.y2 = homey+scrnrow;
	TwistBlockVars();
}
//-------------------------------------------------------------------------
//------------------------------------------------------------------------
void Grid::DispScrollBar()
{
	float f_topline, f_cursorpos, f_cursorlen, x, f_lines, f_cline;
	int topline, tt;
	char a1, a2, a3;

	a1 = gbc[0]*16+gfc[0];
	a2 = gbc[0]*16 +gfc[0];
	a3 = gbc[4]*16+gfc[4];

	cline = homey+scrnrow+1;
	f_cline = cline;

	//lines = a->GetLines();
	f_lines = lines;
	topline = cline - (scrnrow);
	f_topline = topline;

	if(cline == 40)
	{
		tt =1;     //for debugging only
	}

	if(lines <= 22)
	{
		f_cursorlen = 20;
	}
	else
	{
		f_cursorlen = (float) 20 * ((1 / f_lines) *22);
		if( f_cursorlen < 1) f_cursorlen =1;
	}


	if(lines <= 22)
	{
		f_cursorpos =1;
	}
	else
	{
		f_cursorpos = ((1/f_lines) * f_topline) *20;
	}
	cursorpos = f_cursorpos;

	cursorlen = f_cursorlen;
	if((cursorpos+ cursorlen) > 20)
		cursorpos--;

	if((topline + 21) >= lines)
	{
		cursorpos = 20 - cursorlen;
	}
	a->ShowVerticalScrollBar(79, 2, 20, cursorlen, cursorpos, a1, a2, a3);

}
//------------------------------------------------------------------------
//display the status line

void Grid::DispStatusLine()
{

	int len;
	char numbuf[40], *p;
	p = numbuf+1;

	strcpy(statusline,
											"                                                                      ");
	len = strlen(statusline);
	statusline[len-2] = 179;



	a->ShowTopMenu(0);             //show top menu off
	//a->WriteLine(statusline, 0, 24, 80, gbc[3]*16+gfc[3]);
	DispScrollBar();

}
//---------------------------------------------------------------------


//-------------------------------------------------------------------------
//setup default values for class
Grid::Grid()
{
	unsigned int i, t, c, odd;
	unsigned int tt;
	modified =0;

	lines = y100;
	y99 = y100 -1;
	y2600 = y100*26;
	y78 = y100 - 22;

	lpp = 58;    //for print.cpp
	lm =2;
	double_click = 44;
	strcpy(printerfile, "LPT1"); //global printer filename:

	m_boxlevel =0; //global var for screen save level
	//---
	strcpy(editortitle, "UNTITLED");
	currentpath[0] =0;
	gbc[0] = DARKGRAY;       //window border
	gfc[0] = LIGHTGRAY;

	gbc[1] = LIGHTGRAY;		  //menubar
	gfc[1] = BLACK;

	gbc[2] = WHITE;            //lighlight in cells
	gfc[2] = BLACK;

	gbc[3] = DARKGRAY;      	//status line
	gfc[3] = BLACK;

	gbc[4] = BLUE;     	//scroll bar
	gfc[4] = LIGHTGRAY;

	gbc[5] = BLUE;           	//(cell cursor)
	gfc[5] = WHITE;

	gbc[6] = BLACK;      	//block of cells
	gfc[6] = LIGHTGRAY;

	gbc[7] = CYAN;           	//Alt row1
	gfc[7] = BLACK;

	gbc[8] = LIGHTGRAY;      	//Alt row2
	gfc[8] = BLACK;
	//---

	block.validsw =0;     //block not selected yet

	block.x1 =0;
	block.y1 =0;            //for demo and testing
	block.x2 =0;
	block.y2 = 0;
	c_block = block;       //null the clipboard block as well

	homey =0;
	scrncol =0;
	scrnrow =0;
	orghomey = 0;
	orgscrnrow = 0;
	orgscrncol = scrncol;
	orgcx = 0;
	orgcy = orghomey+orgscrnrow;

	//init the scrnsheet[], before attempting to use it or load
	//an old one in
	for(t=0; t<26; t++)
	{
		colwidths[t] = 10;
	}
	//colwidths[1] =1;
	//colwidths[8] = 2;

	//odd =0;  //true choose green
	SetAltRows(); //colour alternative rows
	for(t = 0; t<y2600; t++)
	{
		//if(t%26 ==0 ) odd = !odd;  //switch colours for next row

		//if(odd) scrnsheet[t].colour 	 = (unsigned char) LIGHTGRAY*16+BLACK;
		//else   scrnsheet[t].colour 	 = (unsigned char) CYAN*16+BLACK;
		//scrnsheet[t].colour = gbc[2] *16+gfc[2];
		scrnsheet = sheet[t];
		scrnsheet->u.decplaces = 2; //set any number
		scrnsheet->u.allign 	 = 0;  //default: text left align, numbers right align
		scrnsheet->u.commas 	 = 0;  //nums not in commas
		scrnsheet->u.locked =0;
		scrnsheet->u.percent =0;      //reset the precentage display flag
		sheet(t, scrnsheet);
	}

	//-----------------------
	//If there is a previous scrnsheet[] on disk read it in
	han = fopen("c:\\grid.ara", "r+b");  //try to open a previous sheet file

	if( han != NULL)
	{   //we opened a previous grid file for reading & writing.
		rewind(han);
		for(t = 0; t< 9; t++)
		{
			fread(&c, sizeof(int), 1, han);
			gbc[t] = c/16;
			gfc[t] = c%16;
		}
		SetAltRows(); //colour alternative rows


		fread(&currentpath, 126, 1, han);
		fread(&editortitle, 126, 1, han);

		fread(printerfile, 22, 1, han);
		fread(&lm, sizeof(int), 1, han);
		fread(&lpp, sizeof(int), 1, han);
		fread(&double_click, sizeof(int), 1, han);

		chr = printerfile[0];
		if(chr ==0 || chr >127)
		{
			strcpy(printerfile, "LPT1");
		}

		if(lm < 0 || lm >5) lm = 2;
		if(lpp <20 || lpp >65) lpp = 58;
		if(double_click <34 || double_click >46) double_click =44;


	}
	//-----------------------
	fclose(han);

	scrncol = 0;
	scrnrow = 0;
	homex =0;
	homey =0;
	calc = 1;  //auto calc
	a->m_menu[4][2].txt[6] = ' '; //manual off
	a->m_menu[4][1].txt[4] = '*'; //auto on


	DrawBorder(homex, homey);
	DispStatusLine();

}
//-------------------------------------------------------------------------
//
Grid::~Grid()
{
	int c, t;

	han = fopen("c:\\grid.ara", "w+b");
	if(han == NULL)
	{
		printf("Cannot open file: [grid.ara] to dump data before closing program\n");
		exit(0);
	}
	rewind(han);
	for(t = 0; t< 9; t++)
	{
		c = gbc[t]*16+gfc[t];
		fwrite(&c, sizeof(int), 1, han);
	}

	_getcurrentpath();
	fwrite(&currentpath, 126, 1, han);
	fwrite(&editortitle, 126, 1, han);

	fwrite(printerfile, 22, 1, han);
	fwrite(&lm, sizeof(int), 1, han);
	fwrite(&lpp, sizeof(int), 1, han);
	fwrite(&double_click, sizeof(int), 1, han);



	fclose(han);
}
//-------------------------------------------------------------------------
//colour alternative rows in accordance with the colours in
//gbc[7]*16+gfc[7] and gbc[8]*16+gfc[8]
//for axample: every second row is coloured with gbc[7]*16+gfc[7]
//and every in-between row is coloured with gbc[8]*16+gfc[8]
void Grid::SetAltRows()
{
	unsigned int t, odd =0;  //true choose green

	for(t = 0; t<y2600; t++)
	{
		if(t%26 ==0 ) odd = !odd;  //switch colours for next row

		scrnsheet = sheet[t];
		if(odd)
		{
			scrnsheet->u.colour 	 = (unsigned char) gbc[8]*16+gfc[8];
			sheet(t, scrnsheet);
		}

		else
		{
			scrnsheet->u.colour = (unsigned char) gbc[7]*16+gfc[7];
			sheet(t, scrnsheet);
		}

	}

}
//-------------------------------------------------------------------------
// this function is called by a col insertion and deletion.
//It sets the alternating pattern for the rows starting from absolute
//row 0 all the way down to row 99.
//The col being treated is the one  the cursor is at.
void Grid::SetAltCol(int cx)
{
	unsigned int cy, t, odd;

	for(cy = 0; cy < y100; cy++)
	{
		odd = cy%2;  //even = true, odd = false
		t = 26*cy+cx;
		scrnsheet = sheet[t];   //get properties for this cell
		if(!odd)
		{
		 scrnsheet->u.colour 	 = (unsigned char) gbc[8]*16+gfc[8];
		 sheet(t, scrnsheet);    //store this cell's properties
		}

		else
		{
		  scrnsheet->u.colour = (unsigned char) gbc[7]*16+gfc[7];
		  sheet(t, scrnsheet);
		}
	}

}
//-------------------------------------------------------------------------
//draw the column and left margin borders
int Grid::DrawBorder(int hx, int hy)
{

	char *p, temp[2];
	int acc, cx, t, x, y, cw, cr, l, totalwidth;

	temp[0] = 179;
	temp[1] = 0;
	totalwidth =0;
	l =0;
	memset(linebuf1, ' ', 79);
	strcpy(linebuf2, "    ");

	t = 75;
	x = hx;
  p = linebuf1;
  //colwidths[1] = 4;

h:
	if(x == 26) goto ex;
	cw = colwidths[x];
	if(cw == 0) {x++; goto h;}
	cr = cw/2;    //centre
	*p = 179;
	*(p+cr) = x+'A';
	letters[l] = x+'A';
	starts[l] = p - linebuf1;   //starting pos for each header column
	l++;                        //that is currently being displayed
	p += cw;
	totalwidth += colwidths[x];

	if(totalwidth <75)
	{
		x++;
		goto h;
	}


ex:
	*p = '\0';
	letters[l] =0;
	cx = letters[l-1] - 'A';

	strcat(linebuf2, linebuf1);
	a->WriteLine(linebuf2, 0, 1, 79, gbc[0]*16+gfc[0]);
	l = strlen(linebuf1);
	p = linebuf1-1;
	for(t =0; t <l; t++)
	{
		p++;  //colour all the little vertical lines
				//separating the columns in black
		if(*p == (char) 179)
		{
			a->WriteLine(temp, 4+t, 1, 1, gbc[0]*16+BLACK);
		}

	}

	y = hy;
	if(y+21> y99) y = y99 - 21;
	l = 0;
	for(t = y; t< y+22; t++)
	{
		sprintf(linebuf1, "%3d", t+1);
		a->WriteLine(linebuf1, 0, l+2, 4, gbc[0]*16+gfc[0]);
		l++;
	}

	linebuf1[0] = 191;
	a->WriteLine(linebuf1, 79, 1, 1, gbc[0]*16+gfc[0]);

	return 0;
}
//-------------------------------------------------------------------------
//Get a cells formula and answer into the two buffers
//[answer] and [formula]
//Convert the answer into a string and allign it in accordance
//with the screen cells allignment value
//return the colour of that screen cell in the colour var
//Entry:
//  par an object of the Parse class
//  a   an object of the Disk class  (string alignment routines)
//  answer   the buf to return the answer in
// formula   the buf to return the formula in
// cx        the c column # of the parser's cell
// cy        the c row # of the parser's cell
// colour    the bombined background and foreground colours for the cell

int Grid::GetLineBuf(char *answer, char *formula,
																int cx, int cy, int *colour)
{
	ScreenCell *sc;
	int ch, t, l, dec, coma, allign, align, percent;
	unsigned int loc = cy *26+cx;
	int width = colwidths[cx];
	char cell_name[10];
	char tempbuf[80];

	Cell *j;
	par->errnum =0;    //cancle any possble previous error so that parser
							 //will work.
	scrnsheet = sheet[loc];
	dec	  = scrnsheet->u.decplaces;
	coma	  = scrnsheet->u.commas;
	allign  = scrnsheet->u.allign;
	*colour = scrnsheet->u.colour;
	percent = scrnsheet->u.percent;

	memset(answer, ' ', width);
	memset(tempbuf, ' ', width);
	*(answer+width) = 0;
	*(tempbuf+width) = 0;
	itoa(cy+1, &cell_name[1], 10);
	cell_name[0] = 'A'+cx;

	j = par->Find(cell_name);
	t =0;
	if(j == NULL)
	{
		strcpy(formula, "Empty");
		return 0;   //flag empty
	}

	switch(j->answer.type)
	{
		case 1:   //text
			ch = j->answer.text[0];
			l = strlen(j->answer.text);
			if((l >1) && (ch == 39)) t =1; //if single quote at start skip it
			else t =0;
			strcpy(answer, &(j->answer.text[t]));

		  break;

		case 2:   //numeric
			if(percent)  	//if the percentage flag for this cell is
			{							//on multiply by 100 for display purposes only.
				j->answer.numeric *=100;
				percent=1;
			}
			a->Number(answer, j->answer.numeric, dec, coma, percent);  //number to str
			break;

		default:
			strcpy(answer, j->answer.text);
			break;
	}

	//set the alignment of the text
	//if we havent met a opening single quote trim any left spaces
	if(!t) l = a->LeftTrim(answer);
	if(l) l = a->RightTrim(answer);
	if(!l)
	{
		memset(answer, ' ', colwidths[cx]);
		answer[colwidths[cx]] =0;
		//strcpy(answer, " ");
		l =1;
	}
	if(l >= width) goto ex;
	switch(allign)
	{
		case 0:    //text must be left, number must be right
			if(j->answer.type ==1) goto ex;   //text already left
			if(j->answer.type ==2)
			{
				a->AllignRight(answer, width);
			}
			break;

		case 1:       //text or num must be left alligned
			goto ex;   //already left alligned

		case 2:       //text or number must be cemtred
			a->AllignCentre(answer, width);
			break;
		case 3:
			a->AllignRight(answer, width);
			break;
	}


ex:
	strcpy(formula, j->input);

	return j->answer.type;  //tell caller whether text or number in string
}
//-------------------------------------------------------------------------
//don't allow nonblank adjacent cells to be overwritten
//return the max width within which the cell's text can be written.
//if the cell's text spill out of the cell width
//then for all adjacent blank screen cells allow the
//current cell's text to spill over them.
int Grid::GetMaxWidth(int cx, int cy, int desired)
{
	int lx, loc, let, cc, width;
	char cell_name[10];
	Cell *j;

	lx = strlen(letters);
	cc = scrncol;

top:
	width = (starts[cc] + colwidths[letters[cc] - 'A'])  - starts[scrncol];

	if((starts[scrncol] + width) >=75)
	{
		width = (75 - starts[scrncol]);
		if(desired <=width ) return desired;
		else return width;
	}

	if(desired <=width) return desired;

	//desired is greater than width. see if we have a blank adjacent cell
	cc++;
	if(cc == lx) return width;
	//if(par->sheet[letters[cc]-'A' *26+cc] == 0) goto top;

	cell_name[0] = letters[cc];
	itoa(cy+1, &cell_name[1], 10);
	par->errnum =0;         //just in case cell is not allocated
	j = par->Find(cell_name);
	if(j == NULL) goto top;
	if(j->answer.type ==0) goto top;

	return width;
}
//-------------------------------------------------------------------------
//return any spill over text (from the right of the text)
//for use in a blank cell at the relative 1st screen cell location
// Entry:
//   scrncol = the current relatve screen col (0 based)
// Exit:
//   ax = len of text returned, or 0 if none
//   buf = the returned text (right most spill over)
int Grid::PreText(char *buf, int cy)
{
	int colour, lx, l, x, cx, sx, acc, t;
	unsigned int loc;
	char tempbuf[128];
	char inputbuf[128];
	Cell *j;

	if(scrncol)  return 0;   //must be on relative 1st cell

	cx = letters[scrncol]-'A';
	sx = cx;
	t = -1;
h:
		t++;
		sx--;
		if(sx <0) return 0;
		loc = 26* cy+sx;
		scrnsheet = sheet[loc];
		x = scrnsheet->u.type;
		if(x <1 || colwidths[sx] ==0) goto h;
	t++;      //t = r # of prev cells found

	GetLineBuf(tempbuf, inputbuf, sx, cy, &colour);
	//add up the length of all the columns from sx to cx-1
	acc =0;
	for(t = sx; t<= cx-1; t++)
	{
		acc+= colwidths[t];
	}
	//if the string is greater than acc it means the string
	//spills over.
	//therefore the amount of the string to get is from
	//acc to either the end of the string of colwidth[sx]
	//(which ever is shorter)
	//but if the string smaller than or equal to acc
	//don't display it.

	lx = strlen(tempbuf);
	if(lx <= acc) return 0;   //don't display it

	strcpy(buf, &tempbuf[acc]);
	//There is definately something to be displayed
	//the question now is: can we display all of
	//the truncated string from its middle to the end of it?
	//tell the caller the size of the string to be displayed
	//get the max size
	//find out how many blank cells there are to the right
	//of scrncol
	l = strlen(letters);
	if(l <2) return colwidths[cx];   //size = only current column
	acc =colwidths[cx];
	for(t = 1; t<l; t++)
	{
		sx = letters[t] - 'A';
		loc = cy*26+sx;
		scrnsheet = sheet[loc];
		if(scrnsheet->u.type <1) acc+= colwidths[sx];
		else break;
	}

	if(acc > 75) acc = 75;

	return acc;

}

//-------------------------------------------------------------------------
//Display the text (originally from a cell)
//that is currently in linebuf1 on the screen at location
//scrncol, scrnrow

int Grid::DispCell1(char *linebuf1, char *formula,
						unsigned int colour, int sel,int cx, int cy)

{
	int size, m,l, i, t, color, ll, offcolour, inrange;
	unsigned int x, y;
	offcolour = gbc[7]*16+gfc[7];    //normal text colour
	if(cy%2) offcolour = gbc[8]*16+gfc[8];    //normal text colour
	Cell *j;
	m =1;  //assume there is some text in the cell to print
	char cell_name[6];



	cell_name[0] = cx+'A';
	itoa(cy+1, &cell_name[1], 10);
	par->errnum =0;
	j = par->Find(cell_name);
	if(j == NULL || j->answer.type ==0) m =0;
	scrnsheet = sheet[(unsigned int) cy*26+cx];
	switch(sel)
	{
		case 0:    //user's wants off colour
			color = scrnsheet->u.colour;

			//color = gbc[2]*16+gfc[2]; //normal (off) text colour
			break;

		default:    //give user blue
			color = gbc[5]*16+gfc[5];  //blue
			break;
	}

h1:
	x = starts[scrncol];
	size = colwidths[cx];
	if(!size) return 0;

	//make sure we don't overwrite the space on the screen
	//of an adjacent cell if that adjacent is not blank
	l = GetMaxWidth(cx, cy, strlen(linebuf1));
	if(size >l)
	{
		if((scrncol+1) == strlen(letters))
			size =l; //if its last scrn col reduce size to l
	}


	if(!m)   //empty cell
	{
		if(!sel) color = scrnsheet->u.colour;
		a->ColourLine(x+4, (cy+2)-homey, size, color);

		if(!scrncol) //its a null cell, if we're at the relative beginning
		{            //try to get any spill over text from a previous cell

			if(chr == 'a' )
			{
				chr = chr+0;
			}
			i = PreText(linebuf1, cy);
			if(i)  //if there is spill over text show it first in the offcolour
			{      //then show width amount of it in the cell's colour
				size = i;
				a->WriteLine2(linebuf1, x+4, (cy+2)-homey, size, offcolour);
				size = colwidths[cx];
				a->WriteLine(linebuf1, x+4, (cy+2)-homey, size, color);
			}
		}
	}
	else  //cell not empty
	{
		a->WriteLine2(linebuf1, x+4, (cy+2)-homey, l, offcolour);
		l = strlen(letters);
		if((cx >1) && (color == gbc[2]*16+gfc[2]))
		{
		  cx++;
		  cx--;
		}

		a->WriteLine(linebuf1, x+4, (cy+2)-homey, size, color);

	}

	if(sel)
	{    //display the formula in the status area

		  tempbuf[0] = 'A'+cx;
		  itoa(cy+1, &tempbuf[1], 10);
		  //a->WriteLine(tempbuf, 70, 24, 8, gbc[3]*16+gfc[3]);
		  strcat(tempbuf, " ");
		  l = strlen(tempbuf);
		  tempbuf[l] = '=';
		  tempbuf[l+1] = 0;
		  strcat(tempbuf, "   ");
		  tempbuf[7] =0;
		  if(scrnsheet->u.locked)
			strcat(tempbuf, "Locked!");
		  else
			strcat(tempbuf, formula);
		  a->WriteLine(tempbuf, 1, 24, 79, gbc[3]*16+gfc[3]);
		  strcpy(tempbuf, " ");
		  a->WriteLine(tempbuf, 0, 24, 1, gbc[3]*16+gfc[3]);
	}

	return size;
}
//-------------------------------------------------------------------------
//move the cell cursor to the right.
//If on last possible visible column exit, else
//if on right margin move entire screen right,else
//move to next visible column
//Exit:
//  ax = 1 if job done

int Grid::CursorRight(int active)
{
	int width, x, l, size, t, cx, sx;
	char *p, *p1, oldch;
	int ch;
	p1 = letters;

	DispCell(0);   //turn blue cursor off
	cx = letters[scrncol]-'A';
	if(cx == 25) return 0;

	l = strlen(letters);
	if(scrncol+2 < l)   //if next col is not that last
	{                    //just move to it
		scrncol++;
		DispCell(active);
		return 1;             //job done

	}
	if(scrncol+1 ==l) goto top1;

	if(scrncol+2 == l)   //if on the 2nd last screen cell
	{
		//the next col position is the last
		//if the whole of it is current being displayed
		//just move the cursor to it
		sx = letters[scrncol+1] - 'A';
		width = colwidths[sx];  //wdth of next col
		x = starts[scrncol+1] + width;
		if(x <=75)  //display whole of next col
		{
			DispCell(0);   //turn blue cursor off
			scrncol++;
			DispCell(active);
			return 1;             //job done
		}

top1:	//the next column to move the cursor onto is only half
		//displayed
		//inclrease the homex, and redraw the screen
		ch = letters[scrncol];
		oldch = ch;
top:
		homex++;
		DrawBorder(homex, homey);
		//-----
		p = strchr(p1, ch);  //look for current column
		if(p == NULL)  //not found cause next col letter
							//moved to begining of string
		{
			scrncol =0;
			sx =0;
			goto nul;
		}

h:		ch++;
		if(colwidths[ch-'A'] ==0) goto h;  //get the next visable col
h1:
		p = strchr(p1, ch); //scan letters[] looking for ch
		if(p == NULL)
		{
h2:		homex++;
			DrawBorder(homex, homey);
			goto h1;
		}

		scrncol = (p - letters);
		sx = ch - 'A';
nul:
		width = colwidths[sx];  //wdth of curren col
		x = starts[scrncol] + width;
		if(x <=75)  //display whole of next col
		{
			//a->ClrScr(4, 2, 78, 23, gbc[2]*16+gfc[2]);
			ReDrawSheet(1);
			//a->ScrollLeft(4+size, 2, 78, 23, size, gbc[2]*16+gfc[2]);
			DrawSheet();
			DispCell(active);
			return 1;             //job done
		}
		else goto h2;  //inc homex again
		//-----


		//size = colwidths[cx];
		//a->ClrScr(4, 2, 78, 23, gbc[2]*16+gfc[2]);
		//a->ScrollLeft(4+size, 2, 78, 23, size, gbc[2]*16+gfc[2]);
		//DrawSheet(par, a);
		//return 1;  //job done
	}


	//we are currently at the right margin. See if any more
	//visible columns left. If so move the screen right to
	//bring that column into view and display the cursor
	//on that column.
	cx = letters[scrncol]-'A';
	t =0;
	do{
		if(cx+t == 25) return 0;
		t++;
	}while(!colwidths[cx+t]);

	homex+=t;
	DrawBorder(homex, homey);
	size = colwidths[cx+t];
	ReDrawSheet(1);
	//a->ClrScr(4, 2, 78, 23, gbc[2]*16+gfc[2]);
	//a->ScrollLeft(4+size, 2, 78, 23, size, gbc[2]*16+gfc[2]);

	DrawSheet();

	return 1;  //job done
}
//-------------------------------------------------------------------------
//move the cell cursor to down.
//Exit:
//  ax = 1 if job done

int Grid::CursorDown(int active)
{
	int colour1, colour2;
	int cy = homey + scrnrow;
	int temcol = scrncol;
	if(cy == y99) return 0;
	DispCell(0);   //turn blue cursor off
	if(scrnrow <21)
	{
		scrnrow++;
		return 1;
	}

	if(cy%2)
	{
		colour1 = gbc[7]*16+gfc[7];
		colour2 = gbc[8]*16+gfc[8];
	}
	else
	{
		colour1 = gbc[8]*16+gfc[8];
		colour2 = gbc[7]*16+gfc[7];
	}

	//we are on the last relative screen row. There is a line below
	//scroll the screen up and display it
	a->ScrollUp(4, 3, 78, 23, colour2); //cell area
	a->ScrollUp(0, 3, 3, 23, gbc[0]*16+gfc[0]);  //left border

	homey++;
	DrawRow();
	sprintf(linebuf1, "%3d", homey+scrnrow+1);
	a->WriteLine(linebuf1, 0, 23, 4, gbc[0]*16+gfc[0]);

	return 1;  //job done
}
//-------------------------------------------------------------------------
//move the cell cursor to up.
//Exit:
//  ax = 1 if job done

int Grid::CursorUp(int active)
{
	int colour1, colour2, l, t, cy = homey + scrnrow;
	int temcol = scrncol;
	if(!cy) return 0;
	DispCell(0);   //turn blue cursor off
	if(scrnrow)
	{
		scrnrow--;
		return 1;
	}

	if(cy%2)
	{
		colour1 = gbc[7]*16+gfc[7];
		colour2 = gbc[8]*16+gfc[8];
	}
	else
	{
		colour1 = gbc[8]*16+gfc[8];
		colour2 = gbc[7]*16+gfc[7];
	}


	//a->ColourLine(4, 2, 75, colour1);

	//we are on the top relative screen row. There is a line above
	//scroll the screen down and display it
	a->ScrollDown(4, 2, 78, 22, colour2); //cell area
	a->ScrollDown(0, 2, 3, 22, gbc[0]*16+gfc[0]);  //left border
	homey--;
	sprintf(linebuf1, "%3d", homey+1);
	a->WriteLine(linebuf1, 0, 2, 4, gbc[0]*16+gfc[0]);

	//ReDrawSheet(1);


	DrawRow();
	return 1;  //job done
}
//-------------------------------------------------------------------------

//move the cell cursor to the right.
//If on last possible visible column exit, else
//if on right margin move entire screen right,else
//move to next visible column
//Exit:
//  ax = 1 if job done

int Grid::CursorLeft(int active)
{
	int t, cx, size;

	DispCell(0);   //turn blue cursor off
	if(scrncol)
	{
		scrncol--;
		DispCell(active);
		return 1;             //job done
	}

	//we are currently at the left margin. See if any more
	//visible columns to the left. If so move the screen left to
	//bring that column into view and display the cursor
	//on that column.
	cx = letters[scrncol]-'A';
	t =0;
	do{
		if(cx+t == 0) return 0;
		t--;
	}while(!colwidths[cx+t]);


	homex = cx+t;
	size = colwidths[cx+t];
	DrawBorder(homex, homey);
	//a->ClrScr(4, 2, 78, 23, gbc[2]*16+gfc[2]);
	//a->ScrollRight(4, 2, 78-size, 23, size, gbc[2]*16+gfc[2]);
	ReDrawSheet(1);
	DrawSheet();
	DispCell(1);
	return 1;  //job done
}
//-------------------------------------------------------------------------
//display next 22 lines
//but keep the screen cell where it is
//Exit:
//  ax = 1 if job done

int Grid::PageDown(int active)
{
	int l, t;

	DispCell(0); //turn off the cell cursor

	if(homey == y78) return 0;  //can't page down
	homey +=22;
	if(homey >y78) homey = y78;
	//a->ClrScr(4, 2, 78, 23, gbc[2]*16+gfc[2]);
	ReDrawSheet(1);
	DrawSheet();

	l = 0;
	for(t = homey; t< homey+22; t++)
	{
		sprintf(linebuf1, "%3d", t+1);
		a->WriteLine(linebuf1, 0, l+2, 4, gbc[0]*16+gfc[0]);
		l++;
	}

	DispCell(active); //turn on cell

	return 1;  //job done
}
//-------------------------------------------------------------------------
//display the previous 22 lines (if possible)
//but keep the screen cell where it is
//Exit:
//  ax = 1 if job done

int Grid::PageUp(int active)
{
	int l, t;

	DispCell(0); //turn off the cell cursor

	if(!homey) return 0;  //can't page up
	homey -=22;
	if(homey <0) homey = 0;
	//a->ClrScr(4, 2, 78, 23, gbc[2]*16+gfc[2]);
	ReDrawSheet(1);
	DrawSheet();

	l = 0;
	for(t = homey; t< homey+22; t++)
	{
		sprintf(linebuf1, "%3d", t+1);
		a->WriteLine(linebuf1, 0, l+2, 4, gbc[0]*16+gfc[0]);
		l++;
	}

	DispCell(active); //turn on cell

	return 1;  //job done
}
//-------------------------------------------------------------------------
//Draw 1 row of cells on the screen
//Entry:
//	homey +  scrnrow = the absolute row to fetch
// scrnrow = the relative screen position to display the line on

int Grid::DrawRow()
{
	int colour, cx, cy, tempcol = scrncol;
	int l = strlen(letters);

	for(scrncol =0; scrncol< l; scrncol++)
	{
		cx = letters[scrncol]- 'A';
		cy = homey+scrnrow;
		//fill buffer with cells contents
		//linebuf1 will hold the cells answer, inputbuf the original input
		GetLineBuf(linebuf1, inputbuf, cx, cy, &colour);
		DispCell1(linebuf1, inputbuf, colour, 0, cx, cy);

	}

	scrncol = tempcol;
	return scrncol;
}
//------------------------------------------------------------------------
//For all the cells on a row that fall within the range
//block.x1 to block.x2 colour then in block's colour
//those on the row that don't are coloured in off colour
//if they fall with in column range
//
//Entry:
//	homey +  scrnrow = the absolute row to fetch
// scrnrow = the relative screen position to display the line on

int Grid::ColourRow()
{
	int x1, width, colour, cx, tempcol = scrncol;
	int l = strlen(letters);

	for(scrncol =0; scrncol< l; scrncol++)
	{
		cx = letters[scrncol]- 'A';
		width = colwidths[cx];
		//colour = gbc[2]*16+gfc[2];     //off colour
		scrnsheet = sheet[(homey+scrnrow)*26+cx];
		colour = scrnsheet->u.colour;
		if((cx >= block.x1) && (cx <= block.x2))
			colour = gbc[6]*16+gfc[6];  //block's colour
		x1 = starts[scrncol];
		if(x1+width >75) width = 75-x1;
		a->ColourLine(starts[scrncol]+4, scrnrow+2, width, colour);

	}

	scrncol = tempcol;
	return scrncol;
}

//-------------------------------------------------------------------------
//based on the values of homex, homey fill the spreadsheet display area
//with the contents of the cells in the parser's array.
//Leave cells blank that are empty

int Grid::DrawSheet()
{

	int temprow = scrnrow;

	for(scrnrow = 0; scrnrow< 22; scrnrow++)
	{
		DrawRow();
	}

	scrnrow = temprow;

	return 0;
}
//-------------------------------------------------------------------------
//Display a cell as either active or nonactive.
//if nonactive display the cell in off colour
//if active display in normal active cell colour show its
//formula in the status area
//Entry:
//  scrncol is the relative column of the cell
//  scrnrow is the relative row
//
int Grid::DispCell(int active)
{
	int colour, typ, pos, l, t, err;
	int cx = letters[scrncol] - 'A';
	int cy = scrnrow+ homey;
	int act = active;


	typ = GetLineBuf(linebuf1, inputbuf, cx, cy, &colour); //fill buffer with cells contents
																		//linebuf1 will hold the cells answer, inputbuf the original input

	err= par->ce.answer.errnum;
	DispCell1(linebuf1, inputbuf, colour, active, cx, cy);
	if(active)
	{
		if(typ <0) //error message instead of formula
		{
			par->errnum =0;  //cancel previous error
			par->serror(err);  //get error num of that cell
			strcpy(inputbuf, par->errorMessage);
			l = strlen(par->errorMessage);
			if(l > 73) l = 73;
			pos = 80 - l;
			a->WriteLine(inputbuf, pos, 24, l, RED*16+WHITE);

		}

	}


	return typ;
}
//------------------------------------------------------------------------
// Allow the user to input into a cell
// Entry:
//	  if flg = 0 use an enpty buf to begin the input
//   if flg = 1 use any formula contents current current at that cell
//              in which case the input cursor starts at the end of any
//					 such contents
//   if flg = 2 delete the contents of the cell
//	Exit:
//   if a click occurs outside the input line
//   but within the sheet area or scroll bar accept as if a return was pressed
//   process the input line according and if blank delete that cell
//   then in the rtn int tell the caller to the cell to move to or
//   scrollbar
//   otherwise assume user's intention is to <esc>
//

int Grid::CellInput(int flg)
{
	TMousePos m;
	int i, numfields, x1, y1, fieldsize, maxsize, cursorpos, attrib;
	int colour, l, cx, cy, entrycode, sneek;
	char preanswer[130];
	Cell *j;

	cx = letters[scrncol]-'A'; //bug fixed
	cy = homey+scrnrow;

	fieldsize = 70;      //max input field size
	maxsize = 126;       //max string size
	m.x1 = 8;
	m.x2 = 77;
	m.y1 = 24;
	m.y2 = 24;
	x1 = 8;
	y1 = 24;
	m.available =1;
	attrib = LIGHTGRAY*16+BLACK;
							  //exit upon:
	entrycode = 1+     //tab key
					2+     //up key
					4+    //down key
					//16+	 //right key (if at end of input line or on enpty line)
					32+	 //page up
					64+    //page down
					256;   //mouse click outside input field

	scrnsheet = sheet[cy*26+cx];
	if(scrnsheet->u.locked)
	{
		ShowLockedErrorMsg();
		goto ex;
	}


	if(!flg)    //use empty buf to begin the input
	{
		inputbuf[0] =0;
		cursorpos =0;
		a->PushA_Z(chr);
		entrycode+=16;  //allow right key to exit input
		//entrycode+=8;   //allow left key to exit input
	}
	else   //fill inputbuf with old contents (if any) of cell
	{
		preanswer[0] =0;
		GetLineBuf(linebuf1, preanswer, cx, cy, &colour);
		l = scrnsheet->u.type;
		if(l != NULL)
		{
			strcpy(inputbuf, preanswer);
			cursorpos = strlen(inputbuf);
		}
		else
		{
			cursorpos =0;      //cell was empty
			inputbuf[0] =0;
		}

	}
	if(flg ==2)  //skip input: jut delete the cell
	{
		inputbuf[0] =0;
		i = 0; //
		goto h; //delete a cell
	}

	a->CursorOn();
	i = a->Input(&m, numfields, inputbuf, x1, y1, fieldsize, maxsize, &cursorpos, attrib, entrycode);
	a->CursorOff();
	if(i == 1) goto ex; //<esc> don't accept input.
	modified =1;
	if(a->IsBlank(inputbuf)) inputbuf[0] =0;
h:
	j = par->eval_exp(inputbuf, cx+1, cy+1);
	l = strlen(inputbuf);
	if(l)
	{
		//if the formula evaluates to numeric and there is  '%' at the end
		//of it then set the precentage flag for that cells display
		//cell in the grid.
		if(j->answer.type ==2 && inputbuf[l-1] == '%')
		{
			scrnsheet->u.percent =1;
			sheet(cy*26+cx, scrnsheet);
		}
	}


	if(calc) par->AutoCalc();              //re-evaluate all cells
	//a->ClrScr(4, 2, 78, 23, gbc[2]*16+gfc[2]);
	ReDrawSheet(1);
	switch(i)
	{
		case 3:   //up
			CursorUp(1);
			break;

		case 4:
			CursorDown(1);
			break;

		case 5:
			CursorLeft(1);
			break;

		case 6:
			CursorRight(1);
			break;

		case 7:
			PageUp(1);
			break;

		case 8:
			PageDown(1);
			break;
	}



	DrawSheet();

ex:
	DispCell(1); //turn on cell
ex1:
	return 1;
}
//-------------------------------------------------------------------------
//Redraw the sheet, but not the column border, but yes the row border
//The sheet is drawn properly no matter where it is
int Grid::ReDrawSheet(int active)
{

	int colour, width, cx, t, l, lx, temprow = scrnrow;
	scrnrow =0;
	lx = strlen(letters);
	for(t = homey; t<homey+22; t++)
	{
		if(t%2) colour = gbc[7]*16+gfc[7];
		else colour = gbc[8]*16+gfc[8];
		a->WriteLine(tempbuf, 4, scrnrow+2, 75, colour);
		for(l =0; l < lx; l++)
		{
			cx = letters[l] - 'A';
			scrnsheet = sheet[t*26+cx];
			colour = scrnsheet->u.colour;
			width = colwidths[cx];
			if(width+starts[l] > 75) width = 75 - starts[l];
			a->ColourLine(4+starts[l], scrnrow+2, width, colour);
		}
		DrawRow();

		sprintf(linebuf1, "%3d", t+1);
		a->WriteLine(linebuf1, 0, scrnrow+2, 4, gbc[0]*16+gfc[0]);
		scrnrow++;
	}

	scrnrow = temprow;
	DispCell(active); //turn on cell
	DispStatusLine();
	return scrncol;
}
//---------------------------------------------------------------------

//--------------------------------------------------------------------
//This function is called ScrollDownArrow()
//The user has clicked on the down arrow and still has the mouse button down
//Scroll the text up but leave the cursor where it is
int Grid::MouseCursorDown(int active)
{


	int temcol = scrncol;
	int temprow = scrnrow;
	if(homey == y78) return 0;
	DispCell(0);   //turn blue cursor off

	//There is a line below
	//scroll the screen up and display it
	a->ScrollUp(4, 3, 78, 23, gbc[2]*16+gfc[2]); //cell area
	a->ScrollUp(0, 3, 3, 23, gbc[0]*16+gfc[0]);  //left border

	homey++;
	scrnrow = 21;
	DrawRow();
	sprintf(linebuf1, "%3d", homey+scrnrow+1);
	a->WriteLine(linebuf1, 0, 23, 4, gbc[0]*16+gfc[0]);
	scrnrow = temprow;
	DispCell(active);
	DispStatusLine();

	//-------
	return 1;
}
//-------------------------------------------------------------------
//This function is called ScrollUpArrow()
//The user has clicked on the up arrow and still has the mouse button down
//Scroll the text down but leave the cursor where it is
int Grid::MouseCursorUp(int active)
{

	int temcol = scrncol;
	int temprow = scrnrow;
	if(homey == 0) return 0;
	DispCell(0);   //turn blue cursor off

	//There is a line above
	//scroll the screen down and display it
	a->ScrollDown(4, 2, 78, 22, gbc[2]*16+gfc[2]); //cell area
	a->ScrollDown(0, 2, 3, 22, gbc[0]*16+gfc[0]);  //left border

	homey--;
	scrnrow = 0;
	DrawRow();
	sprintf(linebuf1, "%3d", homey+1);
	a->WriteLine(linebuf1, 0, 2, 4, gbc[0]*16+gfc[0]);
	scrnrow = temprow;
	DispCell(active);
	DispStatusLine();
	//-------
	return 1;
}
//-------------------------------------------------------------------
int Grid::ScrollDownArrow(int active)
{
		int t, chr;

		t =0;

		if(!mouse.ButtonState) return 0;
da:   t = a->WaitMouseButtonRelease(30);
		goto wa45;
wa4:  t = a->WaitMouseButtonRelease(4);
wa45: if(homey+1 == lines) return 0;
		MouseCursorDown(active);
		if(!t) return 0;
		goto wa4;

}
//--------------------------------------------------------------------
int Grid::ScrollUpArrow(int active)
{

		int t, chr;

		t =0;

		if(!mouse.ButtonState) return 0;
da:   t = a->WaitMouseButtonRelease(30);
		goto wa45;
wa4:  t = a->WaitMouseButtonRelease(4);
wa45: if(cline == 1) return 0;
		MouseCursorUp(active);
		if(!t) return 0;
		goto wa4;
}
//---------------------------------------------------------------------
int Grid::CalcScrollBar(int topline)
{

	float f_cursorpos, f_lines, f_topline, f_cursorlen;
	int pos;
	f_topline = topline;
	f_lines = lines;
	f_cursorlen = cursorlen;

	f_cursorpos = ((1/f_lines) * f_topline) *20;

	pos = f_cursorpos;


	if((cursorpos+ cursorlen) > 20)
		cursorpos--;

	if((topline + 21) >= lines)
	{
		pos = 20 - cursorlen;
	}
	//a->ShowVerticalScrollBar(79, 2, 20, cursorlen, cursorpos, a1, a2, a3);
	return pos;
}
//---------------------------------------------------------------------
//Called by ClickInScrollBar()
//The user wants to move the editor's scrollbar cursor up.
//The movement the user gave was big enough to do so but is
//it a legal move?
int Grid::MoveScrollBarCursorUp(int active)
{
	int temprow, t, bottomline, topline;
	char tempbuf[78];
	memset(tempbuf, ' ', 75);

	cline = homey+scrnrow+1;

	topline = homey+1;
	bottomline = topline +21;


	if(topline ==1) return 0;        //cant go up, already
												 //displaying 1st line

top:
	topline--;
	if(topline == 1) goto disp;
	t = CalcScrollBar(topline);
	if(t == cursorpos) goto top;
	if((t > 0 ) && (mouse.y <=3)) goto top;
	if((mouse.y >=3) && ((mouse.y-3) < t)) goto top;

	if(t == 0) topline =1;

//-----
disp:
	homey = topline-1;
	return ReDrawSheet(active);

}
//---------------------------------------------------------------------
// Called by ClickInScrollBar()
//The user wants to move the editor's scrollbar cursor down.
//The movement the user gave was big enough to do so but is
//it a legal move?
int Grid::MoveScrollBarCursorDown(int active)
{

	int t, bottomline, topline, temprow;
	char tempbuf[78];
	memset(tempbuf, ' ', 77);

	cline = homey+scrnrow+1;
	topline = homey+1;
	bottomline = topline +21;


	if(bottomline >= lines) return 0; //cant do down, already
												 //displaying last line

top:
	topline++;
	if((topline+21) >= lines) goto disp;
	t = CalcScrollBar(topline);
	if(t == cursorpos) goto top;
	if(((t+ cursorlen) <20 ) && (mouse.y >=22)) goto top;
	if((mouse.y-2) > (t+cursorlen)) goto top;

disp:
	homey = topline -1;
	return ReDrawSheet(active);

}

//---------------------------------------------------------------------
//A click occurred in the editor's scrollbar
//Should we move the scrollbar cursor up or down?
int Grid::ClickInScrollBar(int active)
{
		int t, chr;

		block.validsw =0;
		NormaliseScreen();

wa5:  chr = a->GetMouseOrKey();
		if(!mouse.ButtonState)
		{
			return 0;
		}
		a->LimitMouse(79, 2, 79, 23);
wa55: t = mouse.y;
		//a->ShowCoordinates();
wa56:	chr = a->WaitGetMouseOrKey();

		if(chr!= 256) //mouse not moved
		{
			if(!mouse.ButtonState)  //if button released
			{
				a->LimitMouse(0, 0, 79, 24); //restore mouse area
				return 0;
			}
			else goto wa56;
		}

		if(t == mouse.y) goto wa56; //move not big enough

		if(t< mouse.y) //if movement was down
		{
			MoveScrollBarCursorDown(active);
			goto wa55;
		}
		else
		{
			MoveScrollBarCursorUp(active);
			goto wa55;
		}


}
//---------------------------------------------------------------------
//A click occurred within the data area
//return the absolute (0 based) location of that cell
//This function only returns information, it dosen't
//alter anything
//Entry:
//	cx, cy are the pars to return the results in
// Exit:
//	ax = the relative  column (0 based) location of that cell
//
int Grid::ClickedInWhichCell(int *cx, int *cy)
{
	int f, t, l, y, x, c;

	*cy = (mouse.y-2)+ homey;
	y = mouse.y;
	x = mouse.x;
	if(!((x>=4) && (x<=78))) return -1;   //error cell out of data area
	if(!((y>=2) && (y <= 23))) return -1; //error cell out of data area
	x -=4;

	l = strlen(letters);
	c =-1;
	f =0;
	for(t = 0; t< l; t++)
	{
		c++;
		if(starts[t] > x) {f = 1; break;}
	}
	if(f) c--;
	x = letters[c] - 'A';
	*cx = x;

	return c;    //the cell column (0 based)  relative to the current
					 //screen column pointed to by the mouse
					 //if cells F to L are being displayed
					 //and the mouse is in column F then c = 0
}
//----------------------------------------------------------------------
//Returns relative column of mouse
//example of usage:
// 	i = MouseInWhichColumn();
// 	cx = letters[c] - 'A';
int Grid::MouseInWhichColumn()
{
	int cx, cy, f, t, l, y, x, c;

	cy = (mouse.y-2)+ homey;
	y = mouse.y;
	x = mouse.x;
	if(!((x>=4) && (x<=78))) return -1;   //error cell out of data area
	//if(!((y>=2) && (y <= 23))) return -1; //error cell out of data area
	x -=4;

	l = strlen(letters);
	c =-1;
	f =0;
	for(t = 0; t< l; t++)
	{
		c++;
		if(starts[t] > x) {f = 1; break;}
	}
	if(f) c--;
	x = letters[c] - 'A';
	cx = x;

	return c;    //the cell column (0 based)  relative to the current
					 //screen column pointed to by the mouse
					 //if cells F to L are being displayed
					 //and the mouse is in column F then c = 0
}
//----------------------------------------------------------------------
//assume the current row is not part of a block row,
//therefore show it in off colour
//Entry:
//	homey+scrnrow point to the current line 0-99
void Grid::RefreshNormalRow()
{
	int x1, t, width, colour, cx;
	int l = strlen(letters);

	for(t =0; t <l; t++)
	{
		cx = letters[t]- 'A';
		width = colwidths[cx];
		//colour = gbc[2]*16+gfc[2];     //off colour

		colour = sheet[(homey+scrnrow)*26+cx]->u.colour;
		x1 = starts[t];
		if(x1+width >75) width = 75-x1;
		a->ColourLine(starts[t]+4, scrnrow+2, width, colour);

	}


}
//----------------------------------------------------------------------
//called by SetCellToMouse(Parse *par, Disk *a)
void Grid::Refresh()
{
	int t, cy, temprow = scrnrow;
	//for all the lines that are in block's range
	//those lines that are currently displayed on the screen that
	//are above the beginning of block's range are coloured
	//in offcolour
	//and those lines that are currently displayed on the screen
	//that are below block's range are coloured in off colour
	//and those lines on the screen that are within block's range
	//are shown in block's colour
	block.x1 = orgcx;
	block.y1 = orgcy;
	block.x2 = letters[scrncol] -'A';
	block.y2 = homey+scrnrow;
	TwistBlockVars();
	for(t = 0; t<22; t++)
	{
		cy = homey+t;
		scrnrow =t;

		//if(block.validsw)
		//{
			if((cy >=block.y1) && (cy <= block.y2))
			{ //the line is within the block's range, so show is as coloured

				ColourRow();
			}
		//}
		else
		{
			RefreshNormalRow();
		}
	}

	scrnrow = temprow;
}
//-----------------------------------------------------------------------
int Grid::BlockCursorUp()
{

	CursorUp(1);
	return 0;
}
//----------------------------------------------------------------------
int Grid::BlockCursorDown()
{
	CursorDown(1);
	return 0;
}
//----------------------------------------------------------------------
int Grid::BlockCursorLeft()
{
	int t;

	t = mouse.ButtonState;
	if(!t) goto ex;
	if(mouse.x ==0)
	{
		a->WaitMouseButtonRelease(10);
	}

ex:
	CursorLeft(1);
	return 0;
}
//----------------------------------------------------------------------
int Grid::BlockCursorRight()
{
	int t;

	t = mouse.ButtonState;
	if(!t) goto ex;
	if(scrncol+2 >= strlen(letters) || mouse.x >=78)
	{
		a->WaitMouseButtonRelease(16);
	}
ex:
	CursorRight(1);
	return 0;
}
//----------------------------------------------------------------------
//Match the mouse line to the block
int Grid::TrackCursor()
{

	int newrow, c;
	if((mouse.y>=2) && (mouse.y<=23))
	{
		newrow = mouse.y-2;
		while(newrow < scrnrow)
		{
			BlockCursorUp();
			//------
h1:
			c = MouseInWhichColumn();
			if(c == -1) continue;
			if(c == scrncol) continue;
			if(c< scrncol)
				BlockCursorLeft();
			else
				BlockCursorRight();
			goto h1;
			//------

		}
		while(newrow> scrnrow)
		{
			BlockCursorDown();
			//------
h2:		c = MouseInWhichColumn();
			if(c == -1) continue;
			if(c == scrncol) continue;
			if(c< scrncol)
				BlockCursorLeft();
			else
				BlockCursorRight();
			goto h2;
			//------

		}
	}
ex:

	return 0;

}
//----------------------------------------------------------------------
//called by clicked in scrollbar
//cancle block's colour
void Grid::NormaliseScreen()
{
	int temprow, tempcol;

	tempcol = scrncol;
	block.validsw =0;  //block's pars are no longer valid
	temprow = scrnrow;
	for(scrnrow =0; scrnrow <22; scrnrow++)
	{
		RefreshNormalRow();
	}

	scrnrow = temprow;
	scrncol = tempcol;
	DispCell(1);
}
//----------------------------------------------------------------------

//A click occurred in the data area (4, 2, to 23, 78)
//Cancle any previous block range
//and bring cell to mouse location where click occurred
//Then if the user is still holding down the left button
//wait until either a movement is made or the button is released
//if the button is released exit, setting the block vars
//if the user had made a movement while while holding down the button
int Grid::SetCellToMouse()
{
	int width, c, cx, cy, sw;
	int oldmousey, oldmousex;


	//DispCell(0);   //turn blue cursor off
	mouse.ButtonState =1;
	if(!mouse.ButtonState) return 0;
	NormaliseScreen();


	c = ClickedInWhichCell(&cx, &cy);
	if(c <0)
		exit(0);  //unlikely, but in case of error
	scrncol = c;
	scrnrow = cy - homey;
	if(starts[scrncol] + colwidths[letters[c]-'A'] >=75)
	{
		CursorLeft(1);
		CursorRight(1);
		//if(cx<25) CursorLeft(par, a, 1);
	}

	orghomey = homey;
	orgscrnrow = scrnrow;
	orgscrncol = scrncol;
	orgcx = letters[scrncol] - 'A';
	orgcy = orghomey+orgscrnrow;

	block.x1 = orgcx;
	block.y1 = orgcy;
	block.x2 = block.x1;
	block.y2 = block.y1;

	DispCell(1); //show cell as blue



	chr =0;
get:
	Refresh();
	DispCell(1);
	DispScrollBar();
	/* for debugging
	sprintf(linebuf1, "x1=%2d, y1=%2d,   x2=%2d, y2=%2d",
		block.x1, block.y1, letters[scrncol]-'A', homey+scrnrow);

	a->WriteLine(linebuf1, 0,0, 78, LIGHTGRAY*16+BLACK);
  */

get1:
	chr = a->WaitEvent(1);
	if(!mouse.ButtonState) goto ex2;
	switch( chr)
	{
		case 259: //up
b1:	  block.validsw =1;
		  if((mouse.y > 1) && (mouse.y < 24))
		  {
			  TrackCursor();
			  goto get;
		  }
		  if(mouse.y ==0)
		  {
			  BlockCursorUp();
			  goto get;
		  }

		  if(lines == cline) goto get;
		  if(mouse.y == 24)
		  {
			  BlockCursorDown();
			  goto get;
		  }
		  goto get;


		case 260:   //down
		  goto b1;


		case 261:  //left
h2:		block.validsw =1;
			c = MouseInWhichColumn();
			if(c == -1) goto get;
			if(c == scrncol) goto get;
			if(c< scrncol)
				BlockCursorLeft();
			else
				BlockCursorRight();
			goto get;

		case 262: //right

			goto h2;


		case 266: //down right
			goto b1;

		case 265: //down left
			goto b1;

		case 263: //up left
			goto b1;

		case 264: // up right
			goto b1;


		default:
			if(mouse.y == 0 || mouse.y ==24 || mouse.x ==0 || mouse.x == 79)
			goto h4;
			else goto get1;
h4:
			if(mouse.y == 0 && mouse.x == 0) //auto scroll up
			{
				block.validsw =1;
				BlockCursorUp();
				BlockCursorLeft();
				goto get;
			}
			if(mouse.y == 0 && mouse.x == 79) //auto scroll up
			{
				block.validsw =1;
				BlockCursorUp();
				BlockCursorRight();
				goto get;
			}
			if(mouse.y == 0) //auto scroll up
			{
				block.validsw =1;
				BlockCursorUp();
				//------
h3:			c = MouseInWhichColumn();
				if(c == -1) goto get;
				if(c == scrncol) goto get;
				if(c< scrncol)
					BlockCursorLeft();
				else
					BlockCursorRight();
				goto h3;
				//------
				goto get;
			}

			if(mouse.y ==24 && mouse.x ==0)
			{
				block.validsw =1;
				BlockCursorDown();
				BlockCursorLeft();
				goto get;
			}
			if(mouse.y ==24 && mouse.x ==79)
			{
				block.validsw =1;
				BlockCursorDown();
				BlockCursorRight();
				goto get;
			}
			if(mouse.y ==24)
			{
				block.validsw =1;
				BlockCursorDown();
				goto get;
			}
			if(mouse.x ==79)
			{

				block.validsw =1;
				BlockCursorRight();
				goto get;
			}
			if(mouse.x ==0)
			{
				block.validsw =1;
				BlockCursorLeft();
				goto get;
			}
			goto get;
	}


ex2:
	block.validsw =1;     //tell other functions to normalise the screen
	return 0;
}
//-----------------------------------------------------------------------




