/******************************************************************/
/*                                                                */
/*            Digitized Voice Programmer's Toolkit                */
/*            ------------------------------------                */
/*                                                                */
/*        Example of a program which records voice data           */
/*               to a file of unlimited length                    */
/*                                                                */
/*           Copyright (c) 1989, Farpoint Software                */
/*                                                                */
/*                                                                */
/*  This program simply records a voice message while displaying  */
/*  a message repeatedly indicating the count of bytes recorded.  */
/*  The digitized voice data is written a disk file piece by      */
/*  piece while the recording is in progress. The memory buffer   */
/*  used is much smaller than the potential file size. Data is    */
/*  written to the buffer with the pointer wrapping back to the   */
/*  beginning of the buffer upon reaching the end. The routine    */
/*  RVOICE_CATCHUP (source in VRMOD.ASM) transfers data from the  */
/*  buffer to the file in the same way.                           */
/*                                                                */
/******************************************************************/

#include "vrmod.h"

#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include <fcntl.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <bios.h>
#include <string.h>

#define buf_size  16384L

char filename[128];
char huge *buffer;
int handle;
short comport;

main(argc,argv)
int argc;
char ** argv;

{
short retval;
long count,index;

/* make sure there are two arguments on the command line */

if (argc != 3)
	{
	printf("Command line must include COM port number (1 - 4) and file name.\n");
	exit(1);
	}

/* get the COM port number */

argv++;
comport = (short)((**argv) - '0');

/* get the file name */

argv++;
strcpy(filename,*argv);

/* open or create the file, truncating if it already exists */

handle = open(filename,O_BINARY|O_RDWR|O_CREAT|O_TRUNC,S_IREAD|S_IWRITE);
if (handle == -1)
	{
	printf("Error opening file.\n");
	exit(1);
	}

/* allocate memory for the buffer */

buffer = (char huge *)halloc(buf_size,1);
if (buffer == NULL)
	{
	close(handle);
	printf("Unable to allocate buffer memory.\n");
	exit(1);
	}

/* get ready */

RVOICE_INIT();

/* start the process */

retval = RVOICE_START(buffer,(long)buf_size,1,handle,comport,0L);

/* check the return code for errors */

switch (retval)
	{
	case 0:
		printf("Voice recording has begun.\n");
		break;
	case 1:
		printf("Buffer sizing error.\n");
		break;
	case 3:
		printf("Invalid COM port.\n");
	}

if (!retval)
	{

	/* loop while testing for the <Esc> key which ends recording */

	while (1)
		{

		/* RVOICE_CATCHUP must be called frequently to keep writing */
		/* the data to the disk as it becomes available without     */
		/* allowing buffer wrap-around to catch up with us.         */
		/* If RVOICE_CATCHUP returns 2 then file write error. */

		if (RVOICE_CATCHUP() == 2)
			{
			printf("File write error.\n");
			break;
			}

		/* doodle in the foreground while all this is happening */

		RVOICE_STATUS(&count,&index);
		printf("Count of bytes recorded = %ld\n",count);

		/* check the keystroke buffer */

		if (_bios_keybrd(_KEYBRD_READY))
			{

			/* key pressed, test for <Esc> key */

			if ( (_bios_keybrd(_KEYBRD_READ) >> 8) == 0x01)
				{
				RVOICE_STOP();
				printf("Voice recording ended.\n");
				break;
				}
			}
		}
	}

if (!retval)
	{

	/* we need to make sure it is all written */

	while (RVOICE_CATCHUP() == 0);
	}

/* call RVOICE_CLEANUP before exiting or crash later */

RVOICE_CLEANUP();

/* close the file and free the allocated memory */

close(handle);
free(buffer);

}
