	IDEAL
	JUMPS
	P386                    ; Use 386 instructions

	MODEL   medium

	PUBLIC  _bytesPerLine, _bankAdjust, _charHeight, _oldBank
	EXTRN   _BankFunc:dword

	DATASEG
_bytesPerLine   dw 0
_oldBank        dw 0ffh
_bankAdjust     dw 0
_charHeight     dw 0

	CODESEG

PROC    C ShiftScreen
	PUBLIC ShiftScreen

	mov     ax,04f05h       ; Set bank number 0
	mov     bx,0
	mov     dx,0
	int     10h

	push    ds
	mov     ax,0a000h
	mov     es,ax
	mov     ds,ax
	mov     di,0
	mov     si,1
	mov     cx,03fffh
	cld
;        rep     movsd
	pop     ds
	ret

ENDP    ShiftScreen


PROC    C clear800x600x8
	PUBLIC clear800x600x8
	USES    si,di

	mov     dx,0            ; Start with the first bank
	mov     bx,0            ; Set the bank
	call    [_BankFunc]

	mov     ax,0a000h       ; Point to video memory
	mov     es,ax

	mov     si,0            ; Bank number
	mov     cx,7
nextbank:
	push    cx
	mov     cx,4000h
	mov     eax,0
	mov     di,0
	cld
	rep     stosd           ; Clear out this bank

	add     si,[_bankAdjust]
	mov     dx,si
	mov     bx,0            ; Set the bank
	call    [_BankFunc]

	pop     cx
	loop    nextbank

	mov     cx,1480h
	mov     eax,0
	mov     di,0
	cld
	rep     stosd           ; Clear out partial bank

	ret

ENDP    clear800x600x8


PROC    C setBank
	PUBLIC setBank
	ARG bank:word

	mov     ax,[bank]
	cmp     ax,[_oldBank]
	je      nc1

	mov     [_oldBank],ax
	mul     [_bankAdjust]
	mov     dx,ax
	mov     bx,0
	call    [_BankFunc]
nc1:
	ret
ENDP    setBank

PROC    C putPixel
	PUBLIC putPixel
	ARG x:word, y:word, color:word
	
	mov     ax,[y]
	mul     [_bytesPerLine]
	add     ax,[x]
	adc     dx,0
	push    ax

	cmp     dx,[_oldBank]
	je      nc2

	mov     [_oldBank],dx
	mov     ax,[_bankAdjust]
	mul     dx
	mov     dx,ax
	mov     bx,0
	call    [_BankFunc]
nc2:
	pop     bx
	mov     ax,0A000h
	mov     es,ax
	mov     ax,[color]
	mov     [es:bx],al

	ret
ENDP    putPixel

PROC    C getPixel
	PUBLIC getPixel
	ARG x:word, y:word
	
	mov     ax,[y]
	mul     [_bytesPerLine]
	add     ax,[x]
	adc     dx,0
	push    ax
	
	cmp     dx,[_oldBank]
	je      nc2b

	mov     [_oldBank],dx
	mov     ax,[_bankAdjust]
	mul     dx
	mov     dx,ax
	mov     bx,0
	call    [_BankFunc]
nc2b:
	pop     bx
	mov     ax,0A000h
	mov     es,ax
	mov     al,[es:bx]
	xor     ah,ah
	
	ret
ENDP    getPixel

PROC    C setvgapalette256
	PUBLIC setvgapalette256
	ARG buffer:dword

	mov     ax,[word ptr buffer+2]
	mov     es,ax
	mov     dx,[word ptr buffer]
	mov     ax,1012h
	mov     bx,0
	mov     cx,256
	int     10h

	ret
ENDP    setvgapalette256

; int getSVGAInfo(SVGAInfoBlock *svgaInfo)
; returns 0=all ok
;         1=no VESA driver
;         2=invalid VESA signature

PROC    C getSVGAInfo
	PUBLIC  getSVGAInfo
	ARG     svgaInfo:dword
	USES    DI

	mov     es,[word ptr svgaInfo+2]
	mov     di,[word ptr svgaInfo]
	mov     ax,4f00h
	int     10h
	cmp     ax,4fh          ; Check for failure
	jne     ret_nodriver
	mov     es,[word ptr svgaInfo+2]
	mov     di,[word ptr svgaInfo]
	cmp     [word ptr es:di],'EV'
	jne     ret_badsig
	add     di,2
	cmp     [word ptr es:di],'AS'
	jne     ret_badsig
	mov     ax,0
	ret
ret_nodriver:
	mov     ax,1
	ret
ret_badsig:
	mov     ax,2
	ret
ENDP    getSVGAInfo

; int getModeInfo(mode,ModeInfoBlock *modeInfo)
; returns 0=all ok
;         1=error initializing mode
PROC    C getModeInfo
	PUBLIC  getModeInfo
	ARG     mode:word,modeInfo:dword
	USES    DI

	mov     es,[word ptr modeInfo+2]
	mov     di,[word ptr modeInfo]
	mov     ax,4F01h
	mov     cx,[mode]
	int     10h

	cmp     ax,4fh
	jne     ret_error
	mov     ax,0            ; Else return all ok
	ret
ret_error:
	mov     ax,1
	ret

ENDP    getModeInfo


; void writeText(int x,int y,int color,uchar *str)

PROC    C writeText
	PUBLIC writeText
	ARG     x:word, y:word, color:word, str:dword
	LOCAL   off:word, page:word, font:dword
	USES    SI,DI

	push    bp              ; Ick, they return it in BP
	mov     ax,1130h
	mov     bx,600h
	int     10h             ; ES:BP now points to the font

	mov     dx,bp
	pop     bp
	mov     [word ptr font],dx ; Hold font pointer in [font]
	mov     [word ptr font+2],es

nextchar:
	mov     es,[word ptr str+2]
	mov     bx,[word ptr str]
	mov     al,[es:bx]      ; Get a character
	cmp     al,0
	jz      EOS             ; At EOS, we may exit

	push    ax              ; Save the character
	mov     ax,[y]          ; Get location of current pixel
	mul     [_bytesPerLine]
	add     ax,[x]
	adc     dx,0
	mov     [off],ax        ; Save offset in [off]
	mov     [page],dx       ; Save page number in [page]

	cmp     dx,[_oldBank]
	je      nc3

	mov     [_oldBank],dx
	mov     ax,[_bankAdjust]
	mul     dx
	mov     dx,ax
	mov     bx,0
	call    [_BankFunc]
nc3:
	pop     ax              ; Restore the character
	xor     ah,ah
	mov     cl,4            ; Multiply by 16
	shl     ax,cl
	add     ax,[word ptr font] ; Add font offset
	mov     si,ax

	mov     cx,[color]      ; Hold color in cl
	mov     ch,16           ; Line count in ch
				; [byte ptr _charHeight] (UNIVBE returns 8 for CharHeight!)

nextline:
	mov     es,[word ptr font+2]
	mov     al,[es:si]      ; Get a line of the character map
	mov     di,[off]        ; Get a pointer to the current pixel
	mov     dx,0a000h       ; Set up segment register for screen access
	mov     es,dx
nextpixel:
	cmp     al,0            ; If no bits are high,
	jz      doneline        ;   we are finished with this line
	test    al,80h
	jz      no_pixel
	mov     [es:di],cl      ; Set the pixel, if required
no_pixel:
	shl     al,1
	add     di,1            ; Move to the next pixel
	jnc     nextpixel       ; On overflow, increment bank also

	push    ax              ; ax still holds some pixels!
	mov     ax,[page]
	inc     ax
	mov     [_oldBank],ax   ; Save this new value
	mul     [_bankAdjust]
	mov     dx,ax
	mov     bx,0            ; Set the bank
	call    [_BankFunc]
	pop     ax
	jmp     nextpixel
doneline:
	dec     ch              ; After _charHeight lines,
	jbe     donechar        ;   we are finished with the character

	inc     si              ; Point to the next line in font memory
	mov     ax,[_bytesPerLine]
	add     [off],ax        ; Point to next line on the screen
	jnc     nextline        ; On carry, we need to set a new bank

	inc     [page]
	mov     ax,[page]
	mov     [_oldBank],ax
	mul     [_bankAdjust]
	mov     dx,ax
	mov     bx,0            ; Set the bank
	call    [_BankFunc]
	jmp     nextline
donechar:
	inc     [word ptr str]  ; Bump of string pointer for next time
	add     [x],8           ; Move to next char position
	jmp     nextchar
EOS:
	ret
ENDP    writeText

PROC    C line
	PUBLIC  line
	ARG     x1:word,y1:word,x2:word,y2:word,color:word
	LOCAL   step1:word,step2:word,dir:word,PageNum:word
	USES    SI,DI

	mov     ax,[x1]
	sub     ax,[x2]
	jnc     xpos
	neg     ax              ; We want the absolute value
xpos:
	mov     si,ax           ; Save this as a step value
	mov     ax,[y1]
	sub     ax,[y2]
	jnc     ypos
	neg     ax              ; We want the absolute value
ypos:
	mov     di,ax           ; Save this as a step value
	cmp     ax,si
	ja      major_y         ; Handle near-vertical lines differently

	; Set up variables for doing most steps along X

	mov     ax,[x1]
	cmp     ax,[x2]         ; If x1<=x2, the order is ok
	jbe     xorderok
	xchg    ax,[x2]         ; else swap the order
	mov     [x1],ax
	mov     ax,[y1]
	xchg    ax,[y2]
	mov     [y1],ax
xorderok:
	mov     ax,1
	mov     [step1],ax      ; Set up pixel stepping variables
	mov     ax,[_bytesPerLine]
	mov     [step2],ax
	mov     bx,1
	mov     ax,[y1]
	cmp     ax,[y2]         ; If y1<=y2, we move down the screen
	jbe     mvdown
	neg     bx              ; else move up the screen
mvdown:
	mov     [dir],bx
	jmp     drawline

	; Set up variables for doing most steps along Y
major_y:
	xchg    si,di           ; Swap step indexes
	mov     ax,[y1]
	cmp     ax,[y2]         ; If y1<=y2, the order is ok
	jbe     yorderok
	xchg    ax,[y2]         ; else swap the order
	mov     [y1],ax
	mov     ax,[x1]
	xchg    ax,[x2]
	mov     [x1],ax
yorderok:
	mov     ax,[_bytesPerLine] ; Set up pixel stepping variables
	mov     [step1],ax
	mov     ax,1
	mov     [step2],ax
	mov     bx,1
	mov     ax,[x1]
	cmp     ax,[x2]         ; If x1<=x2, we must move right
	jbe     mvright 
	neg     bx              ; else move left
mvright:
	mov     [dir],bx

drawline:
	; Compute the initial pixel position

	mov     ax,[y1]
	mul     [_bytesPerLine]
	add     ax,[x1]
	adc     dx,0
	
	push    ax
	mov     ax,[_bankAdjust]
	mul     dx
	mov     [PageNum],ax    ; Save this value for later
	mov     dx,ax
	mov     bx,0            ; Set the bank
	call    [_BankFunc]

	pop     bx
	mov     ax,0A000h       ; Set up ES to point to the video memory
	mov     es,ax
				; Bank number in [_oldBank]
				; Bank offset in bx
	mov     cx,si           ; Get pixel count

	mov     dx,si           ; Step value in dx
	shr     dx,1            ; Start with half-step in place

nextdot:
	mov     ax,[color]
	mov     [es:bx],al      ; Set the pixel
	
	sub     cx,1
	jc      linefinished

	add     bx,[step1]
	jnc     nc5             ; If overflow, set the new bank
	
	push    ax bx dx
	mov     ax,[_bankAdjust]
	add     [PageNum],ax
	mov     dx,[PageNum]
	mov     bx,0
	call    [_BankFunc]
	pop     dx bx ax
nc5:
	add     dx,di           ; Step pixel in major direction
	cmp     dx,si           ; When this overflows, we need a diagonal move
	jc      nextdot

	sub     dx,si           ; Reset for the next step 

	cmp     [dir],1         ; Check if stepping up or down
	je      watchover

	sub     bx,[step2]      ; Step pixel in minor direction
	jnc     nextdot         ; If no underflow, do the next pixel
	mov     ax,[_bankAdjust]
	sub     [PageNum],ax
	jmp     newbank

watchover:
	add     bx,[step2]      ; Step pixel in minor direction
	jnc     nextdot         ; If no over/underflow, do the next pixel
	mov     ax,[_bankAdjust]
	add     [PageNum],ax
newbank:
	push    ax bx dx
	mov     dx,[PageNum]
	mov     bx,0
	call    [_BankFunc]
	pop     dx bx ax

	jmp     nextdot

linefinished:
	mov     [_oldBank],0ffh ; Invalidate the bank number

	ret

ENDP    line

PROC    C box
	PUBLIC  box
	ARG     x1:word,y1:word,x2:word,y2:word,color:word
	LOCAL   step:word,width:word,PageNum:word
	USES    SI,DI
	
	mov     ax,[x2]         ; Make x1 <= x2
	cmp     ax,[x1]
	jae     xok
	xchg    ax,[x1]
	mov     [x2],ax
xok:
	sub     ax,[x1]         ; Get width of box
	inc     ax
	mov     [width],ax      ; Store width in x2
	
	mov     ax,[y2]         ; Make y1 <= y2
	cmp     ax,[y1]
	jae     yok
	xchg    ax,[y1]
	mov     [y2],ax
yok:
	sub     ax,[y1]         ; Get height of box in ax
	inc     ax

	mov     si,ax           ; Store the height in si

	mov     ax,[_bytesPerLine]  ; Get distance to step at
	sub     ax,[width]          ;  the end of the line
	mov     [step],ax           ; Hold this value in [step]

	mov     ax,[y1]         ; Compute the initial pixel location
	mul     [_bytesPerLine]
	add     ax,[x1]
	adc     dx,0
	
	mov     di,ax           ; Store the offset in DI
	
	mov     ax,[_bankAdjust]
	mul     dx
; the following line had a dx!
	mov     [PageNum],ax    ; Hold this value for later
	mov     dx,ax
	mov     bx,0            ; Set the bank
	call    [_BankFunc]
nc6:
	mov     ax,0a000h       ; Set the segment to video memory
	mov     es,ax
	mov     bx,[color]      ; Hold color value in bx
nextrow:
	sub     si,1            ; Count of the number of rows
	jc      boxdone         ; When this passes 0, we are finished
	mov     cx,[width]      ; Get the width of the box
l1:
	mov     [es:di],bl
	add     di,1
	jnc     nc7
	
	mov     ax,[_bankAdjust]
	add     [PageNum],ax
	mov     dx,[PageNum]
	mov     bx,0            ; Set the page number
	call    [_BankFunc]
	mov     bx,[color]      ; Restore the color value
nc7:
	loop    l1              ; Fill CX number of pixels
	add     di,[step]       ; Step to begining of next row
	jnc     nextrow
	
	mov     ax,[_bankAdjust]
	add     [PageNum],ax
	mov     dx,[PageNum]
	mov     bx,0            ; Set the bank
	call    [_BankFunc]
	
	mov     bx,[color]      ; Restore the color value
	jmp     nextrow
boxdone:
	mov     [_oldBank],0ffh ; Invalidate the bank number

	ret

ENDP    box
	END
