#include <stdio.h>
#include <stdlib.h>

#include "specgram.h"
#include "display.h"

/* 
 *  Definition of a set of graphics functions which call SVGAlib functions
 */
char *ptrFont;         /* Fonts for Linux SVGALIB */
char *ptrLabelFont;    /* Fonts for Linux SVGALIB */
int _font_width;
int _font_height;
int _draw_colors;

void draw_setup_graphics(void)
{
   _font_height=8;
   _font_width=8;
   _draw_colors=256;

   if(!vga_hasmode(GMODE))
   {
      printf("VGA display does not support 800x600x256 mode"); \
      exit(1); 
   }
   vga_setmode(GMODE);
   gl_setcontextvga(GMODE);
   ptrFont=(char *)malloc(_font_width*_font_height*256*BYTESPERPIXEL);
   if(!ptrFont) 
   {
      printf("Unable to allocate memory for the font");
      exit(1); 
   }
   gl_expandfont(_font_width,_font_height,TICK_COLOR,gl_font8x8,ptrFont);
}

void draw_rectangle(int x1,int y1,int x2,int y2,int c)
{
   gl_hline(x1,y1,x2,c);gl_hline(x1,y2,x2,c);
   gl_line(x1,y1,x1,y2,c);gl_line(x2,y1,x2,y2,c);
}

void draw_fontcolor(int c)
{
   /* We only accept one color here */
   gl_setfont(_font_width,_font_height,ptrFont);
}

void draw_text_vertical(int x,int y,char *string)
{
   while(*string)
   {
      gl_writen(x,y,1,string);
      y+=_font_height;
      string++;
   }
}

int draw_getpixel(int x,int y)
{
   return(gl_getpixel(x,y));
}

void draw_setallpalette(unsigned char *p)
{
   int i;

   /* The display only accepts r,g,b values from 0-63 */
   for(i=0;i<256*3;i++)
      p[i]>>=2;

   gl_setpalette(p);
}

int draw_esc_pressed=0;

int draw_getch(void)
{
   int ch=vga_getch();
   /* This will return ESC if ESC is pressed, it will return */
   /* ESC, then <arrow> if an arrow key is pressed */
   if(ch==0x1b) 
      draw_esc_pressed=1;
   else if(draw_esc_pressed)
   {
      draw_esc_pressed=0;
      if(ch==0x5b)
      switch(vga_getch())
      {
	 case 0x41: ch=UP_ARROW; break;
	 case 0x42: ch=DOWN_ARROW; break;
	 case 0x43: ch=RIGHT_ARROW; break;
	 case 0x44: ch=LEFT_ARROW; break;
	 case 0x31: ch=HOME; vga_getch(); break;
	 case 0x34: ch=END; vga_getch(); break;
	 case 0x35: ch=PGUP; vga_getch(); break;
	 case 0x36: ch=PGDN; vga_getch(); break;
      }
   }
   return(ch);
}

int draw_getkey(void)
{
   int ch=vga_getkey();

   /* This routine will ignore <ESC>, and return arrows when pressed */
   /* where the arrows are represented by escape codes */
   /* The return codes are #defined in the specgram.h file */

   if(ch==0x1b) 
   {
      draw_esc_pressed=1;
      ch=0;
   }
   else if(draw_esc_pressed)
   {
      draw_esc_pressed=0;
      if(ch==0x5b)
      switch(vga_getkey())
      {
         case 0x00: ch=0; break;
         case 0x41: ch=UP_ARROW; break;
         case 0x42: ch=DOWN_ARROW; break;
         case 0x43: ch=RIGHT_ARROW; break;
         case 0x44: ch=LEFT_ARROW; break;
         case 0x31: ch=HOME; vga_getkey(); break;
         case 0x34: ch=END; vga_getkey(); break;
         case 0x35: ch=PGUP; vga_getkey(); break;
         case 0x36: ch=PGDN; vga_getkey(); break;
      }
   }
   return(ch);
}

