
/* Defines for Soundblaster and Soundblaster Pro IO address */
#define SB_BASE sb_addr                     /* Use these values as offsets */
#define LEFT_FM_STATUS      SB_BASE+0x00    /* Pro only */
#define LEFT_FM_ADDRESS     SB_BASE+0x00    /* Pro only */
#define LEFT_FM_DATA        SB_BASE+0x01    /* Pro only */
#define RIGHT_FM_STATUS     SB_BASE+0x02    /* Pro only */
#define RIGHT_FM_ADDRESS    SB_BASE+0x02    /* Pro only */
#define RIGHT_FM_DATA       SB_BASE+0x03    /* Pro only */
#define MIXER_ADDRESS       SB_BASE+0x04    /* Pro only */
#define MIXER_DATA          SB_BASE+0x05    /* Pro only */
#define DSP_RESET           SB_BASE+0x06
#define FM_STATUS           SB_BASE+0x08
#define FM_ADDRESS          SB_BASE+0x08
#define FM_DATA             SB_BASE+0x09
#define DSP_READ_DATA       SB_BASE+0x0A
#define DSP_WRITE_DATA      SB_BASE+0x0C
#define DSP_WRITE_STATUS    SB_BASE+0x0C
#define DSP_DATA_AVAIL      SB_BASE+0x0E
#define CD_ROM_DATA         SB_BASE+0x10    /* Pro only */
#define CD_ROM_STATUS       SB_BASE+0x11    /* Pro only */
#define CD_ROM_RESET        SB_BASE+0x12    /* Pro only */
#define CD_ROM_ENABLE       SB_BASE+0x13    /* Pro only */

#define ADLIB_FM_STATUS     0x388
#define ADLIB_FM_ADDRESS    0x388
#define ADLIB_FM_DATA       0x389

/* Defines for 8237 DMA Controller IO addresses */
#define DMA         0x00
#define CH0_BASE    DMA+0
#define CH0_COUNT   DMA+1
#define CH1_BASE    DMA+2
#define CH1_COUNT   DMA+3
#define CH2_BASE    DMA+4
#define CH2_COUNT   DMA+5
#define CH3_BASE    DMA+6
#define CH3_COUNT   DMA+7
#define DMA_STATUS  DMA+8
#define DMA_CMD     DMA+8
#define DMA_REQUEST DMA+9
#define DMA_MASK    DMA+10
#define DMA_MODE    DMA+11
#define DMA_FF      DMA+12
#define DMA_TMP     DMA+13
#define DMA_CLEAR   DMA+13
#define DMA_CLRMSK  DMA+14
#define DMA_WRMSK   DMA+15
#define DMAPAGE     0x80

/*
 *  External function references
 */
void far set_SB_address(int base);
int far dma_reset(int Channel);
int far dma_setup(int Channel,char far *Buffer,unsigned Length,int Dir);
int far dma_done(int Channel);
void far dsp_voice(int);
int far dsp_reset(void);
void far dsp_time(int);
void far dsp_dma_prepare(int Dir,int Length);

extern int dma_errno;
extern char *dma_errlist[];

