/*
  vgamem.h - BIOS video memory.
*/

#ifndef VGAMEM_H
#define VGAMEM_H

typedef unsigned char  Byte;
typedef unsigned short Word;

typedef struct
{
  Byte x, y;		// (0, 0) is top-left corner
} Cursor;

typedef struct
{
  Byte	 mode;		// Current video mode
  Word	 cols;		// Number of columns on screen
  Word	 size;		// Size of video page buffer
  Word	 offset;	// Starting offset of video buffer
  Cursor curs[8];       // Cursor position in each of eight pages
  Word	 cursor_line;	// Starting and ending line of cursor
  Byte	 page;		// Currently active display page
  Word	 port;		// Port address of active display
  Byte	 video;		// Video mode register
  Byte	 palette;	// Palette mode register
  Byte	 filler[0x1d];	// Stuff I'm not interested
  Byte	 rows;		// Number of rows on screen, less one
  Word	 font;		// Font height
} video_BIOS;

video_BIOS far* video = (video_BIOS far*)0x0449;

#endif
