; SWMO-7ZX  11/00
; For dual screen systems with both Mono and Super VGA cards & monitors.

; This version is for the crappy AMI BIOS which goes Mode 0Eh when told 7,
; and does NOT maintain the bits at 0410h

; If you boot clean, Mode Mono does work, but the mouse cursor is
; absent even if you run the mouse driver on the Mono screen.
; Loading INT10MDA fixes this.
; It still loses the mouse cursor on Mono when you post to the color screen.

Code	SEGMENT
	ASSUME	CS:Code, SS:Code, DS:Code, ES:Code

cr	equ	0Dh
lf	equ	0Ah
	ORG	100h

Start:	JMP	Begin

	DB	cr,lf,cr,lf
	DB	'Switch Mode for Mono and SVGA cards with AMI BIOS - by J.Rebold  10/93'
	DB	cr,lf,cr,lf
	DB	'Run SWMO-VGA C for color, SWMO-VGA M for Mono - '
	DB	'no command line toggles mode.',cr,lf,cr,lf
	DB	'You must have both SVGA and Mono cards, and the video'
	DB	' mode must be 80 X 25 text.',cr,lf,1Ah

NoColor	DB	'VGA not present',cr,lf,'$'
NoMono	DB	'Mono not present',cr,lf,'$'
CmdLine	DB	0
Mode	DB	0

At449	DB	7,50h,0,0,10h,0,0
At450	DB	16 dup(0)		  ;16 DECIMAL
	DB	0Ah,0Fh,0,0B4h,3,29h,30h  ;last is 466h
At484	DB	18h,0Eh,0,68h,9,10h,0Ch

Begin:	Cmp	Byte Ptr DS:80h,2	;length of command line parameters
	JNZ	CmdLineDone		;must be space + 1 char
	Mov	AL,Byte Ptr DS:82h	;char after the space
	And	AL,0DFh			;strip bit 5, make upper case
	Mov	CmdLine,AL
CmdLineDone:
	Push	DS
	Push	ES
	Xor	DI,DI
	Mov	ES,DI
	Mov	AL,ES:[410h]		;get equip byte, can't use Int 10h
	And	AL,30h
	Cmp	AL,30h
	JNZ	NotMono
	Mov	Mode,7			;save Mono Mode flag
NotMono:Xor	DI,DI
	Mov	AX,0B000h		;MONO RAM area
	Mov	ES,AX
	Mov	AL,ES:[DI]
	Dec	AL
	Mov	ES:[DI],AL		;now test MONO RAM
	Cmp	AL,ES:[DI]
	Mov	DX,offset NoMono
	JZ	NoErr
	Jmp	ErrExit			;MONO not present, give up

NoErr:	Inc	AL
	Mov	ES:[DI],AL		;restore test byte
;turn the VGA on
	Mov	AX,1200h		;misc functions, enable
	Mov	BL,32h			;en/disable VGA entirely
	Int	10h
	Mov	AL,83h			;80 X 25 CGA mode, no clear
	Xor	AH,AH			;set mode in AL (Never clears bkgnd)
	Int	10h
	Mov	AX,0B800h		;CGA RAM area
	Mov	ES,AX
	Xor	DI,DI
	Mov	AL,ES:[DI]
	Dec	AL
	Mov	ES:[DI],AL		;test Color RAM
	Cmp	AL,ES:[DI]
	Mov	DX,offset NoColor
	JNZ	ErrExit			;CGA not present, give up
	Inc	AL
	Mov	ES:[DI],AL		;restore test byte
;check the command line
	Cmp	CS:CmdLine,'C'
	JZ	ToCGA
	Cmp	CS:CmdLine,'M'
	JZ	ToMono
;nothing valid on command line, so toggle mode
	Cmp	CS:Mode,7		;in Mono mode ?
	JZ	ToCGA
ToMono:
	MOV	AL,87h			;Mono, 'no clear', clears anyhow
	XOR	AH,AH			;set mode in AL (does NOT clear bkgnd)
	INT	10h			;This makes mouuse crsr appear
					;until 'Hit any key...'
;reset lo RAM stuff to show Mono
;this once made the mouse crsr show but doesn't now...
	Xor	AX,AX
	Mov	ES,AX
	Or	Byte Ptr ES:[410h],30h	;set to Mono -
	Push	CS
	Pop	DS
	Mov	CX,30			;DECIMAL
	Mov	SI,offset At449
	Mov	DI,449h
	Rep	Movsb
	Mov	DI,484h
	Mov	CX,7
	Rep	Movsb
	Jmp	Short Done

ToCGA:	Xor	AH,AH			;set video mode
	Mov	AL,3			;80 X 25 color text
	Int	10h

; This is no help undoing INT10MDA, output stays on Mono!
;	Mov	AX,ES:[410h]
;	And	AL,11001111b
;	Or	AL,20h
;	Mov	ES:[410h],AX

Done:	Pop	ES
	Pop	DS
	Mov	AX,4C00h		;exit w/ErrorLevel=0
	Int	21h

ErrExit:
	Pop	ES
	Pop	DS
	Mov	AH,9
	Int	21h
	Mov	AX,4C01h		;exit w/ErrorLevel=1
	Int	21h

Code	ENDS
	END	Start
