' $linesize:132
' $title: 'Alias sub for Maple street version of RBBS'
' $INCLUDE: 'RBBS-VAR.MOD'
'
' $SUBTITLE: 'AliasChk - Checks whether ALIAS exists'
' $PAGE
'
'  SUBROUTINE NAME    -- AliasChk
'
'  INPUT PARAMETERS   --     PARAMETER                    MEANING
'                         WhoFind$                    ALIAS to find
'
'  OUTPUT PARAMETERS  --  WhoFound                    Whether ALIAS found
'                         UserNumFound                Record # of User
'
'  SUBROUTINE PURPOSE --  Validate that ALIAS exists.  Get User Record
'
2257 SUB AliasChk (WhoFind$,WhoFound,UserNumFound) STATIC         'Mpl-ALias
     If WhoFound = Ztrue Then Exit Sub                            'Mpl-Alias2
     CALL BreakFileName (ZMainUserFile$,Drive$,Prefix$,Ext$,ZTrue)    '
     DgsTemp = INSTR(ZConfName$," ")                                  '
     IF DgsTemp > 0 THEN _                                            '
      DgsFileName$ = Drive$ + LEFT$(ZConfName$,DgsTemp-1) + "A.DEF" _ '
     ELSE DgsFileName$ = Drive$ + ZConfName$ + "A.DEF"                '
     CALL FindIt (DgsFileName$)                                       '
     IF NOT ZOK THEN _                                                '
        EXIT SUB                                                      '
Call OpenWork (7,DgsFileName$)
     WhoFound=ZFalse                       'Mpl-Alias2
     DgsAlias$ = ""                                                   '
     WHILE DgsAlias$ = "" AND NOT EOF(7)                              '
        INPUT #7, DgsUserName$, DgsTempAlias$                         '
        IF Instr(DgsTempAlias$,WhoFind$) > 0 THEN                  'Mpl-Alis2
          ZSubParm = 1
          ZOutTxt$ = "Send to "+ DgsTempAlias$ +"([Y],N) "
          Call Tget                            
           If ZSubParm = -1 Then _
              Exit Sub
           If ZWasQ=0 Then ZYes = ZTrue
               If Zyes Then 
                  WhoFound = ZTrue                     'Pe 04/04/92
                  WhoFind$ = DgsTempAlias$
                  DgsAlias$ = DgsUserName$ 
               End If
          END IF                                                       '
     WEND                                                              '
     CLOSE 7                                                           '
   END SUB                                                             '
59750' $SUBTITLE: 'AliasDgs - Subroutine to Create/Update Alias Info file'
' $PAGE
'
'  SUBROUTINE NAME    -- DgsAlias
'
'  INPUT PARAMETERS   --     PARAMETER                    MEANING
'                         ZConfName$                  CONFERENCE NAME
'                         ZOrigUserNameDgs$           USERS - LOG ON NAME
'                         DgsAlias$                   USERS - ALIAS NAME
'                         DgsStl$                     NULL FIRST TIME IN
'                                                     'STILL' IF ALIAS EXISTS
'                                                        OR REAL NAME
'                         DgsFileName$                CONFERENCE ALIAS FILE
'
'  OUTPUT PARAMETERS  --  ZConfName$ ZOrigUserNameDgs$ DgsAlias$ DgsStl$
'                         DgsFileName$
'
'  SUBROUTINE PURPOSE --  TO Read ConfA.DEF and Get Users ALIAS or
'                         Create One
'
     SUB AliasDgs (ZConfName$,ZOrigUserNameDgs$,DgsAlias$,DgsStl$,DgsFileName$) STATIC
'
     IF DgsStl$ = "" THEN
        ConfADefFlag = 0
        CALL BreakFileName (ZMainUserFile$,Drive$,Prefix$,Ext$,ZTrue)
        DgsFileName$ = Drive$ + ZConfName$ + "A.DEF"
        CALL FindIt (DgsFileName$)
        IF ZOK THEN
           ConfADefFlag = ZTrue
        END IF
        IF ConfADefFlag = ZTrue THEN
         Call OpenWork (7,DgsFileName$)
           DgsAlias$ = ""
           WHILE DgsAlias$ = "" AND NOT EOF(7)
              INPUT #7, DgsUserName$, DgsTempAlias$
              DgsUnl = LEN(DgsUserName$)
              IF DgsUserName$ = LEFT$(ZOrigUserNameDgs$,DgsUnl) THEN
                 DgsAlias$ = DgsTempAlias$
              END IF
           WEND
           CLOSE 7
        ELSE
           DgsAlias$ = "NO CONFA.DEF"
           EXIT SUB
        END IF
     END IF
     CALL GoodAls (ZConfName$,ZOrigUserNameDgs$,DgsAlias$,DgsStl$,DgsFileName$)
     END SUB
'
'
' $SUBTITLE: 'GoodAls - Subroutine to Make Sure Alias Good'
' $PAGE
'
'  SUBROUTINE NAME    -- GoodAls
'
'  INPUT PARAMETERS   --     PARAMETER                    MEANING
'                         ZConfName$                  CONFERENCE NAME
'                         ZOrigUserNameDgs$           USERS - LOG ON NAME
'                         DgsAlias$                   USERS - ALIAS NAME
'                         DgsStl$                     NULL FIRST TIME IN
'                                                      'STILL' IF ALIAS EXISTS
'                                                         OR REAL NAME
'                         DgsFileName$                CONFERENCE ALIAS FILE
'
'  OUTPUT PARAMETERS  --  ZConfName$ ZOrigUserNameDgs$ DgsAlias$ DgsStl$
'                         DgsFileName$
'
'  SUBROUTINE PURPOSE --  To Read ConfA.DEF and see if Users ALIAS is
'                         Aready in Use or a Real Name
'
     SUB GoodAls (ZConfName$,ZOrigUserNameDgs$,DgsAlias$,DgsStl$,DgsFileName$) STATIC
'
     IF DgsAlias$ = "" THEN
        DgsSfnSln$ = ZSysopFirstName$+" "+ZSysopLastName$
        ZOutTxt$ = "Do you" +DgsStl$+ " want to use an Alias? (Y,[N])"
        ZSubParm = 1
        CALL TGet
        IF ZYes THEN
           ABFlg$ = ""
           ZOutTxt$ = "Enter Alias (31 Char. Max.) "
           ZSubParm = 1
           CALL TGet
           CALL AllCaps (ZUserIn$)
           IF ZUserIn$ = "" OR INSTR(SPACE$(31),ZUserIn$) > 0 THEN
              ZUserIn$ = ""
              ABFlg$ = "Alias Must NOT be Blank"
           END IF
           IF LEN(ZUserIn$) > 31 THEN
              ZUserIn$= ""
              ABFlg$ = "Length Must NOT Exceed 31 Characters"
           END IF
           IF ZUserIn$ = "SYSOP" OR ZUserIn$ = DgsSfnSln$ THEN
              ZOutTxt$ = CHR$(7)+CHR$(7)
              ZOutTxt$ = ZOutTxt$ + "Wrong Answer! Alias Request Denied!"
              ZOutTxt$ = ZOutTxt$ + CHR$(13) + "Contact Sysop for Alias Retry"
              CALL QuickTPut (ZOutTxt$,2)
              DgsAlias$ = ZOrigUserNameDgs$+CHR$(250)
              ZActiveUserName$ = ZOrigUserNameDgs$+CHR$(250)
              ZFirstName$ = ZOrigUserNameDgs$+CHR$(250)
           ELSE
              Call OpenWork (7,DgsFileName$)
              WHILE ABFlg$ = "" AND NOT EOF(7)
              INPUT #7, DgsUserName$, DgsTempAlias$
              IF ZUserIn$ = DgsUserName$ THEN
                 ABFlg$ = " is a Real User"
              ELSE
                 IF ZUserIn$ = DgsTempAlias$ THEN
                    ABFlg$ = " has Already been Used"
                 END IF
              END IF
              WEND
              CLOSE 7
              IF ABFlg$="" THEN
                 DgsAlias$ = ZUserIn$
                 ZActiveUserName$ = ZUserIn$
                 ZFirstName$ = ZUserIn$
              ELSE
                 ZOutTxt$="Sorry "+ZFirstName$+" but "+ZUserIn$+ABFlg$
                 CALL QuickTPut (ZOutTxt$,1)
                 DgsStl$ = " still"
                 DgsAlias$ = ""
              END IF
          END IF
        ELSE
           DgsAlias$ = ZOrigUserNameDgs$
        END IF
        IF DgsAlias$ <> "" THEN
           CLOSE 2
           FOR I = 1 TO LEN(DgsAlias$)
              IF MID$(DgsAlias$,I,1)=CHR$(34) THEN MID$(DgsAlias$,I,1)=CHR$(39)
           NEXT I
           Call OpenWorkA (DgsFileName$)
           WRITE #2, ZOrigUserNameDgs$, DgsAlias$
           CLOSE 2
        END IF
      ELSE
        ZActiveUserName$ = DgsAlias$
        ZFirstName$ = DgsAlias$
      END IF
      END SUB
