;RM82TS8,16,24,32,40,48,56,64
; Updated 11/20/90

;============================================================================
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;           All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;============================================================================

DOSSEG
.MODEL MEDIUM
	PUBLIC  CHANGEPAGE
.data
	;external data so all video routines can access
	EVEN
	EXTRN  B$DVIDEOSEG:WORD     ;inside VDATA
	EXTRN  B$DVIDEOPORT:WORD    ;inside VDATA
	EXTRN  B$DVIDEOINSTL:BYTE   ;inside VDATA
.code

EXTRN	Get_Adapter:FAR              ;inside VDATA

;===========================================================================
; DECLARE SUB CHANGEPAGE ()
; CALL CHANGEPAGE
;Purpose:
;        Adjust the current VIDEOSEG to reflect current active page
;	 Also reinitializes Video Data Area
;
;Limit:
;        This will permit 25, 43, & 50 line displays
;        Note on many HERC's the page size is fixed at 16kb even though
;        it really is 4kb in Text Mode
;
;Returns:
;	 Nothing Video Data Area Filed
;===========================================================================

EVEN
CHANGEPAGE	PROC	FAR
	Push	BP                ;save BP in case video bios destroys it

Reset_Page_0:  			  ;reset BASE Segment to page 0
        Xor	AX,AX             ;zero out AX
	Mov	ES,AX             ;put zero in ES, to look at low memory
	Mov	BX,0B000h         ;assume the Mono screen segment
	Mov	AL,ES:[463h]      ;get CRT controller port address 0000:0463h
	Cmp	AL,0B4h           ;is it mono?
	JZ 	Have_Mono         ;yes, don't add 800h to video segment
	Add	BX,0800h          ;no, adjust BX for a color monitor

        Cmp   	B$DVIDEOINSTL,1   ;Is that video port status accurate?
	JE	Buffer_Set        ;yes, so skip ahead
				  ;test if color VGA/EGA or a CGA
	Push	BX                ;save BX because the EGA test destroys BX

	Mov	AH,12h            ;specify EGA BIOS special function service
	Mov	BL,10h            ;request EGA info
        Int	10h               ;call the BIOS
        Cmp	BL,10h            ;if BL is still 10h, there's no EGA
	JNE	Color_EGA         ;it is an EGA, skip ahead

Snowy_CGA:
				  ;its a CGA,  set video retrace port
	Mov     B$DVIDEOPORT,3DAh ;and store in data area
				  ;assume CGA will cause snow
Color_EGA:
	Pop	BX            	  ;get the video segment again

Have_Mono:
	Mov	B$DVIDEOINSTL,1   ;note that it is now installed

Buffer_Set:
        ;BX contains Page 0 Segment Address

        XOR	CH,CH             ;clear the high byte
	Mov	CL,Byte Ptr ES:[0462h] ;get current page number
	JCXZ    Finis1            ;if it is page 0, then quit

	Mov     DX,CX             ;store CX temporarily in DX
	Mov     AX,ES:[044Ch]     ;get current page size
	Mov     CL,4
	Shr     AX,CL             ;divide page size by 16
	Mov     CX,DX             ;get page number back into CX

EVEN
Adj_Page:       ;allows for 25, 43 & 50 line pages in text mode
	Add     BX,AX             ;adjust one page ahead
	Loop	Adj_Page          ;loop until page (CX) = 0

Finis1:
        Mov     B$DVIDEOSEG,BX    ;store current segment address
	Pop	BP                ;for currently active page
	Ret
CHANGEPAGE	ENDP
END
