;ZeroTrm7.ASM
;Copyright (c) 1992 Jay Munro
;BC 7.x  version
;Syntax
;  Trimmed$ = ZeroTrim$(XString$)
;  Where XString contains leading CHR$(0)'s, Spaces (32), or Ascii Zeros
;  Chr$(48).

;Assemble With Masm 5.1 or later

.Model Medium, Basic

  Extrn StringLength:Proc               ;BC 7 internal string routines
  Extrn StringAddress:Proc
  Extrn StringAssign:Proc
  
.Data

   Descriptor   DD  ?           ;Descriptor starts here
   ZeroString   DW  0           ;Bogus data to point at
   
.Code

ZeroTrim Proc Uses SI, XString:Word
       Push DS
       Mov  SI,XString          ;get address of XString descriptor
       Push SI                  ;push descriptor for length
       Call StringLength        ;length is returned in AX
       Mov  CX,AX               ;move length into CX
       Jcxz ErrExit             ;if zero length then exit now
       Push SI                  ;call string address
       Call StringAddress       ;get address
       Mov  DS,DX               ;point DS:SI at incoming string
       Mov  SI,AX

TrimLoop:
       Mov  AL,Byte Ptr [SI]    ;get character from XString
       Or   AL,AL               ;is it a CHR$(0)?
       Jz   @F                  ;yes, go back for more
       Cmp  AL,32               ;is it a space character?
       Jz   @F                  ;yes, go back for more
       Cmp  AL,'0'              ;is it a a 0 character?
       Jnz  Done                ;nope, then we're done
@@:
       Inc  SI                  ;Point BX at next character
       Loop TrimLoop            ;go back for more
       Jcxz ErrExit             ;oops zero length string
       
Done: 
       Pop  DS                  ;retrieve DS
       Push DX                  ;DX contains segment of string
       Push SI                  ;SI contains current offset into string
       Push CX                  ;CX contains length of string
       Push DS                  ;point to descriptor
       Mov  SI, OffSet Descriptor  ;get address of Descriptor into SI
       Push SI
       Xor  AX,AX
       Push AX
       Call StringAssign        ;return value is address of descriptor
Exit:
       Ret

ErrExit: 
       Lea  SI, ZeroString      ;point at bogus data
       Mov  DX,SS               ;assign DX to DGroup (SS=DGroup)
       Jmp  Short Done          ;and assign the string

ZeroTrim EndP
End
