TITLE  'Compute Pixel Address EGA - VIDEO SYSTEMS p.96'
NAME   PIXADDR
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      determine video buffer address of pixel in native EGA  |
;   caller:      FAR call,assember (for initial pixel location)         |
; register:      ax = y-coor (down)                                     |
;                bx = x-coor (across)                                   |
;                cx = bytes per scanline                                |
;  returns:      ah = bit mask                                          |
;                bx = byte offset in buffer                             |
;                cl = number of bits to shift left                      |
;                es = video buffer segment (always A000)                |
;------------------------------------------------------------------------

;EXTRN RMWbits:word,x0:word,y0:word,x1:word,y1:word,z0:word,z1:word
;EXTRN addrSeg:word,addrOff:word,bpl:word
;EXTRN fg:word,bg:word,char:word,PixelValue:word
;EXTRN StrLen:word,StrOff:word,gap:word
;EXTRN PixelRows:word,PixelRowLen:word,RowCounter:word
;EXTRN StartMask:word,EndMaskL:word,EndMaskR:word,Shift:word,PMask:word
;EXTRN VertIncr:word,Incr1:word,Incr2:word,Routine:word
;EXTRN ULAddr:word,URAddr:word,LLAddr:word,LRAddr:word,LMask:word,RMask:word
;EXTRN xC:word,yC:word,maj:word,min:word
;EXTRN LFx:word,RTx:word,HIy:word,LOy:word,InWindow:word,InFill:word
;EXTRN FillShiftOrg:word,FillShift:word
;EXTRN vd:word,vdx:word,vdy:word
;EXTRN Asquared:word,Bsquared:word,TwoAsquared:word,TwoBsquared:word
;EXTRN TrigTable:word,TrigTableEnd:word
;EXTRN points:word,segXY:word,offXY:word,segXYp:word,offXYp:word
;EXTRN X0clip2:word,Y0clip2:word,X1clip2:word,Y1clip2:word
;EXTRN X0clip3:word,Y0clip3:word,Z0clip3:word,X1clip3:word,Y1clip3:word,Z1clip3:word
;EXTRN xtype2:word,deg2:word
;EXTRN orgX2:word,orgY2:word,transX2:word,transY2:word,scaleX2:word,scaleY2:word
;EXTRN points2:word
;EXTRN segXY2:word,offXY2:word,segXYp2:word,offXYp2:word
;EXTRN xtype3:word,degH3:word,degP3:word,degB3:word
;EXTRN orgX3:word,orgY3:word,orgZ3:word,transX3:word,transY3:word,transZ3:word
;EXTRN scaleX3:word,scaleY3:word,scaleZ3:word
;EXTRN distV3:word,points3:word
;EXTRN segXY3:word,offXY3:word,segXYp3:word,offXYp3:word,segXYj3:word,offXYj3:word
;EXTRN OC1:word,OC2:word,Inside:word,Outside:word,Behind:word,deltaX:word,deltaY:word
;EXTRN COSdeg:word,SINdeg:word
;EXTRN nx1:word,nx2:word,nx3:word
;EXTRN ny1:word,ny2:word,ny3:word,nz1:word,nz2:word,nz3:word
;EXTRN OPx:word,OPy:word,OPdiv:word
;EXTRN distV3ml:word,distV3mh:word
;EXTRN INT0off:word,INT0seg:word
;EXTRN patternf:word,erasecol:word,bordercol:word
;EXTRN StartLeftx:word,StartRightx:word,StartY:word
;EXTRN FAy:word,FAdir:word,NLeftx:word,NRightx:word,PLeftx:word,PRightx:word
;EXTRN Leftx:word,Rightx:word,MaxX:word,MaxY:word,RtnAddr:word
;EXTRN StackStart:word,StackMax:word,StackMax1:word

PUBLIC zCopyrightCheck
PUBLIC RMWbits,x0,y0,x1,y1,z0,z1
PUBLIC addrSeg,addrOff,bpl
PUBLIC fg,bg,char,PixelValue
PUBLIC StrLen,StrOff,gap
PUBLIC PixelRows,PixelRowLen,RowCounter
PUBLIC StartMask,EndMaskL,EndMaskR,Shift,PMask
PUBLIC VertIncr,Incr1,Incr2,Routine
PUBLIC ULAddr,URAddr,LLAddr,LRAddr,LMask,RMask
PUBLIC xC,yC,maj,min
PUBLIC LFx,RTx,HIy,LOy,InWindow,InFill
PUBLIC FillShiftOrg,FillShift
PUBLIC vd,vdx,vdy
PUBLIC Asquared,Bsquared,TwoAsquared,TwoBsquared
PUBLIC TrigTable,TrigTableEnd
PUBLIC points,segXY,offXY,segXYp,offXYp
PUBLIC X0clip2,Y0clip2,X1clip2,Y1clip2
PUBLIC X0clip3,Y0clip3,Z0clip3,X1clip3,Y1clip3,Z1clip3
PUBLIC xtype2,deg2
PUBLIC orgX2,orgY2,transX2,transY2,scaleX2,scaleY2
PUBLIC points2
PUBLIC segXY2,offXY2,segXYp2,offXYp2
PUBLIC xtype3,degH3,degP3,degB3
PUBLIC orgX3,orgY3,orgZ3,transX3,transY3,transZ3
PUBLIC scaleX3,scaleY3,scaleZ3
PUBLIC distV3,points3
PUBLIC segXY3,offXY3,segXYp3,offXYp3,segXYj3,offXYj3
PUBLIC OC1,OC2,Inside,Outside,Behind,deltaX,deltaY
PUBLIC COSdeg,SINdeg
PUBLIC nx1,nx2,nx3
PUBLIC ny1,ny2,ny3,nz1,nz2,nz3
PUBLIC OPx,OPy,OPdiv
PUBLIC distV3ml,distV3mh
PUBLIC INT0off,INT0seg
PUBLIC patternf,erasecol,bordercol
PUBLIC StartLeftx,StartRightx,StartY
PUBLIC FAy,FAdir,NLeftx,NRightx,PLeftx,PRightx
PUBLIC Leftx,Rightx,MaxX,MaxY,RtnAddr
PUBLIC StackStart,StackMax,StackMax1

_BSS            SEGMENT WORD PUBLIC 'BSS'
PixelRows       dw ?
PixelRowLen     dw ?
RowCounter      dw ?
StartMask       dw ?
EndMaskL        dw ?
EndMaskR        dw ?
Shift           dw ?
PMask           dw ?
VertIncr        dw ?
Incr1           dw ?
Incr2           dw ?
Routine         dw ?

ULAddr          dw ?
URAddr          dw ?
LLAddr          dw ?
LRAddr          dw ?
LMask           dw ?
RMask           dw ?
xC              dw ?
yC              dw ?
maj             dw ?
min             dw ?
LFx             dw ?
RTx             dw ?
HIy             dw ?
LOy             dw ?
InWindow        dw ?
vd              dw ?,?
vdx             dw ?,?
vdy             dw ?,?
Asquared        dw ?,?
Bsquared        dw ?,?
TwoAsquared     dw ?,?
TwoBsquared     dw ?,?
;---------------------

points          dw ?    ;misc usage
segXY           dw ?
offXY           dw ?
segXYp          dw ?
offXYp          dw ?
;---------------------

;graphics packet for 2D
xtype2          dw ?    ;1 mode
deg2            dw ?    ;2 rotation degrees
orgX2           dw ?    ;3 rotation origin X
orgY2           dw ?    ;4 Y
transX2         dw ?    ;5 translate amount X
transY2         dw ?    ;6 Y
scaleX2         dw ?    ;7 scale percentage X (100 = 1 (same))
scaleY2         dw ?    ;8 Y
points2         dw ?    ;9 points in array storage
segXY2          dw ?    ;10 address of original points (2D)
offXY2          dw ?    ;11
segXYp2         dw ?    ;12 address of xformed prime points (2D)
offXYp2         dw ?    ;13

;graphics packet for 3D
xtype3          dw ?    ;1 mode
degH3           dw ?    ;2 heading
degP3           dw ?    ;3 pitch
degB3           dw ?    ;4 bank
orgX3           dw ?    ;5 rotation origin X
orgY3           dw ?    ;6 Y
orgZ3           dw ?    ;7 Z
transX3         dw ?    ;8 translate amount X
transY3         dw ?    ;9 Y
transZ3         dw ?    ;10 Z
scaleX3         dw ?    ;11 scale percentage X (100 = 1 (same))
scaleY3         dw ?    ;12 Y
scaleZ3         dw ?    ;13 Z
distV3          dw ?    ;14 distance of viewer to screen
points3         dw ?    ;15 points in array storage
segXY3          dw ?    ;16 address of original points (3D)
offXY3          dw ?    ;17
segXYp3         dw ?    ;18 address of xformed prime points (3D)
offXYp3         dw ?    ;19
segXYj3         dw ?    ;20 address of projection points (2D)
offXYj3         dw ?    ;21

;-------------------
SINdeg          dw ?    ;trans2/3d vars
COSdeg          dw ?
nx1             dw ?    ;xform3d
nx2             dw ?
nx3             dw ?
ny1             dw ?
ny2             dw ?
ny3             dw ?
nz1             dw ?
nz2             dw ?
nz3             dw ?
OPx             dw ?    ;used in projpers
OPy             dw ?
OPdiv           dw ?
distV3ml        dw ?
distV3mh        dw ?

;------------------
OC1             dw ?    ;clipping outcodes
OC2             dw ?
Inside          dw ?
Outside         dw ?
Behind          dw ?
deltaX          dw ?
deltaY          dw ?

;------------------
INT0off         dw ?    ;used by CLIP2D/3D to trap div/0
INT0seg         dw ?

;-------------------
patternf        dw ?    ;used in FxxxAREAx for solid color or pattern fill
erasecol        dw ?
bordercol       dw ?
StackStart      dw ?
StackMax        dw ?
StackMax1       dw ?
StartLeftx      dw ?
StartRightx     dw ?
StartY          dw ?
FAy             dw ?
FAdir           dw ?
NLeftx          dw ?
NRightx         dw ?
PLeftx          dw ?
PRightx         dw ?
Leftx           dw ?
Rightx          dw ?
RtnAddr         dw ?
InFill          dw ?
FillShiftOrg    dw ?
FillShift       dw ?

_BSS            ENDS

_DATA           SEGMENT WORD PUBLIC 'DATA'
RMWbits         dw 0    ;general
x0              dw 0
y0              dw 0
z0              dw 0
x1              dw 639
y1              dw 479
z1              dw 0
addrSeg         dw 0
addrOff         dw 0
bpl             dw 80
fg              dw 7
bg              dw 0
char            dw 32
PixelValue      dw 7
StrLen          dw 0
StrOff          dw 0
gap             dw 8

;window for 2D
X0clip2         dw 0    ;1 ulx
Y0clip2         dw 0    ;2 uly of clipping region
X1clip2         dw 639  ;3 lrx
Y1clip2         dw 479  ;4 lry of clipping region

;window for 3D
X0clip3         dw 0    ;1 ulx
Y0clip3         dw 0    ;2 uly of clipping region
Z0clip3         dw 0    ;3 ulz
X1clip3         dw 639  ;4 lrx
Y1clip3         dw 479  ;5 lry of clipping region
Z1clip3         dw 0    ;6 lrz

MaxX            dw 639  ;max X,Y used in fillarea in case of no bound
MaxY            dw 479  ;and SETSCNBUFF

PUBLIC zWHAT_R_U_LOOKING_4
zWHAT_R_U_LOOKING_4     LABEL byte
zCopyrightCheck dw offset Copyright

                ;The TrigTable is a table of cosines * 10000 for angles 0 - 90
                ;  e.g., cosine of 10 deg = 9848/10000
                ;For cos(  0 -  89) TrigTable (forward order)
                ;For sin(  0 -  89) TrigTableEnd (reverse order)
                ;For cos( 90 - 179) TrigTableEnd (reverse order & negative)
                ;For sin( 90 - 179) TrigTable (forward order)
                ;For cos(180 - 269) TrigTable (forward order & negative)
                ;For sin(180 - 269) TrigTableEnd (reverse order & negative)
                ;For cos(270 - 359) TrigTableEnd (reverse order)
                ;For sin(270 - 359) TrigTable (forward order & negative)
                ;
                ;    0     1     2     3     4     5     6     7     8     9
EVEN
TrigTable       dw 10000,09998,09994,09986,09976,09962,09945,09925,09903,09877
                dw 09848,09816,09781,09744,09703,09659,09613,09563,09511,09455
                dw 09397,09336,09272,09205,09135,09063,08988,08910,08829,08746
                dw 08660,08572,08480,08387,08290,08192,08090,07986,07880,07771
                dw 07660,07547,07431,07314,07193,07071,06947,06820,06691,06561
                dw 06428,06293,06157,06018,05878,05736,05592,05446,05299,05150
                dw 05000,04848,04695,04540,04384,04226,04067,03907,03746,03584
                dw 03420,03256,03090,02924,02756,02588,02419,02250,02079,01908
                dw 01736,01564,01392,01219,01045,00872,00698,00523,00349,00175
TrigTableEnd    dw 00000

PUBLIC Copyright,CopyrightID

Copyright       db 13,10,'QB/EVGFX (C)1990 Cornel Huth.'
                db 13,10,'All Rights Reserved.',13,10
CopyrightID     db 'Cornel Huth/ScanSoft'
                db 13,10,'6402 Ingram Rd'
                db 13,10,'San Antonio, TX 78238'
                db 13,10,'(512)684-8065'
                db 13,10,'VERSION:Aug 04 1990'
                db 13,10,'$'

_DATA           ENDS

dgroup          group _BSS,_DATA

PixAddr_TEXT    SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:PixAddr_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  PixelAddr
PixelAddr       PROC    FAR

                push    dx              ;save it just because
                mov     dx,cx           ;bytes per scanline
                mul     dx              ;ax=y*bytes per line

                pop     dx

                mov     cl,bl           ;low byte of x
                shr     bx,1
                shr     bx,1
                shr     bx,1            ;bx=x/8
                add     bx,ax

                mov     ax,0A000h
                mov     es,ax           ;es:bx = byte address of pixel

                and     cl,7
                xor     cl,7            ;cl = number of bits to shift left
                mov     ah,1            ;ah = unshifted bit mask
                RET

PixelAddr       ENDP


PixAddr_TEXT    ENDS
                END

