/* 
 * Initialization segment for the Windows property list demo
 * This code is discarded after it is used.
 *
 * Written by Bill Hall
 * 3665 Benton Street, #66
 * Santa Clara, CA 95051
 *
 */

#define NOCOMM
#define NOKANJI
#define NOATOM
#define NOSOUND
#include <windows.h>
#include <string.h>
#include "walloc.h"

/* local function declarations */
static BOOL NEAR RegisterWindowClass(HANDLE);
static void NEAR GetPrevInstanceData(HANDLE);
static HWND NEAR MakeAndShowMainWnd(HANDLE, int);

/* This routine is FAR since it is called from another segment */
BOOL FAR InitProgram(HANDLE hInstance, HANDLE hPrevInstance, 
		     LPSTR lpszCmdLine, int cmdShow)
{

    hInst = hInstance;

  /* if this is the first instance of the program ... */
    if (!hPrevInstance) {
     /* register the window */
	if (!RegisterWindowClass(hInstance))
	    return FALSE;
    }

  /* A previous instance already exists so get global data from there */
    else
	GetPrevInstanceData(hPrevInstance);

  /* Create and show the window */
    if (!(hWndMain = MakeAndShowMainWnd(hInstance, cmdShow)))
	return FALSE;

  /* Show window if child windows created successfully */
    if (hWndList && hWndEnum) {
        ShowWindow(hWndMain, cmdShow);
        UpdateWindow(hWndMain);
    }
    else	/* failed, terminate app */
	PostMessage(hWndMain, WM_SYSCOMMAND, SC_CLOSE, 0L);

    return TRUE;    
}

/* Every window must belong to a class. We register ours here */
static BOOL NEAR RegisterWindowClass(HANDLE hInstance)
{

    WNDCLASS WndClass;

  /* Load the name string from resources */
    LoadString(hInstance, IDS_APPNAME,(LPSTR)szAppName,sizeof(szAppName));

    memset(&WndClass, 0, sizeof(WndClass));

  /* fill the structure */	
    WndClass.hCursor = LoadCursor(NULL, IDC_ARROW);  /* standard cursor */
    WndClass.hIcon = LoadIcon(hInstance, szAppName);
    WndClass.lpszMenuName = (LPSTR)szAppName;	/* get menu */
    WndClass.lpszClassName = (LPSTR)szAppName;	/* our class name */
    WndClass.hbrBackground = COLOR_WINDOW + 1;  /* system color */
    WndClass.hInstance = hInstance;		/* instance handle */
    WndClass.style = CS_VREDRAW | CS_HREDRAW; /* standard redraw values */
    WndClass.lpfnWndProc = MainWndProc;	/* pointer to our window proc */

  /* try to register the class */
    return RegisterClass(&WndClass);
}

/*
   If this not the first instance, we can retrieve static data from a
   previous invocation of the program
*/
static void NEAR GetPrevInstanceData(HANDLE hPrevInstance)
{

    GetInstanceData(hPrevInstance, szAppName, sizeof(szAppName));

}

/* Create the main window */
static HANDLE NEAR MakeAndShowMainWnd(HANDLE hInstance, int cmdShow)
{

    char szTitle[50];

    LoadString(hInstance, IDS_TITLE, szTitle, sizeof(szTitle));

  /* create the window, letting it fall where Windows wants */
    return CreateWindow(szAppName,
			szTitle,
			WS_OVERLAPPEDWINDOW,
			CW_USEDEFAULT,0,
			CW_USEDEFAULT,0,
			NULL,
			NULL,
			hInstance,
			NULL);
}

/* create the child list boxes */
BOOL FAR WndCreate(HWND hWnd)
{
    static char *class = "LISTBOX";

    LONG style = WS_CHILD | WS_VISIBLE | WS_BORDER 
		 | WS_VSCROLL | LBS_USETABSTOPS;

    hWndList = CreateWindow(class,
			    NULL,
			    style,
			    0,0,0,0,
			    hWnd,
			    IDD_ALLOC,
			    hInst,
			    NULL);

    hWndEnum = CreateWindow(class,
			    NULL,
			    style | LBS_SORT,
			    0,0,0,0,
			    hWnd,
			    IDD_ENUM,
			    hInst,
			    NULL);

    return (hWndEnum || hWndList);
}
