	title	simple file transfer client
	include	asm.inc
	include	netbios.inc

	public	main

	.stack

	.const
ertx_no_server		db  'CALL failed.  Probably no server.',0
ertx_driver		db  'No NetBIOS driver',0
ertx_send		db  'SEND failed',0
ertx_receive		db  'RECEIVE failed',0
ertx_disk_full		db  'Disk full',0
ertx_cannot_open	db  'Cannot open output file',0

calling_text		db  'Calling server',0
low_iq_client_text	db  'Low IQ Client',0
low_iq_server_text	db  'Low IQ Server',0

help_text  db  'client <source> <destination>',13,10
	   db  'copies <source> file from file server to <destination>.',13,10
	   db  'e.g. client \test\remote.txt local.txt',0


	.data?
	extrn	argc:word,argv:dword

call_ncb	ncb <>

;
; the order of these four objects is important
;
position_req	dd  ?			; file position requested for transfer
length_req	dd  ?			; length of transfer request
direction_flag	db  ?			; 'r' for receive, 's' for send
filename_req	db FILENAME_MAX dup(?)	; requested file and path
		db  ?			; (ensure path is asciiz)

session_number	db  ?

file_buffer	db  512 dup(?)


	.code
	extn  exit_program,netbios_check,puts,clear_ncb,strcpy,netbios_call
	extn  strncpy,netbios_send_wait,open_output_file,netbios_receive_wait
	extn  write_to_file,close_file,netbios_add_name,netbios_delete_name


;;	help
;
help	proc
	lea	si,help_text
	call	puts
	jmp	exit_program
help	endp


;;	main
;
main	proc
	assume	ds:DGROUP		; (test program is small model)

	cmp	argc,3
	jb	help			;  if not enough arguments

	call	netbios_check
	jnc	mai1
	jmp	mai4			;  if no netbios driver

mai1:	lea	si,low_iq_client_text	; register name with netbios driver
	call	netbios_add_name

	lea	si,calling_text		; *Calling server*
	call	puts

	lea	si,call_ncb		; build CALL control block
	call	clear_ncb

	lea	si,low_iq_server_text	;  set client and server names
	lea	di,call_ncb.Ncb_CallName
	call	strcpy
	lea	si,low_iq_client_text
	lea	di,call_ncb.Ncb_Name
	call	strcpy

	lea	si,call_ncb
	mov	Ncb_Rto[si],-1 ;10*2	;  receive  timeout is 10 seconds
	mov	Ncb_Sto[si],-1 ;5*2	;  transmit timeout is  5 seconds

	mov	Ncb_Command[si],NB_CALL_WAIT
	call	netbios_call
	jc	mai5			;  if no server (probably)

	mov	al,Ncb_Lsn[si]
	mov	session_number,al

	mov	ax,-1			; request entire file
	mov	wptr length_req,ax
	mov	wptr length_req+2,ax

	mov	direction_flag,'r'	; r is a read request to server

	lds	si,argv[bp]		; process server file name
	mov	si,[si+2]
	lea	di,filename_req
	mov	cx,size filename_req
	call	strncpy
	mov	ax,@data
	mov	ds,ax

	lea	cx,[di+1]		; send request packet with file
	lea	di,position_req		;  position, maximum length, direction
	sub	cx,di			;  and filename
	mov	al,session_number[bp]
	call	netbios_send_wait
	jc	mai6			;  if SEND failed

	lds	si,argv[bp]		; open output file
	mov	si,[si+4]
	call	open_output_file
	jc	mai7			;  if open failed
	mov	ax,@data
	mov	ds,ax

mai2:	mov	al,session_number	; receive data from file server
	mov	cx,size file_buffer
	lea	di,file_buffer
	call	netbios_receive_wait
	jc	mai8			;  if error
	jcxz	mai3			;  if end of file (hang up)

	call	write_to_file
	jnc	mai2			;  if write OK

	lea	si,ertx_disk_full	; *Disk full*
	call	puts

mai3:	call	close_file
	jmp	mai10

mai4:	lea	si,ertx_driver		; *No NetBIOS driver*
	call	puts
	jmp	exit_program
mai5:	lea	si,ertx_no_server	; *CALL failed.  Probably no server*
	jmp	mai9
mai6:	lea	si,ertx_send		; *SEND failed*
	jmp	mai9
mai7:	lea	si,ertx_cannot_open	; *Cannot open output file*
	jmp	mai9
mai8:	lea	si,ertx_receive		; *RECEIVE failed*
mai9:	call	puts
mai10:	lea	si,low_iq_client_text	; delete client's name
	call	netbios_delete_name
	jmp	exit_program
main	endp

	end
