/**********************************************

   Program Name:   FONTDEMO.C
   Author:         Ron Fosner
   Creation Date:  March-90

   Copyright Ron Fosner, (c) 1990

   Description:
     An program to demonstrate dynamic font generation.

***********************************************/

/**********************************************/

#include   <stdio.h>
#include   <stdlib.h>
#include   <graph.h>
#include "local.h"

/**********************************************/

/* dimensions of typical video screen */

#define X_RESOLUTION 10  /* 10 inches  */
#define Y_RESOLUTION 7.5 /* 7.5 inches */

/* the video origin is in the upper left corner */

/**********************************************/
/* function prototypes                        */
/**********************************************/

void main( int argc, char **argv );
void set_video( void );

/**********************************************/
/* global data                                */
/**********************************************/

int   PixelsperInch_x,PixelsperInch_y,Point_x,Point_y,Value_xy,Value_yx;

short color0 = 1, color1 = 1, color2 = 1;

POINT points_per_pixel;


/**********************************************/
/*
   main: called with one argument that is the
   location of the Bitstream Speedo font file
   name. It then loops though a collection of
   settings for the font, displaying a few
   lines of text each time, while waiting for
   a key press before proceeding.
*/

void main( int argc, char **argv )
{
     char * mssg;
     int i;

     /* the following are the parameters for the
      font calls */

     static int size = 6;
     static int params[][6] =
      {
       { 24, 24,  0,  0},
       { 72, 48,  0,  0},
       { 72, 72,  0,  0},
       { 72, 72, 12,  0},
       { 72, 72,  0, 12},
       { 72, 72, 12, 12},
      };

     if ( argc != 2 )
      {
      printf("Need to specify a font file\n");
      exit( 1 );
      }

     /* reset the text drawing information */
     /* need to get video information */
     set_video();

     for ( i = 0 ; i < size ; i++ )
      {

      /* erase entire screen */
      ERASE_SCREEN;

      /* set the Speedo parameters to new values */

      Point_x  = params[i][0];
      Point_y  = params[i][1];
      Value_xy = params[i][2];
      Value_yx = params[i][3];

      /* call Speedo to generate outlines */
      if ( NULL != ( mssg = start_speedo( argv[1] ) ) )
       {

       /* reset video mode */
       /* print error message */
        RESET_VIDEO_MODE;
       printf("%s\n",mssg);
       exit(1);
       }

      origin();  /* clear screen, reset text origin */

      newline(); /* move down one line from the top */
      place_text("Hello World!");

      newline();
      place_text("Hi Again!\n"); /* note embedded newline */

      place_text("ABCDEabcde1234567890!");

      /* wait for a keypress */
      WAIT_FOR_KEY;

      }

     /* reset video mode */
     RESET_VIDEO_MODE;


}


/**********************************************/
/*
    set_video: this routine sets the video mode
    to the graphics mode, generates the global
    values for the video resolution, sets the
    color values, then returns.
*/

void set_video( void )
{
     struct videoconfig config;

  if ( 0 == _setvideomode( VIDEO_MODE ) )
      {
      printf("Videomode failed\n");
      exit(1);
      }

     _getvideoconfig( &config );

     /* set the globa data */
     video.x_pixels = config.numxpixels;
     video.y_pixels = config.numypixels;
     video.colors   = config.numcolors;

     if ( video.colors > 2 ) /* a color screen */
      {
      color0 = 15;/*_BRIGHTWHITE;*/
      color1 = 1;/*_BLUE;*/
      color2 = 1+8;/*_LIGHTBLUE;*/
      }

     points_per_pixel.x = 72 * X_RESOLUTION / video.x_pixels;
     points_per_pixel.y = 72 * Y_RESOLUTION / video.y_pixels;

     PixelsperInch_x = video.x_pixels / X_RESOLUTION;
     PixelsperInch_y = video.y_pixels / Y_RESOLUTION;

}
