	title	wlib - assembly language window interface
	include	window.inc
	include	asm.inc

; (c) 1990 Soft Advances, all rights reserved.

	.data?
WReq	_WReq	<>			; window request packet
WRep	_WRep	<>			; reply/event packet


	.code
	extn	transmit_window_request,receive_window_reply,video_preset
	public	WCreateWindow,WPreset,WDrawText


;;	get reply
;
;	exit	DS:SI	reply packet from server
;		Cf	if error
;	uses	AX
;
get_reply proc
	pushm	cx,ss
	pop	ds
	lea	si,WRep[bp]
	mov	cx,SIZEOF_WREP
	call	receive_window_reply
	pop	cx
	ret
get_reply endp


;;	request packet read
;
;	exit	DS:SI	request packet
;
request_packet_read proc
	push	ss
	pop	ds
	lea	si,WReq[bp]
	ret
request_packet_read endp


;;	request packet write
;
;	exit	ES:DI	request packet
;
request_packet_write proc
	push	ss
	pop	es
	lea	di,WReq[bp]
	ret
request_packet_write endp


;;	send long request
;
;	entry	CX	text byte count
;		DS:SI	request packet
;	uses	AX
;
send_long_request proc
	push	cx
	add	cx,SIZEOF_WREQ
	call	transmit_window_request
	pop	cx
	ret
send_long_request endp


;;	send short request
;
;	uses	AX
;
send_short_request proc
	push	cx
	mov	cx,SIZEOF_WREQ
	call	transmit_window_request
	pop	cx
	ret
send_short_request endp


;;	WCreateWindow
;
;	entry	BX	parent window
;		CL	x
;		CH	y
;		DL	width  (> 0)
;		DH	height (> 0)
;	exit	BX	window handle
;		Cf	if error (no memory, too many windows)
;	uses	AX
;	note	border width is 1
;
WCreateWindow proc
	pushm	si,ds
	call	request_packet_read
	mov	WReq_code[si],W_CreateWindow
	mov	WReq_windowId[si],bx	;  (set parent window)
	mov	WReq_y_x[si],cx
	mov	WReq_height_width[si],dx
	call	send_short_request

	call	get_reply
	jc	wcw1			; if request failed
	mov	bx,WRep_windowId[si]
wcw1:	popm	ds,si
	ret
WCreateWindow endp


;;	WDestroyWindow
;
;	entry	BX	window handle
;		Cf	if bad window
;	uses	AX
;
WDestroyWindow proc
	pushm	si,ds
	call	request_packet_read
	mov	WReq_code[si],W_DestroyWindow
	mov	WReq_windowId[si],bx
	call	send_short_request
	popm	ds,si
	ret
WDestroyWindow endp


;;	WPreset
;
;	may use	AX,BX,CX,DX,DI,SI,DS,ES
;
WPreset proc
	call	video_preset
	ret
WPreset endp


;;	WDrawText
;
;	entry	AL	attribute
;		BX	windowId
;		CX	string byte count
;		DL	x coordinate
;		DH	y coordinate
;		DS:SI	string pointer
;	uses	AX
;
WDrawText	proc
	pushm	di,si,ds,es
	call	request_packet_write	; copy string to request packet
	lea	di,WReq_text[di]
	push	cx
	rep	movsb
	pop	cx

	call	request_packet_read	; build WDrawText packet
	mov	WReq_code[si],W_Text
	mov	WReq_windowId[si],bx
	mov	WReq_count[si],cx
	mov	WReq_y_x[si],dx
	mov	ah,0
	mov	WReq_attribute[si],ax
	call	send_long_request
	popm	es,ds,si,di
	ret
WDrawText	endp

	end
