/* 
 * Resident segment for the Windows small memory model template
 *
 * Written by Bill Hall
 * 3665 Benton Street, #66
 * Santa Clara, CA 95051
 *
 * This version of the template has been modified to print all messages
 * received by the message loop to the Winaux window.
 */

#include <windows.h>

/* all global variables are declared in this module */
#define EXTERN
#include "smltpl.h"

/* include the necessary hooks to call Winaux */
#ifdef WINAUX
#include <auxprt.h>
#endif

/* local function declaration */
static void NEAR MainWndPaint(HWND hWnd, HDC hDC);

/* Entry point for program */
int PASCAL WinMain(hInstance, hPrevInstance, lpszCmdLine, cmdShow)
HANDLE hInstance, hPrevInstance;
LPSTR lpszCmdLine;
int cmdShow;
{

    MSG msg;

  /* If initialization is not successful then exit */
    if (!InitProgram(hInstance,hPrevInstance, lpszCmdLine, cmdShow))
	return FALSE;

  /* Retrieve messages from Windows */
    while (GetMessage((LPMSG)&msg,NULL,0,0)) {
	TranslateMessage((LPMSG)&msg);
	DispatchMessage((LPMSG)&msg);
    }
    return msg.wParam;		/* exit program */
}

/* All messages are processed here */
long FAR PASCAL MainWndProc(hWnd,message,wParam,lParam)
HWND hWnd;
unsigned message;
WORD wParam;
LONG lParam;
{

    PAINTSTRUCT ps;

/* print all messages to winaux */
#ifdef WINAUX
    static int msgnum;
    sprintf(auxbuf,"%4x hWnd = %4x message = %4x wParam = %4x lParam = %8lx\n",
    			 msgnum, hWnd, message, wParam, lParam);
    msgnum += 1;
    auxprt(auxbuf);
#endif

    switch(message) {

	case WM_DESTROY:
	    PostQuitMessage(0);
	    break;

	case WM_PAINT:
	    BeginPaint(hWnd, (LPPAINTSTRUCT)&ps);
	    MainWndPaint(hWnd, ps.hdc);
	    EndPaint(hWnd, (LPPAINTSTRUCT)&ps);
	    break;

	default:
	    return ((long)DefWindowProc(hWnd,message,wParam,lParam));
	    break;
    }
    return(0L);
}

/* 
   Caveat programmer:  This function is written in the new format.
   If your compiler complains, write it as
	static void MainWndPaint(hWnd, hDC)
	HWND hWnd;
	HDC hDC;
	{
	    ...
	}
*/
/* this program does nothing exciting, so we only need to paint the icon */
static void MainWndPaint(HWND hWnd, HDC hDC)
{

  /* draw the icon */
    if (IsIconic(hWnd)) {
	RECT rIcon;
	GetClientRect(hWnd, (LPRECT)&rIcon);
	Rectangle(hDC, 0,0,rIcon.right, rIcon.bottom);
        TextOut(hDC,2,rIcon.bottom/3,(LPSTR)szIcon,strlen(szIcon));
    }
}
