{Listing 1: ENV.PAS
    Page 44 Volume 6.1                                      }   

PROGRAM Env;

{ Demonstrate how to read environment strings in Turbo Pascal 4.0.
  (C) 1987 by Swan Software, P.O. Box 206, Lititz PA 17543 }

TYPE

   CharPtr = ^Char;   { Pointer to characters }

VAR
   s : String;   { Holds environment string settings }


PROCEDURE AdvanceCP( VAR p : CharPtr );

{ Add one to p's offset address.  This procedure cannot advance
  p beyond a segment boundary.  Later Turbo Pascal versions might
  let you replace calls to AdvanceCP(p) with Inc(p). }

BEGIN
   p := Ptr( Seg(p^), Ofs(p^) + 1 )
END; { AdvanceCP }


FUNCTION GetEnv( s : String ) : CharPtr;

{ Search environment for string s and return a pointer to the
  setting for this environment variable.  If the variable is not
  found, return nil.  For example, if s equals 'COMSPEC', then
  GetEnv returns a pointer to the current COMSPEC setting,
  probably C:\COMMAND.COM.  String s is case sensitive.  In most
  cases, it should be in all caps. }

VAR

   p : CharPtr;   { Pointer to environment characters }


   FUNCTION Match( VAR s : String; VAR p : CharPtr ) : Boolean;

   { True if characters at p^ match string s exactly.  If they do
     match, then p^ addresses the character after the end of the
     matching string.  If they do not match, then p addresses the
     character that does not match. }

   VAR

      i : Integer;   { FOR-loop control variable }

   BEGIN
      FOR i := 1 TO Length(s) DO   { Examine all chars in s }
      BEGIN
         IF p^ <> s[i] THEN        { If mismatch found... }
         BEGIN
            Match := FALSE;        { ... return false }
            exit                   {     and exit Match }
         END; { if }
         AdvanceCP( p )            { Continue looking }
      END; { for }

    { All characters match.  Return true if character
      at p is an equal sign. }

      Match := ( p^ = '=' )

   END; { Match }


BEGIN { GetEnv }

{ Pick up environment pointer at PSP:002C, and assign to p making
  it point to the first character of the environment block. }
 
   p := Ptr( MemW[ PrefixSeg:$002C ], 0 );

   WHILE p^ <> Chr(0) DO    { While not at end of environment block }
   BEGIN
      IF Match( s, p )      { If the string s matches chars at p^ }
       THEN
         BEGIN
            AdvanceCP(p);  { Advance p past = sign }
            GetEnv := p;   { Return pointer to ASCIIZ string }
            exit           { Exit procedure early }
         END; { if }
      WHILE p^ <> Chr(0) DO   { Find end of ASCIIZ string }
         AdvanceCP( p );
      AdvanceCP( p )       { Advance p to next string (if any) }
   END; { while }

   GetEnv := NIL  { Environment variable not found }

END; { GetEnv }

 
PROCEDURE ASCIIZtoStr( p : CharPtr; VAR s : String );

{ Convert ASCIIZ character string addressed by p into a length-byte
  string variable, s.  The character array must end in a null zero
  byte.  The string is limited to 255 characters.  If p is NIL, then
  ASCIIZtoStr returns zero for the string length. }

VAR

   count : integer;   { String length counter }

BEGIN

   count := 0;  { Initialize string length to zero }

   IF p <> NIL THEN  { Return zero length string for nil pointer }
 
      WHILE ( p^ <> Chr(0) ) AND ( count < 255 ) DO
      BEGIN
         count := count + 1;   { Count characters transferred }
         s[ count ] := p^;     { Assign char at p to string s }
         AdvanceCP( p )        { Advance pointer to next char }
      END; { while }

   s[0] := Chr( count )       { Assign string length byte }

END; { ASCIIZtoStr }


BEGIN
   Writeln;
   Writeln( 'Test reading environment strings' );
   Writeln;
   ASCIIZtoStr( GetEnv( 'COMSPEC' ), s );
   writeln( 'COMSPEC ...... ', s );
   ASCIIZtoStr( GetEnv( 'PATH' ), s );
   writeln( 'PATH ......... ', s );
   ASCIIZtoStr( GetEnv( 'PROMPT' ), s );
   writeln( 'PROMPT ....... ', s );
   ASCIIZtoStr( GetEnv( 'TEMP' ), s );
   writeln( 'TEMP ......... ', s )
END.
 
From:     Programmer's Journal / MCI ID: 336-4248

TO:       Swan Software 
Subject:  RE: Article

Thank's Tom.  Looks good.  We'll be in touch shortly.  Chuck A.
