;***********************************************************************
; ZEIGER.ASM
; Copyright     (C) 1991, Hans-Jrgen Herrler und Dieter Sosna
;***********************************************************************
                
DATA    SEGMENT BYTE PUBLIC

        ; Pascal Variable
        EXTRN   SizeOfFloat     : word

DATA    ENDS

CODE    SEGMENT BYTE PUBLIC
        ASSUME CS:CODE, DS:DATA

        PUBLIC  Element
        PUBLIC  IncPtr

;       -------------------------------------------------------------------
;       FUNCTION Element(P: Pointer; i, j, SpaltenLen: Word): FloatPointer;
;       -------------------------------------------------------------------

        ; Parameter auf dem Stack:

SpaltenLen      EQU     6
j               EQU     SpaltenLen + 2
i               EQU     j + 2
POfs            EQU     i + 2
PSeg            EQU     POfs + 2

Element PROC FAR

        push    bp
        mov     bp,sp
        ; berechne Inkrement:
        mov     ah,[bp + SpaltenLen]
        mov     al,[bp + i]
        dec     al
        mul     ah                      ; ax := Pred(i)*SpaltenLen
        mov     bx,[bp + j]
        dec     bx
        add     ax,bx                   ; ax := Pred(i)*SpaltenLen + Pred(j)
        mul     word ptr SizeOfFloat    ; Ergebnis in dx,ax
        ; inkrementiere Pointer
        mov     bx,[bp + POfs]
        xor     cx,cx
        add     ax,bx
        adc     dx,cx                   ; bertrag bercksichtigen
        mov     bx,ax
        ; normalisiere nebenbei den Pointer
        and     ax,000Fh                ; ax := neuer Offset
        rcr     dx,1
        rcr     bx,1
        rcr     dx,1
        rcr     bx,1
        rcr     dx,1
        rcr     bx,1
        rcr     dx,1
        rcr     bx,1
        mov     dx,[bp + PSeg]
        add     dx,bx                   ; neues Segment

        pop     bp
        retf    0Ah
Element ENDP

;       -------------------------------------------------------------------
;       PROCEDURE IncPtr(Var P: FloatPointer);
;       -------------------------------------------------------------------

        ; Parameter auf dem Stack:

AdrOfsP         EQU     6
AdrSegP         EQU     8

IncPtr  PROC FAR

        push    bp
        mov     bp,sp

        les     di,[bp + AdrOfsP]
        mov     ax,word ptr SizeOfFloat
        add     es:[di],ax

        pop     bp
        ret     4

IncPtr  ENDP


        ENDS
        END
