{****************************************************
*            (C) B.St. '94,'95,'96.                 *
*        HPGL to COMPACT BINARY FORMAT              *
*              TRANSLATOR  v2.5                     *
*       (check version No in line 679 !)            *



* MUST HAVE NEGATIVE COORDINATES COMPENSATION!!!!   *
*           THIS WILL BE VERSION 2.5 !!!!!!!!       *



 
*  Handshake, block by block implemented.           *
*  (Reads available block size,                     *
*  but doesn't use it - 1024 byte block is fixed)   *
*                                                   *
*  AA implemented, with minor bug                   *
*  (bigger_than_something radius): FIXED.           *
*  LB (labelling) to be finished (angle missing).   *
*  Get_cmd appears to support absence of ';'        *
*  as command delimiter.                            *
*  PU,PD with ARG are equivalent to PA, with same   *
*  parameters.                                      *
*  AR implemented (not tested after AA changed).    *
*  CI, PG  implemented.                             *
*  Commands still not implemented are at the end    *
*  of CASE loop.                                    *
*****************************************************
****************************************************}

uses crt,DOS, Dirutil,TURBO3;

var filename, scan:text;

    Corr_neg_x,Corr_neg_y : integer;
    xpos, ypos : integer;

    max_byte,llx,lly,ulx,uly : integer;
    a,b,no_bytes:integer;
    fnm:string[80];
    scale:real;
    x_off,y_off:integer;
    ARG, MORE : BOOLEAN;
    dc:char;
    fi,xr,yr,rx,ry,rz,rx_old,ry_old,rz_old : longint;
    start_angle, arc_angle, stop_angle: integer;
    rad: longint;
    cmd:string[2];
    source,target:text;
    PASS:integer;
    pen_no, vel: longint;
    res:longint;
    chord:longint;
    pen:boolean;
    graphdriver,graphmode,errorcode:integer;
    code : integer;
    big_hp : integer;
    corrx, corry : integer;
    bn : integer;
const up=true;
      down=false;
      
    
function FileExists(FileName: string)
				: Boolean;
{ Returns True if file exists; otherwise,
  it returns False. Closes the file if
  it exists. }
var
  f: file;
begin
  {$I-}
  Assign(f, FileName);
  Reset(f);
  Close(f);
  {$I+}
  FileExists := (IOResult = 0) and
   (FileName <> '');
end;  { FileExists }


procedure FName;
var Y: char;
begin
writeln('File name [file.ext] ? ');
Y:=readkey;
write(Y);
 if Y<>#13 then
     begin
      readln(fnm);
      fnm := Y+fnm;
     end;

 if Y=#13 then
      fnm:=pick_file('*.*','');
end;

procedure out_of_range;
begin
writeln;
write(' Out of range ! ');
end;


function bit(stelle,zahl:byte):boolean;
  begin
   bit:=(zahl and (1 shl stelle))>0;
  end;

function rx_rdy:boolean;
var d:char;
begin

rx_rdy:=bit(0,port[$3fd]);

  IF KEYPRESSED THEN
  BEGIN
   D:=READKEY;
    if d=^Q then halt;
  END;




end;



function tx_rdy:boolean;
begin
  tx_rdy:=bit(5,port[$3fd]);
end;

function read_rs:char;
begin
  port[$3fc]:=3;
  repeat until rx_rdy;
  read_rs:=chr(port[$3f8]);
  port[$3fc]:=0;
end;

Procedure write_rs(ch:char);
begin
  port[$3fc]:=3;
  repeat until tx_rdy;
  port[$3f8]:=ord(ch);
  port[$3fc]:=0;
end;

Procedure handshake;
begin

  if not EOF(source) then
      begin
       write_rs(^A);  {* Send handshake *}
       repeat
	until read_rs=(^D);
			  {* Here, waiting for plotter to respond *}
       bn:=bn+1;
       gotoxy(2,19);
       write('Sending block No: ',bn); clreol;
      end;

 no_bytes:=0;
end;


procedure serial_write(ch:INTEGER);
begin
  if no_bytes=max_byte then
   handshake;
     no_bytes:=no_bytes+1;
   write_rs(chr(ch));
end;


function read_ser_line:string;
var ch: char;
    textline : string;
begin

 textline:='';
  while (ch<>chr(13)) do
   begin
     ch:=read_rs;
     textline:=textline+ch;
  end;
 read_ser_line:=textline;
end;




procedure SBN(nn:byte);                 {* Single Byte Number *}
begin
  if nn<=31
    then nn:=nn+64;
    serial_write(nn);
end;


Procedure MBN(n:integer);               {* Multiple Byte Number *}
var nn1,nn2,nn3,nr :integer;
var np1,np2,np3    :integer;
label exit;

 procedure one_byte_format;
 begin
  np1:=n+96;
  serial_write(np1);
 end;

 procedure two_byte_format;
 begin
  nn1:=trunc(int(n/64));
  nn2:=n-64*nn1;
   if nn2>=31 then np2:=nn2 else np2:=nn2+64;
  np1:=nn1+96;

  serial_write(np1);
  serial_write(np2);
 end;

 procedure three_byte_format;
 begin
  nn1:=trunc(int(n/4096));
  nr:=n-4096*nn1;
  nn2:=trunc(int(nr/64));
  nn3:=nr-64*nn2;
   if nn3>31 then np3:=nn3 else np3:=nn3+64;
  np2:=nn2;
   if nn2>31 then np2:=nn2 else np2:=nn2+64;
  np1:=nn1+96;

  serial_write(np1);
  serial_write(np2);
  serial_write(np3);
 end;

Begin
  if ((n>=0)    and (n <= 15))          then one_byte_format;
  if ((n>=16)   and (n <= 1023))        then two_byte_format;
  if ((n>=1024) and (n <= 32767))       then three_byte_format;
  if n  > 32768                         then out_of_range;
End;




Procedure MBP(nx,ny : integer);                 {* Multiple Byte Pair *}
var  n, np1, np2, np3, np4, np5 :integer;
	nx1, nx2, nx3, nx4, nx5 :integer;
	ny1, ny2, ny3, ny4, ny5 :integer;

 procedure one_byte_format;
 begin
  np1:=ny+96+4*nx;

  serial_write(np1);
 end;

 procedure twoo_byte_format;
 begin
  nx1:=trunc(int(nx/2));
  nx2:=nx-2*nx1;
  np1:=nx1+96;
  np2:=ny+32*nx2;  if np2 <= 31 then np2:=np2+64;

  serial_write(np1);
  serial_write(np2);
 end;

 procedure three_byte_format;
 begin
  nx1:=trunc(int(nx/16));
  nx2:=nx-16*nx1;
  ny2:=trunc(int(ny/64));
  ny3:=ny-64*ny2;
  np1:=nx1+96;
  np2:=ny2+4*nx2;  if np2 <= 31 then np2:=np2+64;
  np3:=ny3;        if np3 <= 31 then np3:=np3+64;

  serial_write(np1);
  serial_write(np2);
  serial_write(np3);
 end;

 procedure four_byte_format;
 var nxr : integer;
 begin
  nx1:=trunc(int(nx/128));
  nxr:=nx-128*nx1;
  nx2:=trunc(int(nxr/2));
  nx3:=nxr-2*nx2;
  ny3:=trunc(int(ny/64));
  ny4:=ny-64*ny3;
  np1:=96+nx1;
  np2:=nx2;        if np2 <= 31 then np2:=np2+64;
  np3:=ny3+32*nx3; if np3 <= 31 then np3:=np3+64;
  np4:=ny4;        if np4 <= 31 then np4:=np4+64;

  serial_write(np1);
  serial_write(np2);
  serial_write(np3);
  serial_write(np4);
 end;

 procedure five_byte_format;
 var nxr, nyr : integer;
 begin
  nx1:=trunc(int(nx/1024));
  nxr:=nx-1024*nx1;
  nx2:=trunc(int(nxr/16));
  nx3:=nxr-16*nx2;
  ny3:=trunc(int(ny/4096));
  nyr:=ny-4096*ny3;
  ny4:=trunc(int(nyr/64));
  ny5:=nyr-64*ny4;
  np1:=96+nx1;
  np2:=nx2;        if np2 <= 31 then np2:=np2+64;
  np3:=ny3+4*nx3;  if np3 <= 31 then np3:=np3+64;
  np4:=ny4;        if np4 <= 31 then np4:=np4+64;
  np5:=ny5;        if np5 <= 31 then np5:=np5+64;

  serial_write(np1);
  serial_write(np2);
  serial_write(np3);
  serial_write(np4);
  serial_write(np5);
end;

Begin                                
  if nx>ny then n:=nx else n:=ny;
      if ((n>=0)    and (n<=3))         then one_byte_format;
      if ((n>=4)    and (n<=31))        then twoo_byte_format;
      if ((n>=32)   and (n<=255))       then three_byte_format;
      if ((n>=256)  and (n<=2047))      then four_byte_format;
      if ((n>=2048) and (n<=16383))     then five_byte_format;
End;



Procedure PMB(nx,ny : integer);     {* Pair of Multiple Byte numbers *}
var np1,np2,np3,np4,np5 : integer;
		    neg : boolean;
		  x_cor : boolean;

 procedure one_byte(n:integer);
 begin
  if neg then
   n  :=n+32;
   np1 :=n+32;
    if x_cor then np1:=np1+32;
   serial_write(np1);
 end;

 procedure twoo_byte(n:integer);
 var n1,n2,np1 : integer;
 begin
  if neg then
   nx:=nx+1024;
  n1:=trunc(int(nx/32));
  n2:=nx-32*n1;
  np1:=n1+32; if x_cor then np1:=np1+32;
  np2:=n2+32; if x_cor then np2:=np2+32;

  serial_write(np1);
  serial_write(np2);
 end;

 procedure three_byte(n:integer);
 var n1,n2,n3,nr : integer;
 begin
  if neg then
     begin
      n:=n+16384;
      n:=n+16384;
     end;
  n1:=trunc(int(n/1024));
  nr:=n-1024*n1;
  n2:=trunc(int(nr/32));
  n3:=nr-32*n2;
  np1:=n1+32;  if x_cor then np1:=np1+32;
  np2:=n2+32;  if x_cor then np2:=np2+32;
  np3:=n3+32;  if x_cor then np3:=np3+32;

  serial_write(np1);
  serial_write(np2);
  serial_write(np3);

 end;

begin
 x_cor:=true;
  if nx<0 then
   begin
    neg:=true;
    if ((nx <= -1)   and (nx >= -16))     then one_byte(nx);
    if ((nx <= -17)  and (nx >= -512))    then twoo_byte(nx);
    if ((nx <= -513) and (nx >= -16384))  then three_byte(nx);
   end
   else
   begin
    neg:=false;
    if ((nx >= 0)   and (nx <= 15))       then one_byte(nx);
    if ((nx >= 16)  and (nx <= 511))      then twoo_byte(nx);
    if ((nx >= 512) and (nx <= 16384))    then three_byte(nx);
   end;

 x_cor:=false;
  if ny<0 then
   begin
    neg:=true;
    if ((ny <= -1)   and (ny >=  -16))    then one_byte(ny);
    if ((ny <= -17)  and (ny >= -512))    then twoo_byte(ny);
    if ((ny <= -513) and (ny >= -16384))  then three_byte(ny);
   end
   else
   begin
    neg:=false;
    if ((ny >= 0)   and (ny <= 15))       then one_byte(ny);
    if ((ny >= 16)  and (ny <= 511))      then twoo_byte(ny);
    if ((ny >= 512) and (ny <= 16384))    then three_byte(ny);
   end;
end;


Procedure MBA(a:real);
label EXIT3;

var na, nr, na1, na2, na3 : longint;
var np1, np2, np3 : integer;
begin

np1:=0;
np2:=0;
np3:=0;

 if a>=180 then
   begin
     np1:=8;
     a:=a-180;
   end;
   na := trunc(int((a/90)*16384));
   na1:= trunc(int(na/4096));
   np1:= np1+na1+96;                serial_write(np1);
   nr := na-4096*na1;

    if nr = 0 then goto EXIT3;

   na2:=trunc(int(nr/64));
   np2:=na2;
     if np2<32 then np2:=np2+64;    serial_write(np2);

   na3:=nr-64*na2;
    if na3=0 then  goto EXIT3;

   np3:=na3;
    if np3 <32 then np3:=np3+64;    serial_write(np3);
EXIT3:
end;


procedure init;
begin
 serial_write(ord('~'));
 serial_write(ord('_'));
end;


procedure set_limits;
begin
 serial_write(ord('~'));
 serial_write(ord('W'));
 MBP(llx,lly);
 MBP(ulx,uly);
 serial_write(ord('}'));
end;


procedure set_grid;
begin
 serial_write(ord('~'));
 serial_write(ord('S'));
 MBP((ulx-llx),(uly-lly));
 serial_write(ord('}'));
end;

procedure label_size(a,b:integer);
begin
 serial_write(ord('~'));
 serial_write(ord('%'));
 MBP(a,b);
end;

procedure pen_up;
begin
  serial_write(ord('r'));
  serial_write(ord('}'));
end;


procedure velocity(v:integer);
begin
   v:=trunc(abs(v));
   if v>36 then v:=36;

   serial_write(ord('~'));
   serial_write(ord('V'));
   SBN(v);
end;


procedure HP7221_arc(r,alfastart,alfastop :real);
label EXIT5;
begin

  if rz > 0 then
    serial_write(ord('u'))
  else

    serial_write(ord('t'));    {* 't' *}
    MBN(trunc(r));
    MBA(alfastart);
    MBA(alfastop);
    serial_write(ord('}'));
end;


procedure moverel(x,y:integer);
begin
  serial_write(ord('r'));
  PMB(x,y);
  serial_write(ord('}'));
end;


procedure moveabs(x,y:integer);
begin
  serial_write(ord('p'));
  MBP(x,y);
  serial_write(ord('}'));
end;


procedure plotrel(x,y:integer);
begin
  serial_write(ord('s'));
  PMB(x,y);
  serial_write(ord('}'));
end;


procedure plotabs(x,y:integer);
begin
IF ARG=TRUE THEN
 BEGIN
  serial_write(ord('q'));
  MBP(x,y);
  serial_write(ord('}'));
 END;
end;


procedure pen_select(p: integer);
begin
  serial_write(ord('v'));
  SBN(pen_no);
  serial_write(ord('}'));
end;



procedure get_cmd;
var Count : integer;
begin
Count:=0;
  if not eof(Source) then
   begin
    cmd:='';
      if upcase(dc) in ['A'..'Z'] then
	begin
	  Count:=Count+1;
	  cmd:=dc;
	end;
    repeat
     read(source,dc);
      if upcase(dc) in ['A'..'Z'] then
	begin
	 cmd:=cmd+dc;
	 Count:=Count+1;
	end
	else
	 begin
	  Count:=0;
	  cmd:='';
	 end;
    until (Count=2) or (eof(Source));

    {* write(cmd,' ');    *}

   end
   else cmd:='XX';

end;


procedure pread(var v:longint);
label EXIT5;
var tmp:string;
    tmp1: real;
    negative,decimal:boolean;

begin
  tmp:='';
  negative:=false;
  decimal:=false;
  ARG:=FALSE;
  MORE:=FALSE;
    read(source,dc);
    if dc =  ';' then goto EXIT5;
    if dc <> ';' then ARG:=TRUE;
    if dc='-' then negative:=true;

  repeat
  if (dc='.') then decimal:=true;
  if (dc in ['0'..'9']) or (dc = '.') then tmp:= tmp + dc;
    read(source,dc);
  until ( not((dc in ['0'..'9']) or (dc='.')) ) or (eoln(source)) or (eof(source));
  MORE:=true;

  {* until (dc=';') or (dc=',') or (eoln(source)) or (eof(source)); *}

  val(tmp,tmp1,code);

    if cmd = 'SI' then
      if decimal then tmp1:=tmp1*365;  {* Calc. of plotter units *}

  v:=trunc(tmp1);
    if negative then v:=v*(-1);

EXIT5:
	    {* This procedure returns 0 in case of
	       no arguments, and if that v is used
	       carelessly for calc of something from
	       previous values, error may occur!     *}
end;



Procedure Check_negative_move;

begin

 Corr_neg_x:=0;
 Corr_neg_y:=0;


end;



{**************************************************************
**    Main Program    *****************************************
***************************************************************}

LABEL EXIT2,EXIT4,EXIT6,EXIT8,EXIT_END;
var rx_temp,ry_temp,sx,sy  : longint;
var dx,dy : longint;
BEGIN
  bn := 1;
  big_hp := 0;
  no_bytes:=0;
  pen:=up;
  clrscr;
  writeln;
  writeln('        HPGL to Compact Binary Format translator');
  writeln('            for HP7221C Graphic plotter, v2.5');
  writeln('               (C) B.Stajcar, 1995,1996');
  gotoxy(1,10);

  writeln(' Plotter unit set to:     0.025mm');
  writeln(' Plot scale set to:       1');
  llx:=0;lly:=0;ulx:=16000;uly:=11400; {* Mechanical maximum, A3.         *}
  corrx:=trunc((ulx-llx)/2);           {* This correction is for plotters *}
  corry:=trunc((uly-lly)/2);           {* with origin in centre of paper  *}
  fnm:=ParamStr(1);
  writeln;
  writeln;
  if fnm = '' then
    Fname;


       case (FileExists(fnm)) of
	  false:
	   begin
	     {* gotoxy(5,21);
	     write ('No File!                                 ');
	     delay(2000);
	     Fnm:=pick_file('*.*',''); *}
	   end;

	  true:
	   begin

	       assign(source,fnm);
	       {$i-}
	       reset(source);
	       {$i+}
	   end;
	end;


  gotoxy(1,14); clreol;
  writeln(' File : ',fnm,' will be converted and sent to plotter at COM1!');
  writeln;
  write(' Plot origin is at Lower Left corner (0) or Centred (1)?  ');
  clreol;

  repeat
    val(Readkey,big_hp,code); {* For BIG plotters... 1. *}
  until (code = 0) and (big_hp < 2);

  write(big_hp);

  gotoxy(2,19);clreol;
  writeln(' Supposed to check for negative coordinates... not yet implemented');
  delay(10000);
  Check_negative_move;

  gotoxy(2,19);clreol;
  write(' Enter default pen speed (1..30) ');


  read(vel);
  gotoxy(2,19); clreol;

  gotoxy(1,14); clreol;

  writeln(' Translating and plotting file:  ',fnm);clreol;
  writeln(' (press ^Q to abort..)');
  clreol;


		      write_rs(chr(27));
		      write_rs('.');
		      write_rs('(');                 {* Plotter ON *}

		      write_rs(chr(27));
		      write_rs('.');
		      write_rs('A');            {* Request for ID *}


		      writeln;
		      writeln;
		      writeln(' Plotter ID: ',read_ser_line);   {* Display ID *}
		      clreol;
		      write_rs(chr(27));             {* ESC *}
		      write_rs('.');
		      write_rs('L');  {* Request for amount   *}
				      {* of available memory  *}
		      {*
		      val(read_ser_line,max_byte,code);
		      *}

		      max_byte:=1024;
		      writeln(' Block size: ',max_byte); clreol;

		      write_rs(chr(ord(27)));    {* Handshake setup *}
		      write_rs('.');
		      write_rs('I');
		      write_rs('1');             {*  Max block size,    *}
		      write_rs('1');             {*  must be >=  than   *}
		      write_rs('0');             {*      max_byte !     *}
		      write_rs('0');             {* 1100 fixed, for now *}
		      write_rs(';');
		      write_rs('1');             {* XON trigger   *}

		      write_rs(';');
		      write_rs('4');             {* XON character *}

		      write_rs(':');



  set_limits;
  set_grid;
  velocity(vel);

  gotoxy(2,19);
  write('Sending block No: ',bn); clreol;

  while not eof(source) do
  begin
  
    GET_cmd;

    if cmd='PU' then                            {* Pen Up *}
    begin
      pen:=up;
      pen_up;
      if ARG=true then
       begin
	rx_old:=rx;
      repeat
	pread(rx);  IF ARG=FALSE THEN
				 begin
				  rx:=rx_old;
				  GOTO EXIT8;
				 end;          {* This is to restore rx,
						  in case of no arguments
						  to PA command. *}
	pread(ry);
	 
	 if pen = up then moveabs(rx+big_hp*corrx,ry+big_hp*corry)
	 else             plotabs(rx+big_hp*corrx,ry+big_hp*corry);

      until (dc=';') or (eoln(source) or (ord(dc)>64));
						{* if dc is UPPER CASE.. *}


	EXIT8:

       end;
    end

    else

    if cmd='PD' then                            {* Pen Down *}
    begin
      pen:=down;
      if ARG=true then
       begin
	rx_old:=rx;
      repeat
	pread(rx);  IF ARG=FALSE THEN
				 begin
				  rx:=rx_old;
				  GOTO EXIT2;
				 end;          {* This is to restore rx,
						  in case of no arguments
						  to PA command. *}
	pread(ry);
	 
	 if pen = up then moveabs(rx+big_hp*corrx,ry+big_hp*corry)
	 else             plotabs(rx+big_hp*corrx,ry+big_hp*corry);

      until (dc=';') or (eoln(source) or (ord(dc)>64));
						{* if dc is UPPER CASE.. *}


	EXIT2:

       end;
    end

    else

    if cmd='PA' then                            {* Plot Absolute *}
    begin
	rx_old:=rx;
      repeat
	pread(rx);  IF ARG=FALSE THEN
				 begin
				  rx:=rx_old;
				  GOTO EXIT6;
				 end;          {* This is to restore rx,
						  in case of no arguments
						  to PA command. *}
	pread(ry);
	 
	 if pen = up then moveabs(rx+big_hp*corrx,ry+big_hp*corry)
	 else             plotabs(rx+big_hp*corrx,ry+big_hp*corry);

      until (dc=';') or (eoln(source) or (ord(dc)>64));
						{* if dc is UPPER CASE.. *}


	EXIT6:
    end

    else

    if cmd='PR' then                            {* Plot Relative *}
    begin
       repeat
	 pread(rx);
	 pread(ry);
	  if pen = up then moverel(rx,ry)
	  else             plotrel(rx,ry);
	until (dc=';') or (eoln(source) or (ord(dc)>64));

    end

    else

    if cmd='AA' then                            {* Arc Absolute *}
    begin
	rx_old:=rx;
	ry_old:=ry;
	rz_old:=rz;
	pread(rx);                           {* Coordinates of centre *}
	pread(ry);
	pread(rz);                           {* arc angle *}
	   dx:=rx_old-rx;
	   dy:=ry_old-ry;

	chord:=5;
	if dc<>';' then pread(chord);        {* Chord angle *}

	rad:=trunc(sqrt((dx)*(dx)+(dy)*(dy)));

	 if dx=0 then
	   begin
	     if dy>0 then
		start_angle:= 90
	   else start_angle:=270;
	   end

	 else
	   begin
	     fi:=trunc(arctan((dx*dx+dy*dy)/dx)*180/pi);

	      if ((dx>0) and (dy>0)) then start_angle:=fi;
	      if  (dx<0)             then start_angle:=180+fi;
	      if ((dx>0) and (dy<0)) then start_angle:=360-fi;

	      if ((dy=0) and (dx>0)) then start_angle:=0;
	      if ((dy=0) and (dx<0)) then start_angle:=180;
	   end;

	   stop_angle  := start_angle + rz;

	      if stop_angle >= 360 then stop_angle:=  stop_angle-360;
	      if stop_angle  = 0   then stop_angle:=359;
	      if stop_angle  < 0   then stop_angle:=360 + stop_angle;

	   hp7221_arc(rad,start_angle,stop_angle);

	   rx_temp:= trunc(   dx * cos(-rz*pi/180)
			   +  dy * sin(-rz*pi/180)) +rx;

	   ry_temp:= trunc( (-dx)* sin(-rz*pi/180)
			   +  dy * cos(-rz*pi/180)) +ry;
	   rx:=rx_temp;
	   ry:=ry_temp;
	   moveabs(rx+big_hp*corrx,ry+big_hp*corry)

{*         
	   This routine is supposed to calculate the resulting
	   position of pen after AA, and set the rx, ry values for
	   consecutive AA commands. It also moves the pen to THAT
	   position, to avoid difference between plotter and
	   program positions.
*}



	   {*
	   HPGL AA command assumes current pen position as starting point
	   of an arc. Parameters are coordinates of arc center,
	   arc angle and chord angle.

	   HP7221C arc assumes current position as a starting
	   point for arc, and needs radius, start angle and stop angle.
	   (using 3 o'clock position as a reference, positive angle
	   executed in anticlockwise direction).

	   Number of chords vary according to arc tolerance
	   ( ~,T, tolerance(SBN)), and radius.

	   Calculation of the radius and start-stop angles are done from
	   rx, ry, rx_old, ry_old.

	   HP7221 command has a form of:
	   'u'(or 't'), radius[MBN], start_angle[MBA], stop_angle[MBA].

	   Still, there are two remaining problems: Chord and associated
	   implications, and longint=>integer convesion in routines
	   implemented here.

	   *}

	 

    end

    else


    if cmd='AR' then                            {* Arc Relative *}
      begin
	pread(rx);
	pread(ry);
	pread(rz);
	 
	chord:=5;
	if dc<>';' then
	begin
	  pread(res);
	  chord:=res;
	end;

	rad:=trunc(sqrt((rx)*(rx)+(ry)*(ry)));

	 if rx=0 then
	  begin
	   if ry<0 then
	     start_angle:= 90
	      else start_angle:=270;
	  end

	  else
	   begin
	     fi:=trunc(arctan(ry/rx)*180/PI);
	      if ((xr>0) and (yr>0)) then start_angle:=fi+180;
	      if ((xr<0) and (yr>0)) then start_angle:=360-fi;
	      if ((xr<0) and (yr<0)) then start_angle:=fi;
	      if ((xr>0) and (yr<0)) then start_angle:=180-fi;

	      if ((yr=0) and (xr>0)) then start_angle:=180;
	      if ((yr=0) and (xr<0)) then start_angle:=0;
	   end;

	   stop_angle  := start_angle + rz ;
	      if stop_angle>=360 then stop_angle:=stop_angle-360;

	   hp7221_arc(rad,start_angle,stop_angle);

      end

    else

    if cmd='CI' then                            {* Circle *}
      begin
       while (dc<>';') do
	begin
	 pread(rx);
	 pread(res);
	 chord:=res;
	 moverel(rx,0);
	 hp7221_arc(rx,0,0);
	 moverel(-rx,0);
       end;
      end

    else

    if cmd='SP' then                            {* Pen select *}
     begin
	pread(pen_no);
	if ARG=true then
	  begin
	   if pen_no<>0 then  {* This is because I do not want to crush *}
	   Pen_select(pen_no) {* big pen into a stall while putting pen back*}
	  end
	else
     end

     else

     if cmd='IN' then        {* This is again to avoid crush *}
       begin
	{* init; *}
       end

     else

     if cmd='VS' then
	begin
	  pread(vel);
	  velocity(vel);
	end

     else

     if cmd='LB' then
       begin
       if (((rx+corrx*big_hp) < 0) or ((ry+corry*big_hp)<0)) then goto EXIT4
       else
       write_rs(^B);
	repeat
	 read(source,dc);
	 write_rs(dc);
	until dc=^C;
       EXIT4:
       end

     else

     if cmd='SC' then
       begin
       end

     else

     if cmd='IP' then
       begin
      {*
	pread(llx);
	pread(lly);
	pread(ulx);
	pread(uly);
	set_limits;
	set_grid;
      *}
       end

    else
    if cmd='SI' then    {* Size of the label *}
       begin
	 pread(sx);
	 pread(sy);
	 label_size(trunc(sy*1.5),sx*2); {* In HPGL, sy is LENGTH,       *}
       end                               {* sx is HEIGHT of caracter.    *}
					 {* In THIS, first arg is SPACE  *}
					 {* between caracters,           *}
					 {* and second arg is DISTANCE   *} 
					 {* between LINES   of text      *}
    
    
    
    else                                
    if cmd='PG' then
       begin                               
         gotoxy(2,20);
	 write(^G,^G,^G,'Change paper, then press any key to continue!');
	  while not keypressed do
	   begin
	   end;
         gotoxy(2,20);
         clreol;
       end                                

    else
    if cmd='IW' then
       begin
       end

    else
    if cmd='WP' then
       begin
       end

    else
    if cmd='DF'then
       begin
       end

    
    else
    begin
    end
  
  end;

  close(source);
  gotoxy(2,19);

    if bn = 1 then
       begin
        writeln(bn,' Block Transferred',^g,^g,^g); clreol;
       end
       else
       begin
        writeln(bn,' Blocks Transferred',^g,^g,^g); clreol;
       end;

  write_rs(chr(27));
  write_rs(chr(ord('.')));
  write_rs(chr(ord(')')));                 {* Plotter OFF *}


 EXIT_END:

 END.
