/*
 *  INTEXT.CPP - the function is a part of User library.
 *  Copyleft (l) Stanislav Sokolov, June 1998 and onwards
 *
 *  This library is subject to GNU General Library Public License ver. 2 of
 *  June 1991 and any later version. See COPYING.LIB for details.
 *
 *  You may freely use this function, provided due credits are given.
 *
 *  Contact the author by e-mail: stanislavs@hotmail.com
 *
 *  Internet:  http://members.tripod.com/~stanislavs/prog/prog.htm
 */



#include <conio.h>

#ifndef NULL
#include <_null.h>
#endif

#include "d:\tc\utils\user\user.h"

void GetTxt::PrintStr(int Row, int Col, int CurCol, int Width, Txt *Pointer){
	int Diff = CurCol - Col, i = 0;
	Txt *First;

	First = Pointer;
	while((First->Prev != NULL) && (i < Diff)){
	   i++;
	   First = First->Prev;
	}

	_setcursortype(_NOCURSOR);
	i = 0;
	gotoxy(Col, Row);
	while((First->Next != NULL) && (i < Width)){
		i++;
		putch(First->Letter);
		First = First->Next;
	}

	for(i = i; i < Width; i++) putch(' ');

	_setcursortype(_NORMALCURSOR);
	gotoxy(CurCol, Row);
}


char *GetTxt::InText(char *Text, int Length, int Row, int Col, int Width){
	Txt *Head, *Pointer, *First;

	Head = new Txt;

	unsigned char Chr, Cols;
	int i, NumChars = 1, CurCol = Col;

	Pointer = Head;

	Pointer->Letter = 0;
	Pointer->Next = NULL;
	Pointer->Prev = NULL;

	//Read screen width
	asm{
		mov AH, 0x0F
		int 0x10
		mov Cols, AH
	}

	if(Col + Width > Cols){
		Text[0] = 0;
		return NULL;
	}

	_setcursortype(_NORMALCURSOR);
	gotoxy(Col, Row);

	do{
		while(!kbhit());
		Chr = getch();

		if((Chr >= 32 && Chr <= 254) && (NumChars <= Length)){  //Printable character
			First = new Txt;
			First->Letter = Chr;

			First->Next = Pointer;
			First->Prev = Pointer->Prev;
			if(First->Prev == NULL)
				Head = First;
			else
				First->Prev->Next = First; //The same as Pointer->Prev->Next
			Pointer->Prev = First;

			NumChars++;
			if(CurCol - Col + 1 < Width) CurCol++;
			PrintStr(Row, Col, CurCol, Width, Pointer);
		}

		if((Chr == 8) && (Pointer->Prev != NULL)){  //Backspace
			if(Pointer->Prev != NULL){
				First = Pointer->Prev;
				if(First->Prev == NULL){    //the letter to be deleted is the first char in string
					Head = Pointer;
					Pointer->Prev = NULL;
				}else{
					First->Prev->Next = Pointer;
					Pointer->Prev = First->Prev;
				}
				delete First;
				NumChars--;
				if(CurCol != Col) CurCol--;
				PrintStr(Row, Col, CurCol, Width, Pointer);
			}
		}

		if(Chr == 27){          //Esc
			Text[0] = 0;
			return NULL;
		}

		if(Chr == 0){		//Control key
			Chr = getch();

			switch(Chr){
				case 'K':       //Left
					if(Pointer->Prev != NULL){
						Pointer = Pointer->Prev;
						if(CurCol != Col) CurCol--;
						PrintStr(Row, Col, CurCol, Width, Pointer);
					}
					break;
				case 'M':       //Right
					if(Pointer->Next != NULL){
						Pointer = Pointer->Next;
						if(CurCol - Col + 1 < Width) CurCol++;
						PrintStr(Row, Col, CurCol, Width, Pointer);
					}
					break;
				case 'S':       //Delete
					if(Pointer->Next != NULL){
						if(Pointer->Prev != NULL)
							Pointer->Prev->Next = Pointer->Next;
						else
							Head = Pointer->Next;

						Pointer->Next->Prev = Pointer->Prev;
						First = Pointer->Next;
						delete Pointer;
						Pointer = First;

						NumChars--;
						PrintStr(Row, Col, CurCol, Width, Pointer);
					}
					break;
				case 'G':       //Home
					Pointer = Head;
					CurCol = Col;
					PrintStr(Row, Col, CurCol, Width, Pointer);
					break;
				case 'O':       //End
					while(Pointer->Next != NULL){
						Pointer = Pointer->Next;
					}
					CurCol = Col + NumChars - 1;
					if(CurCol > Col + Width - 1) CurCol = Col + Width - 1;
					PrintStr(Row, Col, CurCol, Width, Pointer);
					break;
				case 147:       //Ctrl-Delete (Delete to EOL)
					if(Pointer->Next != NULL){
						Txt *Temp = Pointer;

						Pointer = Pointer->Next;
						while(Pointer->Next != NULL){
							First = Pointer;
							Pointer = Pointer->Next;
							delete First;
						}
						delete Pointer;

						Pointer = Temp;

						Pointer->Letter = 0;
						Pointer->Next = NULL;
						PrintStr(Row, Col, CurCol, Width, Pointer);

						NumChars = 1;
						First = Head;
						while(First->Next != NULL){
							NumChars++;
							First = First->Next;
						}
					}
					break;
			};
		}
	}while(Chr != 13);

	//Destroy the dynamic data structure, while placing data into Text array.
	Pointer = Head;
	i = 0;
	do{
		Text[i++] = Pointer->Letter;
		Head = Pointer->Next;
		delete Pointer;
		Pointer = Head;
	}while((Pointer->Next != NULL) && (i <= Length));
	Text[i] = 0;

	return Text;
}

/*
int main(void){
	int Length = 40;
	char *Text = new char[Length + 1];

	GetTxt String;

	clrscr();
	cprintf("Enter a text between the arrows ->                    <- Press %c when ready.", 27);

	if(String.InText(Text, Length, 1, 35, 20) != NULL)
		cprintf("\r\n\r\nThe text you entred was: \"%s\"\r\n", Text);
	else
		cprintf("\r\nAn error occured or user pressed 'Esc'\r\n");

	delete [] Text;

	return 0;
}
*/