/*
 *  CENTRE.CPP - the function is a part of User library.
 *  Copyleft (l) Stanislav Sokolov, June 1998 and onwards
 *
 *  This library is subject to GNU General Library Public License ver. 2 of 
 *  June 1991 and any later version. See COPYING.LIB for details.
 *
 *  You may freely use this function, provided due credits are given.
 *
 *  Contact the author by e-mail: stanislavs@hotmail.com
 *
 *  Internet:  http://members.tripod.com/~stanislavs/prog/prog.htm
 */


#include <conio.h>
#include <string.h>

#include "d:\tc\utils\user\user.h"

int Centre(char Row, const char *Text, char StartCol = -1, char EndCol = -1){
	char Cols, temp, Col;

	asm{
		mov AH, 0x0F
		int 0x10
		mov Cols, AH
	}

	//Swap values of start and end, if they are wrong
	if(StartCol > EndCol){
		temp = EndCol;
		EndCol = StartCol;
		StartCol = temp;
	}

	//Set boundaries, if they are given
	if( ((StartCol != -1) && (EndCol != -1)) && (EndCol - StartCol + 1 <= Cols) ) Cols = EndCol - StartCol + 1;
	if(strlen(Text) > Cols) return 0;

	//Locate cursor (in-line if [a?b:c] checks for boundaries)
	Col = (Cols + 2 - strlen(Text)) / 2 + ( ((StartCol != -1) && (EndCol != -1)) ? (StartCol - 1) : 0 );
	if(Row == 0) return Col; //If Row == 0, the user does not want to print the text on screen - return coordinates.

	gotoxy(Col, Row);
	if(wherey() != Row) return 0; //Was cursor placement successful?

	cprintf(Text);
	return Col;
}

/*int main(void){
	textcolor(LIGHTGRAY);
	textbackground(BLACK);
	clrscr();

	Centre(5, "Test absolute page centring");
	Centre(6, "==============================================================================", 0, 80);

	Centre(12, "Test boundaries 1, 40", 1, 40);
	Centre(13, ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>", 1, 40);

	Centre(12, "Test boundaries 41, 80", 41, 80);
	Centre(13, "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", 41, 80);

	cprintf("\r\n\r\nThe word 'Abrakatabra' would be centred at x-location %i\r\n", Centre(0, "Abrakatabra"));

	return 0;
}*/
