//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVUSES.H                             |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Include files manager                |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

/*
CONDITIONAL DIRECTIVES DESCRIPTION
----------------------------------

  Identifier            Description
  --------------------  ----------------------------------------------------
  CYR                   Set cyrillic messages
  HGR                   640x480 graphics mode layout
  MEMMON                Enable memory monitor
  DEBUG                 Debugging assertions enabled
  HDEBUG                Heap debugging assertions enabled
  INIFILE               Set ini filename, default is "PV.INI"
  NOCLOCK               Disable clock/date monitor
  NOCONFIG              Disable configuration INI file handling
  NOFLOAT               Disable float input boxes
  NOHELP                Disable help
  NOHIST                Disable input boxes history lists
  NOICONS               Disable graphical icons
  NOINI                 Disable INI files handling
  NOLOCALMENU           Disable local menu
  NOMAINMENU            Disable main menu
  NOMOUSE               Disable mouse handling
  NOPAL                 Disable EGA/VGA palette procs
  NOPARAM               Disable command-line params handling
  NOTIMER               Disable timer handling
  NOTOOLBAR             Disable toolbar
  TABLEINFO             Enable table information
  CPPHILIGHT            Enable cpp syntax hilighting
  ASMHILIGHT            Enable asm syntax hilighting
  A51HILIGHT            Enable a51 syntax hilighting
  --------------------  ----------------------------------------------------
*/

//Defines dependency info

#if defined(CPPHILIGHT) || defined(ASMHILIGHT) || defined(A51HILIGHT)
#define SYNTAXHILIGHT
#endif

#ifdef NOINI
#define NOCONFIG
#endif

#ifdef NOMOUSE
#define NOTOOLBAR
#endif

#ifdef HDEBUG
#define DEBUG
#define uses_malloc
#endif

#ifdef DEBUG
  #include <assert.h>
#else
  #define NDEBUG
#endif


//Headers dependency info

#ifdef uses_app
#define uses_cmd
#define uses_items
#endif

#ifdef uses_check
#define uses_items
#endif

#ifdef uses_desk
#define uses_items
#endif

#ifdef uses_dialog
#define uses_win
#define uses_lbox
#endif

#ifdef uses_hist
#define uses_combo
#endif

#ifdef uses_ini
#define uses_editor
#define uses_stdio
#endif

#ifdef uses_input
#define uses_button
#define uses_editor
#define uses_combo
#endif

#ifdef uses_label
#define uses_items
#endif

#ifdef uses_lines
#define uses_items
#endif

#ifdef uses_dc
#define uses_system
#endif

#ifdef uses_system
#define uses_dos
#endif

#ifdef uses_txt
#define uses_stdarg
#define uses_items
#endif

#ifdef uses_combo
#define uses_items
#define uses_lbox
#endif

#ifdef uses_editor
#define uses_direct
#define uses_basics
#define uses_win
#endif

#ifdef uses_win
#define uses_button
#define uses_cmdgen
#define uses_scroll
#endif

#ifdef uses_cmdgen
#define uses_cmd
#define uses_items
#define uses_button
#endif

#ifdef uses_cmd
#define uses_basics
#endif

#ifdef uses_db
#define uses_table
#endif

#ifdef uses_table
#define uses_items
#define uses_lbox
#endif

#ifdef uses_stddlg
#define uses_dialog
#define uses_lbox
#endif

#ifdef uses_lbox
#define uses_list
#define uses_scroll
#endif

#ifdef uses_scroll
#define uses_button
#endif

#ifdef uses_button
#define uses_items
#endif

#ifdef uses_hgr
  #ifndef HGR
  #error "HGR" must be pre-defined if you want graphics mode support
  #endif
#define uses_items
#endif

#ifdef uses_items
#define uses_stdlib
#define uses_drv
#endif


//Standard headers

#ifdef uses_conio
#include <conio.h>
#endif

#ifdef uses_ctype
#include <ctype.h>
#endif

#ifdef uses_dos
#include <dos.h>
#endif

#ifdef uses_direct
#include <direct.h>
#endif

#ifdef uses_errno
#include <errno.h>
#endif

#ifdef uses_i86
#include <i86.h>
#endif

#ifdef uses_fcntl
#include <fcntl.h>
#endif

#ifdef uses_io
#include <io.h>
#endif

#if defined( uses_math )
#include <math.h>
#endif

#ifdef uses_malloc
#include <malloc.h>
#endif

#ifdef uses_process
#include <process.h>
#endif

#ifdef uses_signal
#include <signal.h>
#endif

#ifdef uses_stdarg
#include <stdarg.h>
#endif

#ifdef uses_stdio
#include <stdio.h>
#endif

#ifdef uses_stdlib
#include <stdlib.h>
#endif

#ifdef uses_string
#include <string.h>
#endif

#ifdef uses_time
#include <time.h>
#endif


//Power View headers

#ifndef _PVTYPES_H
#define _PVTYPES_H
typedef unsigned short word;
typedef unsigned char boolean;
typedef signed char schar;
typedef unsigned int uint;
#endif

#ifdef uses_basics
#include "PVbasics.h"
#endif

#ifdef uses_cmd
#include "PVcmd.h"
#endif

#ifdef uses_drv
#include "PVdrv.h"
#endif

#ifdef uses_items
#include "PVitems.h"
#endif

#ifdef uses_app
#include "PVapp.h"
#endif

#ifdef uses_button
#include "PVbutton.h"
#endif

#ifdef uses_calc
#include "PVcalc.h"
#endif

#ifdef uses_calend
#include "PVcalend.h"
#endif

#ifdef uses_tetris
#include "PVtetris.h"
#endif

#ifdef uses_check
#include "PVcheck.h"
#endif

#if !defined( NOCLOCK ) && defined( uses_clock )
#include "PVclock.h"
#endif

#ifdef uses_colors
#include "PVcolors.h"
#endif

#ifdef uses_list
#include "PVlist.h"
#endif

#ifdef uses_scroll
#include "PVscroll.h"
#endif

#ifdef uses_lbox
#include "PVlbox.h"
#endif

#ifdef uses_combo
#include "PVcombo.h"
#endif

#if !defined( NOPARAM ) && defined( uses_comlin )
#include "PVcomlin.h"
#endif

#if !defined( NOCONFIG ) && defined ( uses_config )
#include "PVconfig.h"
#endif

#ifdef uses_desk
#include "PVdesk.h"
#endif

#ifdef uses_cmdgen
#include "PVcmdgen.h"
#endif

#ifdef uses_win
#include "PVwin.h"
#endif

#ifdef uses_dialog
#include "PVdialog.h"
#endif

#ifdef uses_editor
#include "PVeditor.h"
#endif

#if !defined( NOHELP ) && defined( uses_help )
#include "PVhelp.h"
#endif

#if !defined ( NOHIST ) &&  defined( uses_hist )
#include "PVhist.h"
#endif

#ifdef uses_icons
#include "PVicons.h"
#endif

#if !defined( NOINI ) && defined ( uses_ini )
#include "PVini.h"
#endif

#ifdef uses_init
#include "PVinit.h"
#endif

#ifdef uses_input
#include "PVinput.h"
#endif

#ifdef uses_label
#include "PVlabel.h"
#endif

#ifdef uses_lines
#include "PVlines.h"
#endif

#if defined( MEMMON ) && defined( uses_memmon )
#include "PVmemmon.h"
#endif

#ifdef uses_stddlg
#include "PVstddlg.h"
#endif

#ifdef uses_system
#include "PVsystem.h"
#endif

#ifdef uses_hgr
#include "PVhgr.h"
#endif

#ifdef uses_dc
#include "PVdc.h"
#endif

#ifdef uses_table
#include "PVtable.h"
#endif

#ifdef uses_db
#include "PVdb.h"
#endif

#ifdef uses_txt
#include "PVtxt.h"
#endif

#if !defined( NOHELP ) && defined( uses_ht )
#include "PVht.h"
#endif
