//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVINIT.CPP                           |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Startup initialization               |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_app
#define uses_clock
#define uses_colors
#define uses_cmdgen
#define uses_comlin
#define uses_config
#define uses_dc
#define uses_desk
#define uses_dialog
#define uses_icons
#define uses_ini
#define uses_lbox
#define uses_memmon
#define uses_stddlg
#define uses_system
#define uses_table

#include "PVuses.h"

#if !defined( NOPARAM ) || !defined( NOCONFIG )
void init_startup( int argc, char *argv[] )
{
#endif
#ifndef NOPARAM
  __init_comlin( argc, argv );
#endif
#ifndef NOCONFIG
  __init_config();
#endif
#if !defined( NOPARAM ) || !defined( NOCONFIG )
}
#endif

#ifndef NOPARAM
void init_comlin( int argc, char *argv[] )
{
  __init_comlin( argc, argv );
}
#endif

#ifndef NOCONFIG
void init_config( void )
{
  __init_config();
}
#endif

void init_system( void )
{
  __init_system();
}

void init_drivers( void )
{
  __init_drivers();
}

void init_dc( void )
{
  __init_colors();
  __init_icons();
  __init_dc();
}

void init_icons( void )
{
  __init_icons();
}

void init_colors( void )
{
  __init_colors();
}

void init_application( void )
{
  __init_application();
  __init_desktop();
#if !defined( NOTOOLS ) || !defined( NOMENUS )
  __init_cmdgen();
#endif
#ifndef NOCLOCK
  __init_clock();
#endif
#ifdef MEMMON
  __init_mem();
#endif
  __resize_application();
}

void init_desktop( void )
{
  __init_desktop();
}

#if !defined( NOTOOLS ) || !defined( NOMENUS )
void init_cmdgen( void )
{
  __init_cmdgen();
}
#endif

#ifndef NOCLOCK
void init_clock( void )
{
  __init_clock();
}
#endif

#ifdef MEMMON
void init_mem( void )
{
  __init_mem();
}
#endif

#if !defined( NOPARAM ) || !defined( NOCONFIG )
void tini_startup( void )
{
#endif
#ifndef NOPARAM
  __tini_comlin();
#endif
#ifndef NOCONFIG
  __tini_config();
#endif
#if !defined( NOPARAM ) || !defined( NOCONFIG )
}
#endif

#ifndef NOPARAM
void tini_comlin( void )
{
  __tini_comlin();
}
#endif

#ifndef NOCONFIG
void tini_config( void )
{
  __tini_config();
}
#endif

void init_screen( void )
{
  __set_startup_video_mode();
#if !defined( NOICONS ) && !defined( HGR )
  set_graph_chars();
#endif
  con_messages = 0;
}

void init_editors( void )
{
  __init_editors();
}
